/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.AbstractSymbolProvider;
import org.simantics.diagram.symbolcontribution.ElementSymbolItem;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.ModifiableSymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactories;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.layer0.Layer0;

public class IndexRootSymbolProviderFactory
implements SymbolProviderFactory {
    Resource indexRoot;

    public IndexRootSymbolProviderFactory(Resource indexRoot) {
        this.indexRoot = indexRoot;
    }

    public int hashCode() {
        return this.indexRoot.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRootSymbolProviderFactory other = (IndexRootSymbolProviderFactory)obj;
        return this.indexRoot.equals(other.indexRoot);
    }

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return (ISymbolProvider)g.syncRequest((Read)new LoadRequest(this.indexRoot));
    }

    private static SymbolGroup createGroup(ReadGraph graph, Resource library, Resource relation) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        String name = (String)graph.adapt(library, String.class);
        String description = (String)graph.getPossibleRelatedValue(library, l0.HasDescription, (Binding)Bindings.STRING);
        if (description == null) {
            description = name;
        }
        ModifiableSymbolGroup group = new ModifiableSymbolGroup((Object)library, name, description);
        ArrayList<ElementSymbolItem> items = new ArrayList<ElementSymbolItem>();
        for (Resource item : (Set)graph.syncRequest((Read)new ObjectsWithSupertype(library, relation, dr.Element))) {
            if (!SymbolProviderFactories.accept(graph, dr, item)) continue;
            String itemName = (String)graph.adapt(item, String.class);
            String itemDescription = (String)graph.getPossibleRelatedValue(item, l0.HasDescription, (Binding)Bindings.STRING);
            if (itemDescription == null) {
                itemDescription = itemName;
            }
            items.add(new ElementSymbolItem(item, itemName, itemDescription, (ISymbolGroup)group));
        }
        Collections.sort(items, new Comparator<ISymbolItem>(){

            @Override
            public int compare(ISymbolItem o1, ISymbolItem o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        group.setItems(items.toArray(new ISymbolItem[items.size()]));
        return group;
    }

    class LoadRequest
    extends ResourceRead<ISymbolProvider> {
        public LoadRequest(Resource contribution) {
            super(contribution);
        }

        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
            ArrayList<ISymbolGroup> groups = new ArrayList<ISymbolGroup>();
            if (IndexRootSymbolProviderFactory.this.indexRoot != null) {
                HashSet<Resource> roots = new HashSet<Resource>();
                roots.add(IndexRootSymbolProviderFactory.this.indexRoot);
                roots.addAll((Collection)graph.syncRequest((Read)new ObjectsWithType(IndexRootSymbolProviderFactory.this.indexRoot, l0.IsLinkedTo, l0.SharedOntology)));
                for (Resource root : roots) {
                    for (Resource library : (Collection)graph.syncRequest((Read)new ObjectsWithType(root, l0.ConsistsOf, dr.SymbolReferenceLibrary))) {
                        groups.add(IndexRootSymbolProviderFactory.createGroup(graph, library, dr.HasSymbol));
                    }
                }
            }
            return new SymbolProvider(groups);
        }
    }

    static class SymbolProvider
    extends AbstractSymbolProvider {
        public SymbolProvider(Collection<ISymbolGroup> groups) {
            this.setSymbolGroup(groups);
            this.lockGroups();
        }
    }
}

