/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.AbstractSymbolProvider;
import org.simantics.diagram.symbolcontribution.ElementSymbolItem;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.ModifiableSymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactories;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.layer0.Layer0;

public class BasicSymbolProviderFactory
implements SymbolProviderFactory {
    Resource contribution;

    public BasicSymbolProviderFactory(Resource contribution) {
        this.contribution = contribution;
    }

    public int hashCode() {
        return this.contribution.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSymbolProviderFactory other = (BasicSymbolProviderFactory)obj;
        return this.contribution.equals(other.contribution);
    }

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return (ISymbolProvider)g.syncRequest((Read)new LoadRequest(this.contribution));
    }

    private static SymbolGroup createGroup(ReadGraph graph, Resource library, Resource relation) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        String name = (String)graph.adapt(library, String.class);
        String description = (String)graph.getPossibleRelatedValue(library, l0.HasDescription, (Binding)Bindings.STRING);
        if (description == null) {
            description = name;
        }
        ModifiableSymbolGroup group = new ModifiableSymbolGroup((Object)library, name, description);
        ArrayList<ElementSymbolItem> items = new ArrayList<ElementSymbolItem>();
        for (Resource item : (Set)graph.syncRequest((Read)new ObjectsWithSupertype(library, relation, dr.Element))) {
            if (!SymbolProviderFactories.accept(graph, dr, item)) continue;
            String itemName = (String)graph.adapt(item, String.class);
            String itemDescription = (String)graph.getPossibleRelatedValue(item, l0.HasDescription, (Binding)Bindings.STRING);
            if (itemDescription == null) {
                itemDescription = itemName;
            }
            items.add(new ElementSymbolItem(item, itemName, itemDescription, (ISymbolGroup)group));
        }
        Collections.sort(items, new Comparator<ISymbolItem>(){

            @Override
            public int compare(ISymbolItem o1, ISymbolItem o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        group.setItems(items.toArray(new ISymbolItem[items.size()]));
        return group;
    }

    class LoadRequest
    extends ResourceRead<ISymbolProvider> {
        public LoadRequest(Resource contribution) {
            super(contribution);
        }

        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
            if (!SymbolProviderFactories.accept(graph, dr, BasicSymbolProviderFactory.this.contribution)) {
                return new SymbolProvider(Collections.<ISymbolGroup>emptyList());
            }
            Collection libraries = graph.getObjects(this.resource, dr.BasicSymbolContributionHasSymbolLibrary);
            ArrayList<ISymbolGroup> groups = new ArrayList<ISymbolGroup>(libraries.size());
            for (Resource library : libraries) {
                if (!SymbolProviderFactories.accept(graph, dr, library)) continue;
                groups.add(BasicSymbolProviderFactory.createGroup(graph, library, l0.DependsOn));
            }
            return new SymbolProvider(groups);
        }
    }

    static class SymbolProvider
    extends AbstractSymbolProvider {
        public SymbolProvider(Collection<ISymbolGroup> groups) {
            this.setSymbolGroup(groups);
            this.lockGroups();
        }
    }
}

