/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.query;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.IDiagramLoader;
import org.simantics.diagram.adapter.NodeRequest;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.content.TerminalMap;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.query.ConnectionVisualsRequest;
import org.simantics.diagram.query.DiagramDescRead;
import org.simantics.diagram.query.DiagramLoadQuery;
import org.simantics.diagram.query.ElementClassQuery;
import org.simantics.diagram.query.FlagPairQuery;
import org.simantics.diagram.query.FlagTextQuery;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.PageDesc;

public class DiagramRequests {
    public static Read<PageDesc> getPageDesc(final Resource diagram, final PageDesc defaultValue) {
        return new Read<PageDesc>(){

            public PageDesc perform(ReadGraph graph) throws DatabaseException {
                return DiagramGraphUtil.getPageDesc(graph, diagram, defaultValue);
            }
        };
    }

    public static Read<DiagramDesc> getDiagramDesc(Resource diagram) {
        return new DiagramDescRead(diagram);
    }

    public static AsyncRead<ElementClass> getElementClass(Resource elementType, IHintObservable hints) {
        return new ElementClassQuery(elementType, hints);
    }

    public static AsyncRead<IElement> getElement(ICanvasContext canvas, IDiagram diagram, Resource element, Listener<IElement> loadListener) {
        return new NodeRequest(canvas, diagram, element, loadListener);
    }

    public static Read<IDiagram> loadDiagram(IProgressMonitor monitor, Resource model, Resource resource, Resource runtime, ResourceArray structuralPath, IDiagramLoader loader, IHintObservable initialHints) {
        return new DiagramLoadQuery(monitor, model, resource, runtime, structuralPath, loader, initialHints);
    }

    public static Read<IModelingRules> getModelingRules(final Resource diagram, final IModelingRules defaultValue) {
        return new Read<IModelingRules>(){

            public IModelingRules perform(ReadGraph graph) throws DatabaseException {
                StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
                Resource rules = graph.getPossibleObject(diagram, sr.HasModelingRules);
                if (rules == null) {
                    return defaultValue;
                }
                return (IModelingRules)graph.adapt(rules, IModelingRules.class);
            }
        };
    }

    public static Read<ConnectionVisuals> getConnectionVisuals(Resource connectionType) {
        return new ConnectionVisualsRequest(connectionType);
    }

    public static Read<String[]> getFlagText(Resource flag) {
        return new FlagTextQuery(flag);
    }

    public static Read<Resource> getFlagPair(Resource flag) {
        return new FlagPairQuery(flag);
    }

    public static Read<TerminalMap> elementTypeTerminals(Resource elementType) {
        return new ResourceRead<TerminalMap>(elementType){

            public TerminalMap perform(ReadGraph graph) throws DatabaseException {
                return DiagramGraphUtil.getElementTypeTerminals(graph, this.resource);
            }
        };
    }

    public static Read<TerminalMap> elementTerminals(Resource element) {
        return new ResourceRead<TerminalMap>(element){

            public TerminalMap perform(ReadGraph graph) throws DatabaseException {
                return DiagramGraphUtil.getElementTerminals(graph, this.resource);
            }
        };
    }

    public static void expandConnections(ReadGraph graph, Resource connection, Set<Resource> conns, Set<IConnectionPoint> cps) throws DatabaseException {
        if (!conns.add(connection)) {
            return;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource connector : graph.getObjects(connection, DIA.HasConnector)) {
            for (Statement stm : graph.getStatements(connector, STR.Connects)) {
                Resource element = stm.getObject();
                if (element.equals(connection)) continue;
                if (graph.isInstanceOf(element, DIA.Flag)) {
                    for (Resource otherFlag : FlagUtil.getCounterparts(graph, element)) {
                        Resource otherConnection;
                        Resource flagConnector = graph.getPossibleObject(otherFlag, DIA.Flag_ConnectionPoint);
                        if (flagConnector == null || (otherConnection = graph.getPossibleObject(flagConnector, DIA.IsConnectorOf)) == null) continue;
                        DiagramRequests.expandConnections(graph, otherConnection, conns, cps);
                    }
                    continue;
                }
                Resource connectionPoint = graph.getInverse(stm.getPredicate());
                cps.add((IConnectionPoint)new CPTerminal(element, connectionPoint));
            }
        }
    }
}

