/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.query;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.svg.LineCap;
import org.simantics.g2d.svg.LineJoin;
import org.simantics.utils.datastructures.ValueUtils;

public class ConnectionVisualsRequest
extends ResourceRead<ConnectionVisuals> {
    static final Float DEFAULT_DASH_OFFSET = Float.valueOf(0.0f);
    static final Float DEFAULT_STROKE_WIDTH = Float.valueOf(1.0f);
    static final Float DEFAULT_MITER_LIMIT = Float.valueOf(10.0f);
    G2DResource g2d;

    public ConnectionVisualsRequest(Resource connectionType) {
        super(connectionType);
        assert (connectionType != null);
    }

    public ConnectionVisuals perform(ReadGraph g) throws DatabaseException {
        float[] col;
        this.g2d = G2DResource.getInstance((ReadGraph)g);
        Resource structuralConnectionType = this.resource;
        Resource c = g.getPossibleObject(structuralConnectionType, this.g2d.HasColor);
        float[] color = null;
        if (c != null && (col = (float[])g.getPossibleValue(c, (Binding)Bindings.FLOAT_ARRAY)) != null && col.length >= 3) {
            color = col;
        }
        EdgeVisuals.StrokeType strokeType = this.toStrokeType(g.getPossibleObject(structuralConnectionType, this.g2d.HasStrokeType));
        Stroke stroke = this.readStroke(g, g.getPossibleObject(structuralConnectionType, this.g2d.HasStroke));
        return new ConnectionVisuals(color, strokeType, stroke);
    }

    EdgeVisuals.StrokeType toStrokeType(Resource strokeType) {
        if (strokeType != null) {
            if (strokeType.equals(this.g2d.StrokeType_Scaling)) {
                return EdgeVisuals.StrokeType.Absolute;
            }
            if (strokeType.equals(this.g2d.StrokeType_Nonscaling)) {
                return EdgeVisuals.StrokeType.Relative;
            }
        }
        return null;
    }

    Stroke readStroke(ReadGraph graph, Resource stroke) throws DatabaseException {
        if (stroke == null) {
            return null;
        }
        float[] dashArray = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, this.g2d.HasDashArray, float[].class, null);
        Float dashOffset = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, this.g2d.HasDashOffset, Float.class, DEFAULT_DASH_OFFSET);
        Float strokeWidth = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, this.g2d.HasStrokeWidth, Float.class, DEFAULT_STROKE_WIDTH);
        Float miterLimit = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, this.g2d.HasMiterLimit, Float.class, DEFAULT_MITER_LIMIT);
        LineJoin lineJoin = DiagramGraphUtil.toLineJoin(this.g2d, graph.getPossibleObject(stroke, this.g2d.HasLineJoin));
        LineCap lineCap = DiagramGraphUtil.toLineCap(this.g2d, graph.getPossibleObject(stroke, this.g2d.HasLineCap));
        if (strokeWidth.floatValue() < 0.0f) {
            strokeWidth = Float.valueOf(0.0f);
        }
        return new BasicStroke(strokeWidth.floatValue(), lineCap.ordinal(), lineJoin.ordinal(), miterLimit.floatValue(), dashArray == null ? null : ValueUtils.toFloatArray((Object)dashArray), dashOffset.floatValue());
    }
}

