/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.Arrays;

public class Profiles {
    public static Resource createProfile(WriteGraph graph, String profileName, Resource ... entries) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList ee = new ArrayList();
        Arrays.addAll(ee, (Object[])entries);
        Resource list = ListUtils.create((WriteGraph)graph, (Resource)DIA.Profile, ee);
        Resource profile = ListUtils.create((WriteGraph)graph, (Resource)DIA.Profile, (Resource[])new Resource[0]);
        graph.claimLiteral(profile, L0.HasName, (Object)profileName);
        graph.claim(profile, DIA.HasEntries, null, list);
        return profile;
    }

    public static Resource createEntry(WriteGraph graph, String name, Resource style, Resource group) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource entry = graph.newResource();
        graph.claim(entry, L0.InstanceOf, null, DIA.GroupStyleProfileEntry);
        graph.claimLiteral(entry, L0.HasName, (Object)name);
        graph.claimLiteral(entry, L0.HasLabel, (Object)name);
        graph.claim(entry, DIA.ProfileEntry_HasStyle, style);
        graph.claim(entry, DIA.ProfileEntry_HasGroup, group);
        return entry;
    }

    public static Resource createContainerProfile(WriteGraph graph, String name, Resource ... children) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource profile = graph.newResource();
        graph.claim(profile, L0.InstanceOf, null, DIA.Profile);
        graph.claim(profile, L0.Abstract, profile);
        graph.claimLiteral(profile, L0.HasName, (Object)name);
        graph.claimLiteral(profile, L0.HasLabel, (Object)name);
        ArrayList cd = new ArrayList();
        Arrays.addAll(cd, (Object[])children);
        graph.claim(profile, DIA.HasEntries, null, ListUtils.create((WriteGraph)graph, (Resource)DIA.Profile, cd));
        return profile;
    }

    public static Variable getMappedVariable(ReadGraph graph, Resource runtimeDiagram, Resource element) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        String variableURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
        Variable activeVariable = Variables.getVariable((ReadGraph)graph, (String)variableURI);
        Resource module = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (module == null) {
            return null;
        }
        return activeVariable.browse(graph, module);
    }
}

