/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.diagram.internal.Activator;
import org.simantics.diagram.profile.IconButtonNode;
import org.simantics.diagram.profile.IconButtonResult;
import org.simantics.diagram.profile.IconResult;
import org.simantics.diagram.profile.Updater;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;

public class IconNode
extends IconButtonNode {
    private IconResult.B config;
    private SVGNode lo = new SVGNode();
    private SVGNode mid = new SVGNode();
    private SVGNode hi = new SVGNode();
    private SVGNode current;
    private static final long serialVersionUID = -7850188341977866325L;
    private Blink blink = Blink.NO;
    private double previousValue = Double.NaN;
    private long previousValueTime = System.nanoTime();
    Rectangle2D EMPTY = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    private void setBlink(Blink blink) {
        if (Blink.NO == blink && Blink.NO != this.blink) {
            Updater.getInstance().unregister((INode)this);
        }
        if (Blink.NO != blink && Blink.NO == this.blink) {
            Updater.getInstance().register((INode)this);
        }
        this.blink = blink;
    }

    private void setValue(double value) {
        if (value < this.config.loValue) {
            this.current = this.lo;
            this.setBlink(Blink.NO);
        } else if (value > this.config.hiValue) {
            this.current = this.hi;
            this.setBlink(Blink.NO);
        } else {
            this.current = this.mid;
            if (value - this.previousValue > 1.0E-6) {
                this.setBlink(Blink.INCREASE);
            } else if (this.previousValue - value > 1.0E-6) {
                this.setBlink(Blink.DECREASE);
            } else {
                this.setBlink(Blink.NO);
            }
        }
        this.previousValue = value;
        this.previousValueTime = System.nanoTime();
    }

    private void setConfig(IconResult.B config) {
        if (this.config == config) {
            return;
        }
        if (config.loColor != null) {
            String loIcon = this.createSVG(config.iconName, config.loColor, config.size);
            this.lo.setData(loIcon);
        }
        if (config.midColor != null) {
            String midIcon = this.createSVG(config.iconName, config.midColor, config.size);
            this.mid.setData(midIcon);
        }
        if (config.hiColor != null) {
            String hiIcon = this.createSVG(config.iconName, config.hiColor, config.size);
            this.hi.setData(hiIcon);
        }
        this.config = config;
    }

    public void setA(IconResult.A data) {
        this.setConfig(data.config);
        this.setValue(data.value);
    }

    public void cleanup() {
        Updater.getInstance().unregister((INode)this);
        super.cleanup();
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.transform);
        }
        if (Blink.NO == this.blink) {
            this.current.render(g2d);
        } else {
            long time = Updater.getInstance().getTime();
            if (time - this.previousValueTime > 2000000000L) {
                this.mid.render(g2d);
                this.setBlink(Blink.NO);
            } else {
                long halfSeconds = time / 500000000L;
                if ((halfSeconds & 1L) == 0L) {
                    this.mid.render(g2d);
                } else if (Blink.INCREASE == this.blink) {
                    this.hi.render(g2d);
                } else {
                    this.lo.render(g2d);
                }
            }
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    public Rectangle2D getBoundsInLocal() {
        return this.EMPTY;
    }

    @Override
    void setData(IconButtonResult data) {
        IconResult ir = (IconResult)data;
        this.setA(ir.getA());
    }

    public String createSVG(String iconName, RGB.Integer rgb, Vec2d scale) {
        return (String)Activator.ICON_PROVIDER.apply((Object)iconName, (Object)rgb, (Object)scale);
    }

    static enum Blink {
        NO,
        INCREASE,
        DECREASE;

    }
}

