/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.flag.Joiner;
import org.simantics.diagram.participant.ControlPoint;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.RemoveElement;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;

public class ConnectionBuilder {
    protected final IDiagram diagram;
    protected final Resource diagramResource;
    protected final boolean createFlags;
    protected final ISynchronizationContext ctx;
    protected final IElementClassProvider elementClassProvider;
    protected final GraphLayerManager layerManager;
    protected ConnectionUtil cu;
    protected Layer0 L0;
    protected DiagramResource DIA;
    protected StructuralResource2 STR;

    public ConnectionBuilder(IDiagram diagram) {
        this.diagram = diagram;
        this.diagramResource = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        this.createFlags = Boolean.TRUE.equals(diagram.getHint(DiagramHints.KEY_USE_CONNECTION_FLAGS));
        this.ctx = (ISynchronizationContext)diagram.getHint(SynchronizationHints.CONTEXT);
        if (this.ctx != null) {
            this.elementClassProvider = (IElementClassProvider)this.ctx.get(SynchronizationHints.ELEMENT_CLASS_PROVIDER);
            this.layerManager = (GraphLayerManager)this.ctx.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
        } else {
            this.elementClassProvider = null;
            this.layerManager = null;
        }
    }

    protected void initializeResources(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
    }

    public void create(WriteGraph graph, final ConnectionJudgement judgment, Deque<ControlPoint> controlPoints, TerminalUtil.TerminalInfo startTerminal, TerminalUtil.TerminalInfo endTerminal) throws DatabaseException {
        EdgeVisuals.EdgeEnd flagEnd;
        this.cu = new ConnectionUtil(graph);
        this.initializeResources((ReadGraph)graph);
        final IModelingRules modelingRules = (IModelingRules)this.diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        final Resource startDisconnectedFlag = ConnectionBuilder.getDisconnectedFlag((ReadGraph)graph, startTerminal);
        final Resource endDisconnectedFlag = ConnectionBuilder.getDisconnectedFlag((ReadGraph)graph, endTerminal);
        if (startDisconnectedFlag != null || endDisconnectedFlag != null) {
            if (startDisconnectedFlag != null && endDisconnectedFlag != null) {
                final VirtualGraph graphProvider = graph.getProvider();
                final Session session = graph.getSession();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            return;
                        }
                        MessageDialog dialog = new MessageDialog(window.getShell(), "Connect or Join Flags?", null, "Connect flags together or join them visually into a connection?", 6, new String[]{"Connect Flags", "Join Flags", "Cancel"}, 0){
                            {
                                this.setShellStyle(this.getShellStyle() | 0x10000000);
                            }
                        };
                        final int choice = dialog.open();
                        if (choice != 2 && choice != -1) {
                            session.asyncRequest((Write)new WriteRequest(graphProvider){

                                public void perform(WriteGraph graph) throws DatabaseException {
                                    switch (choice) {
                                        case 0: {
                                            Resource join = FlagUtil.join(graph, startDisconnectedFlag, endDisconnectedFlag);
                                            FlagLabelingScheme scheme = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)graph);
                                            String commonLabel = scheme.generateLabel((ReadGraph)graph, (this).ConnectionBuilder.this.diagramResource);
                                            graph.claimLiteral(startDisconnectedFlag, (this).ConnectionBuilder.this.L0.HasLabel, (this).ConnectionBuilder.this.DIA.FlagLabel, (Object)commonLabel);
                                            graph.claimLiteral(endDisconnectedFlag, (this).ConnectionBuilder.this.L0.HasLabel, (this).ConnectionBuilder.this.DIA.FlagLabel, (Object)commonLabel);
                                            ConnectionBuilder.setJoinedConnectionTypes(graph, modelingRules, judgment, join);
                                            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                                            graph.addMetadata((Metadata)cm.add("Connected flags"));
                                            return;
                                        }
                                        case 1: {
                                            Resource join = FlagUtil.join(graph, startDisconnectedFlag, endDisconnectedFlag);
                                            ConnectionBuilder.setJoinedConnectionTypes(graph, modelingRules, judgment, join);
                                            new Joiner((ReadGraph)graph).joinLocal(graph, Arrays.asList(startDisconnectedFlag, endDisconnectedFlag));
                                            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                                            graph.addMetadata((Metadata)cm.add("Joined flags"));
                                            return;
                                        }
                                    }
                                }
                            }, (Callback)new Callback<DatabaseException>(){

                                public void run(DatabaseException e) {
                                    if (e != null) {
                                        ErrorLogger.defaultLogError((Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                });
                return;
            }
            TerminalUtil.TerminalInfo normalTerminal = null;
            Resource flagToRemove = null;
            Resource connection = null;
            if (startDisconnectedFlag != null) {
                flagToRemove = startDisconnectedFlag;
                normalTerminal = endTerminal;
                connection = ConnectionBuilder.attachedToExistingConnection((ReadGraph)graph, startTerminal);
            }
            if (endDisconnectedFlag != null) {
                flagToRemove = endDisconnectedFlag;
                normalTerminal = startTerminal;
                connection = ConnectionBuilder.attachedToExistingConnection((ReadGraph)graph, endTerminal);
            }
            if (connection != null) {
                Statement stm = graph.getSingleStatement(flagToRemove, this.STR.IsConnectedTo);
                Collection areConnecteds = graph.getObjects(stm.getObject(), this.DIA.AreConnected);
                graph.deny(stm);
                new RemoveElement((Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE), flagToRemove).perform(graph);
                this.cu.removeConnectionPart(stm.getObject());
                Connector newConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)normalTerminal.e), normalTerminal.t, startDisconnectedFlag != null ? EdgeVisuals.EdgeEnd.End : EdgeVisuals.EdgeEnd.Begin, judgment);
                for (Resource areConnected : areConnecteds) {
                    graph.claim(newConnector.getConnector(), this.DIA.AreConnected, areConnected);
                }
                if (modelingRules != null && judgment.connectionType != null) {
                    modelingRules.setConnectionType(graph, connection, judgment.connectionType);
                }
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Joined flags"));
                this.cu = null;
                return;
            }
        }
        Resource connection = this.getOrCreateConnection((ReadGraph)graph, startTerminal, endTerminal);
        AddElement.claimFreshElementName(graph, this.diagramResource, connection);
        List<Object> bps = Collections.emptyList();
        Resource firstBranchPoint = null;
        Resource lastBranchPoint = null;
        if (!this.isRouteGraphConnection(graph, connection) && !(bps = this.createBranchPoints(graph, connection, controlPoints)).isEmpty()) {
            Iterator<Object> it = bps.iterator();
            Pair prev = (Pair)it.next();
            firstBranchPoint = (Resource)prev.second;
            while (it.hasNext()) {
                Pair next = (Pair)it.next();
                this.cu.connect((Resource)prev.second, (Resource)next.second);
                prev = next;
            }
            lastBranchPoint = (Resource)prev.second;
        }
        Connector startConnector = null;
        Connector endConnector = null;
        IElement startFlag = null;
        IElement endFlag = null;
        if (startTerminal != null && endTerminal != null) {
            Resource startAttachment = this.chooseAttachmentRelationForNode((ReadGraph)graph, connection, startTerminal, judgment);
            Resource endAttachment = this.chooseAttachmentRelationForNode((ReadGraph)graph, connection, endTerminal, judgment);
            Pair<Resource, Resource> attachments = this.resolveEndAttachments(graph, startAttachment, endAttachment);
            startConnector = this.createConnectorForNodeWithAttachment(graph, connection, startTerminal, (Resource)attachments.first);
            endConnector = this.createConnectorForNodeWithAttachment(graph, connection, endTerminal, (Resource)attachments.second);
        } else if (startTerminal != null) {
            startConnector = this.createConnectorForNode(graph, connection, startTerminal, EdgeVisuals.EdgeEnd.Begin, judgment);
            if (this.createFlags) {
                flagEnd = this.cu.toEdgeEnd(this.cu.getAttachmentRelationForConnector(startConnector.getConnector()), EdgeVisuals.EdgeEnd.End).other();
                endFlag = this.createFlag(graph, connection, flagEnd, controlPoints.getLast(), FlagClass.Type.Out, null);
                endConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)endFlag), ElementUtils.getSingleTerminal((IElement)endFlag), flagEnd, judgment);
            }
        } else if (endTerminal != null) {
            endConnector = this.createConnectorForNode(graph, connection, endTerminal, EdgeVisuals.EdgeEnd.End, judgment);
            if (this.createFlags) {
                flagEnd = this.cu.toEdgeEnd(this.cu.getAttachmentRelationForConnector(endConnector.getConnector()), EdgeVisuals.EdgeEnd.Begin).other();
                startFlag = this.createFlag(graph, connection, flagEnd, controlPoints.getFirst(), FlagClass.Type.In, null);
                startConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)startFlag), ElementUtils.getSingleTerminal((IElement)startFlag), flagEnd, judgment);
            }
        } else if (this.createFlags) {
            startFlag = this.createFlag(graph, connection, EdgeVisuals.EdgeEnd.Begin, controlPoints.getFirst(), FlagClass.Type.In, null);
            startConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)startFlag), ElementUtils.getSingleTerminal((IElement)startFlag), EdgeVisuals.EdgeEnd.Begin, judgment);
            endFlag = this.createFlag(graph, connection, EdgeVisuals.EdgeEnd.End, controlPoints.getLast(), FlagClass.Type.Out, null);
            endConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)endFlag), ElementUtils.getSingleTerminal((IElement)endFlag), EdgeVisuals.EdgeEnd.End, judgment);
        }
        if (firstBranchPoint == null || lastBranchPoint == null) {
            this.cu.connect(startConnector.getConnector(), endConnector.getConnector());
        } else {
            this.cu.connect(startConnector.getConnector(), firstBranchPoint);
            this.cu.connect(lastBranchPoint, endConnector.getConnector());
        }
        if (judgment.connectionType != null && modelingRules != null) {
            modelingRules.setConnectionType(graph, connection, judgment.connectionType);
        }
        if (startFlag != null) {
            this.verifyFlagType(graph, modelingRules, startFlag);
        }
        if (endFlag != null) {
            this.verifyFlagType(graph, modelingRules, endFlag);
        }
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Added connection " + connection));
        graph.markUndoPoint();
        this.cu = null;
    }

    protected Pair<Resource, Resource> resolveEndAttachments(WriteGraph graph, Resource startAttachment, Resource endAttachment) throws DatabaseException {
        if (startAttachment != null && endAttachment != null) {
            return Pair.make((Object)startAttachment, (Object)endAttachment);
        }
        if (startAttachment != null && endAttachment == null) {
            return Pair.make((Object)startAttachment, (Object)this.getInverseAttachment((ReadGraph)graph, startAttachment, this.DIA.HasArrowConnector));
        }
        if (startAttachment == null && endAttachment != null) {
            return Pair.make((Object)this.getInverseAttachment((ReadGraph)graph, endAttachment, this.DIA.HasPlainConnector), (Object)endAttachment);
        }
        return Pair.make((Object)this.DIA.HasPlainConnector, (Object)this.DIA.HasArrowConnector);
    }

    protected Resource getInverseAttachment(ReadGraph graph, Resource attachment, Resource defaultValue) throws DatabaseException {
        Resource inverse = attachment != null ? graph.getPossibleObject(attachment, this.DIA.HasInverseAttachment) : defaultValue;
        return inverse != null ? inverse : defaultValue;
    }

    protected void verifyFlagType(WriteGraph graph, IModelingRules modelingRules, IElement flagElement) throws DatabaseException {
        if (modelingRules != null) {
            Resource flag = (Resource)flagElement.getHint(ElementHints.KEY_OBJECT);
            FlagClass.Type flagType = (FlagClass.Type)flagElement.getHint(FlagClass.KEY_FLAG_TYPE);
            FlagUtil.verifyFlagType(graph, modelingRules, flag, flagType);
        }
    }

    public Pair<Resource, Resource> attachToRouteGraph(WriteGraph graph, ConnectionJudgement judgment, Resource connection, Resource attachToLine, Deque<ControlPoint> controlPoints, TerminalUtil.TerminalInfo endTerminal) throws DatabaseException {
        this.cu = new ConnectionUtil(graph);
        this.initializeResources((ReadGraph)graph);
        Connector endConnector = null;
        if (endTerminal != null) {
            endConnector = this.createConnectorForNode(graph, connection, endTerminal, EdgeVisuals.EdgeEnd.End, judgment);
        } else if (this.createFlags) {
            IElement endFlag = this.createFlag(graph, connection, EdgeVisuals.EdgeEnd.End, controlPoints.getLast(), FlagClass.Type.Out, null);
            endConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)endFlag), ElementUtils.getSingleTerminal((IElement)endFlag), EdgeVisuals.EdgeEnd.End, judgment);
        }
        this.cu.connect(attachToLine, endConnector.getConnector());
        IModelingRules modelingRules = (IModelingRules)this.diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        if (judgment.connectionType != null && modelingRules != null) {
            modelingRules.setConnectionType(graph, connection, judgment.connectionType);
        }
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Branched connection " + connection));
        this.cu = null;
        return Pair.make((Object)endConnector.getAttachment(), (Object)endConnector.getConnector());
    }

    protected boolean isRouteGraphConnection(WriteGraph graph, Resource connection) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        return graph.isInstanceOf(connection, DIA.RouteGraphConnection);
    }

    public static Resource attachedToExistingConnection(ReadGraph graph, TerminalUtil.TerminalInfo ti) throws DatabaseException {
        Object obj = ElementUtils.getObject((IElement)ti.e);
        Resource cp = DiagramGraphUtil.getConnectionPointOfTerminal(graph, ti.t);
        if (obj instanceof Resource && cp != null) {
            Resource e = (Resource)obj;
            for (Resource connector : graph.getObjects(e, cp)) {
                Resource connection = ConnectionUtil.tryGetConnection(graph, connector);
                if (connection == null) continue;
                return connection;
            }
        }
        return null;
    }

    public Resource getOrCreateConnection(ReadGraph graph, TerminalUtil.TerminalInfo ... tis) throws DatabaseException {
        Resource connection = null;
        TerminalUtil.TerminalInfo[] terminalInfoArray = tis;
        int n = tis.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalUtil.TerminalInfo ti = terminalInfoArray[n2];
            connection = ConnectionBuilder.getExistingConnection(graph, ti);
            if (connection != null) break;
            ++n2;
        }
        if (connection == null) {
            ElementClass connectionClass = this.elementClassProvider.get(ElementClasses.CONNECTION);
            Resource connectionClassResource = (Resource)ElementUtils.checkedAdapt((ElementClass)connectionClass, Resource.class);
            connection = this.cu.newConnection(this.diagramResource, connectionClassResource);
        }
        return connection;
    }

    public List<Pair<ControlPoint, Resource>> createBranchPoints(WriteGraph graph, Resource connection, Collection<ControlPoint> controlPoints) throws DatabaseException {
        ArrayList<Pair<ControlPoint, Resource>> bps = new ArrayList<Pair<ControlPoint, Resource>>(controlPoints.size());
        for (ControlPoint cp : controlPoints) {
            if (cp.isAttachedToTerminal()) continue;
            Resource bp = this.cu.newBranchPoint(connection, AffineTransform.getTranslateInstance(cp.getPosition().getX(), cp.getPosition().getY()), cp.getDirection());
            bps.add((Pair<ControlPoint, Resource>)Pair.make((Object)cp, (Object)bp));
        }
        return bps;
    }

    protected Resource chooseAttachmentRelationForNode(ReadGraph graph, Resource connection, TerminalUtil.TerminalInfo ti, ConnectionJudgement judgment) throws DatabaseException {
        Resource node = (Resource)ElementUtils.getObject((IElement)ti.e);
        return this.chooseAttachmentRelationForNode(graph, connection, node, ti.t, judgment);
    }

    protected Resource chooseAttachmentRelationForNode(ReadGraph graph, Resource connection, Resource element, Topology.Terminal terminal, ConnectionJudgement judgment) throws DatabaseException {
        IConnectionPoint cp = ConnectionUtil.toConnectionPoint(graph, element, terminal);
        CPTerminal cpt = cp instanceof CPTerminal ? (CPTerminal)cp : null;
        Resource attachment = judgment.attachmentRelations.get(graph, cpt);
        return attachment;
    }

    protected Connector createConnectorForNode(WriteGraph graph, Resource connection, TerminalUtil.TerminalInfo ti, EdgeVisuals.EdgeEnd end, ConnectionJudgement judgment) throws DatabaseException {
        Resource node = (Resource)ElementUtils.getObject((IElement)ti.e);
        return this.createConnectorForNode(graph, connection, node, ti.t, end, judgment);
    }

    protected Connector createConnectorForNode(WriteGraph graph, Resource connection, Resource element, Topology.Terminal terminal, EdgeVisuals.EdgeEnd end, ConnectionJudgement judgment) throws DatabaseException {
        IConnectionPoint cp = ConnectionUtil.toConnectionPoint((ReadGraph)graph, element, terminal);
        CPTerminal cpt = cp instanceof CPTerminal ? (CPTerminal)cp : null;
        Resource attachment = judgment.attachmentRelations.get((ReadGraph)graph, cpt);
        if (attachment == null) {
            attachment = this.cu.toHasConnectorRelation(end);
        }
        Resource connector = this.cu.getOrCreateConnector(connection, element, terminal, end, attachment);
        return new Connector(attachment, connector);
    }

    protected Connector createConnectorForNodeWithAttachment(WriteGraph graph, Resource connection, TerminalUtil.TerminalInfo ti, Resource attachment) throws DatabaseException {
        Resource node = (Resource)ElementUtils.getObject((IElement)ti.e);
        return this.createConnectorForNodeWithAttachment(graph, connection, node, ti.t, attachment);
    }

    protected Connector createConnectorForNodeWithAttachment(WriteGraph graph, Resource connection, Resource element, Topology.Terminal terminal, Resource attachment) throws DatabaseException {
        Resource connector = this.cu.getOrCreateConnector(connection, element, terminal, null, attachment);
        return new Connector(attachment, connector);
    }

    public IElement createFlag(WriteGraph graph, Resource connection, EdgeVisuals.EdgeEnd end, ControlPoint cp, FlagClass.Type type, String label) throws DatabaseException {
        ElementClass flagClass = this.elementClassProvider.get(ElementClasses.FLAG);
        IElement flagElement = Element.spawnNew((ElementClass)flagClass);
        Resource flagClassResource = (Resource)ElementUtils.checkedAdapt((ElementClass)flagClass, Resource.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource flag = graph.newResource();
        graph.claim(flag, L0.InstanceOf, null, flagClassResource);
        flagElement.setHint(ElementHints.KEY_OBJECT, (Object)flag);
        OrderedSetUtils.add((WriteGraph)graph, (Resource)this.diagramResource, (Resource)flag);
        AffineTransform at = AffineTransform.getTranslateInstance(cp.getPosition().getX(), cp.getPosition().getY());
        flagElement.setHint(ElementHints.KEY_TRANSFORM, (Object)at);
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        graph.claimLiteral(flag, DIA.HasTransform, G2D.Transform, (Object)matrix);
        flagElement.setHint(FlagClass.KEY_FLAG_TYPE, (Object)type);
        graph.claim(flag, DIA.HasFlagType, null, DiagramGraphUtil.toFlagTypeResource(DIA, type));
        if (label != null) {
            graph.claimLiteral(flag, L0.HasLabel, DIA.FlagLabel, (Object)label, (Binding)Bindings.STRING);
        }
        AddElement.claimFreshElementName(graph, this.diagramResource, flag);
        graph.claim(this.diagramResource, L0.ConsistsOf, flag);
        if (this.layerManager != null) {
            this.layerManager.removeFromAllLayers(graph, flag);
            this.layerManager.putElementOnVisibleLayers(this.diagram, graph, flag);
        }
        return flagElement;
    }

    protected static Resource getExistingConnection(ReadGraph graph, TerminalUtil.TerminalInfo ti) throws DatabaseException {
        if (ti != null) {
            Object obj;
            if (ConnectionBuilder.isConnection(ti.e)) {
                Object obj2 = ElementUtils.getObject((IElement)ti.e);
                if (obj2 instanceof Resource) {
                    Resource c = (Resource)obj2;
                    return graph.isInstanceOf(c, DiagramResource.getInstance((ReadGraph)graph).Connection) ? c : null;
                }
            } else if (ConnectionBuilder.isBranchPoint(ti.e) && (obj = ElementUtils.getObject((IElement)ti.e)) instanceof Resource) {
                return ConnectionUtil.tryGetConnection(graph, (Resource)obj);
            }
        }
        return null;
    }

    protected static boolean isConnection(IElement e) {
        return e.getElementClass().containsClass(ConnectionHandler.class);
    }

    protected static boolean isBranchPoint(IElement e) {
        return e.getElementClass().containsClass(BranchPoint.class);
    }

    protected static Resource getDisconnectedFlag(ReadGraph graph, TerminalUtil.TerminalInfo terminal) throws DatabaseException {
        Resource flag;
        Object obj;
        if (terminal != null && (obj = ElementUtils.getObject((IElement)terminal.e)) instanceof Resource && graph.isInstanceOf(flag = (Resource)obj, DiagramResource.getInstance((ReadGraph)graph).Flag) && FlagUtil.isDisconnected(graph, flag)) {
            return flag;
        }
        return null;
    }

    protected static void setJoinedConnectionTypes(WriteGraph graph, IModelingRules modelingRules, ConnectionJudgement judgment, Resource join) throws DatabaseException {
        if (modelingRules != null && judgment != null && judgment.connectionType != null) {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            ArrayList<Resource> connections = new ArrayList<Resource>(2);
            for (Resource flag : graph.getObjects(join, DIA.FlagIsJoinedBy)) {
                for (Resource connector : graph.getObjects(flag, STR.IsConnectedTo)) {
                    Resource connection = ConnectionUtil.tryGetConnection((ReadGraph)graph, connector);
                    if (connection == null) continue;
                    connections.add(connection);
                }
            }
            for (Resource connection : connections) {
                modelingRules.setConnectionType(graph, connection, judgment.connectionType);
            }
        }
    }

    protected static class Connector
    extends Tuple2 {
        public Connector(Resource attachmentRelation, Resource connector) {
            super((Object)attachmentRelation, (Object)connector);
        }

        public Resource getAttachment() {
            return (Resource)this.c0;
        }

        public Resource getConnector() {
            return (Resource)this.c1;
        }
    }
}

