/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.internal.timing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.internal.timing.GTask;
import org.simantics.diagram.synchronization.ErrorHandler;

public final class Timing {
    private static Method BEGIN_METHOD;
    private static Method END_METHOD;

    static {
        try {
            Class<?> logClass = Class.forName("org.simantics.threadlog.ThreadLog");
            Class<?> taskClass = Class.forName("org.simantics.threadlog.Task");
            Method begin = logClass.getMethod("BEGIN", String.class);
            Method end = taskClass.getMethod("end", new Class[0]);
            BEGIN_METHOD = begin;
            END_METHOD = end;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void timed(String label, GTask r) throws DatabaseException {
        Object t = Timing.BEGIN(label);
        try {
            long start = 0L;
            long end = 0L;
            if (DebugPolicy.PERFORM_TIMING) {
                start = System.nanoTime();
            }
            r.run();
            if (DebugPolicy.PERFORM_TIMING) {
                end = System.nanoTime();
                System.out.println("TIMED " + (double)(end - start) * 1.0E-6 + "ms for " + label);
            }
        }
        finally {
            Timing.END(t);
        }
    }

    public static void safeTimed(ErrorHandler errorHandler, String label, GTask r) {
        Object t = Timing.BEGIN(label);
        try {
            long start = 0L;
            long end = 0L;
            if (DebugPolicy.PERFORM_TIMING) {
                start = System.nanoTime();
            }
            try {
                r.run();
            }
            catch (DatabaseException e) {
                errorHandler.error(e.getMessage(), e);
            }
            if (DebugPolicy.PERFORM_TIMING) {
                end = System.nanoTime();
                System.out.println("TIMED " + (double)(end - start) * 1.0E-6 + "ms for " + label);
            }
        }
        finally {
            Timing.END(t);
        }
    }

    public static Object BEGIN(String name) {
        if (DebugPolicy.PERFORM_TIMING && BEGIN_METHOD != null) {
            try {
                return BEGIN_METHOD.invoke(null, name);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void END(Object task) {
        if (DebugPolicy.PERFORM_TIMING && task != null) {
            try {
                END_METHOD.invoke(task, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

