/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ExceptionUtils;

public class TerminalConnectionDirectionsMenuContribution
extends DynamicMenuContribution {
    private static final IContributionItem[] NONE = new IContributionItem[0];
    private static final int[] DIRECTION_MASK = new int[]{8, 4, 1, 2};
    private static final String[] DIRECTION_NAME = new String[]{"Up", "Left", "Right", "Down"};

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        return TerminalConnectionDirectionsMenuContribution.getTerminalDirectionItems(graph, selection).toArray(NONE);
    }

    public static Collection<IContributionItem> getTerminalDirectionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> terminals = new ArrayList<Resource>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            Resource connection = (Resource)AdaptionUtils.adaptToSingle((Object)s, Resource.class);
            if (connection == null || !graph.isInstanceOf(connection, DIA.Terminal)) {
                return Collections.emptyList();
            }
            terminals.add(connection);
            ++n2;
        }
        if (terminals.isEmpty()) {
            return Collections.emptyList();
        }
        int jointMask = 0;
        for (Resource terminal : terminals) {
            Integer dirs = (Integer)graph.getPossibleRelatedValue(terminal, DIA.Terminal_AllowedDirections, (Binding)Bindings.INTEGER);
            int mask = dirs == null ? 0 : dirs;
            jointMask |= mask;
        }
        final ArrayList<ToggleDirectionAction> actions = new ArrayList<ToggleDirectionAction>(4);
        int i = 0;
        while (i < DIRECTION_NAME.length) {
            String name = DIRECTION_NAME[i];
            int mask = DIRECTION_MASK[i];
            boolean wasChecked = (jointMask & mask) != 0;
            int orMask = wasChecked ? 0 : mask;
            int andMask = wasChecked ? ~mask : -1;
            ToggleDirectionAction action = new ToggleDirectionAction(graph.getSession(), terminals, orMask, andMask, name);
            action.setChecked(wasChecked);
            actions.add(action);
            ++i;
        }
        return Collections.singleton(new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem directions = new MenuItem(menu, 64, index);
                directions.setText("Allowed Routing Directions");
                Menu subMenu = new Menu(menu);
                directions.setMenu(subMenu);
                for (ToggleDirectionAction a : actions) {
                    MenuItem item = new MenuItem(subMenu, 32);
                    item.setText(a.getText());
                    item.addSelectionListener((SelectionListener)a);
                    item.setSelection(a.isChecked());
                }
            }
        });
    }

    static class ToggleDirectionAction
    extends Action
    implements SelectionListener {
        Session session;
        Collection<Resource> terminals;
        int orMask;
        int andMask;

        public ToggleDirectionAction(Session session, List<Resource> terminals, int orMask, int andMask, String name) {
            super(name, 2);
            this.session = session;
            this.terminals = terminals;
            this.orMask = orMask;
            this.andMask = andMask;
        }

        public void run() {
            this.session.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    for (Resource terminal : ToggleDirectionAction.this.terminals) {
                        Integer dirs = (Integer)graph.getPossibleRelatedValue(terminal, DIA.Terminal_AllowedDirections, (Binding)Bindings.INTEGER);
                        int mask = dirs == null ? 0 : dirs;
                        mask &= ToggleDirectionAction.this.andMask;
                        graph.claimLiteral(terminal, DIA.Terminal_AllowedDirections, (Object)(mask |= ToggleDirectionAction.this.orMask), (Binding)Bindings.INTEGER);
                    }
                }
            }, (Callback)new Callback<DatabaseException>(){

                public void run(DatabaseException parameter) {
                    if (parameter != null) {
                        ExceptionUtils.logError((Throwable)parameter);
                    }
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }
    }
}

