/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Set;
import org.simantics.diagram.participant.ContextUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.utils.TextSegment;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.FocusEvent;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;

@Deprecated
public class EditTextHandler
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    Selection selection;
    @DependencyReflection.Reference
    ContextUtil contextUtil;

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent ke) {
        if (Commands.RENAME.equals((Object)ke.command)) {
            for (Set s : this.selection.getSelections().values()) {
                for (IElement element : s) {
                    TextEditor.Modifier modifier;
                    TextEditor ed;
                    ILayers layers;
                    IDiagram diagram;
                    ElementLayers elementLayers = (ElementLayers)element.getElementClass().getAtMostOneItemOfClass(ElementLayers.class);
                    if (elementLayers != null && (diagram = ElementUtils.peekDiagram((IElement)element)) != null && (layers = (ILayers)diagram.getHint(DiagramHints.KEY_LAYERS)) != null && !elementLayers.isFocusable(element, layers) || (ed = (TextEditor)element.getElementClass().getAtMostOneItemOfClass(TextEditor.class)) == null || (modifier = ed.getModifier(element)) == null) continue;
                    ICanvasParticipant oldEditor = (ICanvasParticipant)this.diagram.removeHint(DiagramHints.KEY_ACTIVE_INLINE_EDITOR);
                    if (oldEditor instanceof TextEditParticipant) {
                        TextEditParticipant tep = (TextEditParticipant)oldEditor;
                        if (ElementUtils.elementEquals((IElement)element, (IElement)tep.element)) {
                            return true;
                        }
                        tep.commit();
                    } else if (oldEditor instanceof AbstractCanvasParticipant) {
                        ((AbstractCanvasParticipant)oldEditor).remove();
                    }
                    String editText = modifier.getValue(element);
                    ed.setText(element, editText);
                    ed.setActive(element, true);
                    ed.setSelection(element, TextSegment.whole((String)editText));
                    ed.setCaretPosition(element, Integer.valueOf(editText.length()));
                    TextEditParticipant newEditor = new TextEditParticipant(element, ed);
                    this.getContext().add((Object)newEditor);
                    this.diagram.setHint(DiagramHints.KEY_ACTIVE_INLINE_EDITOR, (Object)newEditor);
                    this.setDirty();
                }
            }
            return true;
        }
        return false;
    }

    class TextEditParticipant
    extends AbstractDiagramParticipant {
        final IElement element;
        final TextEditor ed;
        Collection<String> originalContexts;
        Point2D elementPoint = new Point2D.Double();

        public TextEditParticipant(IElement element, TextEditor ed) {
            this.element = element;
            this.ed = ed;
        }

        public void addedToContext(ICanvasContext ctx) {
            super.addedToContext(ctx);
            if (EditTextHandler.this.contextUtil != null) {
                this.originalContexts = EditTextHandler.this.contextUtil.getActivatedContextIds();
                EditTextHandler.this.contextUtil.deactivateAll();
                EditTextHandler.this.contextUtil.activate("org.simantics.modeling.ui.diagramming.inlineEdit");
            }
        }

        public void removedFromContext(ICanvasContext ctx) {
            ICanvasParticipant ed;
            if (EditTextHandler.this.contextUtil != null) {
                EditTextHandler.this.contextUtil.deactivateAll();
                EditTextHandler.this.contextUtil.activate(this.originalContexts);
            }
            if (this == (ed = (ICanvasParticipant)this.diagram.getHint(DiagramHints.KEY_ACTIVE_INLINE_EDITOR))) {
                this.diagram.removeHint(DiagramHints.KEY_ACTIVE_INLINE_EDITOR);
            }
            super.removedFromContext(ctx);
        }

        public boolean commit() {
            this.ed.setActive(this.element, false);
            this.ed.setSelection(this.element, null);
            this.ed.setCaretPosition(this.element, null);
            TextEditor.Modifier modi = this.ed.getModifier(this.element);
            try {
                try {
                    modi.modify(this.element, this.ed.getText(this.element));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.setDirty();
                    this.remove();
                }
            }
            finally {
                this.setDirty();
                this.remove();
            }
            return true;
        }

        public boolean cancel() {
            this.ed.setActive(this.element, false);
            this.ed.setSelection(this.element, TextSegment.EMPTY);
            this.ed.setCaretPosition(this.element, null);
            this.setDirty();
            this.remove();
            return true;
        }

        @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
        public boolean handleCommandEvent(CommandEvent e) {
            if (Commands.SELECT_ALL.equals((Object)e.command)) {
                this.selectAll();
                return true;
            }
            return false;
        }

        private void selectAll() {
            String text;
            TextSegment sel = this.ed.getSelection(this.element);
            if (!sel.isWhole(text = this.ed.getText(this.element))) {
                this.ed.setSelection(this.element, TextSegment.whole((String)text));
                this.ed.setCaretPosition(this.element, Integer.valueOf(text.length()));
                this.setDirty();
            }
        }

        @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
        public boolean handleFocus(FocusEvent.FocusLostEvent event) {
            this.commit();
            return false;
        }

        @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
        public boolean handleMouse(MouseEvent event) {
            if (event instanceof MouseEvent.MouseMovedEvent) {
                return false;
            }
            return false;
        }

        @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
        public boolean handleEvent(KeyEvent.KeyPressedEvent event) {
            boolean shiftPressed;
            String text = this.ed.getText(this.element);
            Integer caretPos = this.ed.getCaretPosition(this.element);
            TextSegment segment = this.ed.getSelection(this.element);
            if (segment == null) {
                segment = TextSegment.EMPTY;
            }
            boolean onlyCtrlPressed = (event.stateMask & 0x22C0) == 128;
            boolean bl = shiftPressed = (event.stateMask & 0x40) != 0;
            if (event.keyCode == 65 && onlyCtrlPressed) {
                this.selectAll();
                this.debugEditor();
                return true;
            }
            if (event.keyCode == 27) {
                this.cancel();
            } else {
                if (event.keyCode == 37) {
                    if (caretPos > 0) {
                        int newCaretPos = caretPos;
                        TextSegment newSegment = segment;
                        if (!shiftPressed) {
                            newCaretPos = segment.isEmpty() ? caretPos - 1 : segment.start();
                            newSegment = TextSegment.EMPTY;
                        } else if (segment.isEmpty()) {
                            newCaretPos = caretPos - 1;
                            newSegment = TextSegment.single((int)newCaretPos);
                        } else {
                            if (segment.atStart(caretPos.intValue())) {
                                newSegment = segment.prepend(1);
                            } else if (segment.atEnd(caretPos.intValue())) {
                                newSegment = segment.append(-1);
                            }
                            newCaretPos = caretPos - 1;
                        }
                        this.ed.setSelection(this.element, newSegment);
                        this.ed.setCaretPosition(this.element, Integer.valueOf(newCaretPos));
                        this.setDirty();
                        this.debugEditor();
                    } else if (!shiftPressed && !segment.isEmpty()) {
                        this.ed.setSelection(this.element, TextSegment.EMPTY);
                        this.setDirty();
                        this.debugEditor();
                    }
                    return true;
                }
                if (event.keyCode == 39) {
                    if (caretPos < text.length()) {
                        int newCaretPos = caretPos;
                        TextSegment newSegment = segment;
                        if (!shiftPressed) {
                            newCaretPos = segment.isEmpty() ? caretPos + 1 : segment.end();
                            newSegment = TextSegment.EMPTY;
                        } else if (segment.isEmpty()) {
                            newSegment = TextSegment.single((int)caretPos);
                            newCaretPos = caretPos + 1;
                        } else {
                            if (segment.atStart(caretPos.intValue())) {
                                newSegment = segment.prepend(-1);
                            } else if (segment.atEnd(caretPos.intValue())) {
                                newSegment = segment.append(1);
                            }
                            newCaretPos = caretPos + 1;
                        }
                        this.ed.setSelection(this.element, newSegment);
                        this.ed.setCaretPosition(this.element, Integer.valueOf(newCaretPos));
                        this.setDirty();
                        this.debugEditor();
                    } else if (!shiftPressed && !segment.isEmpty()) {
                        this.ed.setSelection(this.element, TextSegment.EMPTY);
                        this.setDirty();
                        this.debugEditor();
                    }
                    return true;
                }
                if (event.keyCode == 36) {
                    if (caretPos > 0) {
                        TextSegment newSegment = segment;
                        if (!shiftPressed) {
                            newSegment = TextSegment.EMPTY;
                        } else if (segment.isEmpty()) {
                            newSegment = TextSegment.before((int)caretPos);
                        } else if (segment.atStart(caretPos.intValue())) {
                            newSegment = segment.prepend(segment.start());
                        } else if (segment.atEnd(caretPos.intValue())) {
                            newSegment = segment.beforeStart();
                        }
                        this.ed.setSelection(this.element, newSegment);
                        this.ed.setCaretPosition(this.element, Integer.valueOf(0));
                        this.setDirty();
                        this.debugEditor();
                    } else if (!shiftPressed && !segment.isEmpty()) {
                        this.ed.setSelection(this.element, TextSegment.EMPTY);
                        this.setDirty();
                        this.debugEditor();
                    }
                    return true;
                }
                if (event.keyCode == 35) {
                    if (caretPos < text.length()) {
                        TextSegment newSegment = segment;
                        if (!shiftPressed) {
                            newSegment = TextSegment.EMPTY;
                        } else if (segment.isEmpty()) {
                            newSegment = TextSegment.single((int)caretPos).extendToEnd(text);
                        } else if (segment.atStart(caretPos.intValue())) {
                            newSegment = segment.afterEnd(text);
                        } else if (segment.atEnd(caretPos.intValue())) {
                            newSegment = segment.extendToEnd(text);
                        }
                        this.ed.setSelection(this.element, newSegment);
                        this.ed.setCaretPosition(this.element, Integer.valueOf(text.length()));
                        this.setDirty();
                        this.debugEditor();
                    } else if (!shiftPressed && !segment.isEmpty()) {
                        this.ed.setSelection(this.element, TextSegment.EMPTY);
                        this.setDirty();
                        this.debugEditor();
                    }
                    return true;
                }
                if (event.keyCode == 127) {
                    if (text.length() > 0) {
                        String newText = text;
                        if (!segment.isEmpty()) {
                            newText = segment.removeFrom(text);
                            this.ed.setCaretPosition(this.element, Integer.valueOf(segment.start()));
                        } else if (caretPos < text.length()) {
                            newText = TextSegment.single((int)caretPos).removeFrom(text);
                        }
                        this.ed.setText(this.element, newText);
                        this.ed.setSelection(this.element, TextSegment.EMPTY);
                        this.getContext().getContentContext().setDirty();
                        this.debugEditor();
                    }
                    return true;
                }
                if (event.keyCode == 8) {
                    if (text.length() > 0 && caretPos > 0) {
                        String newText = text;
                        if (!segment.isEmpty()) {
                            newText = segment.removeFrom(text);
                            this.ed.setCaretPosition(this.element, Integer.valueOf(segment.start()));
                        } else {
                            newText = TextSegment.single((int)(caretPos - 1)).removeFrom(text);
                            this.ed.setCaretPosition(this.element, Integer.valueOf(caretPos - 1));
                        }
                        this.ed.setText(this.element, newText);
                        this.ed.setSelection(this.element, TextSegment.EMPTY);
                        this.getContext().getContentContext().setDirty();
                        this.debugEditor();
                    }
                    return true;
                }
                if (event.keyCode == 10) {
                    return this.commit();
                }
                if (this.isValidCharacter(event.character)) {
                    String newText = text;
                    int newCaretPos = caretPos + 1;
                    if (!segment.isEmpty()) {
                        newText = this.insert(segment.removeFrom(text), segment.start(), event.character);
                        newCaretPos = segment.start() + 1;
                    } else {
                        newText = this.insert(text, caretPos, event.character);
                    }
                    this.ed.setText(this.element, newText);
                    this.ed.setSelection(this.element, TextSegment.EMPTY);
                    this.ed.setCaretPosition(this.element, Integer.valueOf(newCaretPos));
                    this.setDirty();
                    this.debugEditor();
                    return true;
                }
            }
            return false;
        }

        void debugEditor() {
        }

        boolean isValidCharacter(char c) {
            return c >= ' ' && c < '\u007f' || Character.isLetterOrDigit(c) && !Character.isISOControl(c);
        }

        private String insert(String s, int pos, char c) {
            if (pos == s.length()) {
                return String.valueOf(s) + c;
            }
            return String.valueOf(s.substring(0, pos)) + c + s.substring(pos);
        }
    }
}

