/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.handler.ElementAssortment;
import org.simantics.diagram.handler.ElementObjectAssortment;
import org.simantics.diagram.handler.ElementType;
import org.simantics.diagram.handler.IElementAssortment;
import org.simantics.diagram.handler.PasteOperation;
import org.simantics.diagram.handler.Paster;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.MoveRouteGraphConnection;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scl.commands.Command;
import org.simantics.scl.commands.Commands;

public final class CopyPasteUtil {
    static final EnumSet<ElementType> NODES = EnumSet.of(ElementType.Node);
    static final EnumSet<ElementType> CONNECTIONS = EnumSet.of(ElementType.Connection);
    static final EnumSet<ElementType> CONNECTION_PARTS = EnumSet.of(ElementType.Edge, ElementType.BranchPoint);
    static final EnumSet<ElementType> FLAGS = EnumSet.of(ElementType.Flag);
    static final EnumSet<ElementType> MONITORS = EnumSet.of(ElementType.Monitor);
    static final EnumSet<ElementType> OTHERS = EnumSet.of(ElementType.Other);
    static final EnumSet<ElementType> NODES_AND_EDGES = EnumSet.of(ElementType.Node);
    static final EnumSet<ElementType> NOT_FLAGS = EnumSet.complementOf(FLAGS);

    public static boolean isFlagsOnlySelection(IElementAssortment ea) {
        return !ea.containsAny(NOT_FLAGS) && ea.contains(FLAGS) && ea.count(ElementType.Flag) > 0;
    }

    public static boolean onlyFlagsWithoutCorrespondence(RequestProcessor processor, ElementObjectAssortment ea) throws DatabaseException {
        return CopyPasteUtil.isFlagsOnlySelection(ea) && CopyPasteUtil.checkFlagsCorrespondences(processor, ea.flags, false);
    }

    public static boolean onlyFlagsWithoutCorrespondence(ElementAssortment ea) {
        return CopyPasteUtil.isFlagsOnlySelection(ea) && CopyPasteUtil.checkFlagsCorrespondences(ea.flags, false);
    }

    public static boolean checkFlagsCorrespondences(RequestProcessor processor, final Iterable<Resource> flags, final boolean expectedValue) throws DatabaseException {
        return (Boolean)processor.syncRequest((Read)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return CopyPasteUtil.checkFlagsCorrespondences(graph, (Iterable<Resource>)flags, expectedValue);
            }
        });
    }

    public static boolean checkFlagsCorrespondences(ReadGraph graph, Iterable<Resource> flags, boolean expectedValue) throws DatabaseException {
        for (Resource flag : flags) {
            if (FlagUtil.isJoined(graph, flag) == expectedValue) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFlagsCorrespondences(Iterable<IElement> flags, boolean expectedValue) {
        for (IElement flag : flags) {
            if (CopyPasteUtil.flagHasCorrespondence(flag) == expectedValue) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFlagExternality(RequestProcessor processor, final Iterable<Resource> flags, final boolean expectedValue) throws DatabaseException {
        return (Boolean)processor.syncRequest((Read)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return CopyPasteUtil.checkFlagExternality(graph, (Iterable<Resource>)flags, expectedValue);
            }
        });
    }

    public static boolean checkFlagExternality(ReadGraph graph, Iterable<Resource> flags, boolean expectedValue) throws DatabaseException {
        for (Resource flag : flags) {
            if (FlagUtil.isExternal(graph, flag) == expectedValue) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFlagExternality(Iterable<IElement> flags, boolean expectedValue) {
        for (IElement flag : flags) {
            if (CopyPasteUtil.flagIsExternal(flag) == expectedValue) continue;
            return false;
        }
        return true;
    }

    public static boolean flagHasCorrespondence(IElement flag) {
        FlagHandler fh = (FlagHandler)flag.getElementClass().getSingleItem(FlagHandler.class);
        if (fh == null) {
            throw new IllegalArgumentException("Not a flag element: " + flag);
        }
        return fh.getConnectionData(flag) != null;
    }

    public static boolean flagIsExternal(IElement flag) {
        FlagHandler fh = (FlagHandler)flag.getElementClass().getSingleItem(FlagHandler.class);
        if (fh == null) {
            throw new IllegalArgumentException("Not a flag element: " + flag);
        }
        return fh.isExternal(flag);
    }

    public static Set<Resource> gatherBranchPoints(ReadGraph graph, ElementObjectAssortment ea) throws DatabaseException {
        HashSet<Resource> bps = new HashSet<Resource>();
        bps.addAll(ea.branchPoints);
        for (Resource connection : ea.connections) {
            bps.addAll(CopyPasteUtil.getBranchPoints(graph, connection));
        }
        return bps;
    }

    public static Set<Resource> gatherRouteGraphConnections(ReadGraph graph, ElementObjectAssortment ea) throws DatabaseException {
        HashSet<Resource> rgcs = new HashSet<Resource>();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource connection : ea.connections) {
            if (!graph.isInstanceOf(connection, DIA.RouteGraphConnection)) continue;
            rgcs.add(connection);
        }
        return rgcs;
    }

    public static Collection<Resource> getBranchPoints(ReadGraph graph, Resource connection) throws DatabaseException {
        return graph.getObjects(connection, DiagramResource.getInstance((ReadGraph)graph).HasBranchPoint);
    }

    public static void moveElements(WriteGraph graph, Set<Resource> elements, double xoffset, double yoffset) throws DatabaseException {
        for (Resource e : elements) {
            AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, e);
            at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), at.getTranslateX() + xoffset, at.getTranslateY() + yoffset);
            DiagramGraphUtil.setTransform(graph, e, at);
        }
    }

    public static void moveElements(WriteGraph graph, Set<Resource> elements, Point2D offset) throws DatabaseException {
        CopyPasteUtil.moveElements(graph, elements, offset.getX(), offset.getY());
    }

    public static void moveParentedElements(WriteGraph graph, PasteOperation op, Set<Resource> elements, Resource parentRelation, double xoffset, double yoffset) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource e : elements) {
            Resource referencedElement;
            Resource referencedParentComponent = graph.getPossibleObject(e, parentRelation);
            if (referencedParentComponent == null || (referencedElement = graph.getPossibleObject(referencedParentComponent, MOD.ComponentToElement)) != null && op.ea.all.contains(referencedElement)) continue;
            AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, e);
            at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), at.getTranslateX() + xoffset, at.getTranslateY() + yoffset);
            DiagramGraphUtil.setTransform(graph, e, at);
        }
    }

    public static void moveMonitors(WriteGraph graph, PasteOperation op, Set<Resource> elements, double xoffset, double yoffset) throws DatabaseException {
        CopyPasteUtil.moveParentedElements(graph, op, elements, DiagramResource.getInstance((ReadGraph)graph).HasMonitorComponent, xoffset, yoffset);
    }

    public static void moveReferenceElements(WriteGraph graph, PasteOperation op, Set<Resource> elements, double xoffset, double yoffset) throws DatabaseException {
        CopyPasteUtil.moveParentedElements(graph, op, elements, ModelingResources.getInstance((ReadGraph)graph).HasParentComponent, xoffset, yoffset);
    }

    public static void moveRouteGraphConnections(WriteGraph graph, Set<Resource> connections, Point2D offset) throws DatabaseException {
        if (!connections.isEmpty()) {
            Command command = Commands.get((ReadGraph)graph, (String)"Simantics/Diagram/moveConnection");
            Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(connections.iterator().next()));
            for (Resource r : connections) {
                command.execute((RequestProcessor)graph, root, new Object[]{r, offset.getX(), offset.getY()});
            }
        }
    }

    public static void moveConnection(WriteGraph graph, Resource connection, double offsetX, double offsetY) throws DatabaseException {
        new MoveRouteGraphConnection(connection, offsetX, offsetY).perform(graph);
    }

    public static void copyElementPosition(ICanvasContext ctx, IElement source, IElement target, Point2D offset) {
        Point2D pos = ElementUtils.getPos((IElement)source);
        double x = pos.getX() + offset.getX();
        double y = pos.getY() + offset.getY();
        ElementUtils.setPos((IElement)target, (Point2D)CopyPasteUtil.snap(ctx, new Point2D.Double(x, y)));
    }

    public static void copyElementPosition(WriteGraph graph, ICanvasContext ctx, Resource sourceElement, Resource targetElement, Point2D offset) throws DatabaseException {
        AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, sourceElement);
        Point2D snapped = CopyPasteUtil.snap(ctx, new Point2D.Double(at.getTranslateX() + offset.getX(), at.getTranslateY() + offset.getY()));
        at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), snapped.getX(), snapped.getY());
        DiagramGraphUtil.setTransform(graph, targetElement, at);
    }

    public static Point2D snap(ICanvasContext ctx, Point2D p) {
        ISnapAdvisor snapAdvisor;
        if (ctx != null && (snapAdvisor = (ISnapAdvisor)ctx.getHintStack().getHint(DiagramHints.SNAP_ADVISOR)) != null) {
            snapAdvisor.snap(p);
        }
        return p;
    }

    public static void localCutPaste(final PasteOperation op) throws DatabaseException {
        Simantics.getSession().sync((WriteInterface)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                CopyPasteUtil.localCutPaste(graph, op);
                Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Cutted " + op + " to local target"));
            }
        });
    }

    public static void localCutPaste(WriteGraph graph, PasteOperation op) throws DatabaseException {
        if (op.sameDiagram() && op.cut) {
            CopyPasteUtil.moveElements(graph, op.ea.nodes, op.offset);
            CopyPasteUtil.moveElements(graph, op.ea.flags, op.offset);
            CopyPasteUtil.moveElements(graph, CopyPasteUtil.gatherBranchPoints((ReadGraph)graph, op.ea), op.offset);
            CopyPasteUtil.moveRouteGraphConnections(graph, CopyPasteUtil.gatherRouteGraphConnections((ReadGraph)graph, op.ea), op.offset);
            CopyPasteUtil.moveElements(graph, op.ea.others, op.offset);
            CopyPasteUtil.moveMonitors(graph, op, op.ea.monitors, op.offset.getX(), op.offset.getY());
            CopyPasteUtil.moveReferenceElements(graph, op, op.ea.references, op.offset.getX(), op.offset.getY());
        }
    }

    public static void continueFlags(final PasteOperation op) throws DatabaseException {
        Simantics.getSession().sync((WriteInterface)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                CopyPasteUtil.continueFlags(graph, op);
            }
        });
    }

    public static void continueFlags(WriteGraph graph, PasteOperation op) throws DatabaseException {
        IModifiableSynchronizationContext targetContext = (IModifiableSynchronizationContext)op.target.getHint(SynchronizationHints.CONTEXT);
        if (targetContext == null) {
            throw new IllegalArgumentException("target diagram has no synchronization context");
        }
        CopyAdvisor ca = (CopyAdvisor)op.target.getHint(SynchronizationHints.COPY_ADVISOR);
        if (ca == null) {
            throw new IllegalArgumentException("no copy advisor");
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        FlagLabelingScheme scheme = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)graph);
        int joinedFlags = 0;
        for (Resource src : op.ea.flags) {
            String label;
            Resource sourceDiagram = graph.getPossibleObject(src, L0.PartOf);
            Resource copy = CopyAdvisorUtil.copy(targetContext, graph, ca, src, sourceDiagram, op.targetDiagram);
            OrderedSetUtils.add((WriteGraph)graph, (Resource)op.targetDiagram, (Resource)copy);
            graph.claim(op.targetDiagram, L0.ConsistsOf, copy);
            AddElement.claimFreshElementName(graph, op.targetDiagram, copy);
            GraphLayerManager glm = (GraphLayerManager)targetContext.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
            if (glm != null) {
                glm.removeFromAllLayers(graph, copy);
                glm.putElementOnVisibleLayers(op.target, graph, copy);
            }
            CopyPasteUtil.copyElementPosition(graph, op.ctx, src, copy, op.offset);
            FlagClass.Type type = FlagUtil.getFlagType((ReadGraph)graph, src, FlagClass.Type.Out);
            FlagUtil.setFlagType(graph, copy, type.other());
            FlagUtil.join(graph, src, copy);
            if (scheme != null && (label = scheme.generateLabel((ReadGraph)graph, op.targetDiagram)) != null) {
                graph.claimLiteral(src, L0.HasLabel, DIA.FlagLabel, (Object)label, (Binding)Bindings.STRING);
                graph.claimLiteral(copy, L0.HasLabel, DIA.FlagLabel, (Object)label, (Binding)Bindings.STRING);
            }
            graph.denyValue(copy, DIA.Flag_HasIOTableBinding);
            graph.denyValue(copy, DIA.Flag_HasIOTableRowIndex);
            ++joinedFlags;
        }
        if (joinedFlags > 0) {
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Continued " + joinedFlags + " flag(s)"));
        }
    }

    public static void performDefaultPaste(PasteOperation op) throws DatabaseException {
        Session session = Simantics.getSession();
        new Paster(session, op).perform();
    }
}

