/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class Splitter {
    Layer0 L0;
    DiagramResource DIA;
    StructuralResource2 STR;
    ModelingResources MOD;

    public Splitter(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
    }

    public void split(WriteGraph graph, IElement edgeElement, EdgeResource edge, Point2D splitCanvasPos) throws DatabaseException {
        Parts parts2;
        ConnectionUtil cu = new ConnectionUtil(graph);
        Resource connection = ConnectionUtil.getConnection((ReadGraph)graph, edge);
        Resource diagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)graph, (Resource)connection, (Resource)this.DIA.Diagram);
        cu.disconnect(edge);
        Parts parts1 = Parts.calculate((ReadGraph)graph, edge.first());
        Parts moveToNewConnection = parts2 = Parts.calculate((ReadGraph)graph, edge.second());
        Resource keepConnector = edge.first();
        Resource moveToNewConnectionConnector = edge.second();
        boolean inputsOnly1 = parts1.hasInputsOnly((ReadGraph)graph);
        boolean inputsOnly2 = parts2.hasInputsOnly((ReadGraph)graph);
        if (!(inputsOnly1 && inputsOnly2 || !inputsOnly1)) {
            moveToNewConnection = parts1;
            keepConnector = edge.second();
            moveToNewConnectionConnector = edge.first();
        }
        Resource connectionType = graph.getSingleType(connection, this.DIA.Connection);
        Resource hasConnectionType = graph.getPossibleObject(connection, this.STR.HasConnectionType);
        Resource newConnection = cu.newConnection(diagram, connectionType);
        if (hasConnectionType != null) {
            graph.claim(newConnection, this.STR.HasConnectionType, null, hasConnectionType);
        }
        for (Statement routing : graph.getStatements(connection, this.DIA.Routing)) {
            graph.claim(newConnection, routing.getPredicate(), newConnection);
        }
        for (Statement stm : moveToNewConnection.parts) {
            graph.deny(stm);
            graph.claim(stm.getSubject(), stm.getPredicate(), newConnection);
        }
        FlagClass.Type type1 = FlagClass.Type.Out;
        FlagClass.Type type2 = FlagClass.Type.In;
        Line2D nearestEdge = ConnectionUtil.resolveNearestEdgeLineSegment(splitCanvasPos, edgeElement);
        Vector2d ab = new Vector2d(nearestEdge.getX2() - nearestEdge.getX1(), nearestEdge.getY2() - nearestEdge.getY1());
        Vector2d ap = new Vector2d(splitCanvasPos.getX() - nearestEdge.getX1(), splitCanvasPos.getY() - nearestEdge.getY1());
        double theta = Math.atan2(ab.y, ab.x);
        ab.normalize();
        Vector2d intersection = new Vector2d(ab);
        intersection.scale(ap.dot(ab));
        intersection.add((Tuple2d)new Vector2d(nearestEdge.getX1(), nearestEdge.getY1()));
        Vector2d pos1 = new Vector2d(intersection);
        Vector2d pos2 = new Vector2d(intersection);
        ab.normalize();
        ab.scale(5.0);
        pos2.add((Tuple2d)ab);
        ab.negate();
        pos1.add((Tuple2d)ab);
        FlagLabelingScheme scheme = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)graph);
        String commonLabel = scheme.generateLabel((ReadGraph)graph, diagram);
        Resource flag1 = this.createFlag(graph, diagram, this.getFlagTransform((Tuple2d)pos1, theta), type1, commonLabel);
        Resource flag2 = this.createFlag(graph, diagram, this.getFlagTransform((Tuple2d)pos2, theta), type2, commonLabel);
        Resource flagConnector1 = cu.newConnector(connection, this.DIA.HasArrowConnector);
        Resource flagConnector2 = cu.newConnector(newConnection, this.DIA.HasPlainConnector);
        graph.claim(flag1, this.DIA.Flag_ConnectionPoint, flagConnector1);
        graph.claim(flag2, this.DIA.Flag_ConnectionPoint, flagConnector2);
        graph.claim(flagConnector1, this.DIA.AreConnected, keepConnector);
        graph.claim(flagConnector2, this.DIA.AreConnected, moveToNewConnectionConnector);
        FlagUtil.join(graph, flag1, flag2);
    }

    private AffineTransform getFlagTransform(Tuple2d pos, double theta) {
        AffineTransform at = AffineTransform.getTranslateInstance(pos.x, pos.y);
        at.rotate(theta);
        return at;
    }

    private Resource createFlag(WriteGraph graph, Resource diagram, AffineTransform tr, FlagClass.Type type, String label) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource flag = graph.newResource();
        graph.claim(flag, this.L0.InstanceOf, null, DIA.Flag);
        AddElement.claimFreshElementName(graph, diagram, flag);
        graph.claim(flag, this.L0.PartOf, this.L0.ConsistsOf, diagram);
        DiagramGraphUtil.setTransform(graph, flag, tr);
        if (type != null) {
            FlagUtil.setFlagType(graph, flag, type);
        }
        if (label != null) {
            graph.claimLiteral(flag, this.L0.HasLabel, DIA.FlagLabel, (Object)label, (Binding)Bindings.STRING);
        }
        OrderedSetUtils.add((WriteGraph)graph, (Resource)diagram, (Resource)flag);
        return flag;
    }

    static class Parts {
        DiagramResource DIA;
        Set<Statement> parts = new HashSet<Statement>();

        private Parts(ReadGraph graph) {
            this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        }

        public int size() {
            return this.parts.size();
        }

        public static Parts calculate(ReadGraph graph, Resource routeNode) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            Parts p = new Parts(graph);
            ArrayDeque<Resource> todo = new ArrayDeque<Resource>();
            HashSet<Resource> visited = new HashSet<Resource>();
            todo.add(routeNode);
            while (!todo.isEmpty()) {
                Resource part = (Resource)todo.poll();
                if (!visited.add(part)) continue;
                todo.addAll(graph.getObjects(part, DIA.AreConnected));
                Statement toConnection = graph.getPossibleStatement(part, DIA.IsConnectorOf);
                if (toConnection == null) {
                    toConnection = graph.getPossibleStatement(part, DIA.HasInteriorRouteNode_Inverse);
                }
                if (toConnection == null) continue;
                p.parts.add(toConnection);
            }
            return p;
        }

        public boolean hasInputsOnly(ReadGraph graph) throws ServiceException {
            return this.hasInputs(graph) && !this.hasOutputs(graph);
        }

        public boolean hasInputs(ReadGraph graph) throws ServiceException {
            return this.hasRelations(graph, this.DIA.IsArrowConnectorOf);
        }

        public boolean hasOutputs(ReadGraph graph) throws ServiceException {
            return this.hasRelations(graph, this.DIA.IsPlainConnectorOf);
        }

        public boolean hasRelations(ReadGraph graph, Resource relation) throws ServiceException {
            for (Statement stm : this.parts) {
                if (!graph.isSubrelationOf(stm.getPredicate(), relation)) continue;
                return true;
            }
            return false;
        }
    }
}

