/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.adapter.RouteGraphUtils;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.splitting.SplittedRouteGraph;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RouteGraphModification;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class RouteGraphConnectionSplitter {
    private static final boolean DEBUG = false;
    Layer0 L0;
    DiagramResource DIA;
    StructuralResource2 STR;
    ModelingResources MOD;
    SerialisationSupport ss;

    public RouteGraphConnectionSplitter(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
        this.ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
    }

    public void split(WriteGraph graph, Resource connection, RouteGraph rg, Point2D splitCanvasPos) throws DatabaseException {
        SplittedRouteGraph srg;
        RouteGraphModification modis = new RouteGraphModification(this.ss, rg);
        TObjectIntHashMap<RouteNode> idMap = modis.getIdMap();
        RouteLine line = SplittedRouteGraph.findNearestLine((RouteGraph)rg, (Point2D)splitCanvasPos);
        if (line == null) {
            return;
        }
        double isectX = splitCanvasPos.getX();
        double isectY = splitCanvasPos.getY();
        if (line.isHorizontal()) {
            isectY = line.getPosition();
            srg = rg.splitGraph(line, isectX);
        } else {
            isectX = line.getPosition();
            srg = rg.splitGraph(line, isectY);
        }
        if (rg.isSimpleConnection()) {
            RouteNode na = (RouteNode)srg.terminals1.iterator().next();
            RouteNode nb = (RouteNode)srg.terminals2.iterator().next();
            Resource a = this.ss.getResource(((Long)na.getData()).longValue());
            Resource b = this.ss.getResource(((Long)nb.getData()).longValue());
            graph.deny(a, this.DIA.AreConnected, b);
            modis.addModi(new RouteGraphModification.RemoveLink(idMap.get((Object)na), idMap.get((Object)nb)));
        } else if (srg.splitLine.isTransient()) {
            RouteTerminal terminal = srg.splitLine.getTerminal();
            Resource connector = this.ss.getResource(((Long)terminal.getData()).longValue());
            graph.deny(connector, this.DIA.AreConnected);
            modis.addModi(new RouteGraphModification.RemoveLink(idMap.get((Object)terminal), idMap.get((Object)terminal.getLine())));
        } else {
            graph.deny(this.ss.getResource(((Long)srg.splitLine.getData()).longValue()));
            modis.addModi(new RouteGraphModification.RemoveLine(idMap.get((Object)srg.splitLine)));
        }
        ArrayList<Resource> interfaceNodes1Resources = new ArrayList<Resource>(srg.interfaceNodes1.size());
        for (RouteNode n : srg.interfaceNodes1) {
            interfaceNodes1Resources.add(this.ss.getResource(((Long)n.getData()).longValue()));
        }
        ArrayList<Resource> interfaceNodes2Resources = new ArrayList<Resource>(srg.interfaceNodes2.size());
        for (RouteNode n : srg.interfaceNodes2) {
            interfaceNodes2Resources.add(this.ss.getResource(((Long)n.getData()).longValue()));
        }
        ArrayList<Resource> lines2Resources = new ArrayList<Resource>(srg.lines2.size());
        for (RouteLine n : srg.lines2) {
            lines2Resources.add(this.ss.getResource(((Long)n.getData()).longValue()));
        }
        ArrayList<Resource> terminals1Resources = new ArrayList<Resource>(srg.terminals1.size());
        for (RouteTerminal n : srg.terminals1) {
            terminals1Resources.add(this.ss.getResource(((Long)n.getData()).longValue()));
        }
        ArrayList<Resource> terminals2Resources = new ArrayList<Resource>(srg.terminals2.size());
        for (RouteTerminal n : srg.terminals2) {
            terminals2Resources.add(this.ss.getResource(((Long)n.getData()).longValue()));
        }
        this.doSplit(graph, connection, interfaceNodes1Resources, interfaceNodes2Resources, lines2Resources, terminals1Resources, terminals2Resources, line.isHorizontal(), isectX, isectY);
        modis.addModi(new RouteGraphModification.Split(modis.toIds(interfaceNodes1Resources), modis.toIds(interfaceNodes2Resources), modis.toIds(lines2Resources), modis.toIds(terminals1Resources), modis.toIds(terminals2Resources), line.isHorizontal(), isectX, isectY));
    }

    public void doSplit(WriteGraph graph, Resource connection, ArrayList<Resource> interfaceNodes1Resources, ArrayList<Resource> interfaceNodes2Resources, ArrayList<Resource> lines2Resources, ArrayList<Resource> terminals1Resources, ArrayList<Resource> terminals2Resources, boolean isHorizontal, double isectX, double isectY) throws DatabaseException {
        FlagClass.Type type2;
        FlagClass.Type type1;
        Vector2d pos2;
        Vector2d pos1;
        double theta;
        ConnectionUtil cu = new ConnectionUtil(graph);
        Resource diagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)graph, (Resource)connection, (Resource)this.DIA.Diagram);
        Resource connectionType = graph.getSingleType(connection, this.DIA.Connection);
        Resource hasConnectionType = graph.getPossibleObject(connection, this.STR.HasConnectionType);
        Resource newConnection = cu.newConnection(diagram, connectionType);
        if (hasConnectionType != null) {
            graph.claim(newConnection, this.STR.HasConnectionType, null, hasConnectionType);
        }
        AddElement.claimFreshElementName(graph, diagram, newConnection);
        this.removeFlagJoins(graph, cu, connection, terminals1Resources);
        this.removeFlagJoins(graph, cu, connection, terminals2Resources);
        for (Resource rn : lines2Resources) {
            graph.denyStatement(connection, this.DIA.HasInteriorRouteNode, rn);
            graph.claim(newConnection, this.DIA.HasInteriorRouteNode, rn);
        }
        for (Resource rn : terminals2Resources) {
            Statement stat = graph.getSingleStatement(rn, this.DIA.IsConnectorOf);
            Resource predicate = stat.getPredicate();
            graph.deny(rn, predicate);
            graph.claim(rn, predicate, newConnection);
        }
        FlagLabelingScheme scheme = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)graph);
        String commonLabel = scheme.generateLabel((ReadGraph)graph, diagram);
        double flagDist = 3.0;
        if (isHorizontal) {
            theta = 0.0;
            pos1 = new Vector2d(isectX - flagDist, isectY);
            pos2 = new Vector2d(isectX + flagDist, isectY);
        } else {
            theta = 1.5707963267948966;
            pos1 = new Vector2d(isectX, isectY - flagDist);
            pos2 = new Vector2d(isectX, isectY + flagDist);
        }
        int inputs1 = 0;
        int outputs1 = 0;
        for (Resource connector : terminals1Resources) {
            if (graph.hasStatement(connector, this.DIA.IsHeadConnectorOf)) {
                ++inputs1;
                continue;
            }
            ++outputs1;
        }
        int inputs2 = 0;
        int outputs2 = 0;
        for (Resource connector : terminals2Resources) {
            if (graph.hasStatement(connector, this.DIA.IsHeadConnectorOf)) {
                ++inputs2;
                continue;
            }
            ++outputs2;
        }
        if (outputs1 == 0) {
            type1 = FlagClass.Type.In;
            type2 = FlagClass.Type.Out;
            theta += Math.PI;
        } else {
            type1 = FlagClass.Type.Out;
            type2 = FlagClass.Type.In;
        }
        Resource flag1 = this.createFlag(graph, diagram, this.getFlagTransform((Tuple2d)pos1, theta), type1, commonLabel);
        Resource flag2 = this.createFlag(graph, diagram, this.getFlagTransform((Tuple2d)pos2, theta), type2, commonLabel);
        Resource flagConnector1 = cu.newConnector(connection, type1 == FlagClass.Type.In ? this.DIA.HasPlainConnector : this.DIA.HasArrowConnector);
        Resource flagConnector2 = cu.newConnector(newConnection, type2 == FlagClass.Type.In ? this.DIA.HasPlainConnector : this.DIA.HasArrowConnector);
        graph.claim(flag1, this.DIA.Flag_ConnectionPoint, flagConnector1);
        graph.claim(flag2, this.DIA.Flag_ConnectionPoint, flagConnector2);
        double position = isHorizontal ? isectY : isectX;
        this.connectFlag(graph, isHorizontal, position, connection, flagConnector1, interfaceNodes1Resources);
        this.connectFlag(graph, isHorizontal, position, newConnection, flagConnector2, interfaceNodes2Resources);
        FlagUtil.join(graph, flag1, flag2);
        if (type1 == FlagClass.Type.In) {
            RouteGraphConnectionSplitter.moveStatements(graph, connection, newConnection, this.MOD.ElementToComponent);
            RouteGraphConnectionSplitter.moveStatements(graph, connection, newConnection, this.MOD.DiagramConnectionToConnection);
            RouteGraphConnectionSplitter.moveStatements(graph, connection, newConnection, this.MOD.DiagramConnectionToConnectionSpecial);
        }
    }

    private void removeFlagJoins(WriteGraph graph, ConnectionUtil cu, Resource connection, ArrayList<Resource> connectors) throws DatabaseException {
        for (Resource connector : connectors) {
            Resource diagram;
            Resource e = cu.getConnectedComponent(connection, connector);
            if (!graph.isInstanceOf(e, this.DIA.Flag) || (diagram = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(e, this.DIA.Diagram))) == null) continue;
            for (Resource join : graph.getObjects(e, this.DIA.FlagIsJoinedBy)) {
                Collection joinsComposites = graph.getObjects(join, this.STR.JoinsComposite);
                if (joinsComposites.size() == 1) {
                    graph.deny(join, this.STR.Joins);
                    continue;
                }
                if (joinsComposites.size() != 2) continue;
                for (Resource joins : graph.getObjects(join, this.STR.Joins)) {
                    Resource partOfDiagram;
                    Resource diagramConnection = graph.getPossibleObject(joins, this.MOD.ConnectionToDiagramConnection);
                    if (diagramConnection == null || !diagram.equals(partOfDiagram = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(diagramConnection, this.DIA.Diagram)))) continue;
                    graph.deny(join, this.STR.Joins, joins);
                }
            }
        }
    }

    private static void moveStatements(WriteGraph graph, Resource from, Resource to, Resource relation) throws DatabaseException {
        if (from.equals(to)) {
            return;
        }
        for (Statement stat : graph.getStatements(from, relation)) {
            if (!stat.getSubject().equals(from)) continue;
            graph.claim(to, stat.getPredicate(), stat.getObject());
        }
        graph.deny(from, relation);
    }

    private void connectFlag(WriteGraph graph, boolean isHorizontal, double position, Resource connection, Resource flagConnector, Collection<Resource> interfaceNodes) throws DatabaseException {
        if (interfaceNodes.size() > 1) {
            Resource routeLine = graph.newResource();
            graph.claim(routeLine, this.L0.InstanceOf, this.DIA.RouteLine);
            graph.claim(connection, this.DIA.HasInteriorRouteNode, routeLine);
            graph.claimLiteral(routeLine, this.DIA.IsHorizontal, (Object)isHorizontal);
            graph.claimLiteral(routeLine, this.DIA.HasPosition, (Object)position);
            graph.claim(routeLine, this.DIA.AreConnected, flagConnector);
            flagConnector = routeLine;
        }
        for (Resource rn : interfaceNodes) {
            graph.claim(flagConnector, this.DIA.AreConnected, rn);
        }
    }

    private AffineTransform getFlagTransform(Tuple2d pos, double theta) {
        AffineTransform at = AffineTransform.getTranslateInstance(pos.x, pos.y);
        at.rotate(theta);
        return at;
    }

    private Resource createFlag(WriteGraph graph, Resource diagram, AffineTransform tr, FlagClass.Type type, String label) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource flag = graph.newResource();
        graph.claim(flag, this.L0.InstanceOf, null, DIA.Flag);
        AddElement.claimFreshElementName(graph, diagram, flag);
        graph.claim(flag, this.L0.PartOf, this.L0.ConsistsOf, diagram);
        DiagramGraphUtil.setTransform(graph, flag, tr);
        if (type != null) {
            FlagUtil.setFlagType(graph, flag, type);
        }
        if (label != null) {
            graph.claimLiteral(flag, this.L0.HasLabel, DIA.FlagLabel, (Object)label, (Binding)Bindings.STRING);
        }
        OrderedSetUtils.add((WriteGraph)graph, (Resource)diagram, (Resource)flag);
        return flag;
    }

    public static void splitConnection(WriteGraph graph, Resource connection, double x, double y) throws DatabaseException {
        RouteGraph rg = RouteGraphUtils.load((ReadGraph)graph, null, connection);
        new RouteGraphConnectionSplitter((ReadGraph)graph).split(graph, connection, rg, new Point2D.Double(x, y));
    }
}

