/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class Joiner {
    Layer0 L0;
    DiagramResource DIA;
    StructuralResource2 STR;
    ModelingResources MOD;

    public Joiner(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
    }

    public void joinLocal(WriteGraph graph, Collection<Resource> flags) throws DatabaseException {
        ConnectionUtil cu = new ConnectionUtil(graph);
        HashSet<Resource> visited = new HashSet<Resource>();
        ArrayDeque<Resource> todo = new ArrayDeque<Resource>(flags);
        while (!todo.isEmpty()) {
            Resource flag1 = todo.poll();
            Resource flag2 = FlagUtil.getPossibleCounterpart((ReadGraph)graph, flag1);
            if (flag2 == null || !visited.add(flag1) || !visited.add(flag2)) continue;
            FlagClass.Type type1 = FlagUtil.getFlagType((ReadGraph)graph, flag1);
            FlagClass.Type type2 = FlagUtil.getFlagType((ReadGraph)graph, flag2);
            Resource connector1 = null;
            Resource connector2 = null;
            Resource connection1 = null;
            Resource connection2 = null;
            for (Resource connector : graph.getObjects(flag1, this.STR.IsConnectedTo)) {
                connector1 = graph.getPossibleObject(connector, this.DIA.AreConnected);
                connection1 = ConnectionUtil.getConnection((ReadGraph)graph, connector1);
            }
            for (Resource connector : graph.getObjects(flag2, this.STR.IsConnectedTo)) {
                connector2 = graph.getPossibleObject(connector, this.DIA.AreConnected);
                connection2 = ConnectionUtil.getConnection((ReadGraph)graph, connector2);
            }
            if (connection1 == null || connector1 == null || connection2 == null || connector2 == null) continue;
            for (Resource connector : graph.getObjects(flag1, this.STR.IsConnectedTo)) {
                connector1 = graph.getPossibleObject(connector, this.DIA.AreConnected);
                connection1 = ConnectionUtil.getConnection((ReadGraph)graph, connector1);
                cu.removeConnectionPart(connector);
            }
            for (Resource connector : graph.getObjects(flag2, this.STR.IsConnectedTo)) {
                connector2 = graph.getPossibleObject(connector, this.DIA.AreConnected);
                connection2 = ConnectionUtil.getConnection((ReadGraph)graph, connector2);
                cu.removeConnectionPart(connector);
            }
            Resource connectionToKeep = connection1;
            Resource connectionToRemove = connection2;
            Resource hasElementToComponent1 = graph.getPossibleObject(connection1, this.MOD.ElementToComponent);
            Resource hasElementToComponent2 = graph.getPossibleObject(connection2, this.MOD.ElementToComponent);
            if (hasElementToComponent1 != null && hasElementToComponent2 != null) {
                throw new UnsupportedOperationException("Both flag are connected with connections that have mapped components, can't decide which connection to remove in join operation");
            }
            if (hasElementToComponent2 != null || type1 != FlagClass.Type.Out && type2 == FlagClass.Type.Out) {
                connectionToKeep = connection2;
                connectionToRemove = connection1;
            }
            for (Resource diagram : OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)flag1, (Resource)this.DIA.Diagram)) {
                OrderedSetUtils.remove((WriteGraph)graph, (Resource)diagram, (Resource)flag1);
            }
            for (Resource diagram : OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)flag2, (Resource)this.DIA.Diagram)) {
                OrderedSetUtils.remove((WriteGraph)graph, (Resource)diagram, (Resource)flag2);
            }
            FlagUtil.disconnectFlag(graph, flag1);
            double[] transform1 = (double[])graph.getRelatedValue(flag1, this.DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
            double[] transform2 = (double[])graph.getRelatedValue(flag2, this.DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
            RemoverUtil.remove((WriteGraph)graph, (Resource)flag1);
            RemoverUtil.remove((WriteGraph)graph, (Resource)flag2);
            for (Statement connectorStat : graph.getStatements(connectionToRemove, this.DIA.HasConnector)) {
                graph.deny(connectorStat);
                graph.claim(connectionToKeep, connectorStat.getPredicate(), connectorStat.getObject());
            }
            for (Resource node : graph.getObjects(connectionToRemove, this.DIA.HasInteriorRouteNode)) {
                graph.deny(node, this.DIA.HasInteriorRouteNode_Inverse, connectionToRemove);
                graph.claim(node, this.DIA.HasInteriorRouteNode_Inverse, connectionToKeep);
            }
            cu.removeConnection(connectionToRemove);
            if (graph.isInstanceOf(connector1, this.DIA.RouteLine) && graph.isInstanceOf(connector2, this.DIA.RouteLine) && graph.getRelatedValue(connector1, this.DIA.IsHorizontal) == graph.getRelatedValue(connector2, this.DIA.IsHorizontal)) {
                boolean horizontal = (Boolean)graph.getRelatedValue(connector1, this.DIA.IsHorizontal);
                double position = horizontal ? 0.5 * (transform1[4] + transform2[4]) : 0.5 * (transform1[5] + transform2[5]);
                Resource intermediateRouteLine = graph.newResource();
                graph.claim(intermediateRouteLine, this.L0.InstanceOf, this.DIA.RouteLine);
                graph.claimLiteral(intermediateRouteLine, this.DIA.IsHorizontal, (Object)(!horizontal ? 1 : 0));
                graph.claimLiteral(intermediateRouteLine, this.DIA.HasPosition, (Object)position);
                graph.claim(connectionToKeep, this.DIA.HasInteriorRouteNode, intermediateRouteLine);
                graph.claim(connector1, this.DIA.AreConnected, intermediateRouteLine);
                graph.claim(connector2, this.DIA.AreConnected, intermediateRouteLine);
                continue;
            }
            graph.claim(connector1, this.DIA.AreConnected, connector2);
        }
    }

    public static void joinFlagsLocal(WriteGraph graph, Collection<Resource> flags) throws DatabaseException {
        new Joiner((ReadGraph)graph).joinLocal(graph, flags);
    }
}

