/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.IFlagType;
import org.simantics.diagram.flag.IFlagTypeReader;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.structural2.queries.Terminal;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.ResourceWithContext;
import org.simantics.utils.datastructures.Triple;

public final class FlagUtil {
    public static boolean isDisconnected(ReadGraph graph, Resource flag) throws DatabaseException {
        return !FlagUtil.isJoined(graph, flag) && !FlagUtil.isExternal(graph, flag);
    }

    public static boolean isExternal(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        boolean ext = graph.hasStatement(flag, DIA.ExternalFlag);
        if (!ext) {
            return false;
        }
        Resource cp = FlagUtil.getPossibleCounterpart(graph, flag);
        return cp == null;
    }

    public static boolean isJoined(ReadGraph graph, Resource flag) throws DatabaseException {
        return FlagUtil.getCounterparts(graph, flag).size() > 0;
    }

    public static boolean isLifted(ReadGraph graph, Resource flag) throws DatabaseException {
        Resource cp = FlagUtil.getPossibleConnectionPoint(graph, flag);
        return cp == null ? false : graph.isInstanceOf(cp, StructuralResource2.getInstance((ReadGraph)graph).ConnectionRelation);
    }

    public static Resource getPossibleConnectionPoint(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(flag, DIA.IsLiftedAs);
    }

    public static Resource getPossibleCounterpart(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource connectionJoin : graph.getObjects(flag, DIA.FlagIsJoinedBy)) {
            for (Resource otherFlag : graph.getObjects(connectionJoin, DIA.JoinsFlag)) {
                if (flag.equals(otherFlag)) continue;
                return otherFlag;
            }
        }
        return null;
    }

    public static Set<Resource> getCounterparts(ReadGraph graph, Resource flag, Set<Resource> result) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource connectionJoin : graph.getObjects(flag, DIA.FlagIsJoinedBy)) {
            for (Resource otherFlag : graph.getObjects(connectionJoin, DIA.JoinsFlag)) {
                if (flag.equals(otherFlag)) continue;
                result.add(otherFlag);
            }
        }
        return result;
    }

    public static Set<Resource> getCounterparts(ReadGraph graph, Resource flag) throws DatabaseException {
        return FlagUtil.getCounterparts(graph, flag, new HashSet<Resource>(8));
    }

    public static Set<Resource> getCounterpartsAndSelf(ReadGraph graph, Resource flag, Set<Resource> result) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource connectionJoin : graph.getObjects(flag, DIA.FlagIsJoinedBy)) {
            for (Resource otherFlag : graph.getObjects(connectionJoin, DIA.JoinsFlag)) {
                result.add(otherFlag);
            }
        }
        if (result.size() == 0) {
            result.add(flag);
        }
        return result;
    }

    public static Set<Resource> getCounterpartsAndSelf(ReadGraph graph, Resource flag) throws DatabaseException {
        return FlagUtil.getCounterpartsAndSelf(graph, flag, new HashSet<Resource>(8));
    }

    public static Resource join(WriteGraph g, Resource flag, Resource otherFlag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        Resource connectionJoin = g.newResource();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        g.claim(connectionJoin, L0.InstanceOf, null, STR.ConnectionJoin);
        g.claim(connectionJoin, DIA.JoinsFlag, flag);
        g.claim(connectionJoin, DIA.JoinsFlag, otherFlag);
        IActivationManager manager = (IActivationManager)g.getService(IActivationManager.class);
        for (Resource diagram : OrderedSetUtils.getSubjects((ReadGraph)g, (Resource)flag)) {
            manager.activateOnce(diagram);
        }
        for (Resource diagram : OrderedSetUtils.getSubjects((ReadGraph)g, (Resource)otherFlag)) {
            manager.activateOnce(diagram);
        }
        return connectionJoin;
    }

    public static void disconnectFlag(WriteGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource connectionJoin : graph.getObjects(flag, DIA.FlagIsJoinedBy)) {
            graph.deny(flag, DIA.FlagIsJoinedBy, connectionJoin);
            if (graph.getObjects(connectionJoin, DIA.JoinsFlag).size() >= 2) continue;
            RemoverUtil.remove((WriteGraph)graph, (Resource)connectionJoin);
        }
    }

    public static void disconnectFlag(WriteGraph graph, Resource flag, Resource fromFlag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource connectionJoin : graph.getObjects(flag, DIA.FlagIsJoinedBy)) {
            for (Resource otherFlag : graph.getObjects(connectionJoin, DIA.JoinsFlag)) {
                if (flag.equals(otherFlag) || !otherFlag.equals(fromFlag)) continue;
                graph.deny(connectionJoin, DIA.JoinsFlag, DIA.FlagIsJoinedBy, flag);
                if (graph.getObjects(connectionJoin, DIA.JoinsFlag).size() >= 2) continue;
                RemoverUtil.remove((WriteGraph)graph, (Resource)connectionJoin);
            }
        }
    }

    public static void removeFlag(WriteGraph graph, Resource flag) throws DatabaseException {
        FlagUtil.disconnectFlag(graph, flag);
        RemoverUtil.remove((WriteGraph)graph, (Resource)flag);
    }

    public static boolean isJoinedInSingleDiagram(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource counterpart = FlagUtil.getPossibleCounterpart(graph, flag);
        if (counterpart == null) {
            return false;
        }
        return !Collections.disjoint(OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)flag, (Resource)DIA.Diagram), OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)counterpart, (Resource)DIA.Diagram));
    }

    public static boolean isJoinedBetweenDiagrams(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Set<Resource> counterparts = FlagUtil.getCounterparts(graph, flag);
        if (counterparts.isEmpty()) {
            return false;
        }
        Collection flagDiagrams = OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)flag, (Resource)DIA.Diagram);
        for (Resource counterpart : counterparts) {
            if (!Collections.disjoint(flagDiagrams, OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)counterpart, (Resource)DIA.Diagram))) continue;
            return true;
        }
        return false;
    }

    public static FlagClass.Type getFlagType(ReadGraph graph, Resource flag) throws DatabaseException {
        return FlagUtil.getFlagType(graph, flag, null);
    }

    public static FlagClass.Type getFlagType(ReadGraph graph, Resource flag, FlagClass.Type defaultFlagType) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource type = graph.getPossibleObject(flag, DIA.HasFlagType);
        return DiagramGraphUtil.toFlagType(DIA, type, defaultFlagType);
    }

    public static void setFlagType(WriteGraph graph, Resource flag, FlagClass.Type type) throws DatabaseException {
        Resource existingFlagType;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource flagType = DiagramGraphUtil.toFlagTypeResource(DIA, type);
        if (flagType.equals(existingFlagType = graph.getPossibleObject(flag, DIA.HasFlagType))) {
            return;
        }
        graph.deny(flag, DIA.HasFlagType);
        graph.claim(flag, DIA.HasFlagType, null, flagType);
    }

    public static Set<Resource> findDirectlyConnectedComponents(ReadGraph graph, Resource flag) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource connector : graph.getObjects(flag, STR.IsConnectedTo)) {
            Resource connection;
            Resource diagramConnection = ConnectionUtil.tryGetConnection(graph, connector);
            if (diagramConnection == null || (connection = graph.getPossibleObject(diagramConnection, MOD.DiagramConnectionToConnection)) == null) continue;
            return new HashSet<Resource>(graph.getObjects(connection, STR.Connects));
        }
        return Collections.emptySet();
    }

    public static Set<Terminal> findDirectlyConnectedTerminals(ReadGraph graph, Resource flag) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource connector : graph.getObjects(flag, STR.IsConnectedTo)) {
            Resource connection;
            Resource diagramConnection = ConnectionUtil.tryGetConnection(graph, connector);
            if (diagramConnection == null || (connection = graph.getPossibleObject(diagramConnection, MOD.DiagramConnectionToConnection)) == null) continue;
            HashSet<Terminal> terminals = new HashSet<Terminal>();
            for (Statement stm : graph.getStatements(connection, STR.Connects)) {
                terminals.add(new Terminal(stm.getObject(), graph.getInverse(stm.getPredicate())));
            }
            return terminals;
        }
        return Collections.emptySet();
    }

    public static Set<Triple<Resource, Resource, Resource>> findDirectlyConnectedElementTerminals(ReadGraph graph, Resource toElement) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        HashSet<Triple<Resource, Resource, Resource>> result = new HashSet<Triple<Resource, Resource, Resource>>();
        for (Resource connector : graph.getObjects(toElement, STR.IsConnectedTo)) {
            Resource diagramConnection = ConnectionUtil.tryGetConnection(graph, connector);
            if (diagramConnection == null) continue;
            for (Statement connectionToConnector : graph.getStatements(diagramConnection, DIA.HasConnector)) {
                Resource connector2 = connectionToConnector.getObject();
                if (connector.equals(connector2)) continue;
                Resource attachmentRelation = connectionToConnector.getPredicate();
                for (Statement connectorToElement : graph.getStatements(connector2, STR.Connects)) {
                    Resource terminalRelation = graph.getPossibleInverse(connectorToElement.getPredicate());
                    if (terminalRelation == null) continue;
                    result.add((Triple<Resource, Resource, Resource>)Triple.make((Object)connectorToElement.getObject(), (Object)terminalRelation, (Object)attachmentRelation));
                }
            }
        }
        return result;
    }

    public static Variable getPossibleFlagSignal(ReadGraph graph, Variable configuration, Resource flag, Resource type) throws DatabaseException {
        Variable v;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource component = graph.getPossibleObject(flag, MOD.ElementToComponent);
        if (component != null && graph.isInstanceOf(component, type) && (v = configuration.browsePossible(graph, component)) != null) {
            return v;
        }
        Resource connector = graph.getPossibleObject(flag, DIA.Flag_ConnectionPoint);
        if (connector == null) {
            return null;
        }
        Resource connection = (Resource)graph.sync((ReadInterface)new PossibleObjectWithType(connector, DIA.IsConnectorOf, DIA.Connection));
        if (connection == null) {
            return null;
        }
        return FlagUtil.getPossibleConnectionSignal(graph, configuration, connection, type);
    }

    public static Variable getPossibleConnectionSignal(ReadGraph graph, Variable configuration, Resource connection, Resource type) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new PossibleConnectionSignal(configuration, connection, type), (Listener)TransientCacheListener.instance());
    }

    public static void verifyFlagType(WriteGraph graph, IModelingRules modelingRules, Resource flag, FlagClass.Type flagType) throws DatabaseException {
        if (modelingRules != null) {
            IFlagType.FlagInfo info;
            IFlagType ft;
            IFlagTypeReader ftr = null;
            Resource connectionType = DiagramGraphUtil.getConnectionTypeForFlag((ReadGraph)graph, flag);
            if (connectionType != null) {
                ftr = (IFlagTypeReader)graph.getPossibleAdapter(connectionType, IFlagTypeReader.class);
            }
            if (ftr == null) {
                ftr = (IFlagTypeReader)graph.getPossibleAdapter(flag, IFlagTypeReader.class);
            }
            if (ftr != null && (ft = ftr.read((ReadGraph)graph, flag, modelingRules)) != null && flagType != (info = ft.getInfo((ReadGraph)graph)).getType()) {
                FlagUtil.setFlagType(graph, flag, info.getType());
            }
        }
    }

    public static List<Resource> setFlagExternal(WriteGraph graph, List<Resource> flags, boolean external) throws ServiceException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource flag : flags) {
            if (external) {
                graph.claim(flag, DIA.ExternalFlag, DIA.ExternalFlag, flag);
                continue;
            }
            graph.deny(flag, DIA.ExternalFlag);
        }
        return flags;
    }

    public static class PossibleConnectionSignal
    extends TernaryRead<Variable, Resource, Resource, Variable> {
        public PossibleConnectionSignal(Variable configuration, Resource connection, Resource type) {
            super((Object)configuration, (Object)connection, (Object)type);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            Resource connection = (Resource)this.parameter2;
            Resource mapped = graph.getPossibleObject(connection, MOD.DiagramConnectionToConnection);
            if (mapped != null) {
                connection = mapped;
            }
            for (ResourceWithContext module : ConnectionBrowser.findConnectedComponents((ReadGraph)graph, (Resource)connection, (Variable)((Variable)this.parameter))) {
                if (!graph.isInstanceOf(module.getResource(), (Resource)this.parameter3)) continue;
                Resource element = graph.getPossibleObject(module.getResource(), MOD.ComponentToElement);
                if (element != null) {
                    if (!graph.isInstanceOf(element, DIA.Flag) && !graph.isInstanceOf(element, DIA.Connection)) continue;
                    return module.getContext();
                }
                System.err.println("no element for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)module.getResource()));
            }
            return null;
        }
    }
}

