/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class FlagPropertyTester
extends PropertyTester {
    private static final String CONNECTED = "connected";
    private static final String LOCALLY_CONNECTED = "locallyConnected";
    private static final String EXTERNAL = "external";
    private static final String MERGED = "merged";

    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        final Resource resource = ResourceAdaptionUtils.toSingleResource((Object)receiver);
        if (resource == null) {
            return false;
        }
        Session session = SimanticsUI.peekSession();
        if (session == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        try {
            return (Boolean)session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return FlagPropertyTester.this.doTest(g, resource, property, args, expectedValue);
                }
            });
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    private boolean doTest(ReadGraph graph, Resource resource, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (EXTERNAL.equals(property)) {
            boolean expected = this.parseBoolean(expectedValue, true);
            boolean ext = FlagUtil.isExternal(graph, resource);
            return ext ? expected : expected;
        }
        if (CONNECTED.equals(property)) {
            boolean isConnected;
            boolean expected = this.parseBoolean(expectedValue, true);
            boolean bl = isConnected = FlagUtil.getCounterparts(graph, resource).size() > 0 || FlagUtil.isLifted(graph, resource);
            return isConnected == expected;
        }
        if (LOCALLY_CONNECTED.equals(property)) {
            boolean expected = this.parseBoolean(expectedValue, true);
            boolean isLocallyConnected = FlagUtil.isJoinedInSingleDiagram(graph, resource);
            return isLocallyConnected == expected;
        }
        if (MERGED.equals(property)) {
            boolean isMerged;
            boolean expected = this.parseBoolean(expectedValue, true);
            boolean bl = isMerged = FlagUtil.getCounterparts(graph, resource).size() > 1;
            return isMerged == expected;
        }
        return false;
    }

    boolean parseBoolean(Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }
}

