/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.export;

import com.kitfox.svg.SVGCache;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.primitiverequest.SingleObject;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ExportClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.pdf.ExportPdfWriter;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.g2d.G2DPDFRenderingHints;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.utils.QualityHints;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.StructuralVariables;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.WorkerThread;

public class ExportDiagramPdf
implements ExportClass {
    public static LabelReference P_DIAGRAM_OPTIONS = new LabelReference("Diagram Options");
    public static String S_CONTENT_FIT = "Content Fit";
    public static ChildReference P_CONTENT_FIT = ChildReference.parsePath((String)("Diagram Options/" + S_CONTENT_FIT));
    public static String S_PAGE_SIZE = "Page Size";
    public static ChildReference P_PAGE_SIZE = ChildReference.parsePath((String)("Diagram Options/" + S_PAGE_SIZE));
    RecordType deo;
    RecordType options = new RecordType();
    UnionType contentUt;
    UnionType pageUt;

    public ExportDiagramPdf() {
        this.deo = new RecordType();
        this.contentUt = UnionType.newEnum((String[])new String[]{"Use the diagram specific borders", "Fit page by its contents"});
        this.pageUt = UnionType.newEnum((String[])new String[]{"Use the page size from this wizard", "Use diagram specific page sizes"});
        this.deo.addComponent(S_CONTENT_FIT, (Datatype)this.contentUt);
        this.deo.addComponent(S_PAGE_SIZE, (Datatype)this.pageUt);
        this.options.addComponent(ExportDiagramPdf.P_DIAGRAM_OPTIONS.label, (Datatype)this.deo);
    }

    public RecordType options(ExportContext context, Collection<String> content) throws ExportException {
        return this.options;
    }

    public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_CONTENT_FIT, (int)0);
            ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_PAGE_SIZE, (int)1);
        }
        catch (AccessorConstructionException accessorConstructionException) {
            // empty catch block
        }
    }

    public void export(List<Content> contents, Object handle, ExportContext ctx, Variant options, IProgressMonitor monitor, MapList<Content, Content> attachmentMap) throws ExportException {
        final ExportPdfWriter writer = (ExportPdfWriter)handle;
        WorkerThread workerThread = new WorkerThread("Diagram PDF Painter");
        workerThread.start();
        ExportPdfWriter.Page page = null;
        try {
            try {
                ModelingResources MOD = ModelingResources.getInstance((RequestProcessor)ctx.session);
                SimulationResource SIMU = SimulationResource.getInstance((RequestProcessor)ctx.session);
                StructuralResource2 STR = StructuralResource2.getInstance((RequestProcessor)ctx.session);
                DiagramResource DIA = DiagramResource.getInstance((RequestProcessor)ctx.session);
                final Template2dResource TMPL = Template2dResource.getInstance((RequestProcessor)ctx.session);
                Layer0 L0 = Layer0.getInstance((RequestProcessor)ctx.session);
                for (Content content : contents) {
                    List ats;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Resource resource = (Resource)ctx.session.syncRequest(ExportQueries.toResource((String)content.url));
                    boolean isComposite = (Boolean)ctx.session.syncRequest(Queries.isInstanceOf((Resource)resource, (Resource)STR.Composite));
                    if (!isComposite) {
                        resource = (Resource)ctx.session.syncRequest(Queries.possibleObjectWithType((Resource)resource, (Resource)L0.ConsistsOf, (Resource)STR.Composite));
                        isComposite = (Boolean)ctx.session.syncRequest(Queries.isInstanceOf((Resource)resource, (Resource)STR.Composite));
                    }
                    if (!isComposite) {
                        throw new ExportException(String.valueOf(content.url) + " doesnt contain a diagram.");
                    }
                    Resource composite = resource;
                    Resource diagram = (Resource)ctx.session.syncRequest((AsyncRead)new SingleObject(composite, MOD.CompositeToDiagram));
                    final Resource drawingTemplate = (Resource)ctx.session.syncRequest(Queries.possibleObject((Resource)diagram, (Resource)TMPL.HasDrawingTemplate));
                    Resource activeProfile = (Resource)ctx.session.syncRequest(Queries.possibleObject((Resource)diagram, (Resource)DIA.HasActiveProfile));
                    final List activeProfileEntries = activeProfile != null ? (Collection)ctx.session.syncRequest(Queries.objects((Resource)activeProfile, (Resource)SIMU.IsActive)) : Collections.emptyList();
                    Resource model = (Resource)ctx.session.syncRequest((Read)new PossibleModel(composite));
                    if (model == null) {
                        throw new ExportException("Cannot export diagram. Model was not found.");
                    }
                    final String diagramName = content.label;
                    ResourceArray compositePath = StructuralVariables.getCompositeArray((Session)ctx.session, (Resource)composite);
                    ResourceArray variablePath = compositePath.removeFromBeginning(1);
                    String modelRVI = StructuralVariables.getRVI((Session)ctx.session, (ResourceArray)variablePath);
                    int tag = ExportDiagramPdf.getPageFitArea(options);
                    PageDesc diagramPageDesc = (PageDesc)ctx.session.syncRequest(DiagramRequests.getPageDesc(diagram, writer.defaultPageDesc));
                    PageDesc wizardPageDesc = writer.defaultPageDesc;
                    PageDesc marginaaliViiva = diagramPageDesc;
                    if (page != null) {
                        page.close();
                        page = null;
                    }
                    if (tag == 0) {
                        page = writer.createPage(wizardPageDesc);
                        marginaaliViiva = diagramPageDesc;
                    } else {
                        marginaaliViiva = diagramPageDesc;
                        page = writer.createPage(diagramPageDesc);
                    }
                    final PageDesc _marginaaliViiva = marginaaliViiva;
                    final PageDesc _diagramPageDesc = diagramPageDesc;
                    final ExportPdfWriter.Page _page = page;
                    final boolean fitDiagramContentsToPageMargins = ExportDiagramPdf.getContentFitArea(options) == 1;
                    final CanvasContext cctx = new CanvasContext((IThreadWorkQueue)workerThread);
                    Exception[] errors = new Exception[1];
                    final ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((ICanvasContext)cctx, model, diagram, modelRVI);
                    ThreadUtils.syncExec((IThreadWorkQueue)workerThread, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cctx.getDefaultHintContext().setHint(Hints.KEY_PAGE_DESC, (Object)_marginaaliViiva);
                                String bottomLabel = diagramName;
                                if (drawingTemplate != null && activeProfileEntries.contains(TMPL.DrawingTemplate)) {
                                    bottomLabel = null;
                                }
                                ExportDiagramPdf.this.paint((ICanvasContext)cctx, writer, _page, fitDiagramContentsToPageMargins, bottomLabel, _diagramPageDesc);
                            }
                            finally {
                                provider.dispose();
                                cctx.dispose();
                            }
                        }
                    });
                    if (errors[0] != null) {
                        throw new ExportException((Throwable)errors[0]);
                    }
                    if (attachmentMap == null || (ats = attachmentMap.getValues((Object)content)) == null) continue;
                    for (Content at : ats) {
                        page.addAttachment(at);
                    }
                }
                SVGCache.getSVGUniverse().clearUnreferenced();
                SessionGarbageCollection.gc(null, (Session)writer.ctx.session, (boolean)true, null);
                System.gc();
            }
            catch (DatabaseException e) {
                throw new ExportException(String.valueOf(((Object)((Object)e)).getClass().getName()) + ": " + e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ExportException(String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (workerThread != null) {
                workerThread.stopDispatchingEvents(true);
            }
            if (page != null) {
                page.close();
            }
        }
    }

    public void paint(ICanvasContext canvasContext, ExportPdfWriter writer, ExportPdfWriter.Page page, boolean fitDiagramContentsToPageMargins, String diagramName, PageDesc diagramPageDesc) {
        Graphics2D g2 = page.createGraphics(false);
        try {
            QualityHints.HIGH_QUALITY_HINTS.setQuality(g2);
            g2.setRenderingHint(G2DPDFRenderingHints.KEY_EXPORT_PDF_WRITER, writer);
            g2.setRenderingHint(G2DPDFRenderingHints.KEY_PDF_WRITER, writer.pdfCopy);
            g2.setRenderingHint(G2DPDFRenderingHints.KEY_PDF_BYTECONTENT, writer.cb);
            g2.setRenderingHint(G2DPDFRenderingHints.KEY_PDF_FONTMAPPER, writer.fontMapper);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            double pw = page.pageDesc.getWidth();
            double ph = page.pageDesc.getHeight();
            double w = page.getWidth();
            double h = page.getHeight();
            if (fitDiagramContentsToPageMargins) {
                Rectangle2D.Double controlArea = new Rectangle2D.Double(0.0, 0.0, w, h);
                IDiagram diagram = (IDiagram)canvasContext.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
                Rectangle2D diagramRect = DiagramUtils.getContentRect((IDiagram)diagram);
                if (diagramRect != null) {
                    ((TransformUtil)canvasContext.getSingleItem(TransformUtil.class)).fitArea((Rectangle2D)controlArea, diagramRect, MarginUtils.NO_MARGINS);
                }
            }
            MarginUtils.Margins diagramMargins = diagramPageDesc.getMargins();
            MarginUtils.Margins wizardMargins = page.pageDesc.getMargins();
            g2.translate(wizardMargins.left.diagramAbsolute, wizardMargins.top.diagramAbsolute);
            double diagramPageWidth = diagramPageDesc.getOrientedWidth();
            double diagramPageHeight = diagramPageDesc.getOrientedHeight();
            double wizardPageWidth = page.pageDesc.getOrientedWidth();
            double wizardPageHeight = page.pageDesc.getOrientedHeight();
            double diagramContentWidth = diagramPageDesc.getOrientedWidth() - diagramMargins.left.diagramAbsolute - diagramMargins.right.diagramAbsolute;
            double diagramContentHeight = diagramPageDesc.getOrientedHeight() - diagramMargins.top.diagramAbsolute - diagramMargins.bottom.diagramAbsolute;
            double wizardContentWidth = page.pageDesc.getOrientedWidth() - wizardMargins.left.diagramAbsolute - wizardMargins.right.diagramAbsolute;
            double wizardContentHeight = page.pageDesc.getOrientedHeight() - wizardMargins.top.diagramAbsolute - wizardMargins.bottom.diagramAbsolute;
            if (diagramContentWidth != wizardContentWidth || diagramContentHeight != wizardContentHeight) {
                double r1 = wizardContentWidth / diagramContentWidth;
                double r2 = wizardContentHeight / diagramContentHeight;
                double r = Math.min(r1, r2);
                if (r1 < r2) {
                    g2.translate(0.0, wizardContentHeight / 2.0);
                } else {
                    g2.translate(wizardContentWidth / 2.0, 0.0);
                }
                g2.scale(r, r);
                if (r1 < r2) {
                    g2.translate(0.0, -diagramContentHeight / 2.0);
                } else {
                    g2.translate(-diagramContentWidth / 2.0, 0.0);
                }
            }
            g2.translate(-diagramMargins.left.diagramAbsolute, -diagramMargins.top.diagramAbsolute);
            g2.setRenderingHint(G2DRenderingHints.KEY_CONTROL_BOUNDS, new Rectangle2D.Double(0.0, 0.0, w, h));
            if (canvasContext.isLocked()) {
                throw new IllegalStateException("cannot render PDF, canvas context is locked: " + canvasContext);
            }
            canvasContext.getSceneGraph().render(g2);
        }
        finally {
            g2.dispose();
        }
    }

    public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        int tag = ExportDiagramPdf.getContentFitArea(options);
        if (tag >= 0) {
            contentScopeNode.putInt(S_CONTENT_FIT, tag);
        }
        if ((tag = ExportDiagramPdf.getPageFitArea(options)) >= 0) {
            contentScopeNode.putInt(S_PAGE_SIZE, tag);
        }
    }

    public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            int tag = contentScopeNode.getInt(S_CONTENT_FIT, -1);
            if (tag >= 0) {
                ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_CONTENT_FIT, (int)tag);
            }
            if ((tag = contentScopeNode.getInt(S_PAGE_SIZE, -1)) >= 0) {
                ExporterUtils.setUnionValue((Accessor)ra, (ChildReference)P_PAGE_SIZE, (int)tag);
            }
        }
        catch (AccessorConstructionException accessorConstructionException) {
            // empty catch block
        }
    }

    public List<String> validate(String contentUri, ExportContext context, Variant options) {
        return Collections.emptyList();
    }

    public static int getContentFitArea(Variant options) {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            UnionAccessor ua = (UnionAccessor)ra.getComponent(P_CONTENT_FIT);
            return ua.getTag();
        }
        catch (AccessorConstructionException e) {
            return -1;
        }
        catch (AccessorException e) {
            return -1;
        }
    }

    public static int getPageFitArea(Variant options) {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            UnionAccessor ua = (UnionAccessor)ra.getComponent(P_PAGE_SIZE);
            return ua.getTag();
        }
        catch (AccessorConstructionException e) {
            return -1;
        }
        catch (AccessorException e) {
            return -1;
        }
    }
}

