/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.export;

import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ContentTypeAction;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class DiagramContentTypeAction
implements ContentTypeAction {
    public static String getDiagramLabel(ReadGraph graph, Resource r) throws DatabaseException {
        String label;
        SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
        NameLabelMode mode = NameLabelUtil.getNameLabelMode((RequestProcessor)graph);
        try {
            Deque<Resource> path;
            Resource configuration;
            Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(r));
            if (model != null && (configuration = graph.getPossibleObject(model, SIM.HasConfiguration)) != null && (path = DiagramContentTypeAction.getPathTo(graph, r, model)) != null) {
                path.remove(configuration);
                StringBuilder sb = new StringBuilder();
                for (Resource node : path) {
                    if (sb.length() > 0) {
                        sb.append(" / ");
                    }
                    String nodeLabel = NameLabelUtil.modalName((ReadGraph)graph, (Resource)node, (NameLabelMode)mode);
                    sb.append(nodeLabel);
                }
                return sb.toString();
            }
        }
        catch (AssumptionException model) {
        }
        catch (ValidationException model) {
        }
        catch (ServiceException model) {
            // empty catch block
        }
        String uri = graph.getURI(r);
        int c = uri.lastIndexOf(47);
        if (c >= 0 && !(label = uri.substring(c + 1)).isEmpty()) {
            return label;
        }
        return uri;
    }

    public Map<String, String> getLabels(ExportContext ctx, final Collection<String> uris) throws ExportException {
        UniqueRead<Map<String, String>> req = new UniqueRead<Map<String, String>>(){

            public Map<String, String> perform(ReadGraph graph) throws DatabaseException {
                HashMap<String, String> result = new HashMap<String, String>();
                for (String uri : uris) {
                    Resource r = graph.getResource(uri);
                    String label = DiagramContentTypeAction.getDiagramLabel(graph, r);
                    result.put(uri, label);
                }
                return result;
            }
        };
        try {
            return (Map)ctx.session.syncRequest((Read)req);
        }
        catch (DatabaseException e) {
            throw new ExportException((Throwable)e);
        }
    }

    static Deque<Resource> getPathTo(ReadGraph graph, Resource start, Resource end) throws DatabaseException {
        LinkedList<Resource> result = new LinkedList<Resource>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource pos = start;
        while (!pos.equals(end)) {
            result.add(0, pos);
            pos = graph.getPossibleObject(pos, L0.PartOf);
            if (pos != null) continue;
            return null;
        }
        return result;
    }
}

