/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class ElementPropertyTester
extends PropertyTester {
    private static final String MAPPED = "mapped";

    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        final Resource resource = ResourceAdaptionUtils.toSingleResource((Object)receiver);
        if (resource == null) {
            return false;
        }
        Session session = SimanticsUI.peekSession();
        if (session == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        try {
            return (Boolean)session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return ElementPropertyTester.this.doTest(g, resource, property, args, expectedValue);
                }
            });
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    private boolean doTest(ReadGraph graph, Resource resource, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (MAPPED.equals(property)) {
            return graph.hasStatement(resource, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent);
        }
        return false;
    }
}

