/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.diagram.connection.ConnectionSegmentEnd;
import org.simantics.diagram.content.DesignatedTerminal;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.impl.BranchPointTerminal;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scl.commands.Commands;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPConnection;
import org.simantics.structural2.modelingRules.CPConnectionJoin;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.ui.AdaptionUtils;

public final class ConnectionUtil {
    private final ReadGraph rg;
    private final WriteGraph g;
    private final BasicResources br;

    public ConnectionUtil(ReadGraph g) {
        this.rg = g;
        this.g = g instanceof WriteGraph ? (WriteGraph)g : null;
        this.br = BasicResources.getInstance(g);
    }

    public ConnectionUtil(WriteGraph g) {
        this.rg = g;
        this.g = g;
        this.br = BasicResources.getInstance((ReadGraph)g);
    }

    void assertWriteSupport() {
        if (this.g == null) {
            throw new UnsupportedOperationException("no write support, this ConnectionUtil is read-only");
        }
    }

    public Resource newConnection(Resource composite, Resource type) throws DatabaseException {
        this.assertWriteSupport();
        Resource connection = this.newConnection(type);
        OrderedSetUtils.addFirst((WriteGraph)this.g, (Resource)composite, (Resource)connection);
        this.g.claim(composite, this.br.L0.ConsistsOf, this.br.L0.PartOf, connection);
        return connection;
    }

    public Resource newConnection(Resource type) throws DatabaseException {
        this.assertWriteSupport();
        return this.newInstance((WriteOnlyGraph)this.g, type);
    }

    public Resource newConnector(Resource connection, Resource hasConnector) throws DatabaseException {
        this.assertWriteSupport();
        Resource connector = this.newInstance((WriteOnlyGraph)this.g, this.br.DIA.Connector);
        this.g.claim(connection, hasConnector, connector);
        return connector;
    }

    public Resource newBranchPoint(Resource connection, AffineTransform tr) throws DatabaseException {
        return this.newBranchPoint(connection, tr, null);
    }

    public Resource newBranchPoint(Resource connection, AffineTransform tr, BranchPoint.Direction direction) throws DatabaseException {
        Resource tag;
        this.assertWriteSupport();
        Resource bp = this.g.newResource();
        this.g.claim(bp, this.br.L0.InstanceOf, null, this.br.DIA.BranchPoint);
        if (tr != null) {
            double[] mat = new double[6];
            tr.getMatrix(mat);
            Resource transform = this.g.newResource();
            this.g.claim(transform, this.br.L0.InstanceOf, null, this.br.G2D.Transform);
            this.g.claimValue(transform, (Object)mat);
            this.g.claim(bp, this.br.DIA.HasTransform, transform);
        }
        if ((tag = ConnectionUtil.toDirectionTag((ReadGraph)this.g, direction)) != null) {
            this.g.claim(bp, tag, tag, bp);
        }
        this.g.claim(connection, this.br.DIA.HasBranchPoint, bp);
        return bp;
    }

    public Resource newRouteLine(Resource connection, Double position, Boolean isHorizontal) throws DatabaseException {
        this.assertWriteSupport();
        Resource rl = this.newInstance((WriteOnlyGraph)this.g, this.br.DIA.RouteLine);
        if (position != null) {
            this.g.addLiteral(rl, this.br.DIA.HasPosition, this.br.DIA.HasPosition_Inverse, this.br.L0.Double, (Object)position, (Binding)Bindings.DOUBLE);
        }
        if (isHorizontal != null) {
            this.g.addLiteral(rl, this.br.DIA.IsHorizontal, this.br.DIA.IsHorizontal_Inverse, this.br.L0.Boolean, (Object)isHorizontal, (Binding)Bindings.BOOLEAN);
        }
        this.g.claim(connection, this.br.DIA.HasInteriorRouteNode, this.br.DIA.HasInteriorRouteNode_Inverse, rl);
        return rl;
    }

    ConnectionSegmentEnd getTerminalType(Topology.Terminal terminal, ConnectionSegmentEnd defaultValue) {
        ConnectionSegmentEnd type = this.getTerminalType(terminal);
        return type != null ? type : defaultValue;
    }

    ConnectionSegmentEnd getTerminalType(Topology.Terminal t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ResourceTerminal) {
            return ConnectionSegmentEnd.CONNECTOR;
        }
        if (t instanceof BranchPointTerminal) {
            return ConnectionSegmentEnd.BRANCH;
        }
        throw new IllegalArgumentException("unsupported terminal '" + t + "'");
    }

    Resource resolveTerminalRelation(ReadGraph g, Topology.Terminal t) throws DatabaseException {
        if (t == null) {
            return null;
        }
        if (t instanceof ResourceTerminal) {
            ResourceTerminal rt = (ResourceTerminal)t;
            Resource terminalRelation = DiagramGraphUtil.getConnectionPointOfTerminal(g, rt.getResource());
            g.isSubrelationOf(terminalRelation, this.br.STR.IsConnectedTo);
            return terminalRelation;
        }
        throw new IllegalArgumentException("unsupported terminal '" + t + "' for terminal relation resolution");
    }

    public Resource toHasConnectorRelation(EdgeVisuals.EdgeEnd end) {
        switch (end) {
            case Begin: {
                return this.br.DIA.HasPlainConnector;
            }
            case End: {
                return this.br.DIA.HasArrowConnector;
            }
        }
        throw new IllegalArgumentException("unsupported edge end: " + end);
    }

    public EdgeVisuals.EdgeEnd toEdgeEnd(Resource attachmentRelation, EdgeVisuals.EdgeEnd defaultValue) throws DatabaseException {
        if (this.g.isSubrelationOf(attachmentRelation, this.br.DIA.HasPlainConnector)) {
            return EdgeVisuals.EdgeEnd.Begin;
        }
        if (this.g.isSubrelationOf(attachmentRelation, this.br.DIA.HasArrowConnector)) {
            return EdgeVisuals.EdgeEnd.End;
        }
        return defaultValue;
    }

    public Resource getAttachmentRelationForConnector(Resource connector) throws DatabaseException {
        Statement connection = this.g.getPossibleStatement(connector, this.br.DIA.IsConnectorOf);
        if (connection == null) {
            return null;
        }
        Resource attachment = this.g.getInverse(connection.getPredicate());
        return attachment;
    }

    public Resource getOrCreateConnector(Resource connection, Resource node, Topology.Terminal terminal, EdgeVisuals.EdgeEnd end, Resource attachmentRelation) throws DatabaseException {
        this.assertWriteSupport();
        ConnectionSegmentEnd connectorType = this.getTerminalType(terminal, null);
        if (connectorType == null) {
            throw new AssumptionException("Invalid connection node", new Resource[]{connection, node});
        }
        switch (connectorType) {
            case BRANCH: {
                return node;
            }
            case CONNECTOR: {
                Resource terminalRelation = this.resolveTerminalRelation((ReadGraph)this.g, terminal);
                if (attachmentRelation == null) {
                    attachmentRelation = this.toHasConnectorRelation(end);
                }
                if (!this.g.isSubrelationOf(attachmentRelation, this.br.DIA.HasConnector)) {
                    throw new AssumptionException("attachment relation not a subrelation of Has Connector", new Resource[]{attachmentRelation});
                }
                Resource terminalConnector = this.newConnector(connection, attachmentRelation);
                this.g.claim(node, terminalRelation, terminalConnector);
                return terminalConnector;
            }
        }
        throw new Error("this should be unreachable code");
    }

    public void connect(Resource connector1, Resource connector2) throws DatabaseException {
        this.assertWriteSupport();
        this.g.claim(connector1, this.br.DIA.AreConnected, this.br.DIA.AreConnected, connector2);
    }

    public void disconnect(Resource connector1, Resource connector2) throws DatabaseException {
        this.assertWriteSupport();
        this.g.denyStatement(connector1, this.br.DIA.AreConnected, connector2);
    }

    public void disconnectFromAllRouteNodes(Resource connector) throws DatabaseException {
        this.assertWriteSupport();
        this.g.deny(connector, this.br.DIA.AreConnected);
    }

    public void disconnect(EdgeResource segment) throws DatabaseException {
        this.assertWriteSupport();
        this.disconnect(segment.first(), segment.second());
    }

    public boolean isConnected(Resource connector) throws DatabaseException {
        return this.rg.hasStatement(connector, this.br.DIA.AreConnected);
    }

    public boolean isConnected(Resource connector, Resource toConnector) throws DatabaseException {
        return this.rg.hasStatement(connector, this.br.DIA.AreConnected, toConnector);
    }

    public boolean isConnectionEmpty(Resource connection) throws DatabaseException {
        return !this.rg.hasStatement(connection, this.br.DIA.HasConnector) && !this.rg.hasStatement(connection, this.br.DIA.HasInteriorRouteNode);
    }

    private void removeConnectorOrBranchPoint(Resource connectorOrBranchPoint) throws DatabaseException {
        this.g.deny(connectorOrBranchPoint, this.br.DIA.AreConnected);
        this.g.deny(connectorOrBranchPoint, this.br.STR.Connects);
        this.g.deny(connectorOrBranchPoint, this.br.DIA.IsBranchPointOf);
        this.g.deny(connectorOrBranchPoint, this.br.DIA.HasInteriorRouteNode_Inverse);
    }

    public void removeConnection(Resource connection) throws DatabaseException {
        this.assertWriteSupport();
        CommentMetadata cm = (CommentMetadata)this.g.getMetadata(CommentMetadata.class);
        this.g.addMetadata((Metadata)cm.add("Remove connection " + connection));
        ArrayList connectors = new ArrayList();
        connectors.addAll(this.rg.getObjects(connection, this.br.DIA.HasConnector));
        connectors.addAll(this.rg.getObjects(connection, this.br.DIA.HasInteriorRouteNode));
        for (Resource connector : connectors) {
            this.removeConnectorOrBranchPoint(connector);
            RemoverUtil.remove((WriteGraph)this.g, (Resource)connector);
        }
        for (Resource owner : OrderedSetUtils.getOwnerLists((ReadGraph)this.g, (Resource)connection, (Resource)this.br.DIA.Diagram)) {
            OrderedSetUtils.remove((WriteGraph)this.g, (Resource)owner, (Resource)connection);
        }
        EntityRemover.remove((WriteGraph)this.g, (Resource)connection);
    }

    public void removeConnectionPart(Resource connectorOrBranchPoint) throws DatabaseException {
        this.removeConnectorOrBranchPoint(connectorOrBranchPoint);
        RemoverUtil.remove((WriteGraph)this.g, (Resource)connectorOrBranchPoint);
    }

    public void remove(EdgeResource segment) throws DatabaseException {
        this.remove(segment, false);
    }

    public void remove(EdgeResource segment, boolean unchecked) throws DatabaseException {
        this.assertWriteSupport();
        if (!unchecked) {
            Resource resource = ConnectionUtil.getConnection((ReadGraph)this.g, segment);
        }
        this.disconnect(segment);
        if (!this.isConnected(segment.first())) {
            this.removeConnectorOrBranchPoint(segment.first());
        }
        if (!this.isConnected(segment.second())) {
            this.removeConnectorOrBranchPoint(segment.second());
        }
    }

    public int removeUnusedConnectors(Resource connection) throws DatabaseException {
        int result = 0;
        for (Resource connector : this.getConnectors(connection, null)) {
            Collection connects;
            if (!this.g.getObjects(connector, this.br.DIA.AreConnected).isEmpty() || (connects = this.g.getObjects(connector, this.br.STR.Connects)).size() > 1) continue;
            this.removeConnectionPart(connector);
            ++result;
        }
        return result;
    }

    public int removeExtraInteriorRouteNodes(Resource connection) throws DatabaseException {
        int result = 0;
        for (Resource interiorRouteNode : this.g.getObjects(connection, this.br.DIA.HasInteriorRouteNode)) {
            Collection connectedTo = this.g.getObjects(interiorRouteNode, this.br.DIA.AreConnected);
            if (connectedTo.size() > 1) continue;
            this.removeConnectionPart(interiorRouteNode);
            ++result;
        }
        return result;
    }

    public Resource split(EdgeResource segment, AffineTransform splitPos) throws DatabaseException {
        this.assertWriteSupport();
        Resource connection = ConnectionUtil.getConnection((ReadGraph)this.g, segment);
        this.disconnect(segment);
        Resource bp = this.newBranchPoint(connection, splitPos);
        this.connect(segment.first(), bp);
        this.connect(bp, segment.second());
        return bp;
    }

    public void join(Resource interiorRouteNode) throws DatabaseException {
        this.assertWriteSupport();
        if (!this.g.isInstanceOf(interiorRouteNode, this.br.DIA.InteriorRouteNode)) {
            throw new ValidationException("'" + NameUtils.getSafeName((ReadGraph)this.g, (Resource)interiorRouteNode) + "' is not an instance of DIA.InteriorRouteNode");
        }
        Resource connection = ConnectionUtil.getConnection((ReadGraph)this.g, interiorRouteNode);
        Collection connectedTo = this.g.getObjects(interiorRouteNode, this.br.DIA.AreConnected);
        if (connectedTo.size() != 2) {
            throw new ValidationException("Interior route node is not a discardable route line/point. It is not connected to 2 route nodes, but " + connectedTo.size() + ".");
        }
        Iterator it = connectedTo.iterator();
        Resource connector1 = (Resource)it.next();
        Resource connector2 = (Resource)it.next();
        this.removeConnectorOrBranchPoint(interiorRouteNode);
        this.connect(connector1, connector2);
    }

    public void getConnectionSegments(Resource connection, Collection<EdgeResource> result) throws DatabaseException {
        ArrayList<EdgeResource> edges = new ArrayList<EdgeResource>();
        HashSet<Resource> visited = new HashSet<Resource>();
        Stack<Resource> todo = new Stack<Resource>();
        Collection seeds = this.rg.getObjects(connection, this.br.DIA.HasArrowConnector);
        if (seeds.isEmpty()) {
            seeds = this.rg.getObjects(connection, this.br.DIA.HasPlainConnector);
        }
        assert (!seeds.isEmpty());
        Resource seed = (Resource)seeds.iterator().next();
        todo.push(seed);
        while (!todo.isEmpty()) {
            Resource location = (Resource)todo.pop();
            if (visited.contains(location)) continue;
            visited.add(location);
            for (Resource connectedTo : this.rg.getObjects(location, this.br.DIA.AreConnected)) {
                todo.add(connectedTo);
                EdgeResource edge = new EdgeResource(location, connectedTo);
                if (edges.contains(edge)) continue;
                edges.add(edge);
            }
        }
        for (EdgeResource uer : edges) {
            result.add(uer);
        }
    }

    public Collection<Resource> getBranchPoints(Resource connection, Collection<Resource> result) throws DatabaseException {
        if (result == null) {
            result = new ArrayList<Resource>();
        }
        result.addAll(this.rg.getObjects(connection, this.br.DIA.HasBranchPoint));
        return result;
    }

    public Collection<Resource> getConnectors(Resource connection, Collection<Resource> result) throws DatabaseException {
        if (result == null) {
            result = new ArrayList<Resource>();
        }
        result.addAll(this.rg.getObjects(connection, this.br.DIA.HasConnector));
        return result;
    }

    public Resource getConnectedComponent(Resource connection, Resource connector) throws DatabaseException {
        for (Resource connects : this.rg.getObjects(connector, this.br.STR.Connects)) {
            if (connects.equals(connection)) continue;
            return connects;
        }
        return null;
    }

    public Statement getConnectedComponentStatement(Resource connection, Resource connector) throws DatabaseException {
        for (Statement connects : this.rg.getStatements(connector, this.br.STR.Connects)) {
            if (connects.getObject().equals(connection)) continue;
            return connects;
        }
        return null;
    }

    public void gatherEdges(Resource connection, Collection<EdgeResource> result) throws DatabaseException {
        HashSet<EdgeResource> visited = new HashSet<EdgeResource>();
        for (Resource connector : this.rg.getObjects(connection, this.br.DIA.HasConnector)) {
            for (Resource connectedTo : this.rg.getObjects(connector, this.br.DIA.AreConnected)) {
                EdgeResource p = new EdgeResource(connector, connectedTo);
                if (!visited.add(p)) continue;
                result.add(p);
            }
        }
        Collection routeNodes = this.rg.getObjects(connection, this.br.DIA.HasInteriorRouteNode);
        for (Resource routeNode : routeNodes) {
            for (Resource connectedTo : this.rg.getObjects(routeNode, this.br.DIA.AreConnected)) {
                EdgeResource p = new EdgeResource(routeNode, connectedTo);
                if (!visited.add(p)) continue;
                result.add(p);
            }
        }
    }

    public void gatherConnectionParts(Resource connection, Collection<Object> result) throws DatabaseException {
        HashSet<EdgeResource> visited = new HashSet<EdgeResource>();
        for (Resource connector : this.rg.getObjects(connection, this.br.DIA.HasConnector)) {
            for (Resource connectedTo : this.rg.getObjects(connector, this.br.DIA.AreConnected)) {
                EdgeResource p = new EdgeResource(connector, connectedTo);
                if (!visited.add(p)) continue;
                result.add(p);
            }
        }
        Collection routeNodes = this.rg.getObjects(connection, this.br.DIA.HasInteriorRouteNode);
        for (Resource routeNode : routeNodes) {
            result.add(routeNode);
            for (Resource connectedTo : this.rg.getObjects(routeNode, this.br.DIA.AreConnected)) {
                EdgeResource p = new EdgeResource(routeNode, connectedTo);
                if (!visited.add(p)) continue;
                result.add(p);
            }
        }
    }

    public Collection<Resource> getConnectedComponents(Resource connection, Collection<Resource> result) throws DatabaseException {
        if (result == null) {
            result = new ArrayList<Resource>(2);
        }
        for (Resource connector : this.rg.getObjects(connection, this.br.DIA.HasConnector)) {
            for (Resource connects : this.rg.getObjects(connector, this.br.STR.Connects)) {
                if (connects.equals(connection)) continue;
                result.add(connects);
            }
        }
        return result;
    }

    public Collection<Resource> getConnectedConnectors(Resource connection, Collection<Resource> result) throws DatabaseException {
        if (result == null) {
            result = new ArrayList<Resource>(2);
        }
        for (Resource connector : this.rg.getObjects(connection, this.br.DIA.HasConnector)) {
            Resource connects = this.getConnectedComponent(connection, connector);
            if (connects == null) continue;
            result.add(connector);
        }
        return result;
    }

    public Collection<Resource> getTerminalConnectors(Resource node, Collection<Resource> result) throws DatabaseException {
        if (result == null) {
            result = new ArrayList<Resource>(2);
        }
        result.addAll(this.rg.getObjects(node, this.br.STR.IsConnectedTo));
        return result;
    }

    public static Resource tryGetConnection(ReadGraph g, Resource routeNode) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Resource conn = g.getPossibleObject(routeNode, dr.IsConnectorOf);
        if (conn == null) {
            conn = g.getPossibleObject(routeNode, dr.HasInteriorRouteNode_Inverse);
        }
        return conn;
    }

    public static Resource tryGetConnection(ReadGraph g, EdgeResource segment) throws DatabaseException {
        Resource first = ConnectionUtil.tryGetConnection(g, segment.first());
        Resource second = ConnectionUtil.tryGetConnection(g, segment.second());
        if (first == null || second == null || !first.equals(second)) {
            return null;
        }
        return first;
    }

    public static Resource tryGetMappedConnection(ReadGraph g, Resource connector) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        return g.getPossibleObject(connector, MOD.ConnectorToConnection);
    }

    public static Resource getConnection(ReadGraph g, EdgeResource segment) throws DatabaseException {
        Resource first = ConnectionUtil.tryGetConnection(g, segment.first());
        Resource second = ConnectionUtil.tryGetConnection(g, segment.second());
        if (first == null && second == null) {
            throw new ValidationException("neither connection segment end is attached to a Connection entity instance: " + segment.toString(g) + " - " + segment.toString());
        }
        if (first != null ^ second != null) {
            throw new ValidationException("both ends of connection segment " + segment.toString(g) + " - " + segment.toString() + " are not connected (first=" + first + ", second=" + second + ")");
        }
        if (!first.equals(second)) {
            throw new ValidationException("connectors of connection segment " + segment.toString(g) + " - " + segment.toString() + " are part of different connections: " + first + " vs. " + second);
        }
        return first;
    }

    public static Resource getConnection(ReadGraph g, Resource routeNode) throws DatabaseException {
        Resource connection = ConnectionUtil.tryGetConnection(g, routeNode);
        if (connection == null) {
            throw new ValidationException("route node '" + NameUtils.getSafeName((ReadGraph)g, (Resource)routeNode) + "' is not part of any connection");
        }
        return connection;
    }

    public static IConnectionPoint toConnectionPoint(ReadGraph g, Resource element, Topology.Terminal terminal) throws DatabaseException {
        if (terminal instanceof ResourceTerminal) {
            Resource t = ((ResourceTerminal)terminal).getResource();
            if (element == null) {
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                Resource join = g.getPossibleObject(t, DIA.FlagIsJoinedBy);
                if (join == null) {
                    return null;
                }
                return new CPConnectionJoin(join);
            }
            Resource bindingRelation = DiagramGraphUtil.getConnectionPointOfTerminal(g, t);
            return new CPTerminal(element, bindingRelation);
        }
        if (terminal instanceof BranchPointTerminal) {
            Resource connection = null;
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
            connection = g.isInstanceOf(element, DIA.Connection) ? element : ConnectionUtil.getConnection(g, element);
            return new CPConnection(connection);
        }
        throw new IllegalArgumentException("Unrecognized Terminal class: " + terminal);
    }

    public static IConnectionPoint toConnectionPoint(ReadGraph graph, IElement element, Topology.Terminal terminal) throws DatabaseException {
        Resource r = (Resource)ElementUtils.getObject((IElement)element);
        return ConnectionUtil.toConnectionPoint(graph, r, terminal);
    }

    public static IConnectionPoint toConnectionPoint(ReadGraph graph, TerminalUtil.TerminalInfo ti) throws DatabaseException {
        return ConnectionUtil.toConnectionPoint(graph, ti.e, ti.t);
    }

    public static IConnectionPoint toConnectionPoint(ReadGraph graph, DesignatedTerminal t) throws DatabaseException {
        return ConnectionUtil.toConnectionPoint(graph, t.element, t.terminal);
    }

    public static Resource toDirectionTag(ReadGraph graph, BranchPoint.Direction direction) {
        if (direction == null) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        switch (direction) {
            case Horizontal: {
                return DIA.Horizontal;
            }
            case Vertical: {
                return DIA.Vertical;
            }
        }
        return null;
    }

    public static Line2D resolveNearestEdgeLineSegment(Point2D toCanvasPos, IElement onEdge) {
        ArrayList points = new ArrayList();
        BendsHandler bh = (BendsHandler)onEdge.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
        if (bh != null) {
            org.simantics.g2d.utils.GeometryUtils.getPoints((Path2D)bh.getPath(onEdge), points);
        }
        Line2D.Double nearestLine = null;
        double nearestDistanceToLine = Double.MAX_VALUE;
        int i = 0;
        while (i < points.size() - 1) {
            Point2D p2;
            Point2D p1 = (Point2D)points.get(i);
            double distanceToLine = GeometryUtils.distanceFromLine((Point2D)toCanvasPos, (Point2D)p1, (Point2D)(p2 = (Point2D)points.get(i + 1)));
            if (distanceToLine < nearestDistanceToLine) {
                nearestDistanceToLine = distanceToLine;
                if (nearestLine == null) {
                    nearestLine = new Line2D.Double();
                }
                nearestLine.setLine(p1, p2);
            }
            ++i;
        }
        return nearestLine;
    }

    public static IElement getSingleEdge(Object object) throws DatabaseException {
        IElement e = (IElement)AdaptionUtils.adaptToSingle((Object)object, IElement.class);
        if (e == null) {
            return null;
        }
        if (PickRequest.PickFilter.FILTER_CONNECTION_EDGES.accept(e)) {
            return e;
        }
        if (PickRequest.PickFilter.FILTER_CONNECTIONS.accept(e)) {
            ConnectionHandler ch = (ConnectionHandler)e.getElementClass().getSingleItem(ConnectionHandler.class);
            Collection bps = ch.getBranchPoints(e, null);
            Collection segs = ch.getSegments(e, null);
            if (bps.isEmpty() && segs.size() == 1) {
                return (IElement)segs.iterator().next();
            }
        }
        return null;
    }

    public static Collection<IElement> getEdges(Object object) throws DatabaseException {
        IElement e = (IElement)AdaptionUtils.adaptToSingle((Object)object, IElement.class);
        if (e == null) {
            return null;
        }
        if (PickRequest.PickFilter.FILTER_CONNECTION_EDGES.accept(e)) {
            return Collections.singleton(e);
        }
        if (PickRequest.PickFilter.FILTER_CONNECTIONS.accept(e)) {
            ConnectionHandler ch = (ConnectionHandler)e.getElementClass().getSingleItem(ConnectionHandler.class);
            return ch.getSegments(e, null);
        }
        return null;
    }

    public static Resource getConnectionTailNode(ReadGraph graph, Resource connection) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource connector : graph.getObjects(connection, DIA.HasTailConnector)) {
            for (Resource node : graph.getObjects(connector, STR.Connects)) {
                if (node.equals(connection)) continue;
                return node;
            }
        }
        return null;
    }

    public static Statement getConnectionTailNodeStatement(ReadGraph graph, Resource connection) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource connector : graph.getObjects(connection, DIA.HasTailConnector)) {
            for (Statement connects : graph.getStatements(connector, STR.Connects)) {
                if (connects.getObject().equals(connection)) continue;
                return connects;
            }
        }
        return null;
    }

    public void translateRouteNodes(Resource connection, double dx, double dy) throws DatabaseException {
        Commands.get((ReadGraph)this.g, (String)"Simantics/Diagram/translateRouteNodes").execute((RequestProcessor)this.g, (Resource)this.g.syncRequest((Read)new IndexRoot(connection)), new Object[]{connection, dx, dy});
    }

    public static void translateRouteNodes(WriteGraph g, Resource connection, double dx, double dy) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        for (Resource routeNode : g.getObjects(connection, DIA.HasInteriorRouteNode)) {
            if (!g.isInstanceOf(routeNode, DIA.RouteLine)) continue;
            Double pos = (Double)g.getRelatedValue(routeNode, DIA.HasPosition, (Binding)Bindings.DOUBLE);
            Boolean isHorizontal = (Boolean)g.getRelatedValue(routeNode, DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
            pos = pos + (isHorizontal != false ? dy : dx);
            g.claimLiteral(routeNode, DIA.HasPosition, (Object)pos);
        }
    }

    public Resource createConnectionWithCorners(WriteGraph graph, Resource startElement, Resource startConnectionPoint, Resource endElement, Resource endConnectionPoint, List<Point2D> corners) throws DatabaseException {
        DiagramResource DIA = this.br.DIA;
        return this.createConnectionWithCorners(graph, DIA.RouteGraphConnection, startElement, startConnectionPoint, DIA.HasPlainConnector, endElement, endConnectionPoint, DIA.HasArrowConnector, corners);
    }

    public Resource createConnectionWithCorners(WriteGraph graph, Resource connectionType, Resource element1, Resource connectionPoint1, Resource hasConnector1, Resource element2, Resource connectionPoint2, Resource hasConnector2, List<Point2D> corners) throws DatabaseException {
        DiagramResource DIA = this.br.DIA;
        if (corners.size() == 1) {
            throw new UnsupportedOperationException("1 corner currently not supported");
        }
        Resource connection = this.newInstance((WriteOnlyGraph)this.g, connectionType);
        Resource connector1 = this.newConnector(connection, hasConnector1);
        Resource connector2 = this.newConnector(connection, hasConnector2);
        graph.claim(element1, connectionPoint1, connector1);
        graph.claim(element2, connectionPoint2, connector2);
        if (corners.size() > 1) {
            Resource previousRouteNode = connector1;
            int i = 0;
            while (i < corners.size() - 1) {
                Point2D p = corners.get(i);
                Point2D p1 = corners.get(i + 1);
                boolean horizontal = Math.abs(p1.getY() - p.getY()) < Math.abs(p1.getX() - p.getX());
                Resource routeLine = ConnectionUtil.createRouteline(graph, connection, horizontal ? p.getY() : p.getX(), horizontal);
                graph.claim(previousRouteNode, DIA.AreConnected, DIA.AreConnected, routeLine);
                previousRouteNode = routeLine;
                ++i;
            }
            graph.claim(previousRouteNode, DIA.AreConnected, DIA.AreConnected, connector2);
        } else {
            graph.claim(connector1, DIA.AreConnected, DIA.AreConnected, connector2);
        }
        return connection;
    }

    public Resource createConnectionWithSingleLine(WriteGraph graph, Resource connectionType, Collection<Triple<Resource, Resource, Resource>> endpoints, double coordinate, boolean horizontal) throws DatabaseException {
        DiagramResource DIA = this.br.DIA;
        Resource connection = this.newInstance((WriteOnlyGraph)this.g, connectionType);
        Resource routeLine = ConnectionUtil.createRouteline(graph, connection, coordinate, horizontal);
        for (Triple<Resource, Resource, Resource> endpoint : endpoints) {
            Resource connector = this.newConnector(connection, (Resource)endpoint.third);
            graph.claim((Resource)endpoint.first, (Resource)endpoint.second, connector);
            graph.claim(routeLine, DIA.AreConnected, DIA.AreConnected, connector);
        }
        return connection;
    }

    public Resource createConnection(WriteGraph graph, Resource connectionType, List<Triple<Resource, Resource, Resource>> terminals, List<Pair<Double, Boolean>> routeLines, List<Pair<Integer, Integer>> connections) throws DatabaseException {
        DiagramResource DIA = this.br.DIA;
        Resource connection = this.newInstance((WriteOnlyGraph)this.g, connectionType);
        Resource[] parts = new Resource[terminals.size() + routeLines.size()];
        int index = 0;
        for (Triple<Resource, Resource, Resource> triple : terminals) {
            Resource connector = this.newConnector(connection, (Resource)triple.third);
            graph.claim((Resource)triple.first, (Resource)triple.second, connector);
            parts[index++] = connector;
        }
        for (Pair pair : routeLines) {
            Resource r = ConnectionUtil.createRouteline(graph, connection, (Double)pair.first, (Boolean)pair.second);
            parts[index++] = r;
        }
        for (Pair pair : connections) {
            Resource part1 = parts[(Integer)pair.first];
            Resource part2 = parts[(Integer)pair.second];
            graph.claim(part1, DIA.AreConnected, DIA.AreConnected, part2);
        }
        return connection;
    }

    public static Resource createRouteline(WriteGraph graph, Resource connection, double pos, boolean isHorizontal) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource routeLine = graph.newResource();
        graph.claim(routeLine, L0.InstanceOf, null, DIA.RouteLine);
        graph.addLiteral(routeLine, DIA.HasPosition, DIA.HasPosition_Inverse, L0.Double, (Object)pos, (Binding)Bindings.DOUBLE);
        graph.addLiteral(routeLine, DIA.IsHorizontal, DIA.IsHorizontal_Inverse, L0.Boolean, (Object)isHorizontal, (Binding)Bindings.BOOLEAN);
        graph.claim(connection, DIA.HasInteriorRouteNode, DIA.HasInteriorRouteNode_Inverse, routeLine);
        return routeLine;
    }

    private Resource newInstance(WriteOnlyGraph graph, Resource type) throws DatabaseException {
        Resource connection = graph.newResource();
        this.g.claim(connection, this.br.L0.InstanceOf, null, type);
        return connection;
    }
}

