/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.diagram.adapter.RouteGraphConnectionClassFactory;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.arrows.ArrowLineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainLineEndStyle;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.TerminalMap;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RouteGraphConnection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.ElementDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.threads.CurrentThread;

public class RouteGraphUtils {
    public static boolean DEBUG = false;
    public static final ILineEndStyle HEAD = new ArrowLineEndStyle("fill 2 1 0");
    public static final ILineEndStyle TAIL = PlainLineEndStyle.INSTANCE;
    private static final double DEG_45 = 0.7853981633974483;
    private static final double DEG_135 = 2.356194490192345;

    private static EdgeVisuals.EdgeEnd toEdgeEnd(ReadGraph graph, Resource attachmentRelation, EdgeVisuals.EdgeEnd defaultValue) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasTailConnector)) {
            return EdgeVisuals.EdgeEnd.Begin;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector)) {
            return EdgeVisuals.EdgeEnd.End;
        }
        return defaultValue;
    }

    private static Resource resolveFlagAttachment(ReadGraph graph, Resource connection, Resource flag, IModelingRules modelingRules) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        FlagClass.Type type = RouteGraphUtils.resolveFlagType(graph, connection, flag, modelingRules);
        if (type != null) {
            switch (type) {
                case In: {
                    return DIA.HasPlainConnector;
                }
                case Out: {
                    return DIA.HasArrowConnector;
                }
            }
        }
        return null;
    }

    private static FlagClass.Type resolveFlagType(ReadGraph graph, Resource connection, Resource flag, IModelingRules modelingRules) throws DatabaseException {
        return RouteGraphUtils.readFlagType(graph, flag);
    }

    private static FlagClass.Type readFlagType(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource flagType = graph.getPossibleObject(flag, DIA.HasFlagType);
        FlagClass.Type type = DiagramGraphUtil.toFlagType(DIA, flagType);
        return type;
    }

    public static ILineEndStyle loadLineEndStyle0(ReadGraph graph, Resource attachmentRelation) throws DatabaseException {
        ILineEndStyle style = (ILineEndStyle)graph.getPossibleAdapter(attachmentRelation, ILineEndStyle.class);
        if (style != null) {
            return style;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector)) {
            return HEAD;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasTailConnector)) {
            return TAIL;
        }
        return null;
    }

    private static Statement findTerminalStatement(ReadGraph graph, Resource connection, Resource connector) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Statement stm : graph.getStatements(connector, STR.Connects)) {
            if (connection.equals(stm.getObject())) continue;
            return stm;
        }
        return null;
    }

    private static Resource getInverseAttachment(ReadGraph graph, Resource attachmentRelation) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource inverse = graph.getPossibleObject(attachmentRelation, DIA.HasInverseAttachment);
        if (inverse != null) {
            return inverse;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector)) {
            return DIA.HasPlainConnector;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasTailConnector)) {
            return DIA.HasArrowConnector;
        }
        return null;
    }

    public static RouteGraph load(ReadGraph graph, Resource diagramRuntime, Resource connection) throws DatabaseException {
        CanvasContext canvas = new CanvasContext(CurrentThread.getThreadAccess());
        ElementDiagram diagram = new ElementDiagram((ICanvasContext)canvas);
        return RouteGraphUtils.load(graph, diagramRuntime, connection, (ICanvasContext)canvas, (IDiagram)diagram);
    }

    public static RouteGraph load(ReadGraph graph, Resource diagramRuntime, Resource connection, ICanvasContext canvas, IDiagram diagram) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource diagramResource = graph.getPossibleObject(connection, L0.PartOf);
        IModelingRules modelingRules = (IModelingRules)graph.syncRequest(DiagramRequests.getModelingRules(diagramResource, null), (Listener)TransientCacheListener.instance());
        RouteGraph rg = new RouteGraph();
        THashSet links = new THashSet();
        THashMap nodeByData = new THashMap();
        for (Resource interiorNode : graph.getObjects(connection, DIA.HasInteriorRouteNode)) {
            if (graph.isInstanceOf(interiorNode, DIA.RouteLine)) {
                Boolean isHorizontal = (Boolean)graph.getRelatedValue(interiorNode, DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
                Double position = (Double)graph.getRelatedValue(interiorNode, DIA.HasPosition, (Binding)Bindings.DOUBLE);
                RouteLine line = rg.addLine(isHorizontal.booleanValue(), position.doubleValue());
                line.setData(RouteGraphConnection.serialize((ServiceLocator)graph, interiorNode));
                nodeByData.put(interiorNode, line);
                for (Resource connectedTo : graph.getObjects(interiorNode, DIA.AreConnected)) {
                    links.add(new EdgeResource(interiorNode, connectedTo));
                }
                continue;
            }
            graph.isInstanceOf(interiorNode, DIA.RoutePoint);
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        THashMap connectorToModeledAttachment = null;
        Collection toConnectorStatements = graph.getStatements(connection, DIA.HasConnector);
        int terminalCount = 0;
        if (modelingRules != null) {
            for (Statement toConnector : toConnectorStatements) {
                Resource connector = toConnector.getObject();
                Statement terminalStm = RouteGraphUtils.findTerminalStatement(graph, connection, connector);
                if (terminalStm == null) continue;
                Resource terminalElement = terminalStm.getObject();
                Resource connectionRelation = graph.getPossibleInverse(terminalStm.getPredicate());
                if (connectionRelation == null) continue;
                ++terminalCount;
                IAttachmentRelationMap map = modelingRules.getAttachmentRelations(graph, connection);
                Resource attachment = map.get(graph, new CPTerminal(terminalElement, connectionRelation));
                if (attachment != null) {
                    if (connectorToModeledAttachment == null) {
                        connectorToModeledAttachment = new THashMap(toConnectorStatements.size());
                    }
                    connectorToModeledAttachment.put(connector, attachment);
                    if (!DEBUG) continue;
                    System.out.println("modeling rules decided attachment: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)attachment, (boolean)true) + " for (" + NameUtils.toString((ReadGraph)graph, (Statement)toConnector, (boolean)true) + ") & (" + NameUtils.toString((ReadGraph)graph, (Statement)terminalStm, (boolean)true) + ")");
                    continue;
                }
                if (!graph.isInstanceOf(terminalElement, DIA.Flag) || (attachment = RouteGraphUtils.resolveFlagAttachment(graph, connection, terminalElement, modelingRules)) == null) continue;
                if (connectorToModeledAttachment == null) {
                    connectorToModeledAttachment = new THashMap(toConnectorStatements.size());
                }
                connectorToModeledAttachment.put(connector, attachment);
                if (!DEBUG) continue;
                System.out.println("flag type decided attachment: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)attachment, (boolean)true) + " for (" + NameUtils.toString((ReadGraph)graph, (Statement)toConnector, (boolean)true) + ") & (" + NameUtils.toString((ReadGraph)graph, (Statement)terminalStm, (boolean)true) + ")");
            }
        }
        if (connectorToModeledAttachment == null) {
            connectorToModeledAttachment = Collections.emptyMap();
        }
        Resource forcedAttachmentRelation = null;
        if (terminalCount == 2 && connectorToModeledAttachment.size() == 1) {
            forcedAttachmentRelation = RouteGraphUtils.getInverseAttachment(graph, (Resource)connectorToModeledAttachment.values().iterator().next());
            if (DEBUG) {
                System.out.println("set forced attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)forcedAttachmentRelation));
            }
        }
        Resource connectionType = graph.getPossibleObject(connection, STR.HasConnectionType);
        THashSet backendConnections = new THashSet(toConnectorStatements.size(), 0.75f);
        for (Statement toConnector : toConnectorStatements) {
            Integer allowedDirections;
            AffineTransform terminalElementTr;
            Resource connectionRelation;
            Resource terminalElement;
            Resource terminalElementType;
            Statement terminalStm;
            Resource connector = toConnector.getObject();
            Resource attachmentRelation = toConnector.getPredicate();
            if (DEBUG) {
                System.out.println("original attachment relation: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
            }
            if ((terminalStm = RouteGraphUtils.findTerminalStatement(graph, connection, connector)) == null || (terminalElementType = graph.getPossibleType(terminalElement = terminalStm.getObject(), DIA.Element)) == null || (connectionRelation = graph.getPossibleInverse(terminalStm.getPredicate())) == null) continue;
            TerminalMap terminals = (TerminalMap)graph.syncRequest(DiagramRequests.elementTypeTerminals(terminalElementType), (Listener)TransientCacheListener.instance());
            Resource terminal = terminals.getTerminal(connectionRelation);
            if (terminal == null) {
                System.err.println("RouteGraphUtils: Could not find terminal for connection point " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation, (boolean)true) + " in element " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalElement, (boolean)true));
                continue;
            }
            double[] position = (double[])graph.getRelatedValue(connector, DIA.HasRelativeLocation, (Binding)Bindings.DOUBLE_ARRAY);
            if (position.length != 2) {
                position = new double[]{0.0, 0.0};
            }
            if (DEBUG) {
                System.out.println("terminalStm: " + NameUtils.toString((ReadGraph)graph, (Statement)terminalStm));
                System.out.println("terminal: " + graph.getURI(terminalStm.getPredicate()));
            }
            AffineTransform affineTransform = terminalElementTr = diagramRuntime != null ? DiagramGraphUtil.getDynamicWorldTransform(graph, diagramRuntime, terminalElement) : DiagramGraphUtil.getWorldTransform(graph, terminalElement);
            if (DEBUG) {
                System.out.println("terminalElementTr: " + terminalElementTr);
            }
            double x = terminalElementTr.getTranslateX();
            double y = terminalElementTr.getTranslateY();
            double minx = x - 1.0;
            double miny = y - 1.0;
            double maxx = x + 1.0;
            double maxy = y + 1.0;
            int direction = 0;
            Resource att = (Resource)connectorToModeledAttachment.get(connector);
            if (att != null) {
                attachmentRelation = att;
                if (DEBUG) {
                    System.out.println("modeling rules attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
                }
            } else if (forcedAttachmentRelation != null) {
                attachmentRelation = forcedAttachmentRelation;
                if (DEBUG) {
                    System.out.println("forced rules attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
                }
            }
            if (DEBUG) {
                System.out.println("decided attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
            }
            IElement te = (IElement)graph.syncRequest(DiagramRequests.getElement(canvas, diagram, terminalElement, null));
            ElementUtils.getElementBounds((IElement)te, (Rectangle2D)bounds);
            Shape shp = org.simantics.g2d.utils.GeometryUtils.transformShape((Shape)bounds, (AffineTransform)terminalElementTr);
            bounds.setFrame(shp.getBounds2D());
            GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)2.0);
            minx = bounds.getMinX();
            miny = bounds.getMinY();
            maxx = bounds.getMaxX();
            maxy = bounds.getMaxY();
            AffineTransform terminalPos = DiagramGraphUtil.getDynamicAffineTransform(graph, terminalElement, terminal);
            if (terminalPos != null) {
                if (DEBUG) {
                    System.out.println("terminalPos: " + terminalPos);
                }
                terminalElementTr.concatenate(terminalPos);
                if (DEBUG) {
                    System.out.println("terminalElementTr: " + terminalElementTr);
                }
                x = terminalElementTr.getTranslateX();
                y = terminalElementTr.getTranslateY();
            }
            if ((allowedDirections = (Integer)graph.getPossibleRelatedValue(terminal, DIA.Terminal_AllowedDirections, (Binding)Bindings.INTEGER)) != null) {
                direction |= allowedDirections.intValue();
                direction = RouteGraphUtils.rotateDirection(direction, terminalElementTr);
            } else {
                direction |= RouteGraphConnectionClass.shortestDirectionOutOfBounds(x, y, bounds);
            }
            backendConnections.add(new RouteGraphConnectionClassFactory.BackendConnection(RouteGraphUtils.toEdgeEnd(graph, attachmentRelation, EdgeVisuals.EdgeEnd.Begin), terminalElement, terminal));
            if (direction == 0) {
                direction = 15;
            }
            if (((Boolean)graph.getRelatedValue(connector, DIA.Connector_straight)).booleanValue()) {
                direction |= 0x10;
            }
            if (DEBUG) {
                System.out.println("load line style: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
            }
            ILineEndStyle endStyle = RouteGraphConnectionClassFactory.loadLineEndStyle(graph, attachmentRelation, connectionType, RouteGraphConnectionClassFactory.TAIL);
            RouteTerminal routeTerminal = rg.addTerminal(x, y, minx, miny, maxx, maxy, direction, endStyle);
            routeTerminal.setData(RouteGraphConnection.serialize((ServiceLocator)graph, connector));
            nodeByData.put(connector, routeTerminal);
            for (Resource connectedTo : graph.getObjects(connector, DIA.AreConnected)) {
                links.add(new EdgeResource(connectedTo, connector));
            }
        }
        for (EdgeResource link : links) {
            RouteNode n1 = (RouteNode)nodeByData.get(link.first());
            RouteNode n2 = (RouteNode)nodeByData.get(link.second());
            if (n1 == null || n2 == null) {
                System.err.println("Stray connection link found: " + link.toString(graph));
                continue;
            }
            rg.link(n1, n2);
        }
        return rg;
    }

    public static int rotateDirection(int direction, AffineTransform at) {
        boolean rotatedOrFlipped;
        if ((direction & 0x10) != 0) {
            return direction;
        }
        int mask = 88;
        boolean bl = rotatedOrFlipped = (at.getType() & 0x58) != 0;
        if (rotatedOrFlipped) {
            double xAxisAngle = Math.atan2(at.getShearY(), at.getScaleX());
            double yAxisAngle = Math.atan2(at.getScaleY(), at.getShearX());
            int xQuadrant = RouteGraphUtils.mainQuadrant(xAxisAngle);
            int yQuadrant = RouteGraphUtils.mainQuadrant(yAxisAngle);
            int xDirMask = direction & 5;
            int yDirMask = direction & 0xA;
            int xDirMaskRotated = RouteGraphUtils.rotl4(xDirMask, xQuadrant);
            int yDirMaskRotated = RouteGraphUtils.rotl4(yDirMask, yQuadrant - 1);
            direction = xDirMaskRotated | yDirMaskRotated;
        }
        return direction;
    }

    private static int rotl4(int x, int n) {
        if ((n &= 3) == 0) {
            return x;
        }
        int hx = x & 0xFFFFFFF0;
        int lx = x & 0xF;
        int xh = lx << n & 0xF;
        int xl = lx >>> 4 - n;
        return xh | xl | hx;
    }

    private static int mainQuadrant(double theta) {
        if (theta > -0.7853981633974483 && theta <= 0.7853981633974483) {
            return 0;
        }
        if (theta > 0.7853981633974483 && theta <= 2.356194490192345) {
            return 1;
        }
        if (theta >= -2.356194490192345 && theta < -0.7853981633974483) {
            return 3;
        }
        return 2;
    }

    public static class LineEndStyle
    extends UnaryRead<Resource, ILineEndStyle> {
        public LineEndStyle(Resource attachmentRelation) {
            super((Object)attachmentRelation);
        }

        public ILineEndStyle perform(ReadGraph graph) throws DatabaseException {
            return RouteGraphUtils.loadLineEndStyle0(graph, (Resource)this.parameter);
        }
    }
}

