/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.RouteGraphUtils;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.BasicConnectionStyle;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ArrowLineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainLineEndStyle;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.content.TerminalMap;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RouteGraphConnection;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.nodes.connection.IRouteGraphListener;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphChangeEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IModelingRules;

public class RouteGraphConnectionClassFactory
extends SyncElementFactory {
    private static final boolean DEBUG = false;
    public static final ElementClass CLASS = RouteGraphConnectionClass.CLASS;
    public static final ILineEndStyle HEAD = new ArrowLineEndStyle("fill 2 1 0");
    public static final ILineEndStyle TAIL = PlainLineEndStyle.INSTANCE;
    protected Layer0 L0;
    protected DiagramResource DIA;
    protected StructuralResource2 STR;
    protected ModelingResources MOD;

    public RouteGraphConnectionClassFactory(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)CLASS.newClassWith(false, new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}));
    }

    @Override
    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return this.DIA.Connection;
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, final Resource connection, IElement element) throws DatabaseException {
        IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        Resource diagramRuntime = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
        RouteGraph rg = new RouteGraph();
        THashSet links = new THashSet();
        THashMap nodeByData = new THashMap();
        for (Resource interiorNode : graph.getObjects(connection, this.DIA.HasInteriorRouteNode)) {
            if (graph.isInstanceOf(interiorNode, this.DIA.RouteLine)) {
                Boolean isHorizontal = (Boolean)graph.getRelatedValue(interiorNode, this.DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
                Double position = (Double)graph.getRelatedValue(interiorNode, this.DIA.HasPosition, (Binding)Bindings.DOUBLE);
                RouteLine line = rg.addLine(isHorizontal.booleanValue(), position.doubleValue());
                line.setData(RouteGraphConnection.serialize((ServiceLocator)graph, interiorNode));
                nodeByData.put(interiorNode, line);
                for (Resource connectedTo : graph.getObjects(interiorNode, this.DIA.AreConnected)) {
                    links.add(new EdgeResource(interiorNode, connectedTo));
                }
                continue;
            }
            graph.isInstanceOf(interiorNode, this.DIA.RoutePoint);
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        THashMap connectorToModeledAttachment = null;
        Collection toConnectorStatements = graph.getStatements(connection, this.DIA.HasConnector);
        int terminalCount = 0;
        if (modelingRules != null) {
            for (Statement toConnector : toConnectorStatements) {
                Resource connector = toConnector.getObject();
                Statement terminalStm = this.findTerminalStatement(graph, connection, connector);
                if (terminalStm == null) continue;
                Resource terminalElement = terminalStm.getObject();
                Resource connectionRelation = graph.getPossibleInverse(terminalStm.getPredicate());
                if (connectionRelation == null) continue;
                ++terminalCount;
                IAttachmentRelationMap map = modelingRules.getAttachmentRelations(graph, connection);
                Resource attachment = map.get(graph, new CPTerminal(terminalElement, connectionRelation));
                if (attachment != null) {
                    if (connectorToModeledAttachment == null) {
                        connectorToModeledAttachment = new THashMap(toConnectorStatements.size());
                    }
                    connectorToModeledAttachment.put(connector, attachment);
                    continue;
                }
                if (!graph.isInstanceOf(terminalElement, this.DIA.Flag) || (attachment = this.resolveFlagAttachment(graph, connection, terminalElement, modelingRules)) == null) continue;
                if (connectorToModeledAttachment == null) {
                    connectorToModeledAttachment = new THashMap(toConnectorStatements.size());
                }
                connectorToModeledAttachment.put(connector, attachment);
            }
        }
        if (connectorToModeledAttachment == null) {
            connectorToModeledAttachment = Collections.emptyMap();
        }
        Resource forcedAttachmentRelation = null;
        if (terminalCount == 2 && connectorToModeledAttachment.size() == 1) {
            forcedAttachmentRelation = this.getInverseAttachment(graph, (Resource)connectorToModeledAttachment.values().iterator().next());
        }
        Resource connectionType = graph.getPossibleObject(connection, this.STR.HasConnectionType);
        THashSet backendConnections = new THashSet(toConnectorStatements.size(), 0.75f);
        for (Statement toConnector : toConnectorStatements) {
            Integer allowedDirections;
            Resource connectionRelation;
            Resource terminalElement;
            Resource terminalElementType;
            Resource connector = toConnector.getObject();
            Resource attachmentRelation = toConnector.getPredicate();
            Statement terminalStm = this.findTerminalStatement(graph, connection, connector);
            if (terminalStm == null || (terminalElementType = graph.getPossibleType(terminalElement = terminalStm.getObject(), this.DIA.Element)) == null || (connectionRelation = graph.getPossibleInverse(terminalStm.getPredicate())) == null) continue;
            TerminalMap terminals = (TerminalMap)graph.syncRequest(DiagramRequests.elementTypeTerminals(terminalElementType), (Listener)TransientCacheListener.instance());
            Resource terminal = terminals.getTerminal(connectionRelation);
            if (terminal == null) {
                System.err.println(String.valueOf(this.getClass().getSimpleName()) + ": Could not find terminal for connection point " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation, (boolean)true) + " in element " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalElement, (boolean)true));
                continue;
            }
            double[] position = (double[])graph.getRelatedValue(connector, this.DIA.HasRelativeLocation, (Binding)Bindings.DOUBLE_ARRAY);
            if (position.length != 2) {
                position = new double[]{0.0, 0.0};
            }
            AffineTransform terminalElementTr = DiagramGraphUtil.getDynamicWorldTransform(graph, diagramRuntime, terminalElement);
            double x = terminalElementTr.getTranslateX();
            double y = terminalElementTr.getTranslateY();
            double minx = x - 1.0;
            double miny = y - 1.0;
            double maxx = x + 1.0;
            double maxy = y + 1.0;
            int direction = 0;
            Resource att = (Resource)connectorToModeledAttachment.get(connector);
            if (att != null) {
                attachmentRelation = att;
            } else if (forcedAttachmentRelation != null) {
                attachmentRelation = forcedAttachmentRelation;
            }
            IElement te = (IElement)graph.syncRequest(DiagramRequests.getElement(canvas, diagram, terminalElement, null));
            ElementUtils.getElementBounds((IElement)te, (Rectangle2D)bounds);
            Shape shp = org.simantics.g2d.utils.GeometryUtils.transformShape((Shape)bounds, (AffineTransform)terminalElementTr);
            bounds.setFrame(shp.getBounds2D());
            GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)2.0);
            minx = bounds.getMinX();
            miny = bounds.getMinY();
            maxx = bounds.getMaxX();
            maxy = bounds.getMaxY();
            AffineTransform terminalPos = DiagramGraphUtil.getDynamicAffineTransform(graph, terminalElement, terminal);
            if (terminalPos != null) {
                terminalElementTr.concatenate(terminalPos);
                x = terminalElementTr.getTranslateX();
                y = terminalElementTr.getTranslateY();
            }
            if ((allowedDirections = (Integer)graph.getPossibleRelatedValue(terminal, this.DIA.Terminal_AllowedDirections, (Binding)Bindings.INTEGER)) != null) {
                direction |= allowedDirections.intValue();
                direction = RouteGraphUtils.rotateDirection(direction, terminalElementTr);
            } else {
                direction |= RouteGraphConnectionClass.shortestDirectionOutOfBounds(x, y, bounds);
            }
            backendConnections.add(new BackendConnection(this.toEdgeEnd(graph, attachmentRelation, EdgeVisuals.EdgeEnd.Begin), terminalElement, terminal));
            if (direction == 0) {
                direction = 15;
            }
            if (((Boolean)graph.getRelatedValue(connector, this.DIA.Connector_straight)).booleanValue()) {
                direction |= 0x10;
            }
            ILineEndStyle endStyle = RouteGraphConnectionClassFactory.loadLineEndStyle(graph, attachmentRelation, connectionType, TAIL);
            RouteTerminal routeTerminal = rg.addTerminal(x, y, minx, miny, maxx, maxy, direction, endStyle);
            routeTerminal.setData(RouteGraphConnection.serialize((ServiceLocator)graph, connector));
            nodeByData.put(connector, routeTerminal);
            for (Resource connectedTo : graph.getObjects(connector, this.DIA.AreConnected)) {
                links.add(new EdgeResource(connectedTo, connector));
            }
        }
        for (EdgeResource link : links) {
            RouteNode n1 = (RouteNode)nodeByData.get(link.first());
            RouteNode n2 = (RouteNode)nodeByData.get(link.second());
            if (n1 == null || n2 == null) {
                System.err.println("Stray connection link found: " + link.toString(graph));
                continue;
            }
            rg.link(n1, n2);
        }
        ConnectionStyle style = this.readConnectionStyle(graph, modelingRules, connection);
        StyledRouteGraphRenderer renderer = this.getRenderer(graph, style);
        element.setHint(RouteGraphConnectionClass.KEY_ROUTEGRAPH, (Object)rg);
        element.setHint(RouteGraphConnectionClass.KEY_RENDERER, (Object)renderer);
        element.setHint(RouteGraphConnectionClass.KEY_PICK_TOLERANCE, (Object)0.5);
        element.setHint(ElementHints.KEY_CONNECTION_ENTITY, (Object)new CE(diagram, connection, element, (Set<BackendConnection>)backendConnections));
        final Session session = graph.getSession();
        element.setHint(RouteGraphConnectionClass.KEY_RG_LISTENER, (Object)new IRouteGraphListener(){

            public void routeGraphChanged(RouteGraphChangeEvent event) {
                RouteGraphConnectionClassFactory.scheduleSynchronize(session, connection, event);
            }
        });
    }

    protected EdgeVisuals.EdgeEnd toEdgeEnd(ReadGraph graph, Resource attachmentRelation, EdgeVisuals.EdgeEnd defaultValue) throws DatabaseException {
        if (graph.isSubrelationOf(attachmentRelation, this.DIA.HasTailConnector)) {
            return EdgeVisuals.EdgeEnd.Begin;
        }
        if (graph.isSubrelationOf(attachmentRelation, this.DIA.HasHeadConnector)) {
            return EdgeVisuals.EdgeEnd.End;
        }
        return defaultValue;
    }

    protected StyledRouteGraphRenderer getRenderer(ReadGraph graph, ConnectionStyle style) throws DatabaseException {
        return (StyledRouteGraphRenderer)graph.syncRequest((Read)new Renderer(style), (Listener)TransientCacheListener.instance());
    }

    protected ConnectionStyle readConnectionStyle(ReadGraph graph, IModelingRules modelingRules, Resource connection) throws DatabaseException {
        Resource connectionType = null;
        if (modelingRules != null) {
            connectionType = modelingRules.getConnectionType(graph, connection);
        }
        if (connectionType == null) {
            connectionType = graph.getPossibleObject(connection, this.STR.HasConnectionType);
        }
        return this.readConnectionStyleFromConnectionType(graph, connectionType);
    }

    protected ConnectionStyle readConnectionStyleFromConnectionType(ReadGraph graph, Resource connectionType) throws DatabaseException {
        return (ConnectionStyle)graph.syncRequest((Read)new ReadConnectionStyleFromConnectionType(connectionType), (Listener)TransientCacheListener.instance());
    }

    protected static ConnectionStyle readConnectionStyleFromConnectionType0(ReadGraph graph, Resource connectionType) throws DatabaseException {
        Stroke lineStroke;
        Color lineColor;
        ConnectionVisuals cv = null;
        if (connectionType != null) {
            cv = (ConnectionVisuals)graph.syncRequest(DiagramRequests.getConnectionVisuals(connectionType), (Listener)TransientCacheListener.instance());
        }
        Color branchPointColor = Color.BLACK;
        double branchPointRadius = 0.5;
        double degenerateLineLength = 0.8;
        Color color = lineColor = cv != null ? cv.toColor() : null;
        if (lineColor == null) {
            lineColor = Color.DARK_GRAY;
        }
        Stroke stroke = lineStroke = cv != null ? cv.stroke : null;
        if (lineStroke == null) {
            lineStroke = new BasicStroke(0.1f, 0, 2, 10.0f, null, 0.0f);
        }
        BasicStroke routeLineStroke = GeometryUtils.scaleStrokeWidth((Stroke)lineStroke, (float)2.0f);
        return new BasicConnectionStyle(lineColor, branchPointColor, branchPointRadius, lineStroke, (Stroke)routeLineStroke, degenerateLineLength);
    }

    public Statement findTerminalStatement(ReadGraph graph, Resource connection, Resource connector) throws DatabaseException {
        for (Statement stm : graph.getStatements(connector, this.STR.Connects)) {
            if (connection.equals(stm.getObject())) continue;
            return stm;
        }
        return null;
    }

    public static ILineEndStyle loadLineEndStyle(ReadGraph graph, Resource attachmentRelation, ILineEndStyle defaultValue) throws DatabaseException {
        ILineEndStyle style = (ILineEndStyle)graph.syncRequest((Read)new LineEndStyle(attachmentRelation), (Listener)TransientCacheListener.instance());
        return style != null ? style : defaultValue;
    }

    public static ILineEndStyle loadLineEndStyle(ReadGraph graph, Resource attachmentRelation, Resource connectionType, ILineEndStyle defaultValue) throws DatabaseException {
        if (connectionType != null) {
            ILineEndStyle style = (ILineEndStyle)graph.syncRequest((Read)new LineEndStyleWithType(attachmentRelation, connectionType), (Listener)TransientCacheListener.instance());
            return style != null ? style : defaultValue;
        }
        ILineEndStyle style = (ILineEndStyle)graph.syncRequest((Read)new LineEndStyle(attachmentRelation), (Listener)TransientCacheListener.instance());
        return style != null ? style : defaultValue;
    }

    public static ILineEndStyle loadLineEndStyle0(ReadGraph graph, Resource attachmentRelation) throws DatabaseException {
        ILineEndStyle style = (ILineEndStyle)graph.getPossibleAdapter(attachmentRelation, ILineEndStyle.class);
        if (style != null) {
            return style;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector)) {
            return HEAD;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasTailConnector)) {
            return TAIL;
        }
        return null;
    }

    public static ILineEndStyle loadLineEndStyle0(ReadGraph graph, Resource attachmentRelation, Resource connectionType) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector) && connectionType != null) {
            G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
            Resource end = graph.getPossibleObject(connectionType, G2D.HasEndArrow);
            if (end != null) {
                float[] col;
                Double space;
                Double widthRatio;
                Double size = (Double)graph.getPossibleRelatedValue(end, G2D.HasSize, (Binding)Bindings.DOUBLE);
                if (size == null) {
                    size = 0.0;
                }
                if ((widthRatio = (Double)graph.getPossibleRelatedValue(end, G2D.HasWidthRatio, (Binding)Bindings.DOUBLE)) == null) {
                    widthRatio = 1.0;
                }
                if ((space = (Double)graph.getPossibleRelatedValue(end, G2D.HasSpace, (Binding)Bindings.DOUBLE)) == null) {
                    space = 0.0;
                }
                Resource c = graph.getPossibleObject(end, G2D.HasColor);
                Color color = null;
                if (c != null && (col = (float[])graph.getPossibleValue(c, (Binding)Bindings.FLOAT_ARRAY)) != null && col.length >= 3) {
                    color = new Color(col[0], col[1], col[2]);
                }
                return new ArrowLineEndStyle(size.doubleValue(), widthRatio * size, space.doubleValue(), color);
            }
        }
        return RouteGraphConnectionClassFactory.loadLineEndStyle0(graph, attachmentRelation);
    }

    public Resource getInverseAttachment(ReadGraph graph, Resource attachmentRelation) throws DatabaseException {
        Resource inverse = graph.getPossibleObject(attachmentRelation, this.DIA.HasInverseAttachment);
        if (inverse != null) {
            return inverse;
        }
        if (graph.isSubrelationOf(attachmentRelation, this.DIA.HasHeadConnector)) {
            return this.DIA.HasPlainConnector;
        }
        if (graph.isSubrelationOf(attachmentRelation, this.DIA.HasTailConnector)) {
            return this.DIA.HasArrowConnector;
        }
        return null;
    }

    public Resource resolveFlagAttachment(ReadGraph graph, Resource connection, Resource flag, IModelingRules modelingRules) throws DatabaseException {
        FlagClass.Type type = this.resolveFlagType(graph, connection, flag, modelingRules);
        if (type != null) {
            switch (type) {
                case In: {
                    return this.DIA.HasPlainConnector;
                }
                case Out: {
                    return this.DIA.HasArrowConnector;
                }
            }
        }
        return null;
    }

    protected FlagClass.Type resolveFlagType(ReadGraph graph, Resource connection, Resource flag, IModelingRules modelingRules) throws DatabaseException {
        return this.readFlagType(graph, flag);
    }

    protected FlagClass.Type readFlagType(ReadGraph graph, Resource flag) throws DatabaseException {
        Resource flagType = graph.getPossibleObject(flag, this.DIA.HasFlagType);
        FlagClass.Type type = DiagramGraphUtil.toFlagType(this.DIA, flagType);
        return type;
    }

    public static void scheduleSynchronize(Session session, Resource connection, RouteGraphChangeEvent event) {
        session.asyncRequest(RouteGraphConnection.synchronizer(connection, event));
    }

    public static class BackendConnection {
        public final Resource node;
        public final Resource terminal;
        public final EdgeVisuals.EdgeEnd end;

        public BackendConnection(EdgeVisuals.EdgeEnd end, Resource node, Resource terminal) {
            assert (end != null);
            assert (node != null);
            assert (terminal != null);
            this.end = end;
            this.node = node;
            this.terminal = terminal;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Topology.Connection)) {
                return false;
            }
            Topology.Connection other = (Topology.Connection)obj;
            return other.terminal == this.terminal && other.node == this.node && other.end == this.end;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end.hashCode();
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.terminal == null ? 0 : this.terminal.hashCode());
            return result;
        }

        public String toString() {
            return "BackendConnection[node=" + this.node + ", terminal=" + this.terminal + ", end=" + this.end + "]";
        }
    }

    public static class CE
    implements ConnectionEntity {
        final IDiagram diagram;
        final DataElementMap dataMap;
        final Resource connection;
        IElement connectionElement;
        final Set<BackendConnection> backendConnections;
        Set<Topology.Connection> terminalConnections;

        public CE(IDiagram diagram, Resource connection, IElement connectionElement, Set<BackendConnection> backendConnections) {
            if (connectionElement == null) {
                throw new NullPointerException("null connection element");
            }
            this.diagram = diagram;
            this.dataMap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
            this.connection = connection;
            this.connectionElement = connectionElement;
            this.backendConnections = backendConnections;
            IElement ce = this.getConnection0();
            if (ce != null) {
                this.connectionElement = ce;
            }
        }

        public IElement getConnection0() {
            DataElementMap dem = (DataElementMap)this.diagram.getDiagramClass().getSingleItem(DataElementMap.class);
            IElement connectionElement = dem.getElement(this.diagram, (Object)this.connection);
            return connectionElement;
        }

        public IElement getConnection() {
            IElement c = this.getConnection0();
            if (c == null) {
                c = this.connectionElement;
            }
            return c;
        }

        public Collection<IElement> getBranchPoints(Collection<IElement> result) {
            return result != null ? result : Collections.emptyList();
        }

        public Collection<IElement> getSegments(Collection<IElement> result) {
            return result != null ? result : Collections.emptyList();
        }

        public Collection<Topology.Connection> getTerminalConnections(Collection<Topology.Connection> result) {
            if (this.terminalConnections == null) {
                this.terminalConnections = this.calculateTerminalConnections();
            }
            if (result == null) {
                result = new ArrayList<Topology.Connection>(this.terminalConnections);
            } else {
                result.addAll(this.terminalConnections);
            }
            return this.terminalConnections;
        }

        private Set<Topology.Connection> calculateTerminalConnections() {
            THashSet result = new THashSet(this.backendConnections.size());
            DataElementMap dem = (DataElementMap)this.diagram.getDiagramClass().getSingleItem(DataElementMap.class);
            IElement connectionElement = dem.getElement(this.diagram, (Object)this.connection);
            if (connectionElement == null) {
                throw new NullPointerException("connection is not mapped");
            }
            ArrayList ts = new ArrayList();
            block0: for (BackendConnection bc : this.backendConnections) {
                IElement e = dem.getElement(this.diagram, (Object)bc.node);
                if (e == null) continue;
                TerminalTopology tt = (TerminalTopology)e.getElementClass().getSingleItem(TerminalTopology.class);
                ts.clear();
                tt.getTerminals(e, ts);
                for (Topology.Terminal t : ts) {
                    ResourceTerminal rt;
                    if (!(t instanceof ResourceTerminal) || !bc.terminal.equals((rt = (ResourceTerminal)t).getResource())) continue;
                    result.add(new Topology.Connection(connectionElement, bc.end, e, t));
                    continue block0;
                }
            }
            return result;
        }

        public void setListener(ConnectionEntity.ConnectionListener listener) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[resource=" + this.connection + ", connectionElement=" + this.getConnection() + "]";
        }
    }

    public static class LineEndStyle
    extends UnaryRead<Resource, ILineEndStyle> {
        public LineEndStyle(Resource attachmentRelation) {
            super((Object)attachmentRelation);
        }

        public ILineEndStyle perform(ReadGraph graph) throws DatabaseException {
            return RouteGraphConnectionClassFactory.loadLineEndStyle0(graph, (Resource)this.parameter);
        }
    }

    public static class LineEndStyleWithType
    extends ResourceRead2<ILineEndStyle> {
        public LineEndStyleWithType(Resource attachmentRelation, Resource connectionType) {
            super(attachmentRelation, connectionType);
        }

        public ILineEndStyle perform(ReadGraph graph) throws DatabaseException {
            return RouteGraphConnectionClassFactory.loadLineEndStyle0(graph, this.resource, this.resource2);
        }
    }

    public static class ReadConnectionStyleFromConnectionType
    extends UnaryRead<Resource, ConnectionStyle> {
        public ReadConnectionStyleFromConnectionType(Resource connectionType) {
            super((Object)connectionType);
        }

        public ConnectionStyle perform(ReadGraph graph) throws DatabaseException {
            return RouteGraphConnectionClassFactory.readConnectionStyleFromConnectionType0(graph, (Resource)this.parameter);
        }
    }

    public static class Renderer
    extends UnaryRead<ConnectionStyle, StyledRouteGraphRenderer> {
        public Renderer(ConnectionStyle style) {
            super((Object)style);
        }

        public StyledRouteGraphRenderer perform(ReadGraph graph) throws DatabaseException {
            return new StyledRouteGraphRenderer((ConnectionStyle)this.parameter);
        }
    }
}

