/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.diagram.adapter.BaseRequest;
import org.simantics.diagram.content.ConnectionPartData;
import org.simantics.diagram.content.ConnectionPartRequest;
import org.simantics.diagram.content.DiagramContents;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.RouteGraphConnectionPartData;
import org.simantics.diagram.content.RouteGraphConnectionPartRequest;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.g2d.canvas.ICanvasContext;

public class DiagramContentRequest
extends BaseRequest<Resource, DiagramContents> {
    int previousElementCount = 32;
    ErrorHandler errorHandler;

    public DiagramContentRequest(ICanvasContext canvas, Resource resource, ErrorHandler errorHandler) {
        super(canvas, resource);
        this.errorHandler = errorHandler;
    }

    public DiagramContents perform(ReadGraph g) throws DatabaseException {
        final DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        final DiagramContents result = new DiagramContents();
        result.elements = new ArrayList<Resource>(this.previousElementCount);
        result.nodeSet = new THashSet();
        result.connectionSet = new THashSet();
        result.connectionSegments = new THashSet();
        result.branchPoints = new THashSet();
        result.routeGraphConnectionSet = new THashSet();
        result.routeLinks = new THashSet();
        result.routeLines = new THashSet();
        result.routePoints = new THashSet();
        result.partToConnection = new THashMap();
        final AtomicInteger index = new AtomicInteger();
        final TIntArrayList unrecognizedElementIndices = new TIntArrayList();
        g.forOrderedSet((Resource)this.data, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

            public void execute(AsyncReadGraph graph, final Resource component) {
                final int elementIndex = index.getAndIncrement();
                result.elements.add(component);
                graph.forTypes(component, (AsyncProcedure)new AsyncProcedure<Set<Resource>>(){

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        if ((this).DiagramContentRequest.this.errorHandler != null) {
                            (this).DiagramContentRequest.this.errorHandler.error(t.getMessage(), t);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Set<Resource> types) {
                        if (types.contains(DIA.Connection)) {
                            if (types.contains(DIA.RouteGraphConnection)) {
                                graph.asyncRequest((AsyncRead)new RouteGraphConnectionPartRequest((this).DiagramContentRequest.this.errorHandler, DIA, component), (Procedure)new ProcedureAdapter<RouteGraphConnectionPartData>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void execute(RouteGraphConnectionPartData partData) {
                                        DiagramContents diagramContents = result;
                                        synchronized (diagramContents) {
                                            for (EdgeResource link : partData.links) {
                                                result.routeLinks.add(link);
                                                result.partToConnection.put(link, component);
                                                result.connectionToParts.add((Object)component, (Object)link);
                                            }
                                            for (Resource line : partData.routeLines) {
                                                result.routeLines.add(line);
                                                result.connectionToParts.add((Object)component, (Object)line);
                                                result.partToConnection.put(line, component);
                                            }
                                            for (Resource point : partData.routePoints) {
                                                result.routePoints.add(point);
                                                result.connectionToParts.add((Object)component, (Object)point);
                                                result.partToConnection.put(point, component);
                                            }
                                        }
                                    }
                                });
                                Set<Resource> set = result.routeGraphConnectionSet;
                                synchronized (set) {
                                    result.routeGraphConnectionSet.add(component);
                                }
                            } else {
                                graph.asyncRequest((AsyncRead)new ConnectionPartRequest((this).DiagramContentRequest.this.errorHandler, DIA, component), (Procedure)new ProcedureAdapter<ConnectionPartData>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void execute(ConnectionPartData partData) {
                                        DiagramContents diagramContents = result;
                                        synchronized (diagramContents) {
                                            for (EdgeResource er : partData.edges) {
                                                result.connectionSegments.add(er);
                                                result.partToConnection.put(er, component);
                                                result.connectionToParts.add((Object)component, (Object)er);
                                            }
                                            for (Resource bp : partData.branchPoints) {
                                                result.branchPoints.add(bp);
                                                result.connectionToParts.add((Object)component, (Object)bp);
                                                result.partToConnection.put(bp, component);
                                            }
                                        }
                                    }
                                });
                                Set<Resource> set = result.connectionSet;
                                synchronized (set) {
                                    result.connectionSet.add(component);
                                }
                            }
                        } else {
                            if (types.contains(DIA.Element)) {
                                Set<Resource> set = result.nodeSet;
                                synchronized (set) {
                                    result.nodeSet.add(component);
                                }
                            }
                            TIntArrayList tIntArrayList = unrecognizedElementIndices;
                            synchronized (tIntArrayList) {
                                unrecognizedElementIndices.add(elementIndex);
                            }
                        }
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                unrecognizedElementIndices.sort();
                unrecognizedElementIndices.forEachDescending(new TIntProcedure(){

                    public boolean execute(int index) {
                        result.elements.remove(index);
                        return true;
                    }
                });
                DiagramContentRequest.this.previousElementCount = result.elements.size();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                if (DiagramContentRequest.this.errorHandler != null) {
                    DiagramContentRequest.this.errorHandler.error(t.getMessage(), t);
                }
            }
        });
        return result;
    }
}

