/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.diagram.adapter.CompositeImage;
import org.simantics.diagram.adapter.ElementFactoryAdapter;
import org.simantics.diagram.adapter.NodeRequest;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.ImageClass;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;

public class CompositeClassFactory
extends ElementFactoryAdapter {
    private static final StaticSymbolImpl STATIC_SYMBOL = new StaticSymbolImpl((Image)DefaultImages.COMPOSITION.get());

    private static ElementClass build(Resource elementType) {
        String id = "Composite: " + elementType.getResourceId();
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{TextImpl.INSTANCE, new StaticObjectAdapter((Object)elementType), DefaultTransform.INSTANCE, StaticSymbolImageInitializer.INSTANCE, STATIC_SYMBOL, ImageClass.ImageElementHandler.INSTANCE}).setId(id);
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)CompositeClassFactory.build(elementType));
    }

    @Override
    public void load(AsyncReadGraph graph, final ICanvasContext canvas, final IDiagram diagram, Resource element, final IElement e, AsyncProcedure<IElement> procedure) {
        final GuardedAsyncProcedureWrapper guard = new GuardedAsyncProcedureWrapper(procedure, 1);
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)TransformSynchronizer.INSTANCE);
        final ArrayList elements = new ArrayList();
        final TObjectIntHashMap elementOrderMap = new TObjectIntHashMap();
        final AtomicInteger ready = new AtomicInteger(1);
        final AtomicInteger indexCounter = new AtomicInteger(0);
        graph.forOrderedSet(element, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                guard.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, Resource r) {
                ready.incrementAndGet();
                final int childIndex = indexCounter.getAndIncrement();
                graph.asyncRequest((AsyncRead)new NodeRequest(canvas, diagram, r, null), (AsyncListener)new TransientCacheAsyncListener<IElement>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        guard.exception(graph, throwable);
                    }

                    public void execute(AsyncReadGraph graph, IElement child) {
                        this.elementReady(graph, child, childIndex);
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                this.elementReady(graph, null, -1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void elementReady(AsyncReadGraph graph, IElement child, int index) {
                if (child != null) {
                    List list = elements;
                    synchronized (list) {
                        elements.add(child);
                        elementOrderMap.put((Object)child, index);
                    }
                }
                if (ready.decrementAndGet() == 0) {
                    Collections.sort(elements, new Comparator<IElement>(){

                        @Override
                        public int compare(IElement o1, IElement o2) {
                            int anotherVal;
                            int thisVal = elementOrderMap.get((Object)o1);
                            return thisVal < (anotherVal = elementOrderMap.get((Object)o2)) ? -1 : (thisVal == anotherVal ? 0 : 1);
                        }
                    });
                    CompositeImage img = new CompositeImage(elements);
                    e.setHint(ElementHints.KEY_IMAGE, (Object)img);
                    guard.execute(graph, (Object)e);
                }
            }
        });
    }
}

