/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.format.MetricsFormat;

public class G2DUtils {
    public static Object getObject(ReadGraph g, Resource resource) throws ServiceException, NoSingleResultException, DoesNotContainValueException, ManyObjectsForFunctionalRelationException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(resource, g2d.Font)) {
            return G2DUtils.getFont(g, resource);
        }
        if (g.isInstanceOf(resource, g2d.Color)) {
            return G2DUtils.getColor(g, resource);
        }
        if (g.isInstanceOf(resource, g2d.Transform)) {
            return G2DUtils.getTransform(g, resource);
        }
        if (g.isInstanceOf(resource, g2d.Rectangle2D)) {
            return G2DUtils.getRectangle(g, resource);
        }
        return g.getPossibleValue(resource);
    }

    public static Font getFont(ReadGraph g, Resource fontResource) throws ServiceException, NoSingleResultException, DoesNotContainValueException, ManyObjectsForFunctionalRelationException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(fontResource, g2d.Font)) {
            throw new IllegalArgumentException("Resource " + fontResource + " is not a font");
        }
        String name = (String)g.getRelatedValue(fontResource, g2d.HasFontFamily);
        int size = (Integer)g.getRelatedValue(fontResource, g2d.HasFontSize);
        int style = 0;
        Resource styleResource = g.getPossibleObject(fontResource, g2d.HasFontStyle);
        if (styleResource != null) {
            if (styleResource.equals(g2d.FontStyle_bold_italic_style)) {
                style = 3;
            } else if (styleResource.equals(g2d.FontStyle_bold_font_style)) {
                style = 1;
            } else if (styleResource.equals(g2d.FontStyle_italic_font_style)) {
                style = 2;
            } else if (styleResource.equals(g2d.FontStyle_normal_font_style)) {
                style = 0;
            } else {
                throw new IllegalArgumentException("Given font " + fontResource + " does not contain valid style. Current style is " + styleResource);
            }
        }
        return new Font(name, style, size);
    }

    public static Color getColor(ReadGraph g, Resource colorResource) throws DoesNotContainValueException, ServiceException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(colorResource, g2d.Color)) {
            throw new IllegalArgumentException("Resource " + colorResource + " is not a color");
        }
        float[] value = (float[])g.getValue(colorResource);
        if (value.length != 4) {
            throw new IllegalArgumentException("Color " + colorResource + " does not have proper definition, expected 4 components, got " + value.length + " components");
        }
        return new Color(value[0], value[1], value[2], value[3]);
    }

    public static AffineTransform getTransform(ReadGraph g, Resource resource) throws DoesNotContainValueException, ServiceException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(resource, g2d.Transform)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a transform");
        }
        double[] values = (double[])g.getValue(resource);
        if (values.length != 6) {
            throw new IllegalArgumentException("Transform " + resource + " does not have proper definition, expected 6 components, got " + values.length + " components");
        }
        return new AffineTransform(values);
    }

    public static Rectangle2D getRectangle(ReadGraph g, Resource resource) throws DoesNotContainValueException, ServiceException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(resource, g2d.Rectangle2D)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a rectangle");
        }
        double[] values = (double[])g.getValue(resource);
        if (values.length != 4) {
            throw new IllegalArgumentException("Transform " + resource + " does not have proper definition, expected 4 components, got " + values.length + " components");
        }
        return new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
    }

    public static Resource createFont(WriteGraph g, Font font) throws ServiceException, ManyObjectsForFunctionalRelationException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        Resource fontResource = g.newResource();
        g.claim(fontResource, b.InstanceOf, null, g2d.Font);
        g.claimLiteral(fontResource, g2d.HasFontFamily, (Object)font.getFamily());
        g.claimLiteral(fontResource, g2d.HasFontSize, (Object)font.getSize());
        if (font.getStyle() == 3) {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_bold_italic_style);
        } else if (font.getStyle() == 1) {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_bold_font_style);
        } else if (font.getStyle() == 2) {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_italic_font_style);
        } else {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_normal_font_style);
        }
        return fontResource;
    }

    public static Resource createColor(WriteGraph g, Color color) throws ServiceException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        Resource colorResource = g.newResource();
        g.claim(colorResource, b.InstanceOf, null, g2d.Color);
        g.claimValue(colorResource, (Object)color.getRGBComponents(null));
        return colorResource;
    }

    public static Resource createMetricsFormat(WriteGraph g, MetricsFormat format) throws ServiceException, ManyObjectsForFunctionalRelationException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Resource formatResource = g.newResource();
        g.claim(formatResource, b.InstanceOf, null, dr.Format);
        g.claimLiteral(formatResource, b.HasName, (Object)format.getName());
        g.claimLiteral(formatResource, dr.HasPattern, (Object)format.getPattern());
        return formatResource;
    }

    public static MetricsFormat getMetricsFormat(ReadGraph g, Resource formatResource) throws NoSingleResultException, DoesNotContainValueException, ServiceException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        String name = (String)g.getRelatedValue(formatResource, l0.HasName);
        String pattern = (String)g.getRelatedValue(formatResource, dr.HasPattern);
        return new MetricsFormat(pattern, 1.0, name);
    }
}

