/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class Strings {
    private static final MessageDigest MESSAGE_DIGEST;
    public static final String[] EMPTY_ARRAY;
    private static final String HEX_CHARS = "0123456789ABCDEF";

    static {
        MessageDigest md;
        EMPTY_ARRAY = new String[0];
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException();
        }
        MESSAGE_DIGEST = md;
    }

    private Strings() {
    }

    public static int compareVersions(String version1, String version2, boolean startsWithDigits) {
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        if (version2 == null) {
            return 1;
        }
        if (startsWithDigits) {
            int diff;
            String v1prefix = Strings.leadingDigits(version1);
            String v2prefix = Strings.leadingDigits(version2);
            if (v1prefix.length() == 0) {
                if (v2prefix.length() == 0) {
                    return 0;
                }
                return -1;
            }
            if (v2prefix.length() == 0) {
                return 1;
            }
            try {
                diff = Integer.parseInt(v1prefix) - Integer.parseInt(v2prefix);
            }
            catch (NumberFormatException numberFormatException) {
                diff = 0;
            }
            if (diff == 0) {
                return Strings.compareVersions(version1.substring(v1prefix.length()), version2.substring(v2prefix.length()), false);
            }
            return diff;
        }
        String v1prefix = Strings.leadingNonDigits(version1);
        String v2prefix = Strings.leadingNonDigits(version2);
        if (v1prefix.length() == 0) {
            if (v2prefix.length() == 0) {
                return 0;
            }
            return -1;
        }
        if (v2prefix.length() == 0) {
            return 1;
        }
        int diff = v1prefix.compareTo(v2prefix);
        if (diff == 0) {
            return Strings.compareVersions(version1.substring(v1prefix.length()), version2.substring(v2prefix.length()), true);
        }
        return diff;
    }

    public static String leadingDigits(String text) {
        int length = text.length();
        StringBuffer buffer = null;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (!Character.isDigit(ch)) break;
            if (buffer == null) {
                buffer = new StringBuffer(3);
            }
            buffer.append(ch);
            ++i;
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static String leadingNonDigits(String text) {
        int length = text.length();
        StringBuffer buffer = null;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (Character.isDigit(ch)) break;
            if (buffer == null) {
                buffer = new StringBuffer(3);
            }
            buffer.append(ch);
            ++i;
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static boolean isBlank(String text) {
        return text == null || "".equals(text);
    }

    public static int countLines(String text) {
        int lbIdx;
        int startIdx = 0;
        int lineCount = 1;
        while ((lbIdx = text.indexOf(10, startIdx)) != -1) {
            ++lineCount;
            startIdx = lbIdx + 1;
        }
        return lineCount;
    }

    public static boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        int len = id.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getJavaStringLiteral(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int len = text.length();
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String getJavaIdentifier(String candidateID) {
        int len = candidateID.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            boolean good;
            char ch = candidateID.charAt(i);
            boolean bl = good = i == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch);
            if (good) {
                buf.append(ch);
            } else {
                buf.append('_');
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(String source) {
        byte[] result;
        byte[] bytes;
        try {
            bytes = source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            throw new IllegalStateException(ue);
        }
        MessageDigest messageDigest = MESSAGE_DIGEST;
        synchronized (messageDigest) {
            MESSAGE_DIGEST.update(bytes);
            result = MESSAGE_DIGEST.digest();
        }
        char[] resChars = new char[32];
        int len = result.length;
        int i = 0;
        while (i < len) {
            byte b = result[i];
            int lo4 = b & 0xF;
            int hi4 = (b & 0xF0) >> 4;
            resChars[i * 2] = HEX_CHARS.charAt(hi4);
            resChars[i * 2 + 1] = HEX_CHARS.charAt(lo4);
            ++i;
        }
        return new String(resChars);
    }

    public static String getHash32(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 8);
    }

    public static String getHash64(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 16);
    }

    public static int countChars(String text, char ch) {
        int len = text.length();
        int count = 0;
        int i = 0;
        while (i < len) {
            if (ch == text.charAt(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String unquote(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String[] split(String phrase) {
        int length = phrase.length();
        ArrayList<String> wordList = new ArrayList<String>();
        StringBuffer word = null;
        int i = 0;
        while (i < length) {
            char ch = phrase.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (word == null) break;
                    wordList.add(word.toString());
                    word = null;
                    break;
                }
                default: {
                    if (word == null) {
                        word = new StringBuffer();
                    }
                    word.append(ch);
                }
            }
            ++i;
        }
        if (word != null) {
            wordList.add(word.toString());
        }
        return wordList.toArray(EMPTY_ARRAY);
    }

    public static String truncate(String text, int maxLength) {
        if (text == null) {
            return null;
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return String.valueOf(text.substring(0, Math.max(maxLength - 3, 0))) + "...";
    }

    public static String strictHtmlEncode(String rawText, boolean quotes) {
        StringBuffer output = new StringBuffer();
        int length = rawText.length();
        int i = 0;
        while (i < length) {
            char ch = rawText.charAt(i);
            switch (ch) {
                case '&': {
                    output.append("&amp;");
                    break;
                }
                case '\"': {
                    if (quotes) {
                        output.append("&quot;");
                        break;
                    }
                    output.append(ch);
                    break;
                }
                case '<': {
                    output.append("&lt;");
                    break;
                }
                case '>': {
                    output.append("&gt;");
                    break;
                }
                default: {
                    output.append(ch);
                }
            }
            ++i;
        }
        return output.toString();
    }

    public static String trimForAlphaNumDash(String rawText) {
        int length = rawText.length();
        int i = 0;
        while (i < length) {
            char ch = rawText.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-')) {
                return rawText.substring(0, i);
            }
            ++i;
        }
        return rawText;
    }

    public static String getCRLFString(String original) {
        if (original == null) {
            return null;
        }
        int length = original.length();
        StringBuffer buffer = new StringBuffer();
        boolean lastSlashR = false;
        int i = 0;
        while (i < length) {
            char ch = original.charAt(i);
            switch (ch) {
                case '\r': {
                    lastSlashR = true;
                    break;
                }
                case '\n': {
                    lastSlashR = false;
                    buffer.append("\r\n");
                    break;
                }
                default: {
                    if (lastSlashR) {
                        lastSlashR = false;
                        buffer.append("\r\n");
                    }
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

