/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.RemovalEvent;
import org.lobobrowser.util.RemovalListener;

public class LRUCache
implements Serializable {
    private static final long serialVersionUID = 940427225784212823L;
    private int approxMaxSize;
    private final Map cacheMap = new HashMap();
    private volatile transient EventDispatch2 removalEvent;
    private final TreeSet timedSet = new TreeSet();
    private int currentSize = 0;

    public LRUCache(int approxMaxSize) {
        this.approxMaxSize = approxMaxSize;
        this.removalEvent = new RemovalDispatch();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.removalEvent = new RemovalDispatch();
    }

    public int getApproxMaxSize() {
        return this.approxMaxSize;
    }

    public void setApproxMaxSize(int approxMaxSize) {
        this.approxMaxSize = approxMaxSize;
    }

    public void put(Object key, Object value, int approxSize) {
        if (approxSize > this.approxMaxSize) {
            return;
        }
        OrderedValue ordVal = (OrderedValue)this.cacheMap.get(key);
        if (ordVal != null) {
            if (ordVal.value != value) {
                this.removalEvent.fireEvent(new RemovalEvent(this, ordVal.value));
            }
            this.currentSize += approxSize - ordVal.approximateSize;
            this.timedSet.remove(ordVal);
            ordVal.approximateSize = approxSize;
            ordVal.value = value;
            ordVal.touch();
            this.timedSet.add(ordVal);
        } else {
            ordVal = new OrderedValue(key, value, approxSize);
            this.cacheMap.put(key, ordVal);
            this.timedSet.add(ordVal);
            this.currentSize += approxSize;
        }
        while (this.currentSize > this.approxMaxSize) {
            this.removeLRU();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeLRU() {
        OrderedValue ordVal = (OrderedValue)this.timedSet.first();
        if (ordVal == null) throw new IllegalStateException("Cannot remove LRU since the cache is empty.");
        this.removalEvent.fireEvent(new RemovalEvent(this, ordVal.value));
        if (!this.timedSet.remove(ordVal)) throw new IllegalStateException("Could not remove existing tree node.");
        this.cacheMap.remove(ordVal.key);
        this.currentSize -= ordVal.approximateSize;
    }

    public Object get(Object key) {
        OrderedValue ordVal = (OrderedValue)this.cacheMap.get(key);
        if (ordVal != null) {
            this.timedSet.remove(ordVal);
            ordVal.touch();
            this.timedSet.add(ordVal);
            return ordVal.value;
        }
        return null;
    }

    public Object remove(Object key) {
        OrderedValue ordVal = (OrderedValue)this.cacheMap.get(key);
        if (ordVal != null) {
            this.removalEvent.fireEvent(new RemovalEvent(this, ordVal.value));
            this.currentSize -= ordVal.approximateSize;
            this.timedSet.remove(ordVal);
            return ordVal.value;
        }
        return null;
    }

    public void addRemovalListener(RemovalListener listener) {
        this.removalEvent.addListener(listener);
    }

    public void removeRemovalListener(RemovalListener listener) {
        this.removalEvent.removeListener(listener);
    }

    public int getApproxSize() {
        return this.currentSize;
    }

    public int getNumEntries() {
        return this.cacheMap.size();
    }

    public List getEntryInfoList() {
        ArrayList<EntryInfo> list = new ArrayList<EntryInfo>();
        for (OrderedValue ov : this.cacheMap.values()) {
            Object value = ov.value;
            Class<?> vc = value == null ? null : value.getClass();
            list.add(new EntryInfo(vc, ov.approximateSize));
        }
        return list;
    }

    public static class EntryInfo {
        public final Class valueClass;
        public final int approximateSize;

        public EntryInfo(Class valueClass, int approximateSize) {
            this.valueClass = valueClass;
            this.approximateSize = approximateSize;
        }

        public String toString() {
            Class vc = this.valueClass;
            String vcName = vc == null ? "<none>" : vc.getName();
            return "[class=" + vcName + ",approx-size=" + this.approximateSize + "]";
        }
    }

    private class OrderedValue
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 340227625744215821L;
        private long timestamp;
        private int approximateSize;
        private Object value;
        private Object key;

        private OrderedValue(Object key, Object value, int approxSize) {
            this.key = key;
            this.value = value;
            this.approximateSize = approxSize;
            this.touch();
        }

        private final void touch() {
            this.timestamp = System.currentTimeMillis();
        }

        public int compareTo(Object arg0) {
            int hc2;
            if (this == arg0) {
                return 0;
            }
            OrderedValue other = (OrderedValue)arg0;
            long diff = this.timestamp - other.timestamp;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            int hc1 = System.identityHashCode(this);
            if (hc1 == (hc2 = System.identityHashCode(other))) {
                hc1 = System.identityHashCode(this.value);
                hc2 = System.identityHashCode(other.value);
            }
            return hc1 - hc2;
        }
    }

    private class RemovalDispatch
    extends EventDispatch2 {
        private RemovalDispatch() {
        }

        @Override
        protected void dispatchEvent(EventListener listener, EventObject event) {
            ((RemovalListener)listener).removed((RemovalEvent)event);
        }
    }
}

