/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class History
implements Serializable {
    private static final long serialVersionUID = 2257845000800300100L;
    private transient ArrayList historySequence;
    private final SortedSet historySortedSet = new TreeSet();
    private final Map historyMap = new HashMap();
    private final SortedSet historyTimedSet = new TreeSet();
    private int sequenceCapacity;
    private int commonEntriesCapacity;
    private transient int sequenceIndex = -1;

    public History(int sequenceCapacity, int commonEntriesCapacity) {
        this.historySequence = new ArrayList();
        this.sequenceCapacity = sequenceCapacity;
        this.commonEntriesCapacity = commonEntriesCapacity;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.historySequence = new ArrayList();
        this.sequenceIndex = -1;
        in.defaultReadObject();
    }

    public int getCommonEntriesCapacity() {
        return this.commonEntriesCapacity;
    }

    public void setCommonEntriesCapacity(int commonEntriesCapacity) {
        this.commonEntriesCapacity = commonEntriesCapacity;
    }

    public int getSequenceCapacity() {
        return this.sequenceCapacity;
    }

    public void setSequenceCapacity(int sequenceCapacity) {
        this.sequenceCapacity = sequenceCapacity;
    }

    public String getCurrentItem() {
        if (this.sequenceIndex >= 0) {
            return (String)this.historySequence.get(this.sequenceIndex);
        }
        return null;
    }

    public String back() {
        if (this.sequenceIndex > 0) {
            --this.sequenceIndex;
            return this.getCurrentItem();
        }
        return null;
    }

    public String forward() {
        if (this.sequenceIndex + 1 < this.historySequence.size()) {
            ++this.sequenceIndex;
            return this.getCurrentItem();
        }
        return null;
    }

    public Collection getRecentItems(int maxNumItems) {
        LinkedList<String> items = new LinkedList<String>();
        Iterator i = this.historyTimedSet.iterator();
        int count = 0;
        while (i.hasNext() && count++ < maxNumItems) {
            TimedEntry entry = (TimedEntry)i.next();
            items.add(entry.value);
        }
        return items;
    }

    public Collection getHeadMatchItems(String item, int maxNumItems) {
        Object[] array = this.historySortedSet.toArray();
        int idx = Arrays.binarySearch(array, item);
        int startIdx = idx >= 0 ? idx : -idx - 1;
        int count = 0;
        LinkedList<String> items = new LinkedList<String>();
        int i = startIdx;
        while (i < array.length && count++ < maxNumItems) {
            String potentialItem = (String)array[i];
            if (!potentialItem.startsWith(item)) break;
            items.add(potentialItem);
            ++i;
        }
        return items;
    }

    public void addAsRecentOnly(String item) {
        TimedEntry entry = (TimedEntry)this.historyMap.get(item);
        if (entry != null) {
            this.historyTimedSet.remove(entry);
            entry.touch();
            this.historyTimedSet.add(entry);
        } else {
            entry = new TimedEntry(item);
            this.historyTimedSet.add(entry);
            this.historyMap.put(item, entry);
            this.historySortedSet.add(item);
            if (this.historyTimedSet.size() > this.commonEntriesCapacity) {
                TimedEntry entryToRemove = (TimedEntry)this.historyTimedSet.last();
                this.historyMap.remove(entryToRemove.value);
                this.historySortedSet.remove(entryToRemove.value);
                this.historyTimedSet.remove(entryToRemove);
            }
        }
    }

    public void addItem(String item, boolean updateAsRecent) {
        int newIndex = this.sequenceIndex + 1;
        while (newIndex >= this.historySequence.size()) {
            this.historySequence.add(null);
        }
        this.historySequence.set(newIndex, item);
        this.sequenceIndex = newIndex;
        int expectedSize = newIndex + 1;
        while (this.historySequence.size() > expectedSize) {
            this.historySequence.remove(expectedSize);
        }
        while (this.historySequence.size() > this.sequenceCapacity) {
            this.historySequence.remove(0);
            --this.sequenceIndex;
        }
        if (updateAsRecent) {
            this.addAsRecentOnly(item);
        }
    }

    private class TimedEntry
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2257845000000000200L;
        private long timestamp = System.currentTimeMillis();
        private final String value;

        public TimedEntry(String value) {
            this.value = value;
        }

        public void touch() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object obj) {
            TimedEntry other = (TimedEntry)obj;
            return other.value.equals(this.value);
        }

        public int compareTo(Object arg0) {
            if (this.equals(arg0)) {
                return 0;
            }
            TimedEntry other = (TimedEntry)arg0;
            long time1 = this.timestamp;
            long time2 = other.timestamp;
            if (time1 > time2) {
                return -1;
            }
            if (time2 > time1) {
                return 1;
            }
            int diff = System.identityHashCode(this) - System.identityHashCode(other);
            if (diff == 0) {
                return 1;
            }
            return diff;
        }
    }
}

