/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.net.CookieHandler;
import java.net.Proxy;
import java.net.URL;
import java.security.Policy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.test.SimpleHttpRequest;

public class SimpleUserAgentContext
implements UserAgentContext {
    private static final Logger logger = Logger.getLogger(SimpleUserAgentContext.class.getName());
    private static final Set mediaNames = new HashSet();
    private Proxy proxy = Proxy.NO_PROXY;
    private String appCodeName = "Cobra";
    private String appMinorVersion = "0";
    private String appName = "Cobra";
    private String appVersion = "1";
    private String userAgent = "Mozilla/4.0 (compatible; MSIE 6.0;) Cobra/Simple";
    private boolean scriptingEnabled = true;
    private int scriptingOptimizationLevel = -1;
    private String vendor = "The Lobo Project";
    private String product = "Cobra";
    private boolean externalCSSEnabled = true;

    static {
        Set mn = mediaNames;
        mn.add("screen");
        mn.add("tv");
        mn.add("tty");
        mn.add("all");
    }

    @Override
    public boolean isMedia(String mediaName) {
        return mediaNames.contains(mediaName.toLowerCase());
    }

    @Override
    public HttpRequest createHttpRequest() {
        return new SimpleHttpRequest(this, this.getProxy());
    }

    protected Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public String getAppCodeName() {
        return this.appCodeName;
    }

    public void setAppCodeName(String appCodeName) {
        this.appCodeName = appCodeName;
    }

    @Override
    public String getAppMinorVersion() {
        return this.appMinorVersion;
    }

    public void setAppMinorVersion(String appMinorVersion) {
        this.appMinorVersion = appMinorVersion;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    @Override
    public String getBrowserLanguage() {
        return Locale.getDefault().getLanguage();
    }

    @Override
    public String getPlatform() {
        return System.getProperty("os.name");
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public boolean isCookieEnabled() {
        return CookieHandler.getDefault() != null;
    }

    @Override
    public String getCookie(URL url) {
        Map<String, List<String>> results;
        CookieHandler handler = CookieHandler.getDefault();
        if (handler == null) {
            return "";
        }
        try {
            results = handler.get(url.toURI(), new HashMap<String, List<String>>());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "getCookie()", err);
            return "";
        }
        if (results == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<Map.Entry<String, List<String>>> i = results.entrySet().iterator();
        boolean firstTime = true;
        while (i.hasNext()) {
            Map.Entry<String, List<String>> entry = i.next();
            String key = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key)) continue;
            List<String> list = entry.getValue();
            for (String value : list) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    buffer.append("; ");
                }
                buffer.append(value);
            }
        }
        return buffer.toString();
    }

    @Override
    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean enable) {
        this.scriptingEnabled = enable;
    }

    @Override
    public void setCookie(URL url, String cookieSpec) {
        CookieHandler handler = CookieHandler.getDefault();
        if (handler == null) {
            return;
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(2);
        headers.put("Set-Cookie", Collections.singletonList(cookieSpec));
        try {
            handler.put(url.toURI(), headers);
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "setCookie()", err);
        }
    }

    @Override
    public Policy getSecurityPolicy() {
        return null;
    }

    @Override
    public int getScriptingOptimizationLevel() {
        return this.scriptingOptimizationLevel;
    }

    public void setScriptingOptimizationLevel(int level) {
        this.scriptingOptimizationLevel = level;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @Override
    public boolean isExternalCSSEnabled() {
        return this.externalCSSEnabled;
    }

    public void setExternalCSSEnabled(boolean enabled) {
        this.externalCSSEnabled = enabled;
    }
}

