/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import com.steadystate.css.parser.CSSOMParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.style.CSSUtilities;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CssParserTest
extends JFrame {
    private static final Logger logger = Logger.getLogger(CssParserTest.class.getName());
    private final HtmlPanel cssOutput;
    private final JTextArea textArea;

    public CssParserTest() throws HeadlessException {
        this("CSS Parser Test Tool");
    }

    public CssParserTest(String title) throws HeadlessException {
        super(title);
        JTextArea textArea;
        HtmlPanel htmlPanel;
        this.setDefaultCloseOperation(3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        final JTextField textField = new JTextField();
        JButton button = new JButton("Parse & Render");
        JTabbedPane tabbedPane = new JTabbedPane();
        this.cssOutput = htmlPanel = new HtmlPanel();
        contentPane.add((Component)topPanel, "North");
        contentPane.add((Component)bottomPanel, "Center");
        topPanel.add((Component)new JLabel("URL: "), "West");
        topPanel.add((Component)textField, "Center");
        topPanel.add((Component)button, "East");
        bottomPanel.add((Component)tabbedPane, "Center");
        this.textArea = textArea = new JTextArea();
        JScrollPane textAreaSp = new JScrollPane(textArea);
        tabbedPane.addTab("Parsed CSS", htmlPanel);
        tabbedPane.addTab("Source Code", textAreaSp);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CssParserTest.this.process(textField.getText());
            }
        });
    }

    private void process(String uri) {
        try {
            byte[] content;
            URL url;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException mfu) {
                int idx = uri.indexOf(58);
                if (idx == -1 || idx == 1) {
                    url = new URL("file:" + uri);
                }
                throw mfu;
            }
            logger.info("process(): Loading URI=[" + uri + "].");
            long time0 = System.currentTimeMillis();
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible;) Cobra/0.96.1+");
            connection.setRequestProperty("Cookie", "");
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)connection;
                hc.setInstanceFollowRedirects(true);
                int responseCode = hc.getResponseCode();
                logger.info("process(): HTTP response code: " + responseCode);
            }
            InputStream in = connection.getInputStream();
            try {
                content = IORoutines.load(in, 8192);
            }
            finally {
                in.close();
            }
            String source = new String(content, "ISO-8859-1");
            this.textArea.setText(source);
            long time1 = System.currentTimeMillis();
            CSSOMParser parser = new CSSOMParser();
            InputSource is = CSSUtilities.getCssInputSourceForStyleSheet(source, uri);
            CSSStyleSheet styleSheet = parser.parseStyleSheet(is);
            long time2 = System.currentTimeMillis();
            logger.info("Parsed URI=[" + uri + "]: Parse elapsed: " + (time2 - time1) + " ms. Load elapsed: " + (time1 - time0) + " ms.");
            this.showStyleSheet(styleSheet);
        }
        catch (Exception err) {
            logger.log(Level.SEVERE, "Error trying to load URI=[" + uri + "].", err);
            this.clearCssOutput();
        }
    }

    private void clearCssOutput() {
        this.cssOutput.clearDocument();
    }

    private void showStyleSheet(CSSStyleSheet styleSheet) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("<DL>");
        CSSRuleList ruleList = styleSheet.getCssRules();
        int length = ruleList.getLength();
        int i = 0;
        while (i < length) {
            CSSRule rule = ruleList.item(i);
            writer.println("<DT><strong>Rule: type=" + rule.getType() + ",class=" + rule.getClass().getName() + "</strong></DT>");
            writer.println("<DD>");
            this.writeRuleInfo(writer, rule);
            writer.println("</DD>");
            ++i;
        }
        writer.println("</DL>");
        writer.flush();
        String html = stringWriter.toString();
        SimpleHtmlRendererContext rcontext = new SimpleHtmlRendererContext(this.cssOutput);
        this.cssOutput.setHtml(html, "about:css", rcontext);
    }

    private void writeRuleInfo(PrintWriter writer, CSSRule rule) {
        if (rule instanceof CSSStyleRule) {
            CSSStyleRule styleRule = (CSSStyleRule)rule;
            writer.println("Selector: " + styleRule.getSelectorText());
            writer.println("<br>");
            writer.println("CSS Text: " + styleRule.getCssText());
        } else if (rule instanceof CSSImportRule) {
            CSSImportRule styleRule = (CSSImportRule)rule;
            writer.println("HREF: " + styleRule.getHref());
            writer.println("<br>");
            writer.println("CSS Text: " + styleRule.getCssText());
        }
    }

    public static void main(String[] args) {
        CssParserTest frame = new CssParserTest();
        frame.setSize(800, 400);
        frame.setExtendedState(6);
        frame.setVisible(true);
    }
}

