/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.util.gui.ColorFactory;

public class TableRenderState
extends StyleSheetRenderState {
    private BackgroundInfo backgroundInfo = INVALID_BACKGROUND_INFO;

    public TableRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element);
    }

    @Override
    public Color getTextBackgroundColor() {
        return super.getTextBackgroundColor();
    }

    @Override
    protected int getDefaultDisplay() {
        return 6;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.backgroundInfo = INVALID_BACKGROUND_INFO;
    }

    @Override
    public BackgroundInfo getBackgroundInfo() {
        String background;
        String bgColor;
        BackgroundInfo binfo = this.backgroundInfo;
        if (binfo != INVALID_BACKGROUND_INFO) {
            return binfo;
        }
        binfo = super.getBackgroundInfo();
        HTMLTableElementImpl element = (HTMLTableElementImpl)this.element;
        if (!(binfo != null && binfo.backgroundColor != null || (bgColor = element.getBgColor()) == null || "".equals(bgColor))) {
            Color bgc = ColorFactory.getInstance().getColor(bgColor);
            if (binfo == null) {
                binfo = new BackgroundInfo();
            }
            binfo.backgroundColor = bgc;
        }
        if (!(binfo != null && binfo.backgroundImage != null || (background = element.getAttribute("background")) == null || "".equals(background))) {
            if (binfo == null) {
                binfo = new BackgroundInfo();
            }
            binfo.backgroundImage = this.document.getFullURL(background);
        }
        this.backgroundInfo = binfo;
        return binfo;
    }

    @Override
    public BorderInfo getBorderInfo() {
        BorderInfo binfo = this.borderInfo;
        if (binfo != INVALID_BORDER_INFO) {
            return binfo;
        }
        binfo = super.getBorderInfo();
        if (binfo == null || binfo.topStyle == 0 && binfo.bottomStyle == 0 && binfo.leftStyle == 0 && binfo.rightStyle == 0) {
            String border;
            HTMLElementImpl element;
            if (binfo == null) {
                binfo = new BorderInfo();
            }
            if ((element = this.element) != null && (border = element.getAttribute("border")) != null) {
                int value;
                int valueType;
                if ((border = border.trim()).endsWith("%")) {
                    valueType = 3;
                    try {
                        value = Integer.parseInt(border.substring(0, border.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        value = 0;
                    }
                } else {
                    valueType = 1;
                    try {
                        value = Integer.parseInt(border);
                    }
                    catch (NumberFormatException numberFormatException) {
                        value = 0;
                    }
                }
                HtmlInsets borderInsets = new HtmlInsets();
                borderInsets.right = borderInsets.bottom = value;
                borderInsets.left = borderInsets.bottom;
                borderInsets.top = borderInsets.bottom;
                borderInsets.rightType = borderInsets.bottomType = valueType;
                borderInsets.leftType = borderInsets.bottomType;
                borderInsets.topType = borderInsets.bottomType;
                binfo.insets = borderInsets;
                if (binfo.topColor == null) {
                    binfo.topColor = Color.LIGHT_GRAY;
                }
                if (binfo.leftColor == null) {
                    binfo.leftColor = Color.LIGHT_GRAY;
                }
                if (binfo.rightColor == null) {
                    binfo.rightColor = Color.GRAY;
                }
                if (binfo.bottomColor == null) {
                    binfo.bottomColor = Color.GRAY;
                }
                if (value != 0) {
                    binfo.bottomStyle = 4;
                    binfo.rightStyle = 4;
                    binfo.leftStyle = 4;
                    binfo.topStyle = 4;
                }
            }
        }
        this.borderInfo = binfo;
        return binfo;
    }
}

