/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.FontInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.ListStyle;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.css.CSS2Properties;

public class HtmlValues {
    public static final Map SYSTEM_FONTS = new HashMap();
    private static final Logger logger = Logger.getLogger(HtmlValues.class.getName());
    public static final float DEFAULT_FONT_SIZE = 14.0f;
    public static final int DEFAULT_FONT_SIZE_INT = 14;
    public static final Float DEFAULT_FONT_SIZE_BOX = new Float(14.0f);
    public static final int DEFAULT_BORDER_WIDTH = 2;
    public static final int BORDER_STYLE_NONE = 0;
    public static final int BORDER_STYLE_HIDDEN = 1;
    public static final int BORDER_STYLE_DOTTED = 2;
    public static final int BORDER_STYLE_DASHED = 3;
    public static final int BORDER_STYLE_SOLID = 4;
    public static final int BORDER_STYLE_DOUBLE = 5;
    public static final int BORDER_STYLE_GROOVE = 6;
    public static final int BORDER_STYLE_RIDGE = 7;
    public static final int BORDER_STYLE_INSET = 8;
    public static final int BORDER_STYLE_OUTSET = 9;

    static {
        FontInfo systemFont = new FontInfo();
        SYSTEM_FONTS.put("caption", systemFont);
        SYSTEM_FONTS.put("icon", systemFont);
        SYSTEM_FONTS.put("menu", systemFont);
        SYSTEM_FONTS.put("message-box", systemFont);
        SYSTEM_FONTS.put("small-caption", systemFont);
        SYSTEM_FONTS.put("status-bar", systemFont);
    }

    private HtmlValues() {
    }

    public static boolean isBorderStyle(String token) {
        String tokenTL = token.toLowerCase();
        return tokenTL.equals("solid") || tokenTL.equals("dashed") || tokenTL.equals("dotted") || tokenTL.equals("double") || tokenTL.equals("none") || tokenTL.equals("hidden") || tokenTL.equals("groove") || tokenTL.equals("ridge") || tokenTL.equals("inset") || tokenTL.equals("outset");
    }

    public static HtmlInsets getMarginInsets(CSS2Properties cssProperties, RenderState renderState) {
        HtmlInsets insets = null;
        String topText = cssProperties.getMarginTop();
        insets = HtmlValues.updateTopInset(insets, topText, renderState);
        String leftText = cssProperties.getMarginLeft();
        insets = HtmlValues.updateLeftInset(insets, leftText, renderState);
        String bottomText = cssProperties.getMarginBottom();
        insets = HtmlValues.updateBottomInset(insets, bottomText, renderState);
        String rightText = cssProperties.getMarginRight();
        insets = HtmlValues.updateRightInset(insets, rightText, renderState);
        return insets;
    }

    public static HtmlInsets getPaddingInsets(CSS2Properties cssProperties, RenderState renderState) {
        HtmlInsets insets = null;
        String topText = cssProperties.getPaddingTop();
        insets = HtmlValues.updateTopInset(insets, topText, renderState);
        String leftText = cssProperties.getPaddingLeft();
        insets = HtmlValues.updateLeftInset(insets, leftText, renderState);
        String bottomText = cssProperties.getPaddingBottom();
        insets = HtmlValues.updateBottomInset(insets, bottomText, renderState);
        String rightText = cssProperties.getPaddingRight();
        insets = HtmlValues.updateRightInset(insets, rightText, renderState);
        return insets;
    }

    public static HtmlInsets getBorderInsets(Insets borderStyles, CSS2Properties cssProperties, RenderState renderState) {
        HtmlInsets insets = null;
        if (borderStyles.top != 0) {
            String topText = cssProperties.getBorderTopWidth();
            insets = HtmlValues.updateTopInset(insets, topText, renderState);
        }
        if (borderStyles.left != 0) {
            String leftText = cssProperties.getBorderLeftWidth();
            insets = HtmlValues.updateLeftInset(insets, leftText, renderState);
        }
        if (borderStyles.bottom != 0) {
            String bottomText = cssProperties.getBorderBottomWidth();
            insets = HtmlValues.updateBottomInset(insets, bottomText, renderState);
        }
        if (borderStyles.right != 0) {
            String rightText = cssProperties.getBorderRightWidth();
            insets = HtmlValues.updateRightInset(insets, rightText, renderState);
        }
        return insets;
    }

    public static void populateBorderInsets(BorderInfo binfo, CSS2Properties cssProperties, RenderState renderState) {
        HtmlInsets insets = null;
        if (binfo.topStyle != 0) {
            String topText = cssProperties.getBorderTopWidth();
            insets = HtmlValues.updateTopInset(insets, topText, renderState);
        }
        if (binfo.leftStyle != 0) {
            String leftText = cssProperties.getBorderLeftWidth();
            insets = HtmlValues.updateLeftInset(insets, leftText, renderState);
        }
        if (binfo.bottomStyle != 0) {
            String bottomText = cssProperties.getBorderBottomWidth();
            insets = HtmlValues.updateBottomInset(insets, bottomText, renderState);
        }
        if (binfo.rightStyle != 0) {
            String rightText = cssProperties.getBorderRightWidth();
            insets = HtmlValues.updateRightInset(insets, rightText, renderState);
        }
        binfo.insets = insets;
    }

    private static int getBorderWidth(String sizeText, int borderStyle, RenderState renderState) {
        if (borderStyle == 0) {
            return 0;
        }
        if (sizeText == null || sizeText.length() == 0) {
            return 2;
        }
        return HtmlValues.getPixelSize(sizeText, renderState, 2);
    }

    private static HtmlInsets updateTopInset(HtmlInsets insets, String sizeText, RenderState renderState) {
        if (sizeText == null) {
            return insets;
        }
        if ((sizeText = sizeText.trim()).length() == 0) {
            return insets;
        }
        if (insets == null) {
            insets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(sizeText)) {
            insets.topType = 2;
        } else if (sizeText.endsWith("%")) {
            insets.topType = 3;
            try {
                insets.top = Integer.parseInt(sizeText.substring(0, sizeText.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                insets.top = 0;
            }
        } else {
            insets.topType = 1;
            insets.top = HtmlValues.getPixelSize(sizeText, renderState, 0);
        }
        return insets;
    }

    private static HtmlInsets updateLeftInset(HtmlInsets insets, String sizeText, RenderState renderState) {
        if (sizeText == null) {
            return insets;
        }
        if ((sizeText = sizeText.trim()).length() == 0) {
            return insets;
        }
        if (insets == null) {
            insets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(sizeText)) {
            insets.leftType = 2;
        } else if (sizeText.endsWith("%")) {
            insets.leftType = 3;
            try {
                insets.left = Integer.parseInt(sizeText.substring(0, sizeText.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                insets.left = 0;
            }
        } else {
            insets.leftType = 1;
            insets.left = HtmlValues.getPixelSize(sizeText, renderState, 0);
        }
        return insets;
    }

    private static HtmlInsets updateBottomInset(HtmlInsets insets, String sizeText, RenderState renderState) {
        if (sizeText == null) {
            return insets;
        }
        if ((sizeText = sizeText.trim()).length() == 0) {
            return insets;
        }
        if (insets == null) {
            insets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(sizeText)) {
            insets.bottomType = 2;
        } else if (sizeText.endsWith("%")) {
            insets.bottomType = 3;
            try {
                insets.bottom = Integer.parseInt(sizeText.substring(0, sizeText.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                insets.bottom = 0;
            }
        } else {
            insets.bottomType = 1;
            insets.bottom = HtmlValues.getPixelSize(sizeText, renderState, 0);
        }
        return insets;
    }

    private static HtmlInsets updateRightInset(HtmlInsets insets, String sizeText, RenderState renderState) {
        if (sizeText == null) {
            return insets;
        }
        if ((sizeText = sizeText.trim()).length() == 0) {
            return insets;
        }
        if (insets == null) {
            insets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(sizeText)) {
            insets.rightType = 2;
        } else if (sizeText.endsWith("%")) {
            insets.rightType = 3;
            try {
                insets.right = Integer.parseInt(sizeText.substring(0, sizeText.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                insets.right = 0;
            }
        } else {
            insets.rightType = 1;
            insets.right = HtmlValues.getPixelSize(sizeText, renderState, 0);
        }
        return insets;
    }

    public static Insets getInsets(String insetsSpec, RenderState renderState, boolean negativeOK) {
        int[] insetsArray = new int[4];
        int size = 0;
        StringTokenizer tok = new StringTokenizer(insetsSpec);
        if (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            insetsArray[0] = HtmlValues.getPixelSize(token, renderState, 0);
            if (negativeOK || insetsArray[0] >= 0) {
                size = 1;
                if (tok.hasMoreTokens()) {
                    token = tok.nextToken();
                    insetsArray[1] = HtmlValues.getPixelSize(token, renderState, 0);
                    if (negativeOK || insetsArray[1] >= 0) {
                        size = 2;
                        if (tok.hasMoreTokens()) {
                            token = tok.nextToken();
                            insetsArray[2] = HtmlValues.getPixelSize(token, renderState, 0);
                            if (negativeOK || insetsArray[2] >= 0) {
                                size = 3;
                                if (tok.hasMoreTokens()) {
                                    token = tok.nextToken();
                                    insetsArray[3] = HtmlValues.getPixelSize(token, renderState, 0);
                                    size = 4;
                                    if (!negativeOK && insetsArray[3] < 0) {
                                        insetsArray[3] = 0;
                                    }
                                }
                            } else {
                                size = 4;
                                insetsArray[2] = 0;
                            }
                        }
                    } else {
                        size = 4;
                        insetsArray[1] = 0;
                    }
                }
            } else {
                size = 1;
                insetsArray[0] = 0;
            }
        }
        if (size == 4) {
            return new Insets(insetsArray[0], insetsArray[3], insetsArray[2], insetsArray[1]);
        }
        if (size == 1) {
            int val = insetsArray[0];
            return new Insets(val, val, val, val);
        }
        if (size == 2) {
            return new Insets(insetsArray[0], insetsArray[1], insetsArray[0], insetsArray[1]);
        }
        if (size == 3) {
            return new Insets(insetsArray[0], insetsArray[1], insetsArray[2], insetsArray[1]);
        }
        return null;
    }

    public static final int getFontNumberOldStyle(String oldHtmlSpec, RenderState renderState) {
        int tentative;
        oldHtmlSpec = oldHtmlSpec.trim();
        try {
            tentative = oldHtmlSpec.startsWith("+") ? renderState.getFontBase() + Integer.parseInt(oldHtmlSpec.substring(1)) : (oldHtmlSpec.startsWith("-") ? renderState.getFontBase() + Integer.parseInt(oldHtmlSpec) : Integer.parseInt(oldHtmlSpec));
            if (tentative < 1) {
                tentative = 1;
            } else if (tentative > 7) {
                tentative = 7;
            }
        }
        catch (NumberFormatException numberFormatException) {
            tentative = 3;
        }
        return tentative;
    }

    public static final float getFontSize(int fontNumber) {
        switch (fontNumber) {
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 11.0f;
            }
            case 3: {
                return 13.0f;
            }
            case 4: {
                return 16.0f;
            }
            case 5: {
                return 21.0f;
            }
            case 6: {
                return 29.0f;
            }
            case 7: {
                return 42.0f;
            }
        }
        return 63.0f;
    }

    public static final String getFontSizeSpec(int fontNumber) {
        switch (fontNumber) {
            case 1: {
                return "10px";
            }
            case 2: {
                return "11px";
            }
            case 3: {
                return "13px";
            }
            case 4: {
                return "16px";
            }
            case 5: {
                return "21px";
            }
            case 6: {
                return "29px";
            }
            case 7: {
                return "42px";
            }
        }
        return "63px";
    }

    public static final float getFontSize(String spec, RenderState parentRenderState) {
        String specTL = spec.toLowerCase();
        if (specTL.endsWith("em")) {
            double value;
            if (parentRenderState == null) {
                return 14.0f;
            }
            Font font = parentRenderState.getFont();
            String pxText = specTL.substring(0, specTL.length() - 2);
            try {
                value = Double.parseDouble(pxText);
            }
            catch (NumberFormatException numberFormatException) {
                return 14.0f;
            }
            return (int)Math.round((double)font.getSize() * value);
        }
        if (specTL.endsWith("px") || specTL.endsWith("pt") || specTL.endsWith("cm") || specTL.endsWith("pc") || specTL.endsWith("cm") || specTL.endsWith("mm") || specTL.endsWith("ex")) {
            int pixelSize = HtmlValues.getPixelSize(spec, parentRenderState, 14);
            int dpi = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            return pixelSize * 96 / dpi;
        }
        if (specTL.endsWith("%")) {
            String value = specTL.substring(0, specTL.length() - 1);
            try {
                double valued = Double.parseDouble(value);
                double parentFontSize = parentRenderState == null ? 14.0 : (double)parentRenderState.getFont().getSize();
                return (float)(parentFontSize * valued / 100.0);
            }
            catch (NumberFormatException numberFormatException) {
                return 14.0f;
            }
        }
        if ("small".equals(specTL)) {
            return 12.0f;
        }
        if ("medium".equals(specTL)) {
            return 14.0f;
        }
        if ("large".equals(specTL)) {
            return 20.0f;
        }
        if ("x-small".equals(specTL)) {
            return 11.0f;
        }
        if ("xx-small".equals(specTL)) {
            return 10.0f;
        }
        if ("x-large".equals(specTL)) {
            return 26.0f;
        }
        if ("xx-large".equals(specTL)) {
            return 40.0f;
        }
        if ("larger".equals(specTL)) {
            int parentFontSize = parentRenderState == null ? 14 : parentRenderState.getFont().getSize();
            return (float)parentFontSize * 1.2f;
        }
        if ("smaller".equals(specTL)) {
            int parentFontSize = parentRenderState == null ? 14 : parentRenderState.getFont().getSize();
            return (float)parentFontSize / 1.2f;
        }
        return HtmlValues.getPixelSize(spec, parentRenderState, 14);
    }

    public static final int getPixelSize(String spec, RenderState renderState, int errorValue, int availSize) {
        if (spec.endsWith("%")) {
            String perText = spec.substring(0, spec.length() - 1);
            try {
                double val = Double.parseDouble(perText);
                return (int)Math.round((double)availSize * val / 100.0);
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
        }
        return HtmlValues.getPixelSize(spec, renderState, errorValue);
    }

    public static final int getPixelSize(String spec, RenderState renderState, int errorValue) {
        String lcSpec = spec.toLowerCase();
        if (lcSpec.endsWith("px")) {
            String pxText = lcSpec.substring(0, lcSpec.length() - 2);
            try {
                return (int)Math.round(Double.parseDouble(pxText));
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
        }
        if (lcSpec.endsWith("em") && renderState != null) {
            double val;
            Font f = renderState.getFont();
            String valText = lcSpec.substring(0, lcSpec.length() - 2);
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
            int fontSize = f.getSize();
            int dpi = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double pixelSize = fontSize * dpi / 96;
            return (int)Math.round(pixelSize * val);
        }
        if (lcSpec.endsWith("pt")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - 2);
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
            int dpi = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 72.0;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("pc")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - 2);
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
            int dpi = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 6.0;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("cm")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - 2);
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
            int dpi = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 2.54;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("mm")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - 2);
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
            int dpi = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 25.4;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("ex") && renderState != null) {
            double val;
            double xHeight = (double)renderState.getFontMetrics().getAscent() * 0.47;
            String valText = lcSpec.substring(0, lcSpec.length() - 2);
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException numberFormatException) {
                return errorValue;
            }
            return (int)Math.round(xHeight * val);
        }
        String pxText = lcSpec;
        try {
            return (int)Math.round(Double.parseDouble(pxText));
        }
        catch (NumberFormatException numberFormatException) {
            return errorValue;
        }
    }

    public static int getOldSyntaxPixelSize(String spec, int availSize, int errorValue) {
        if (spec == null) {
            return errorValue;
        }
        spec = spec.trim();
        try {
            if (spec.endsWith("%")) {
                return availSize * Integer.parseInt(spec.substring(0, spec.length() - 1)) / 100;
            }
            return Integer.parseInt(spec);
        }
        catch (NumberFormatException numberFormatException) {
            return errorValue;
        }
    }

    public static int getOldSyntaxPixelSizeSimple(String spec, int errorValue) {
        if (spec == null) {
            return errorValue;
        }
        spec = spec.trim();
        try {
            return Integer.parseInt(spec);
        }
        catch (NumberFormatException numberFormatException) {
            return errorValue;
        }
    }

    public static URL getURIFromStyleValue(String fullURLStyleValue) {
        String start = "url(";
        if (!fullURLStyleValue.toLowerCase().startsWith(start)) {
            return null;
        }
        int startIdx = start.length();
        int closingIdx = fullURLStyleValue.lastIndexOf(41);
        if (closingIdx == -1) {
            return null;
        }
        String quotedUri = fullURLStyleValue.substring(startIdx, closingIdx);
        String tentativeUri = HtmlValues.unquoteAndUnescape(quotedUri);
        try {
            return Urls.createURL(null, tentativeUri);
        }
        catch (MalformedURLException mfu) {
            logger.log(Level.WARNING, "Unable to create URL for URI=[" + tentativeUri + "].", mfu);
            return null;
        }
    }

    public static String unquoteAndUnescape(String text) {
        char ch;
        StringBuffer result = new StringBuffer();
        int index = 0;
        int length = text.length();
        boolean escape = false;
        boolean single = false;
        if (index < length) {
            ch = text.charAt(index);
            switch (ch) {
                case '\'': {
                    single = true;
                    break;
                }
                case '\"': {
                    break;
                }
                case '\\': {
                    escape = true;
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++index;
        }
        block10: while (index < length) {
            ch = text.charAt(index);
            switch (ch) {
                case '\'': {
                    if (!escape && single) break block10;
                    escape = false;
                    result.append(ch);
                    break;
                }
                case '\"': {
                    if (!escape && !single) break block10;
                    escape = false;
                    result.append(ch);
                    break;
                }
                case '\\': {
                    if (escape) {
                        escape = false;
                        result.append(ch);
                        break;
                    }
                    escape = true;
                    break;
                }
                default: {
                    if (escape) {
                        escape = false;
                        result.append('\\');
                    }
                    result.append(ch);
                }
            }
            ++index;
        }
        return result.toString();
    }

    public static String quoteAndEscape(String text) {
        StringBuffer result = new StringBuffer();
        result.append("'");
        int index = 0;
        int length = text.length();
        while (index < length) {
            char ch = text.charAt(index);
            switch (ch) {
                case '\'': {
                    result.append("\\'");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++index;
        }
        result.append("'");
        return result.toString();
    }

    public static String getColorFromBackground(String background) {
        String[] backgroundParts = HtmlValues.splitCssValue(background);
        int i = 0;
        while (i < backgroundParts.length) {
            String token = backgroundParts[i];
            if (ColorFactory.getInstance().isColor(token)) {
                return token;
            }
            ++i;
        }
        return null;
    }

    public static boolean isLength(String token) {
        if (token.endsWith("px") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("ex") || token.endsWith("em")) {
            return true;
        }
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String[] splitCssValue(String cssValue) {
        ArrayList<String> tokens = new ArrayList<String>(4);
        int len = cssValue.length();
        int parenCount = 0;
        StringBuffer currentWord = null;
        int i = 0;
        while (i < len) {
            char ch = cssValue.charAt(i);
            switch (ch) {
                case '(': {
                    ++parenCount;
                    if (currentWord == null) {
                        currentWord = new StringBuffer();
                    }
                    currentWord.append(ch);
                    break;
                }
                case ')': {
                    --parenCount;
                    if (currentWord == null) {
                        currentWord = new StringBuffer();
                    }
                    currentWord.append(ch);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (parenCount == 0) {
                        tokens.add(currentWord.toString());
                        currentWord = null;
                        break;
                    }
                }
                default: {
                    if (currentWord == null) {
                        currentWord = new StringBuffer();
                    }
                    currentWord.append(ch);
                }
            }
            ++i;
        }
        if (currentWord != null) {
            tokens.add(currentWord.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static boolean isUrl(String token) {
        return token.toLowerCase().startsWith("url(");
    }

    public static int getListStyleType(String token) {
        String tokenTL = token.toLowerCase();
        if ("none".equals(tokenTL)) {
            return 0;
        }
        if ("disc".equals(tokenTL)) {
            return 1;
        }
        if ("circle".equals(tokenTL)) {
            return 2;
        }
        if ("square".equals(tokenTL)) {
            return 3;
        }
        if ("decimal".equals(tokenTL)) {
            return 4;
        }
        if ("lower-alpha".equals(tokenTL) || "lower-latin".equals(tokenTL)) {
            return 5;
        }
        if ("upper-alpha".equals(tokenTL) || "upper-latin".equals(tokenTL)) {
            return 6;
        }
        return 256;
    }

    public static int getListStyleTypeDeprecated(String token) {
        String tokenTL = token.toLowerCase();
        if ("disc".equals(tokenTL)) {
            return 1;
        }
        if ("circle".equals(tokenTL)) {
            return 2;
        }
        if ("square".equals(tokenTL)) {
            return 3;
        }
        if ("1".equals(tokenTL)) {
            return 4;
        }
        if ("a".equals(tokenTL)) {
            return 5;
        }
        if ("A".equals(tokenTL)) {
            return 6;
        }
        return 256;
    }

    public static int getListStylePosition(String token) {
        String tokenTL = token.toLowerCase();
        if ("inside".equals(tokenTL)) {
            return 0;
        }
        if ("outside".equals(tokenTL)) {
            return 0;
        }
        return 0;
    }

    public static ListStyle getListStyle(String listStyleText) {
        ListStyle listStyle = new ListStyle();
        String[] tokens = HtmlValues.splitCssValue(listStyleText);
        int i = 0;
        while (i < tokens.length) {
            int listStylePosition;
            String token = tokens[i];
            int listStyleType = HtmlValues.getListStyleType(token);
            if (listStyleType != 256) {
                listStyle.type = listStyleType;
            } else if (!HtmlValues.isUrl(token) && (listStylePosition = HtmlValues.getListStylePosition(token)) != 0) {
                listStyle.position = listStylePosition;
            }
            ++i;
        }
        return listStyle;
    }

    public static boolean isFontStyle(String token) {
        return "italic".equals(token) || "normal".equals(token) || "oblique".equals(token);
    }

    public static boolean isFontVariant(String token) {
        return "small-caps".equals(token) || "normal".equals(token);
    }

    public static boolean isFontWeight(String token) {
        if ("bold".equals(token) || "bolder".equals(token) || "lighter".equals(token)) {
            return true;
        }
        try {
            int value = Integer.parseInt(token);
            return value % 100 == 0 && value >= 100 && value <= 900;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static BorderInfo getBorderInfo(CSS2Properties properties, RenderState renderState) {
        String leftColorSpec;
        String bottomColorSpec;
        String rightColorSpec;
        BorderInfo binfo = new BorderInfo();
        binfo.topStyle = HtmlValues.getBorderStyle(properties.getBorderTopStyle());
        binfo.rightStyle = HtmlValues.getBorderStyle(properties.getBorderRightStyle());
        binfo.bottomStyle = HtmlValues.getBorderStyle(properties.getBorderBottomStyle());
        binfo.leftStyle = HtmlValues.getBorderStyle(properties.getBorderLeftStyle());
        ColorFactory cf = ColorFactory.getInstance();
        String topColorSpec = properties.getBorderTopColor();
        if (topColorSpec != null) {
            binfo.topColor = cf.getColor(topColorSpec);
        }
        if ((rightColorSpec = properties.getBorderRightColor()) != null) {
            binfo.rightColor = cf.getColor(rightColorSpec);
        }
        if ((bottomColorSpec = properties.getBorderBottomColor()) != null) {
            binfo.bottomColor = cf.getColor(bottomColorSpec);
        }
        if ((leftColorSpec = properties.getBorderLeftColor()) != null) {
            binfo.leftColor = cf.getColor(leftColorSpec);
        }
        HtmlValues.populateBorderInsets(binfo, properties, renderState);
        return binfo;
    }

    public static Insets getBorderStyles(CSS2Properties properties) {
        int topStyle = HtmlValues.getBorderStyle(properties.getBorderTopStyle());
        int rightStyle = HtmlValues.getBorderStyle(properties.getBorderRightStyle());
        int bottomStyle = HtmlValues.getBorderStyle(properties.getBorderBottomStyle());
        int leftStyle = HtmlValues.getBorderStyle(properties.getBorderLeftStyle());
        return new Insets(topStyle, leftStyle, bottomStyle, rightStyle);
    }

    private static int getBorderStyle(String styleText) {
        if (styleText == null || styleText.length() == 0) {
            return 0;
        }
        String stl = styleText.toLowerCase();
        if ("solid".equals(stl)) {
            return 4;
        }
        if ("dashed".equals(stl)) {
            return 3;
        }
        if ("dotted".equals(stl)) {
            return 2;
        }
        if ("none".equals(stl)) {
            return 0;
        }
        if ("hidden".equals(stl)) {
            return 1;
        }
        if ("double".equals(stl)) {
            return 5;
        }
        if ("groove".equals(stl)) {
            return 6;
        }
        if ("ridge".equals(stl)) {
            return 7;
        }
        if ("inset".equals(stl)) {
            return 8;
        }
        if ("outset".equals(stl)) {
            return 9;
        }
        return 0;
    }

    public static boolean isBackgroundRepeat(String repeat) {
        String repeatTL = repeat.toLowerCase();
        return repeatTL.indexOf("repeat") != -1;
    }

    public static boolean isBackgroundPosition(String token) {
        return HtmlValues.isLength(token) || token.endsWith("%") || token.equalsIgnoreCase("top") || token.equalsIgnoreCase("center") || token.equalsIgnoreCase("bottom") || token.equalsIgnoreCase("left") || token.equalsIgnoreCase("right");
    }
}

