/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableRowElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RTableCell;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.VirtualCell;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderThreadState;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLTableCellElement;
import org.w3c.dom.html2.HTMLTableRowElement;

class TableMatrix {
    private static final NodeFilter COLUMNS_FILTER = new ColumnsFilter();
    private final ArrayList ROWS = new ArrayList();
    private final ArrayList ALL_CELLS = new ArrayList();
    private final ArrayList ROW_ELEMENTS = new ArrayList();
    private final HTMLElementImpl tableElement;
    private final UserAgentContext parserContext;
    private final HtmlRendererContext rendererContext;
    private final FrameContext frameContext;
    private final RElement relement;
    private final RenderableContainer container;
    private SizeInfo[] columnSizes;
    private SizeInfo[] rowSizes;
    private int tableWidth;
    private int tableHeight;
    private int hasOldStyleBorder;
    private int cellSpacingY;
    private int cellSpacingX;
    private int widthsOfExtras;
    private int heightsOfExtras;
    private HtmlLength tableWidthLength;
    private BoundableRenderable armedRenderable;

    public TableMatrix(HTMLElementImpl element, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer tableAsContainer, RElement relement) {
        this.tableElement = element;
        this.parserContext = pcontext;
        this.rendererContext = rcontext;
        this.frameContext = frameContext;
        this.relement = relement;
        this.container = tableAsContainer;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getNumRows() {
        return this.ROWS.size();
    }

    public int getNumColumns() {
        return this.columnSizes.length;
    }

    public int getTableHeight() {
        return this.tableHeight;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public void reset(Insets insets, int availWidth, int availHeight) {
        this.ROWS.clear();
        this.ALL_CELLS.clear();
        this.ROW_ELEMENTS.clear();
        String borderText = this.tableElement.getAttribute("border");
        int border = 0;
        if (borderText != null) {
            try {
                border = Integer.parseInt(borderText);
                if (border < 0) {
                    border = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String cellSpacingText = this.tableElement.getAttribute("cellspacing");
        int cellSpacing = 1;
        if (cellSpacingText != null) {
            try {
                cellSpacing = Integer.parseInt(cellSpacingText);
                if (cellSpacing < 0) {
                    cellSpacing = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.cellSpacingX = cellSpacing;
        this.cellSpacingY = cellSpacing;
        this.tableWidthLength = TableMatrix.getWidthLength(this.tableElement, availWidth);
        this.populateRows();
        this.adjustForCellSpans();
        this.createSizeArrays();
        SizeInfo[] columnSizes = this.columnSizes;
        int numCols = columnSizes.length;
        int widthsOfExtras = insets.left + insets.right + (numCols + 1) * cellSpacing;
        if (border > 0) {
            widthsOfExtras += numCols * 2;
        }
        this.widthsOfExtras = widthsOfExtras;
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = insets.top + insets.bottom + (numRows + 1) * cellSpacing;
        if (border > 0) {
            heightsOfExtras += numRows * 2;
        }
        this.heightsOfExtras = heightsOfExtras;
        this.hasOldStyleBorder = border > 0 ? 1 : 0;
    }

    public void build(int availWidth, int availHeight, boolean sizeOnly) {
        int hasBorder = this.hasOldStyleBorder;
        this.determineColumnSizes(hasBorder, this.cellSpacingX, this.cellSpacingY, availWidth);
        this.determineRowSizes(hasBorder, this.cellSpacingY, availHeight, sizeOnly);
    }

    private final HTMLTableRowElementImpl getParentRow(HTMLTableCellElementImpl cellNode) {
        Node parentNode = cellNode.getParentNode();
        while (!(parentNode instanceof HTMLTableRowElementImpl)) {
            if (parentNode instanceof HTMLTableElementImpl) {
                return null;
            }
            parentNode = parentNode.getParentNode();
        }
        return (HTMLTableRowElementImpl)parentNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HtmlLength getWidthLength(HTMLElementImpl element, int availWidth) {
        String widthAttr;
        block3: {
            try {
                String widthText;
                AbstractCSS2Properties props = element.getCurrentStyle();
                String string = widthText = props == null ? null : props.getWidth();
                if (widthText != null) return new HtmlLength(HtmlValues.getPixelSize(widthText, element.getRenderState(), 0, availWidth));
                widthAttr = element.getAttribute("width");
                if (widthAttr != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return new HtmlLength(widthAttr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HtmlLength getHeightLength(HTMLElementImpl element, int availHeight) {
        String ha;
        block3: {
            try {
                String heightText;
                AbstractCSS2Properties props = element.getCurrentStyle();
                String string = heightText = props == null ? null : props.getHeight();
                if (heightText != null) return new HtmlLength(HtmlValues.getPixelSize(heightText, element.getRenderState(), 0, availHeight));
                ha = element.getAttribute("height");
                if (ha != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return new HtmlLength(ha);
    }

    private void populateRows() {
        HTMLElementImpl te = this.tableElement;
        ArrayList rows = this.ROWS;
        ArrayList rowElements = this.ROW_ELEMENTS;
        ArrayList allCells = this.ALL_CELLS;
        HashMap rowElementToRowArray = new HashMap(2);
        ArrayList cellList = te.getDescendents(COLUMNS_FILTER, false);
        ArrayList<VirtualCell> currentNullRow = null;
        for (HTMLTableCellElementImpl columnNode : cellList) {
            RTableCell ac;
            ArrayList<VirtualCell> row;
            HTMLTableRowElementImpl rowElement = this.getParentRow(columnNode);
            if (rowElement != null && rowElement.getRenderState().getDisplay() == 0) continue;
            if (rowElement != null) {
                currentNullRow = null;
                row = (ArrayList<VirtualCell>)rowElementToRowArray.get(rowElement);
                if (row == null) {
                    row = new ArrayList<VirtualCell>();
                    rowElementToRowArray.put(rowElement, row);
                    rows.add(row);
                    rowElements.add(rowElement);
                }
            } else if (currentNullRow != null) {
                row = currentNullRow;
            } else {
                currentNullRow = row = new ArrayList<VirtualCell>();
                rows.add(row);
                rowElements.add(null);
            }
            if ((ac = (RTableCell)columnNode.getUINode()) == null) {
                ac = new RTableCell(columnNode, this.parserContext, this.rendererContext, this.frameContext, this.container);
                ac.setParent(this.relement);
                columnNode.setUINode(ac);
            }
            VirtualCell vc = new VirtualCell(ac, true);
            ac.setTopLeftVirtualCell(vc);
            row.add(vc);
            allCells.add(ac);
        }
    }

    private void adjustForCellSpans() {
        VirtualCell vc;
        int c;
        int numCols;
        ArrayList row;
        ArrayList rows = this.ROWS;
        int numRows = rows.size();
        int r = 0;
        while (r < numRows) {
            row = (ArrayList)rows.get(r);
            numCols = row.size();
            c = 0;
            while (c < numCols) {
                vc = (VirtualCell)row.get(c);
                if (vc != null && vc.isTopLeft()) {
                    int targetRows;
                    int rowspan;
                    RTableCell ac = vc.getActualCell();
                    int colspan = ac.getColSpan();
                    if (colspan < 1) {
                        colspan = 1;
                    }
                    if ((rowspan = ac.getRowSpan()) < 1) {
                        rowspan = 1;
                    }
                    if (numRows < (targetRows = r + rowspan)) {
                        rowspan = numRows - r;
                        ac.setRowSpan(rowspan);
                    }
                    numRows = rows.size();
                    int y = 0;
                    while (y < rowspan) {
                        if (colspan > 1 || y > 0) {
                            int xstart;
                            int nr = r + y;
                            ArrayList newRow = (ArrayList)rows.get(nr);
                            int cc = xstart = y == 0 ? 1 : 0;
                            while (cc < colspan) {
                                int nc = c + cc;
                                while (newRow.size() < nc) {
                                    newRow.add(null);
                                }
                                newRow.add(nc, new VirtualCell(ac, false));
                                ++cc;
                            }
                            if (row == newRow) {
                                numCols = row.size();
                            }
                        }
                        ++y;
                    }
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < numRows) {
            row = (ArrayList)rows.get(r);
            numCols = row.size();
            c = 0;
            while (c < numCols) {
                vc = (VirtualCell)row.get(c);
                if (vc != null) {
                    vc.setColumn(c);
                    vc.setRow(r);
                }
                ++c;
            }
            ++r;
        }
    }

    private void createSizeArrays() {
        ArrayList rows = this.ROWS;
        int numRows = rows.size();
        SizeInfo[] rowSizes = new SizeInfo[numRows];
        this.rowSizes = rowSizes;
        int numCols = 0;
        ArrayList rowElements = this.ROW_ELEMENTS;
        int i = 0;
        while (i < numRows) {
            HTMLTableRowElement rowElement;
            SizeInfo rowSizeInfo;
            ArrayList row = (ArrayList)rows.get(i);
            int rs = row.size();
            if (rs > numCols) {
                numCols = rs;
            }
            rowSizes[i] = rowSizeInfo = new SizeInfo();
            try {
                rowElement = (HTMLTableRowElement)rowElements.get(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                rowElement = null;
            }
            String rowHeightText = rowElement == null ? null : rowElement.getAttribute("height");
            HtmlLength rowHeightLength = null;
            if (rowHeightText != null) {
                try {
                    rowHeightLength = new HtmlLength(rowHeightText);
                }
                catch (Exception exception) {}
            }
            if (rowHeightLength != null) {
                rowSizeInfo.htmlLength = rowHeightLength;
            } else {
                HtmlLength bestHeightLength = null;
                int x = 0;
                while (x < rs) {
                    HtmlLength vcHeightLength;
                    VirtualCell vc = (VirtualCell)row.get(x);
                    if (vc != null && (vcHeightLength = vc.getHeightLength()) != null && vcHeightLength.isPreferredOver(bestHeightLength)) {
                        bestHeightLength = vcHeightLength;
                    }
                    ++x;
                }
                rowSizeInfo.htmlLength = bestHeightLength;
            }
            ++i;
        }
        SizeInfo[] columnSizes = new SizeInfo[numCols];
        this.columnSizes = columnSizes;
        int i2 = 0;
        while (i2 < numCols) {
            HtmlLength vcWidthLength;
            RTableCell ac;
            VirtualCell vc;
            ArrayList row;
            HtmlLength bestWidthLength = null;
            int y = 0;
            while (y < numRows) {
                row = (ArrayList)rows.get(y);
                try {
                    vc = (VirtualCell)row.get(i2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    vc = null;
                }
                if (vc != null && (ac = vc.getActualCell()).getColSpan() == 1 && (vcWidthLength = vc.getWidthLength()) != null && vcWidthLength.isPreferredOver(bestWidthLength)) {
                    bestWidthLength = vcWidthLength;
                }
                ++y;
            }
            if (bestWidthLength == null) {
                y = 0;
                while (y < numRows) {
                    row = (ArrayList)rows.get(y);
                    try {
                        vc = (VirtualCell)row.get(i2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        vc = null;
                    }
                    if (vc != null && (ac = vc.getActualCell()).getColSpan() > 1 && (vcWidthLength = vc.getWidthLength()) != null && vcWidthLength.isPreferredOver(bestWidthLength)) {
                        bestWidthLength = vcWidthLength;
                    }
                    ++y;
                }
            }
            SizeInfo colSizeInfo = new SizeInfo();
            colSizeInfo.htmlLength = bestWidthLength;
            columnSizes[i2] = colSizeInfo;
            ++i2;
        }
    }

    private void determineColumnSizes(int hasBorder, int cellSpacingX, int cellSpacingY, int availWidth) {
        boolean widthKnown;
        int tableWidth;
        HtmlLength tableWidthLength = this.tableWidthLength;
        if (tableWidthLength != null) {
            tableWidth = tableWidthLength.getLength(availWidth);
            widthKnown = true;
        } else {
            tableWidth = availWidth;
            widthKnown = false;
        }
        SizeInfo[] columnSizes = this.columnSizes;
        int widthsOfExtras = this.widthsOfExtras;
        int cellAvailWidth = tableWidth - widthsOfExtras;
        if (cellAvailWidth < 0) {
            tableWidth += -cellAvailWidth;
            cellAvailWidth = 0;
        }
        this.determineTentativeSizes(columnSizes, widthsOfExtras, cellAvailWidth, widthKnown);
        this.preLayout(hasBorder, cellSpacingX, cellSpacingY, widthKnown);
        this.adjustForRenderWidths(columnSizes, hasBorder, cellSpacingX, widthKnown);
        this.adjustWidthsForExpectedMax(columnSizes, cellAvailWidth, widthKnown);
    }

    private void determineTentativeSizes(SizeInfo[] columnSizes, int widthsOfExtras, int cellAvailWidth, boolean setNoWidthColumns) {
        int totalWidthUsed;
        int difference;
        int numCols = columnSizes.length;
        int widthUsedByPercent = 0;
        int i = 0;
        while (i < numCols) {
            SizeInfo colSizeInfo = columnSizes[i];
            HtmlLength widthLength = colSizeInfo.htmlLength;
            if (widthLength != null && widthLength.getLengthType() == 2) {
                int actualSizeInt = widthLength.getLength(cellAvailWidth);
                widthUsedByPercent += actualSizeInt;
                colSizeInfo.actualSize = actualSizeInt;
            }
            ++i;
        }
        int widthUsedByAbsolute = 0;
        int numNoWidthColumns = 0;
        int i2 = 0;
        while (i2 < numCols) {
            SizeInfo colSizeInfo = columnSizes[i2];
            HtmlLength widthLength = colSizeInfo.htmlLength;
            if (widthLength != null && widthLength.getLengthType() != 2) {
                int actualSizeInt = widthLength.getRawValue();
                widthUsedByAbsolute += actualSizeInt;
                colSizeInfo.actualSize = actualSizeInt;
            } else if (widthLength == null) {
                ++numNoWidthColumns;
            }
            ++i2;
        }
        if (numNoWidthColumns == 0 && (difference = (totalWidthUsed = widthUsedByPercent + widthUsedByAbsolute) - cellAvailWidth) > 0) {
            int newActualSize;
            int oldActualSize;
            HtmlLength widthLength;
            SizeInfo sizeInfo;
            int i3;
            if (widthUsedByAbsolute > 0) {
                int expectedAbsoluteWidthTotal = widthUsedByAbsolute - difference;
                if (expectedAbsoluteWidthTotal < 0) {
                    expectedAbsoluteWidthTotal = 0;
                }
                double ratio = (double)expectedAbsoluteWidthTotal / (double)widthUsedByAbsolute;
                i3 = 0;
                while (i3 < numCols) {
                    sizeInfo = columnSizes[i3];
                    widthLength = columnSizes[i3].htmlLength;
                    if (widthLength != null && widthLength.getLengthType() != 2) {
                        oldActualSize = sizeInfo.actualSize;
                        sizeInfo.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                        totalWidthUsed += newActualSize - oldActualSize;
                    }
                    ++i3;
                }
                difference = totalWidthUsed - cellAvailWidth;
            }
            if (difference > 0 && widthUsedByPercent > 0) {
                int expectedPercentWidthTotal = widthUsedByPercent - difference;
                if (expectedPercentWidthTotal < 0) {
                    expectedPercentWidthTotal = 0;
                }
                double ratio = (double)expectedPercentWidthTotal / (double)widthUsedByPercent;
                i3 = 0;
                while (i3 < numCols) {
                    sizeInfo = columnSizes[i3];
                    widthLength = columnSizes[i3].htmlLength;
                    if (widthLength != null && widthLength.getLengthType() == 2) {
                        oldActualSize = sizeInfo.actualSize;
                        sizeInfo.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                        totalWidthUsed += newActualSize - oldActualSize;
                    }
                    ++i3;
                }
            }
        }
    }

    private void adjustForRenderWidths(SizeInfo[] columnSizes, int hasBorder, int cellSpacing, boolean tableWidthKnown) {
        int numCols = columnSizes.length;
        int i = 0;
        while (i < numCols) {
            SizeInfo si = columnSizes[i];
            if (si.actualSize < si.layoutSize) {
                si.actualSize = si.layoutSize;
            }
            ++i;
        }
    }

    private void layoutColumn(SizeInfo[] columnSizes, SizeInfo colSize, int col, int cellSpacingX, int hasBorder) {
        SizeInfo[] rowSizes = this.rowSizes;
        ArrayList rows = this.ROWS;
        int numRows = rows.size();
        int actualSize = colSize.actualSize;
        colSize.layoutSize = 0;
        int row = 0;
        while (row < numRows) {
            RTableCell ac;
            ArrayList columns = (ArrayList)rows.get(row);
            VirtualCell vc = null;
            try {
                vc = (VirtualCell)columns.get(col);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                vc = null;
            }
            RTableCell rTableCell = ac = vc == null ? null : vc.getActualCell();
            if (ac != null && ac.getVirtualRow() == row) {
                int colSpan = ac.getColSpan();
                if (colSpan > 1) {
                    int cellExtras;
                    int firstCol = ac.getVirtualColumn();
                    int vcActualWidth = cellExtras = (colSpan - 1) * (cellSpacingX + 2 * hasBorder);
                    int x = 0;
                    while (x < colSpan) {
                        vcActualWidth += columnSizes[firstCol + x].actualSize;
                        ++x;
                    }
                    Dimension size = ac.doCellLayout(vcActualWidth, 0, true, true, true);
                    int vcRenderWidth = size.width;
                    int denominator = vcActualWidth - cellExtras;
                    int newTentativeCellWidth = denominator > 0 ? actualSize * (vcRenderWidth - cellExtras) / denominator : (vcRenderWidth - cellExtras) / colSpan;
                    if (newTentativeCellWidth > colSize.layoutSize) {
                        colSize.layoutSize = newTentativeCellWidth;
                    }
                    int rowSpan = ac.getRowSpan();
                    int vch = (size.height - (rowSpan - 1) * (this.cellSpacingY + 2 * hasBorder)) / rowSpan;
                    int y = 0;
                    while (y < rowSpan) {
                        if (rowSizes[row + y].minSize < vch) {
                            rowSizes[row + y].minSize = vch;
                        }
                        ++y;
                    }
                } else {
                    Dimension size = ac.doCellLayout(actualSize, 0, true, true, true);
                    if (size.width > colSize.layoutSize) {
                        colSize.layoutSize = size.width;
                    }
                    int rowSpan = ac.getRowSpan();
                    int vch = (size.height - (rowSpan - 1) * (this.cellSpacingY + 2 * hasBorder)) / rowSpan;
                    int y = 0;
                    while (y < rowSpan) {
                        if (rowSizes[row + y].minSize < vch) {
                            rowSizes[row + y].minSize = vch;
                        }
                        ++y;
                    }
                }
            }
            ++row;
        }
    }

    private int adjustWidthsForExpectedMax(SizeInfo[] columnSizes, int cellAvailWidth, boolean expand) {
        int hasBorder = this.hasOldStyleBorder;
        int cellSpacingX = this.cellSpacingX;
        int currentTotal = 0;
        int numCols = columnSizes.length;
        int i = 0;
        while (i < numCols) {
            currentTotal += columnSizes[i].actualSize;
            ++i;
        }
        int difference = currentTotal - cellAvailWidth;
        if (difference > 0 || difference < 0 && expand) {
            SizeInfo sizeInfo;
            int i2;
            int noWidthTotal = 0;
            int numNoWidth = 0;
            int i3 = 0;
            while (i3 < numCols) {
                if (columnSizes[i3].htmlLength == null) {
                    ++numNoWidth;
                    noWidthTotal += columnSizes[i3].actualSize;
                }
                ++i3;
            }
            if (noWidthTotal > 0) {
                int expectedNoWidthTotal = noWidthTotal - difference;
                if (expectedNoWidthTotal < 0) {
                    expectedNoWidthTotal = 0;
                }
                double ratio = (double)expectedNoWidthTotal / (double)noWidthTotal;
                int noWidthCount = 0;
                i2 = 0;
                while (i2 < numCols) {
                    sizeInfo = columnSizes[i2];
                    if (sizeInfo.htmlLength == null) {
                        int newActualSize;
                        int oldActualSize = sizeInfo.actualSize;
                        if (++noWidthCount == numNoWidth) {
                            int currentDiff = currentTotal - cellAvailWidth;
                            newActualSize = oldActualSize - currentDiff;
                            if (newActualSize < 0) {
                                newActualSize = 0;
                            }
                        } else {
                            newActualSize = (int)Math.round((double)oldActualSize * ratio);
                        }
                        sizeInfo.actualSize = newActualSize;
                        if (newActualSize < sizeInfo.layoutSize) {
                            this.layoutColumn(columnSizes, sizeInfo, i2, cellSpacingX, hasBorder);
                            if (newActualSize < sizeInfo.layoutSize) {
                                sizeInfo.actualSize = newActualSize = sizeInfo.layoutSize;
                            }
                        }
                        currentTotal += newActualSize - oldActualSize;
                    }
                    ++i2;
                }
                difference = currentTotal - cellAvailWidth;
            }
            if (difference > 0 || difference < 0 && expand) {
                int absoluteWidthTotal = 0;
                int i4 = 0;
                while (i4 < numCols) {
                    HtmlLength widthLength = columnSizes[i4].htmlLength;
                    if (widthLength != null && widthLength.getLengthType() != 2) {
                        absoluteWidthTotal += columnSizes[i4].actualSize;
                    }
                    ++i4;
                }
                if (absoluteWidthTotal > 0) {
                    int expectedAbsoluteWidthTotal = absoluteWidthTotal - difference;
                    if (expectedAbsoluteWidthTotal < 0) {
                        expectedAbsoluteWidthTotal = 0;
                    }
                    double ratio = (double)expectedAbsoluteWidthTotal / (double)absoluteWidthTotal;
                    i2 = 0;
                    while (i2 < numCols) {
                        sizeInfo = columnSizes[i2];
                        HtmlLength widthLength = columnSizes[i2].htmlLength;
                        if (widthLength != null && widthLength.getLengthType() != 2) {
                            int newActualSize;
                            int oldActualSize = sizeInfo.actualSize;
                            sizeInfo.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                            if (newActualSize < sizeInfo.layoutSize) {
                                this.layoutColumn(columnSizes, sizeInfo, i2, cellSpacingX, hasBorder);
                                if (newActualSize < sizeInfo.layoutSize) {
                                    sizeInfo.actualSize = newActualSize = sizeInfo.layoutSize;
                                }
                            }
                            currentTotal += newActualSize - oldActualSize;
                        }
                        ++i2;
                    }
                    difference = currentTotal - cellAvailWidth;
                }
                if (difference > 0 || difference < 0 && expand) {
                    int percentWidthTotal = 0;
                    int i5 = 0;
                    while (i5 < numCols) {
                        HtmlLength widthLength = columnSizes[i5].htmlLength;
                        if (widthLength != null && widthLength.getLengthType() == 2) {
                            percentWidthTotal += columnSizes[i5].actualSize;
                        }
                        ++i5;
                    }
                    if (percentWidthTotal > 0) {
                        int expectedPercentWidthTotal = percentWidthTotal - difference;
                        if (expectedPercentWidthTotal < 0) {
                            expectedPercentWidthTotal = 0;
                        }
                        double ratio = (double)expectedPercentWidthTotal / (double)percentWidthTotal;
                        int i6 = 0;
                        while (i6 < numCols) {
                            SizeInfo sizeInfo2 = columnSizes[i6];
                            HtmlLength widthLength = columnSizes[i6].htmlLength;
                            if (widthLength != null && widthLength.getLengthType() == 2) {
                                int newActualSize;
                                int oldActualSize = sizeInfo2.actualSize;
                                sizeInfo2.actualSize = newActualSize = (int)Math.round((double)oldActualSize * ratio);
                                if (newActualSize < sizeInfo2.layoutSize) {
                                    this.layoutColumn(columnSizes, sizeInfo2, i6, cellSpacingX, hasBorder);
                                    if (newActualSize < sizeInfo2.layoutSize) {
                                        sizeInfo2.actualSize = newActualSize = sizeInfo2.layoutSize;
                                    }
                                }
                                currentTotal += newActualSize - oldActualSize;
                            }
                            ++i6;
                        }
                    }
                }
            }
        }
        return currentTotal;
    }

    private final void preLayout(int hasBorder, int cellSpacingX, int cellSpacingY, boolean tableWidthKnown) {
        SizeInfo[] colSizes = this.columnSizes;
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int i = 0;
        while (i < numRows) {
            rowSizes[i].minSize = 0;
            ++i;
        }
        int numCols = colSizes.length;
        int i2 = 0;
        while (i2 < numCols) {
            colSizes[i2].layoutSize = 0;
            ++i2;
        }
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        int i3 = 0;
        while (i3 < numCells) {
            Dimension size;
            int cellsTotalWidth;
            int cellsUsedWidth;
            RTableCell cell = (RTableCell)allCells.get(i3);
            int col = cell.getVirtualColumn();
            int colSpan = cell.getColSpan();
            boolean widthDeclared = false;
            if (colSpan > 1) {
                cellsUsedWidth = 0;
                int x = 0;
                while (x < colSpan) {
                    SizeInfo colSize = colSizes[col + x];
                    if (colSize.htmlLength != null) {
                        widthDeclared = true;
                    }
                    cellsUsedWidth += colSize.actualSize;
                    ++x;
                }
                cellsTotalWidth = cellsUsedWidth + (colSpan - 1) * (cellSpacingX + 2 * hasBorder);
            } else {
                SizeInfo colSize = colSizes[col];
                if (colSize.htmlLength != null) {
                    widthDeclared = true;
                }
                cellsUsedWidth = cellsTotalWidth = colSize.actualSize;
            }
            RenderThreadState state = RenderThreadState.getState();
            boolean prevOverrideNoWrap = state.overrideNoWrap;
            try {
                if (!prevOverrideNoWrap) {
                    state.overrideNoWrap = !widthDeclared;
                }
                size = cell.doCellLayout(cellsTotalWidth, 0, true, true, true);
            }
            finally {
                state.overrideNoWrap = prevOverrideNoWrap;
            }
            int cellLayoutWidth = size.width;
            if (colSpan > 1) {
                if (cellsUsedWidth > 0) {
                    double ratio = (double)cellLayoutWidth / (double)cellsUsedWidth;
                    int x = 0;
                    while (x < colSpan) {
                        SizeInfo si = colSizes[col + x];
                        int newLayoutSize = (int)Math.round((double)si.actualSize * ratio);
                        if (si.layoutSize < newLayoutSize) {
                            si.layoutSize = newLayoutSize;
                        }
                        ++x;
                    }
                } else {
                    int newLayoutSize = cellLayoutWidth / colSpan;
                    int x = 0;
                    while (x < colSpan) {
                        SizeInfo si = colSizes[col + x];
                        if (si.layoutSize < newLayoutSize) {
                            si.layoutSize = newLayoutSize;
                        }
                        ++x;
                    }
                }
            } else {
                SizeInfo colSizeInfo = colSizes[col];
                if (colSizeInfo.layoutSize < cellLayoutWidth) {
                    colSizeInfo.layoutSize = cellLayoutWidth;
                }
            }
            int actualCellHeight = size.height;
            int row = cell.getVirtualRow();
            int rowSpan = cell.getRowSpan();
            if (rowSpan > 1) {
                int vch = (actualCellHeight - (rowSpan - 1) * (cellSpacingY + 2 * hasBorder)) / rowSpan;
                int y = 0;
                while (y < rowSpan) {
                    if (rowSizes[row + y].minSize < vch) {
                        rowSizes[row + y].minSize = vch;
                    }
                    ++y;
                }
            } else if (rowSizes[row].minSize < actualCellHeight) {
                rowSizes[row].minSize = actualCellHeight;
            }
            ++i3;
        }
    }

    private void determineRowSizes(int hasBorder, int cellSpacing, int availHeight, boolean sizeOnly) {
        HtmlLength tableHeightLength = TableMatrix.getHeightLength(this.tableElement, availHeight);
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = this.heightsOfExtras;
        if (tableHeightLength != null) {
            int tableHeight = tableHeightLength.getLength(availHeight);
            this.determineRowSizesFixedTH(hasBorder, cellSpacing, availHeight, tableHeight, sizeOnly);
        } else {
            int tableHeight = heightsOfExtras;
            int row = 0;
            while (row < numRows) {
                tableHeight += rowSizes[row].minSize;
                ++row;
            }
            this.determineRowSizesFlexibleTH(hasBorder, cellSpacing, availHeight, sizeOnly);
        }
    }

    private void determineRowSizesFixedTH(int hasBorder, int cellSpacing, int availHeight, int tableHeight, boolean sizeOnly) {
        int i;
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = this.heightsOfExtras;
        int cellAvailHeight = tableHeight - heightsOfExtras;
        if (cellAvailHeight < 0) {
            cellAvailHeight = 0;
        }
        int heightUsedbyPercent = 0;
        int otherMinSize = 0;
        int i2 = 0;
        while (i2 < numRows) {
            SizeInfo rowSizeInfo = rowSizes[i2];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null && heightLength.getLengthType() == 2) {
                int actualSizeInt = heightLength.getLength(cellAvailHeight);
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedbyPercent += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
            } else {
                otherMinSize += rowSizeInfo.minSize;
            }
            ++i2;
        }
        if (heightUsedbyPercent + otherMinSize > cellAvailHeight) {
            double ratio = (double)(cellAvailHeight - otherMinSize) / (double)heightUsedbyPercent;
            int i3 = 0;
            while (i3 < numRows) {
                SizeInfo rowSizeInfo = rowSizes[i3];
                HtmlLength heightLength = rowSizeInfo.htmlLength;
                if (heightLength != null && heightLength.getLengthType() == 2) {
                    int actualSize = rowSizeInfo.actualSize;
                    int prevActualSize = actualSize;
                    int newActualSize = (int)Math.round((double)prevActualSize * ratio);
                    if (newActualSize < rowSizeInfo.minSize) {
                        newActualSize = rowSizeInfo.minSize;
                    }
                    heightUsedbyPercent += newActualSize - prevActualSize;
                    rowSizeInfo.actualSize = newActualSize;
                }
                ++i3;
            }
        }
        int heightUsedByAbsolute = 0;
        int noHeightMinSize = 0;
        int numNoHeightColumns = 0;
        int i4 = 0;
        while (i4 < numRows) {
            SizeInfo rowSizeInfo = rowSizes[i4];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null && heightLength.getLengthType() != 2) {
                int actualSizeInt = heightLength.getRawValue();
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedByAbsolute += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
            } else if (heightLength == null) {
                ++numNoHeightColumns;
                noHeightMinSize += rowSizeInfo.minSize;
            }
            ++i4;
        }
        if (heightUsedByAbsolute + heightUsedbyPercent + noHeightMinSize > cellAvailHeight) {
            double ratio = (double)(cellAvailHeight - noHeightMinSize - heightUsedbyPercent) / (double)heightUsedByAbsolute;
            i = 0;
            while (i < numRows) {
                SizeInfo rowSizeInfo = rowSizes[i];
                HtmlLength heightLength = rowSizeInfo.htmlLength;
                if (heightLength != null && heightLength.getLengthType() != 2) {
                    int actualSize = rowSizeInfo.actualSize;
                    int prevActualSize = actualSize;
                    int newActualSize = (int)Math.round((double)prevActualSize * ratio);
                    if (newActualSize < rowSizeInfo.minSize) {
                        newActualSize = rowSizeInfo.minSize;
                    }
                    heightUsedByAbsolute += newActualSize - prevActualSize;
                    rowSizeInfo.actualSize = newActualSize;
                }
                ++i;
            }
        }
        int remainingHeight = cellAvailHeight - heightUsedByAbsolute - heightUsedbyPercent;
        int heightUsedByRemaining = 0;
        i = 0;
        while (i < numRows) {
            SizeInfo rowSizeInfo = rowSizes[i];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength == null) {
                int actualSizeInt = remainingHeight / numNoHeightColumns;
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedByRemaining += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
            }
            ++i;
        }
        int totalUsed = heightUsedByAbsolute + heightUsedbyPercent + heightUsedByRemaining;
        if (totalUsed >= cellAvailHeight) {
            this.tableHeight = totalUsed + heightsOfExtras;
        } else {
            double ratio = (double)cellAvailHeight / (double)totalUsed;
            int i5 = 0;
            while (i5 < numRows) {
                SizeInfo rowSizeInfo = rowSizes[i5];
                int actualSize = rowSizeInfo.actualSize;
                rowSizeInfo.actualSize = (int)Math.round((double)actualSize * ratio);
                ++i5;
            }
            this.tableHeight = tableHeight;
        }
        this.finalRender(hasBorder, cellSpacing, sizeOnly);
    }

    private void determineRowSizesFlexibleTH(int hasBorder, int cellSpacing, int availHeight, boolean sizeOnly) {
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int heightsOfExtras = this.heightsOfExtras;
        int heightUsedByAbsolute = 0;
        int percentSum = 0;
        int i = 0;
        while (i < numRows) {
            SizeInfo rowSizeInfo = rowSizes[i];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null && heightLength.getLengthType() == 1) {
                int actualSizeInt = heightLength.getRawValue();
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedByAbsolute += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
            } else if (heightLength != null && heightLength.getLengthType() == 2) {
                percentSum += heightLength.getRawValue();
            }
            ++i;
        }
        int heightUsedByNoSize = 0;
        int i2 = 0;
        while (i2 < numRows) {
            SizeInfo rowSizeInfo = rowSizes[i2];
            HtmlLength widthLength = rowSizeInfo.htmlLength;
            if (widthLength == null) {
                int actualSizeInt = rowSizeInfo.minSize;
                heightUsedByNoSize += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
            }
            ++i2;
        }
        int expectedTotalCellHeight = (int)Math.round((double)(heightUsedByAbsolute + heightUsedByNoSize) / (1.0 - (double)percentSum / 100.0));
        int heightUsedByPercent = 0;
        int i3 = 0;
        while (i3 < numRows) {
            SizeInfo rowSizeInfo = rowSizes[i3];
            HtmlLength heightLength = rowSizeInfo.htmlLength;
            if (heightLength != null && heightLength.getLengthType() == 2) {
                int actualSizeInt = heightLength.getLength(expectedTotalCellHeight);
                if (actualSizeInt < rowSizeInfo.minSize) {
                    actualSizeInt = rowSizeInfo.minSize;
                }
                heightUsedByPercent += actualSizeInt;
                rowSizeInfo.actualSize = actualSizeInt;
            }
            ++i3;
        }
        this.tableHeight = heightUsedByAbsolute + heightUsedByNoSize + heightUsedByPercent + heightsOfExtras;
        this.finalRender(hasBorder, cellSpacing, sizeOnly);
    }

    private final void finalRender(int hasBorder, int cellSpacing, boolean sizeOnly) {
        ArrayList allCells = this.ALL_CELLS;
        SizeInfo[] colSizes = this.columnSizes;
        SizeInfo[] rowSizes = this.rowSizes;
        int numCells = allCells.size();
        int i = 0;
        while (i < numCells) {
            int totalCellHeight;
            int totalCellWidth;
            RTableCell cell = (RTableCell)allCells.get(i);
            int col = cell.getVirtualColumn();
            int colSpan = cell.getColSpan();
            if (colSpan > 1) {
                totalCellWidth = (colSpan - 1) * (cellSpacing + 2 * hasBorder);
                int x = 0;
                while (x < colSpan) {
                    totalCellWidth += colSizes[col + x].actualSize;
                    ++x;
                }
            } else {
                totalCellWidth = colSizes[col].actualSize;
            }
            int row = cell.getVirtualRow();
            int rowSpan = cell.getRowSpan();
            if (rowSpan > 1) {
                totalCellHeight = (rowSpan - 1) * (cellSpacing + 2 * hasBorder);
                int y = 0;
                while (y < rowSpan) {
                    totalCellHeight += rowSizes[row + y].actualSize;
                    ++y;
                }
            } else {
                totalCellHeight = rowSizes[row].actualSize;
            }
            Dimension size = cell.doCellLayout(totalCellWidth, totalCellHeight, true, true, sizeOnly);
            if (size.width > totalCellWidth) {
                colSizes[col].actualSize = colSpan == 1 ? size.width : (colSizes[col].actualSize += size.width - totalCellWidth);
            }
            if (size.height > totalCellHeight) {
                rowSizes[row].actualSize = rowSpan == 1 ? size.height : (rowSizes[row].actualSize += size.height - totalCellHeight);
            }
            ++i;
        }
    }

    public final void doLayout(Insets insets) {
        SizeInfo[] rowSizes = this.rowSizes;
        int numRows = rowSizes.length;
        int yoffset = insets.top;
        int cellSpacingY = this.cellSpacingY;
        int hasBorder = this.hasOldStyleBorder;
        int i = 0;
        while (i < numRows) {
            yoffset += cellSpacingY;
            SizeInfo rowSizeInfo = rowSizes[i];
            rowSizeInfo.offset = yoffset += hasBorder;
            yoffset += rowSizeInfo.actualSize;
            yoffset += hasBorder;
            ++i;
        }
        this.tableHeight = yoffset + cellSpacingY + insets.bottom;
        SizeInfo[] colSizes = this.columnSizes;
        int numColumns = colSizes.length;
        int xoffset = insets.left;
        int cellSpacingX = this.cellSpacingX;
        int i2 = 0;
        while (i2 < numColumns) {
            xoffset += cellSpacingX;
            SizeInfo colSizeInfo = colSizes[i2];
            colSizeInfo.offset = xoffset += hasBorder;
            xoffset += colSizeInfo.actualSize;
            xoffset += hasBorder;
            ++i2;
        }
        this.tableWidth = xoffset + cellSpacingX + insets.right;
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        int i3 = 0;
        while (i3 < numCells) {
            RTableCell cell = (RTableCell)allCells.get(i3);
            cell.setCellBounds(colSizes, rowSizes, hasBorder, cellSpacingX, cellSpacingY);
            ++i3;
        }
    }

    public final void paint(Graphics g, Dimension size) {
        RTableCell cell;
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        int i = 0;
        while (i < numCells) {
            cell = (RTableCell)allCells.get(i);
            Graphics newG = g.create(cell.x, cell.y, cell.width, cell.height);
            try {
                cell.paint(newG);
            }
            finally {
                newG.dispose();
            }
            ++i;
        }
        if (this.hasOldStyleBorder > 0) {
            g.setColor(Color.GRAY);
            i = 0;
            while (i < numCells) {
                cell = (RTableCell)allCells.get(i);
                int cx = cell.getX() - 1;
                int cy = cell.getY() - 1;
                int cwidth = cell.getWidth() + 1;
                int cheight = cell.getHeight() + 1;
                g.drawRect(cx, cy, cwidth, cheight);
                ++i;
            }
        }
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        int i = 0;
        while (i < numCells) {
            RenderableSpot rp;
            RTableCell cell = (RTableCell)allCells.get(i);
            Rectangle bounds = cell.getBounds();
            if (bounds.contains(x, y) && (rp = cell.getLowestRenderableSpot(x - bounds.x, y - bounds.y)) != null) {
                return rp;
            }
            ++i;
        }
        return null;
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        int i = 0;
        while (i < numCells) {
            RTableCell cell = (RTableCell)allCells.get(i);
            Rectangle bounds = cell.getBounds();
            if (bounds.contains(x, y)) {
                if (cell.onMouseClick(event, x - bounds.x, y - bounds.y)) break;
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        int i = 0;
        while (i < numCells) {
            RTableCell cell = (RTableCell)allCells.get(i);
            Rectangle bounds = cell.getBounds();
            if (bounds.contains(x, y)) {
                if (cell.onDoubleClick(event, x - bounds.x, y - bounds.y)) break;
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable ar = this.armedRenderable;
        if (ar != null) {
            this.armedRenderable = null;
            return ar.onMouseDisarmed(event);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        int i = 0;
        while (i < numCells) {
            RTableCell cell = (RTableCell)allCells.get(i);
            Rectangle bounds = cell.getBounds();
            if (bounds.contains(x, y)) {
                if (cell.onMousePressed(event, x - bounds.x, y - bounds.y)) break;
                this.armedRenderable = cell;
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        BoundableRenderable oldArmedRenderable;
        ArrayList allCells = this.ALL_CELLS;
        int numCells = allCells.size();
        boolean found = false;
        int i = 0;
        while (i < numCells) {
            RTableCell cell = (RTableCell)allCells.get(i);
            Rectangle bounds = cell.getBounds();
            if (bounds.contains(x, y)) {
                found = true;
                BoundableRenderable oldArmedRenderable2 = this.armedRenderable;
                if (oldArmedRenderable2 != null && cell != oldArmedRenderable2) {
                    oldArmedRenderable2.onMouseDisarmed(event);
                    this.armedRenderable = null;
                }
                if (cell.onMouseReleased(event, x - bounds.x, y - bounds.y)) break;
                return false;
            }
            ++i;
        }
        if (!found && (oldArmedRenderable = this.armedRenderable) != null) {
            oldArmedRenderable.onMouseDisarmed(event);
            this.armedRenderable = null;
        }
        return true;
    }

    public Iterator getRenderables() {
        return this.ALL_CELLS.iterator();
    }

    private static class ColumnsFilter
    implements NodeFilter {
        private ColumnsFilter() {
        }

        @Override
        public final boolean accept(Node node) {
            return node instanceof HTMLTableCellElement;
        }
    }

    private static class RowsFilter
    implements NodeFilter {
        private RowsFilter() {
        }

        @Override
        public final boolean accept(Node node) {
            return node instanceof HTMLTableRowElement;
        }
    }

    public static class SizeInfo {
        public HtmlLength htmlLength;
        public int actualSize;
        public int layoutSize;
        public int minSize;
        public int offset;
    }
}

