/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Objects;

class RUIControl
extends BaseElementRenderable
implements RElement {
    private static final int MAX_CACHE_SIZE = 10;
    public final UIControl widget;
    protected final ModelNode modelNode;
    private final FrameContext frameContext;
    private int declaredWidth = -1;
    private int declaredHeight = -1;
    private LayoutKey lastLayoutKey = null;
    private LayoutValue lastLayoutValue = null;
    private final Map cachedLayout = new HashMap(5);

    public RUIControl(ModelNode me, UIControl widget, RenderableContainer container, FrameContext frameContext, UserAgentContext ucontext) {
        super(container, me, ucontext);
        this.modelNode = me;
        this.widget = widget;
        this.frameContext = frameContext;
        widget.setRUIControl(this);
    }

    @Override
    public void focus() {
        super.focus();
        Component c = this.widget.getComponent();
        c.requestFocus();
    }

    @Override
    public final void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.widget.invalidate();
        this.cachedLayout.clear();
        this.lastLayoutKey = null;
        this.lastLayoutValue = null;
    }

    @Override
    public int getVAlign() {
        return this.widget.getVAlign();
    }

    public boolean hasBackground() {
        return this.backgroundColor != null || this.backgroundImage != null || this.lastBackgroundImageUri != null;
    }

    @Override
    public final void paint(Graphics g) {
        RenderState rs = this.modelNode.getRenderState();
        if (rs != null && rs.getVisibility() != 0) {
            return;
        }
        this.prePaint(g);
        Insets insets = this.getInsets(false, false);
        g.translate(insets.left, insets.top);
        try {
            this.widget.paint(g);
        }
        finally {
            g.translate(-insets.left, -insets.top);
        }
    }

    @Override
    public boolean onMouseClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseClick(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onDoubleClick(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMousePressed(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDown(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseUp(me, event, x, y);
        }
        return true;
    }

    @Override
    public boolean onMouseDisarmed(MouseEvent event) {
        ModelNode me = this.modelNode;
        if (me != null) {
            return HtmlController.getInstance().onMouseDisarmed(me, event);
        }
        return true;
    }

    public void invalidateRenderStyle() {
    }

    @Override
    public void repaint(ModelNode modelNode) {
        UIControl widget = this.widget;
        if (widget instanceof UINode) {
            ((UINode)((Object)widget)).repaint(modelNode);
        } else {
            this.repaint();
        }
    }

    @Override
    public void updateWidgetBounds(int guiX, int guiY) {
        super.updateWidgetBounds(guiX, guiY);
        Insets insets = this.getInsets(false, false);
        this.widget.setBounds(guiX + insets.left, guiY + insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
    }

    @Override
    public Color getBlockBackgroundColor() {
        return this.widget.getBackgroundColor();
    }

    @Override
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        if (inSelection = super.paintSelection(g, inSelection, startPoint, endPoint)) {
            Color over = new Color(0, 0, 255, 50);
            Color oldColor = g.getColor();
            try {
                g.setColor(over);
                g.fillRect(0, 0, this.width, this.height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
        return inSelection;
    }

    @Override
    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    @Override
    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        return new RenderableSpot(this, x, y);
    }

    @Override
    public void doLayout(int availWidth, int availHeight, boolean sizeOnly) {
        Map cachedLayout = this.cachedLayout;
        RenderState rs = this.modelNode.getRenderState();
        int whitespace = rs == null ? 0 : rs.getWhiteSpace();
        Font font = rs == null ? null : rs.getFont();
        LayoutKey layoutKey = new LayoutKey(availWidth, availHeight, whitespace, font);
        LayoutValue layoutValue = sizeOnly ? (LayoutValue)cachedLayout.get(layoutKey) : (Objects.equals(this.lastLayoutKey, layoutKey) ? this.lastLayoutValue : null);
        if (layoutValue == null) {
            int finalHeight;
            Insets marginInsets;
            Insets borderInsets;
            this.applyStyle(availWidth, availHeight);
            RenderState renderState = this.modelNode.getRenderState();
            Insets paddingInsets = this.paddingInsets;
            if (paddingInsets == null) {
                paddingInsets = RBlockViewport.ZERO_INSETS;
            }
            if ((borderInsets = this.borderInsets) == null) {
                borderInsets = RBlockViewport.ZERO_INSETS;
            }
            if ((marginInsets = this.marginInsets) == null) {
                marginInsets = RBlockViewport.ZERO_INSETS;
            }
            int actualAvailWidth = availWidth - paddingInsets.left - paddingInsets.right - borderInsets.left - borderInsets.right - marginInsets.left - marginInsets.right;
            int actualAvailHeight = availHeight - paddingInsets.top - paddingInsets.bottom - borderInsets.top - borderInsets.bottom - marginInsets.top - marginInsets.bottom;
            Integer dw = this.getDeclaredWidth(renderState, actualAvailWidth);
            Integer dh = this.getDeclaredHeight(renderState, actualAvailHeight);
            int declaredWidth = dw == null ? -1 : dw;
            int declaredHeight = dh == null ? -1 : dh;
            this.declaredWidth = declaredWidth;
            this.declaredHeight = declaredHeight;
            UIControl widget = this.widget;
            widget.reset(availWidth, availHeight);
            Insets insets = this.getInsets(false, false);
            int finalWidth = declaredWidth == -1 ? -1 : declaredWidth - insets.left - insets.right;
            int n = finalHeight = declaredHeight == -1 ? -1 : declaredHeight - insets.top - insets.bottom;
            if (finalWidth == -1 || finalHeight == -1) {
                Dimension size = widget.getPreferredSize();
                if (finalWidth == -1) {
                    finalWidth = size.width + insets.left + insets.right;
                }
                if (finalHeight == -1) {
                    finalHeight = size.height + insets.top + insets.bottom;
                }
            }
            layoutValue = new LayoutValue(finalWidth, finalHeight);
            if (sizeOnly) {
                if (cachedLayout.size() > 10) {
                    cachedLayout.clear();
                }
                cachedLayout.put(layoutKey, layoutValue);
                this.lastLayoutKey = null;
                this.lastLayoutValue = null;
            } else {
                this.lastLayoutKey = layoutKey;
                this.lastLayoutValue = layoutValue;
            }
        }
        this.width = layoutValue.width;
        this.height = layoutValue.height;
    }

    public final void preferredSizeInvalidated() {
        int dw = this.declaredWidth;
        int dh = this.declaredHeight;
        if (dw == -1 || dh == -1) {
            this.frameContext.delayedRelayout((NodeImpl)this.modelNode);
        } else {
            this.repaint();
        }
    }

    @Override
    public Iterator getRenderables() {
        return null;
    }

    @Override
    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public Color getForegroundColor() {
        RenderState rs = this.modelNode.getRenderState();
        return rs == null ? null : rs.getColor();
    }

    private static class LayoutKey {
        public final int availWidth;
        public final int availHeight;
        public final int whitespace;
        public final Font font;

        public LayoutKey(int availWidth, int availHeight, int whitespace, Font font) {
            this.availWidth = availWidth;
            this.availHeight = availHeight;
            this.whitespace = whitespace;
            this.font = font;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LayoutKey)) {
                return false;
            }
            LayoutKey other = (LayoutKey)obj;
            return other.availWidth == this.availWidth && other.availHeight == this.availHeight && other.whitespace == this.whitespace && Objects.equals(other.font, this.font);
        }

        public int hashCode() {
            Font font = this.font;
            return this.availWidth * 1000 + this.availHeight ^ (font == null ? 0 : font.hashCode());
        }
    }

    private static class LayoutValue {
        public final int width;
        public final int height;

        public LayoutValue(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

