/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.renderer.BaseRListElement;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RList;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.ListStyle;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLElement;

class RListItem
extends BaseRListElement {
    private static final int BULLET_WIDTH = 5;
    private static final int BULLET_HEIGHT = 5;
    private static final int BULLET_RMARGIN = 5;
    private static final int BULLET_SPACE_WIDTH = 36;
    private static final Integer UNSET = new Integer(Integer.MIN_VALUE);
    private Integer value = null;
    private int count;

    public RListItem(NodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer, RCollection parent) {
        super(modelNode, listNesting, pcontext, rcontext, frameContext, parentContainer);
    }

    @Override
    public int getViewportListNesting(int blockNesting) {
        return blockNesting + 1;
    }

    @Override
    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.value = null;
    }

    private Integer getValue() {
        Integer value = this.value;
        if (value == null) {
            String valueText;
            HTMLElement node = (HTMLElement)((Object)this.modelNode);
            String string = valueText = node == null ? null : node.getAttribute("value");
            if (valueText == null) {
                value = UNSET;
            } else {
                try {
                    value = Integer.valueOf(valueText);
                }
                catch (NumberFormatException numberFormatException) {
                    value = UNSET;
                }
            }
            this.value = value;
        }
        return value;
    }

    @Override
    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource, int defaultOverflowX, int defaultOverflowY, boolean sizeOnly) {
        super.doLayout(availWidth, availHeight, expandWidth, expandHeight, floatBoundsSource, defaultOverflowX, defaultOverflowY, sizeOnly);
        RenderState renderState = this.modelNode.getRenderState();
        Integer value = this.getValue();
        if (value == UNSET) {
            this.count = renderState.incrementCount("$cobra.counter", this.listNesting);
        } else {
            int newCount;
            this.count = newCount = value.intValue();
            renderState.resetCount("$cobra.counter", this.listNesting, newCount + 1);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        RenderState rs = this.modelNode.getRenderState();
        Insets marginInsets = this.marginInsets;
        RBlockViewport layout = this.bodyLayout;
        if (layout != null) {
            int bulletType;
            ListStyle listStyle = this.listStyle;
            int n = bulletType = listStyle == null ? 256 : listStyle.type;
            if (bulletType != 0) {
                if (bulletType == 256) {
                    ListStyle parentListStyle;
                    RCollection parent = this.getOriginalOrCurrentParent();
                    if (!(parent instanceof RList)) {
                        parent = parent.getOriginalOrCurrentParent();
                    }
                    bulletType = parent instanceof RList ? ((parentListStyle = ((RList)parent).listStyle) == null ? 1 : parentListStyle.type) : 1;
                }
                Color prevColor = g.getColor();
                g.setColor(rs.getColor());
                try {
                    Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                    Insets paddingInsets = this.paddingInsets;
                    int baselineOffset = layout.getFirstBaselineOffset();
                    int bulletRight = (marginInsets == null ? 0 : marginInsets.left) - 5;
                    int bulletBottom = insets.top + baselineOffset + (paddingInsets == null ? 0 : paddingInsets.top);
                    int bulletTop = bulletBottom - 5;
                    int bulletLeft = bulletRight - 5;
                    int bulletNumber = this.count;
                    String numberText = null;
                    switch (bulletType) {
                        case 4: {
                            numberText = String.valueOf(bulletNumber) + ".";
                            break;
                        }
                        case 5: {
                            numberText = String.valueOf((char)(97 + bulletNumber)) + ".";
                            break;
                        }
                        case 6: {
                            numberText = String.valueOf((char)(65 + bulletNumber)) + ".";
                            break;
                        }
                        case 1: {
                            g.fillOval(bulletLeft, bulletTop, 5, 5);
                            break;
                        }
                        case 2: {
                            g.drawOval(bulletLeft, bulletTop, 5, 5);
                            break;
                        }
                        case 3: {
                            g.fillRect(bulletLeft, bulletTop, 5, 5);
                        }
                    }
                    if (numberText != null) {
                        FontMetrics fm = g.getFontMetrics();
                        int numberLeft = bulletRight - fm.stringWidth(numberText);
                        int numberY = bulletBottom;
                        g.drawString(numberText, numberLeft, numberY);
                    }
                }
                finally {
                    g.setColor(prevColor);
                }
            }
        }
    }
}

