/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.ComputedCSS2Properties;
import org.lobobrowser.html.style.HeadingRenderState;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLHeadingElement;

public class HTMLHeadingElementImpl
extends HTMLAbstractUIElement
implements HTMLHeadingElement {
    public HTMLHeadingElementImpl(String name) {
        super(name);
    }

    @Override
    public String getAlign() {
        return this.getAttribute("align");
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    private final float getHeadingFontSize() {
        String tagName = this.getTagName();
        try {
            int lastCharValue = tagName.charAt(1) - 48;
            switch (lastCharValue) {
                case 1: {
                    return 24.0f;
                }
                case 2: {
                    return 18.0f;
                }
                case 3: {
                    return 15.0f;
                }
                case 4: {
                    return 12.0f;
                }
                case 5: {
                    return 10.0f;
                }
                case 6: {
                    return 8.0f;
                }
            }
        }
        catch (Exception thrown) {
            this.warn("getHeadingFontSize(): Bad heading tag: " + this.getTagName(), thrown);
        }
        return 14.0f;
    }

    private final String getHeadingFontSizeText() {
        String tagName = this.getTagName();
        try {
            int lastCharValue = tagName.charAt(1) - 48;
            switch (lastCharValue) {
                case 1: {
                    return "24pt";
                }
                case 2: {
                    return "18pt";
                }
                case 3: {
                    return "13.55pt";
                }
                case 4: {
                    return "12pt";
                }
                case 5: {
                    return "10pt";
                }
                case 6: {
                    return "7.55pt";
                }
            }
        }
        catch (Exception thrown) {
            this.warn("getHeadingFontSizeText(): Bad heading tag: " + this.getTagName(), thrown);
        }
        return "14px";
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        this.getHeadingFontSize();
        return new HeadingRenderState(prevRenderState, this);
    }

    @Override
    protected void appendInnerTextImpl(StringBuffer buffer) {
        int lineBreaks;
        int length = buffer.length();
        if (length == 0) {
            lineBreaks = 2;
        } else {
            int start = length - 4;
            if (start < 0) {
                start = 0;
            }
            lineBreaks = 0;
            int i = start;
            while (i < length) {
                char ch = buffer.charAt(i);
                if (ch == '\n') {
                    ++lineBreaks;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < 2 - lineBreaks) {
            buffer.append("\r\n");
            ++i;
        }
        super.appendInnerTextImpl(buffer);
        buffer.append("\r\n\r\n");
    }

    @Override
    protected AbstractCSS2Properties createDefaultStyleSheet() {
        ComputedCSS2Properties css = new ComputedCSS2Properties(this);
        css.internalSetLC("font-size", this.getHeadingFontSizeText());
        css.internalSetLC("font-weight", "bolder");
        return css;
    }
}

