/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BaseFontRenderState;
import org.lobobrowser.html.style.ComputedCSS2Properties;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLBaseFontElement;

public class HTMLBaseFontElementImpl
extends HTMLAbstractUIElement
implements HTMLBaseFontElement {
    public HTMLBaseFontElementImpl(String name) {
        super(name);
    }

    @Override
    public String getColor() {
        return this.getAttribute("color");
    }

    @Override
    public String getFace() {
        return this.getAttribute("face");
    }

    @Override
    public void setColor(String color) {
        this.setAttribute("color", color);
    }

    @Override
    public void setFace(String face) {
        this.setAttribute("face", face);
    }

    @Override
    public int getSize() {
        try {
            return Integer.parseInt(this.getAttribute("size"));
        }
        catch (Exception thrown) {
            this.warn("getSize(): Unable to parse size attribute in " + this + ".", thrown);
            return 0;
        }
    }

    @Override
    public void setSize(int size) {
        this.setAttribute("size", String.valueOf(size));
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        String size = this.getAttribute("size");
        if (size != null) {
            int fontNumber = HtmlValues.getFontNumberOldStyle(size, prevRenderState);
            HtmlValues.getFontSize(fontNumber);
            prevRenderState = new BaseFontRenderState(prevRenderState, fontNumber);
        }
        return super.createRenderState(prevRenderState);
    }

    @Override
    protected AbstractCSS2Properties createDefaultStyleSheet() {
        String fontFamily = this.getAttribute("face");
        String color = this.getAttribute("color");
        String size = this.getAttribute("size");
        ModelNode parentModelNode = this.getParentModelNode();
        RenderState parentRS = parentModelNode == null ? null : parentModelNode.getRenderState();
        String fontSize = null;
        if (parentRS != null) {
            int fontNumber = HtmlValues.getFontNumberOldStyle(size, parentRS);
            fontSize = HtmlValues.getFontSizeSpec(fontNumber);
        }
        ComputedCSS2Properties css = new ComputedCSS2Properties(this);
        if (fontSize != null) {
            css.internalSetLC("font-size", fontSize);
        }
        if (fontFamily != null) {
            css.internalSetLC("font-family", fontFamily);
        }
        if (color != null) {
            css.internalSetLC("color", color);
        }
        return css;
    }
}

