/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db.old;

import java.io.DataOutput;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusterBuilder;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.graph.db.CoreInitialization;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.old.OldMissingDependencyException;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.representation.old.OldTransferableGraph1;
import org.simantics.graph.representation.old.OldValue1;

public class OldTransferableGraphImportProcess1 {
    public static String LOG_FILE = "transferableGraphs.log";
    private static final boolean LOG = false;
    static DataOutput log;
    OldTransferableGraph1 tg;
    IImportAdvisor advisor;
    Resource[] resources;
    ClusterBuilder.ResourceHandle[] handles;
    Set<String> missingExternals = new HashSet<String>();
    Resource RootLibrary;
    Resource String;
    Resource Library;
    Resource InstanceOf;
    Resource ConsistsOf;
    Resource PartOf;
    Resource HasName;
    Resource NameOf;

    private static void log(String line) {
    }

    public OldTransferableGraphImportProcess1(OldTransferableGraph1 tg, IImportAdvisor advisor) {
        this.tg = tg;
        this.advisor = advisor;
    }

    public void findBuiltins(WriteOnlyGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
    }

    public void findBuiltins(ReadGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
    }

    void initialPrepare(WriteOnlyGraph graph) throws DatabaseException {
        this.findBuiltins(graph);
        this.resources = new Resource[this.tg.resourceCount];
        int Root2 = -1;
        int SimanticsDomain = -1;
        int Layer02 = -1;
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            if (identity.definition instanceof Internal) {
                Internal def = (Internal)identity.definition;
                Resource res = null;
                if (def.parent == Layer02) {
                    try {
                        res = graph.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + def.name);
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else if (def.parent == SimanticsDomain) {
                    if (def.name.equals("Layer0-1.1")) {
                        Layer02 = identity.resource;
                    }
                } else if (def.parent == Root2 && def.name.equals("www.simantics.org")) {
                    SimanticsDomain = identity.resource;
                }
                if (res == null) {
                    res = this.createChild(graph, this.resources[def.parent], def.name);
                } else {
                    this.createChild(graph, res, this.resources[def.parent], def.name);
                }
                this.resources[identity.resource] = res;
            } else if (identity.definition instanceof Root) {
                Root2 = identity.resource;
                this.resources[identity.resource] = this.RootLibrary;
            }
            ++n2;
        }
    }

    void addMissing(String external) {
        HashSet<String> removals = new HashSet<String>();
        for (String ext : this.missingExternals) {
            if (!ext.startsWith(external)) continue;
            return;
        }
        for (String ext : this.missingExternals) {
            if (!external.startsWith(ext)) continue;
            removals.add(ext);
        }
        this.missingExternals.removeAll(removals);
        this.missingExternals.add(external);
    }

    void prepare(ReadGraph graph) throws DatabaseException {
        this.findBuiltins(graph);
        Resource[] resources = new Resource[this.tg.resourceCount];
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Resource parent;
            External def;
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof External) {
                Resource child;
                def = (External)definition;
                if (def.parent == -1) {
                    resources[identity.resource] = this.RootLibrary;
                } else if ("@inverse".equals(def.name)) {
                    parent = resources[def.parent];
                    resources[identity.resource] = child = graph.getInverse(parent);
                } else {
                    parent = resources[def.parent];
                    if (parent != null) {
                        child = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent), (AsyncProcedure)new TransientCacheAsyncListener())).get(def.name);
                        if (child == null) {
                            this.addMissing(java.lang.String.valueOf(graph.getURI(parent)) + "/" + def.name);
                        }
                        resources[identity.resource] = child;
                    } else {
                        this.addMissing(java.lang.String.valueOf(TransferableGraphUtils.getURI((int)this.tg.resourceCount, (Identity[])this.tg.identities, (int)def.parent)) + "/" + def.name);
                    }
                }
            } else if (!(definition instanceof Internal)) {
                if (definition instanceof Root) {
                    Root root = (Root)definition;
                    if (root.name.equals("")) {
                        resources[identity.resource] = this.RootLibrary;
                    } else {
                        this.advisor.analyzeRoot(graph, root);
                    }
                } else if (definition instanceof Optional) {
                    def = (External)definition;
                    parent = resources[def.parent];
                    if (parent != null) {
                        resources[identity.resource] = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent))).get(def.name);
                    }
                }
            }
            ++n2;
        }
        this.resources = resources;
        if (!this.missingExternals.isEmpty()) {
            throw new OldMissingDependencyException(this);
        }
    }

    Resource createChild(WriteOnlyGraph graph, Resource parent, String name) throws DatabaseException {
        Resource child = graph.newResource();
        graph.claim(parent, this.ConsistsOf, this.PartOf, child);
        Resource nameResource = graph.newResource();
        graph.claim(nameResource, this.InstanceOf, null, this.String);
        graph.claimValue(nameResource, (Object)name, WriteBindings.STRING);
        graph.claim(child, this.HasName, this.NameOf, nameResource);
        return child;
    }

    void createChild(WriteOnlyGraph graph, Resource child, Resource parent, String name) throws DatabaseException {
        graph.claim(parent, this.ConsistsOf, this.PartOf, child);
        Resource nameResource = graph.newResource();
        graph.claim(nameResource, this.InstanceOf, null, this.String);
        graph.claimValue(nameResource, (Object)name, WriteBindings.STRING);
        graph.claim(child, this.HasName, this.NameOf, nameResource);
    }

    int[] getClustering() {
        Variant v = (Variant)this.tg.extensions.get("clustering");
        if (v == null) {
            return null;
        }
        try {
            return (int[])v.getValue((Binding)Bindings.INT_ARRAY);
        }
        catch (AdaptException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    void write(WriteOnlyGraph graph) throws DatabaseException {
        int i;
        Object child;
        Resource[] resources = this.resources;
        ClusterBuilder.ResourceHandle[] handles = this.handles = new ClusterBuilder.ResourceHandle[resources.length];
        int[] clustering = this.getClustering();
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (resources[identity.resource] == null && !(definition instanceof External)) {
                Internal def;
                if (definition instanceof Internal) {
                    def = (Internal)definition;
                    resources[identity.resource] = this.createChild(graph, resources[def.parent], def.name);
                } else if (definition instanceof Root) {
                    Root root = (Root)definition;
                    resources[identity.resource] = this.advisor.createRoot(graph, root);
                } else if (definition instanceof Optional) {
                    def = (Optional)definition;
                    child = this.createChild(graph, resources[def.parent], def.name);
                    graph.claim((Resource)child, this.InstanceOf, null, this.Library);
                    resources[identity.resource] = (Resource)child;
                }
            }
            ++n2;
        }
        ClusterBuilder builder = (ClusterBuilder)graph.getService(ClusterBuilder.class);
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        if (clustering != null) {
            i = 0;
            child = clustering;
            int def = clustering.length;
            int definition = 0;
            while (definition < def) {
                int c = child[definition];
                builder.newCluster();
                int r = 0;
                while (r < c) {
                    handles[i] = resources[i] == null ? builder.newResource() : builder.resource(resources[i]);
                    ++r;
                    ++i;
                }
                ++definition;
            }
            while (i < resources.length) {
                handles[i] = resources[i] == null ? builder.newResource() : builder.resource(resources[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < resources.length) {
                handles[i] = resources[i] == null ? builder.newResource() : builder.resource(resources[i]);
                ++i;
            }
        }
        int[] statements = this.tg.statements;
        int internals = this.tg.resourceCount - this.tg.identities.length;
        int i2 = 0;
        while (i2 < statements.length) {
            int sub = statements[i2];
            int pred = statements[i2 + 1];
            int inv = statements[i2 + 2];
            int obj = statements[i2 + 3];
            ClusterBuilder.ResourceHandle subject = handles[sub];
            ClusterBuilder.ResourceHandle predicate = handles[pred];
            ClusterBuilder.ResourceHandle object = handles[obj];
            if (resources[sub] == null) {
                subject.addStatement(graph, predicate, object);
            } else {
                graph.claim(handles[sub].resource(ss), handles[pred].resource(ss), null, handles[obj].resource(ss));
            }
            if (inv >= 0) {
                if (resources[obj] == null) {
                    ClusterBuilder.ResourceHandle inverse = handles[inv];
                    object.addStatement(graph, inverse, subject);
                } else {
                    graph.claim(handles[obj].resource(ss), handles[inv].resource(ss), null, handles[sub].resource(ss));
                }
            }
            i2 += 4;
        }
        TransferableGraphSupport tgSupport = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
        VirtualGraph vg = graph.getProvider();
        OldValue1[] oldValue1Array = this.tg.values;
        int n3 = this.tg.values.length;
        int n4 = 0;
        while (n4 < n3) {
            OldValue1 value = oldValue1Array[n4];
            int file = value.resource & Integer.MIN_VALUE;
            int resource = value.resource & Integer.MAX_VALUE;
            if (file != 0) {
                graph.claimValue(handles[resource].resource(ss), (Object)value.value, (Binding)Bindings.BYTE_ARRAY);
            } else if (resource < internals) {
                handles[resource].addValue(graph, value.value);
            } else {
                tgSupport.setValue(graph, handles[resource].resource(ss), vg, value.value);
            }
            ++n4;
        }
    }

    void write2(WriteOnlyGraph graph) throws DatabaseException {
        Resource[] resources = this.resources;
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (resources[identity.resource] == null && !(definition instanceof External)) {
                Internal def;
                if (definition instanceof Internal) {
                    def = (Internal)definition;
                    resources[identity.resource] = this.createChild(graph, resources[def.parent], def.name);
                } else if (definition instanceof Root) {
                    Root root = (Root)definition;
                    resources[identity.resource] = this.advisor.createRoot(graph, root);
                } else if (definition instanceof Optional) {
                    def = (Optional)definition;
                    Resource child = this.createChild(graph, resources[def.parent], def.name);
                    graph.claim(child, this.InstanceOf, null, this.Library);
                    resources[identity.resource] = child;
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                resources[i] = graph.newResource();
            }
            ++i;
        }
        int[] statements = this.tg.statements;
        int i2 = 0;
        while (i2 < statements.length) {
            int inv = statements[i2 + 2];
            graph.claim(resources[statements[i2]], resources[statements[i2 + 1]], inv < 0 ? null : resources[inv], resources[statements[i2 + 3]]);
            i2 += 4;
        }
        TransferableGraphSupport tgSupport = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
        VirtualGraph vg = graph.getProvider();
        OldValue1[] oldValue1Array = this.tg.values;
        int n3 = this.tg.values.length;
        int n4 = 0;
        while (n4 < n3) {
            OldValue1 value = oldValue1Array[n4];
            int file = value.resource & Integer.MIN_VALUE;
            int resource = value.resource & Integer.MAX_VALUE;
            if (file != 0) {
                graph.claimValue(resources[resource], (Object)value.value, (Binding)Bindings.BYTE_ARRAY);
            } else {
                tgSupport.setValue(graph, resources[resource], vg, value.value);
            }
            ++n4;
        }
    }

    public long[] getResourceIds(SerialisationSupport serializer) throws DatabaseException {
        int count = this.resources.length;
        long[] resourceIds = new long[count];
        if (this.handles != null) {
            int i = 0;
            while (i < count) {
                resourceIds[i] = serializer.getRandomAccessId(this.handles[i].resource(serializer));
                ++i;
            }
        } else {
            int i = 0;
            while (i < count) {
                resourceIds[i] = serializer.getRandomAccessId(this.resources[i]);
                ++i;
            }
        }
        return resourceIds;
    }
}

