/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.UUID;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.ImportAdvisor;
import org.simantics.graph.db.StreamingTransferableGraphImportProcess;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TGToGraphMap;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphImportProcess;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.WrapperAdvisor;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.graph.representation.Extensions;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.BinaryFunction;

public class TransferableGraphs {
    public static long[] importGraph(Session session, Object tg, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(session, (TransferableGraph1)tg, advisor);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static long[] importGraph(WriteGraph g, Object tg, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(g, (TransferableGraph1)tg, advisor);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static long[] importGraph(Session session, Object tg) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(session, (TransferableGraph1)tg);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static long[] importGraph(WriteGraph g, Object tg) throws DatabaseException, TransferableGraphException {
        if (tg instanceof TransferableGraph1) {
            return TransferableGraphs.importGraph1(g, (TransferableGraph1)tg);
        }
        throw new TransferableGraphException("Cannot import " + tg.getClass().getName());
    }

    public static Collection<Resource> collectExternals(RequestProcessor processor, TransferableGraph1 tg) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, new ImportAdvisor());
        processor.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        HashSet<Resource> result = new HashSet<Resource>();
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof External) {
                result.add(process.resources[id.resource]);
            }
            ++n2;
        }
        return result;
    }

    public static long[] importGraph1(Session session, TransferableGraph1 tg, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                process.write(graph);
            }
        });
        return process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
    }

    public static void importGraph1(Session session, TransferableGraph1 tg, IImportAdvisor advisor, final BinaryFunction<Boolean, WriteOnlyGraph, TransferableGraphImportProcess> callback) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                process.write(graph);
                if (callback != null) {
                    callback.call((Object)graph, (Object)process);
                }
            }
        });
    }

    public static void importGraph1(Session session, TransferableGraphSource tg, IImportAdvisor advisor) throws Exception {
        TransferableGraphs.importGraph1(session, tg, advisor, null);
    }

    public static void importGraph1(Session session, TransferableGraphSource tg, IImportAdvisor advisor, TGStatusMonitor monitor) throws DatabaseException {
        TransferableGraphs.importGraph1(session, null, tg, advisor, monitor);
    }

    public static void importGraph1(Session session, VirtualGraph vg, TransferableGraphSource tg, IImportAdvisor advisor_, TGStatusMonitor monitor) throws DatabaseException {
        final IImportAdvisor2 advisor = advisor_ instanceof IImportAdvisor2 ? (IImportAdvisor2)advisor_ : new WrapperAdvisor(advisor_);
        final StreamingTransferableGraphImportProcess process = new StreamingTransferableGraphImportProcess(session, vg, tg, advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                try {
                    process.prepare(graph);
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(vg){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                try {
                    advisor.beforeWrite(graph, process);
                    process.write(graph);
                    advisor.afterWrite(graph, process);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    public static void importGraph1WithChanges(Session session, final TransferableGraph1 tg, IImportAdvisor advisor, final BinaryFunction<Boolean, WriteGraph, TransferableGraphImportProcess> callback) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                process.write2((WriteOnlyGraph)graph);
                CommentMetadata comments = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                comments.add("Imported transferable graph with " + tg.resourceCount + " resources");
                graph.addMetadata((Metadata)comments);
                if (callback != null) {
                    callback.call((Object)graph, (Object)process);
                }
            }
        });
    }

    public static long[] importGraph1(Session session, TransferableGraph1 tg) throws DatabaseException, TransferableGraphException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, null);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                process.write(graph);
            }
        });
        return process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
    }

    public static long[] importGraph1(WriteGraph graph, TransferableGraph1 tg) throws DatabaseException, TransferableGraphException {
        TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, null);
        process.prepare((ReadGraph)graph);
        process.write2((WriteOnlyGraph)graph);
        return process.getResourceIds((SerialisationSupport)graph.getSession().getService(SerialisationSupport.class));
    }

    public static long[] importGraph1(WriteGraph graph, TransferableGraph1 tg, IImportAdvisor advisor) throws DatabaseException {
        return TransferableGraphs.importGraph1(graph, tg, advisor, null);
    }

    public static long[] importGraph1(WriteGraph graph, TransferableGraph1 tg, IImportAdvisor advisor, TGStatusMonitor monitor) throws DatabaseException {
        TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor, monitor);
        process.prepare((ReadGraph)graph);
        if (advisor instanceof IImportAdvisor2) {
            ((IImportAdvisor2)advisor).beforeWrite((WriteOnlyGraph)graph, process);
        }
        process.write2((WriteOnlyGraph)graph);
        if (advisor instanceof IImportAdvisor2) {
            ((IImportAdvisor2)advisor).afterWrite((WriteOnlyGraph)graph, process);
        }
        return process.getResourceIds((SerialisationSupport)graph.getSession().getService(SerialisationSupport.class));
    }

    public static long[] applyDelta(WriteGraph graph, long[] oldResources, TransferableGraphDelta1 delta) throws DatabaseException {
        SerialisationSupport serializer = (SerialisationSupport)graph.getSession().getService(SerialisationSupport.class);
        TGToGraphMap aMap = new TGToGraphMap(delta.a);
        aMap.addOldResources(serializer, oldResources);
        aMap.deny(graph);
        TGToGraphMap bMap = new TGToGraphMap(delta.b);
        bMap.addMappedOldResources(serializer, delta.aToB, aMap.getResources());
        bMap.prepare((ReadGraph)graph);
        bMap.claim((WriteOnlyGraph)graph);
        return bMap.getResources(serializer);
    }

    public static void uninstallGraph(WriteGraph writeGraph, TransferableGraph1 graph, ImportAdvisor advisor) throws TransferableGraphException {
        throw new UnsupportedOperationException();
    }

    public static long[] importVirtualGraph(Session session, final VirtualGraph vg, TransferableGraph1 tg, IImportAdvisor advisor) throws DatabaseException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                process.prepare(graph);
            }
        });
        session.syncRequest((WriteOnly)new WriteOnlyRequest(vg){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                if (vg != null) {
                    process.write2(graph);
                } else {
                    process.write(graph);
                }
            }
        });
        return process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
    }

    public static long[] importVirtualGraph(WriteGraph graph, TransferableGraph1 tg, IImportAdvisor advisor) throws DatabaseException {
        TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, advisor == null ? new ImportAdvisor() : advisor);
        process.prepare((ReadGraph)graph);
        process.write2((WriteOnlyGraph)graph);
        return process.getResourceIds((SerialisationSupport)graph.getService(SerialisationSupport.class));
    }

    public static TransferableGraph1 readGraph(File file) throws TransferableGraphException {
        FileVariantAccessor va = null;
        try {
            va = Accessors.openAccessor((File)file);
            Datatype type = va.getContentType();
            if (type.equals((Object)Datatypes.getDatatype(TransferableGraph1.class))) {
                TransferableGraph1 transferableGraph1 = (TransferableGraph1)va.getContentValue(Bindings.getBinding(TransferableGraph1.class));
                return transferableGraph1;
            }
            try {
                throw new SerializationException("Unknown transferable graph data type.");
            }
            catch (AccessorException e) {
                throw new TransferableGraphException(e);
            }
            catch (BindingConstructionException e) {
                throw new TransferableGraphException(e);
            }
            catch (SerializationException e) {
                throw new TransferableGraphException(e);
            }
            catch (AccessorConstructionException e) {
                throw new TransferableGraphException(e);
            }
            catch (DatatypeConstructionException e) {
                throw new TransferableGraphException(e);
            }
        }
        finally {
            if (va != null) {
                try {
                    va.close();
                }
                catch (AccessorException accessorException) {}
            }
        }
    }

    public static void importVirtualGraph(Session session, VirtualGraph vg, File file) throws TransferableGraphException {
        try {
            TransferableGraphs.importVirtualGraph(session, vg, TransferableGraphs.readGraph(file), new ImportAdvisor());
        }
        catch (DatabaseException e) {
            throw new TransferableGraphException(e);
        }
    }

    public static VirtualGraph importVirtualGraph(Session session, File file) throws TransferableGraphException {
        VirtualGraphSupport support = (VirtualGraphSupport)session.getService(VirtualGraphSupport.class);
        VirtualGraph vg = support.getMemoryPersistent(UUID.randomUUID().toString());
        TransferableGraphs.importVirtualGraph(session, vg, file);
        return vg;
    }

    public static void writeTransferableGraph(RequestProcessor processor, String format, TransferableGraphSource source, File target) throws Exception {
        TransferableGraphs.writeTransferableGraph(processor, format, 1, source, target);
    }

    public static void writeTransferableGraph(RequestProcessor processor, String format, int version, TransferableGraphSource source, File target) throws Exception {
        TransferableGraphs.writeTransferableGraph(processor, format, version, new TreeMap<String, Variant>(), source, target);
    }

    public static void writeTransferableGraph(RequestProcessor processor, String format, int version, TreeMap<String, Variant> metadata, TransferableGraphSource source, File target) throws Exception {
        Serializer datatypeSerializer = Bindings.getSerializerUnchecked(Datatype.class);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        try {
            DataContainer container = new DataContainer(format, version, metadata, null);
            DataContainers.writeHeader((DataOutput)new DataOutputStream(out), (DataContainer)container);
            datatypeSerializer.serialize((OutputStream)out, (Object)Datatypes.getDatatypeUnchecked(TransferableGraph1.class));
            TransferableGraphs.writeTransferableGraph(processor, source, out);
        }
        finally {
            FileUtils.uncheckedClose((Closeable)out);
        }
    }

    private static void writeTransferableGraph(RequestProcessor processor, final TransferableGraphSource source, final OutputStream out) throws Exception {
        long start = System.nanoTime();
        final Serializer datatypeSerializer = Bindings.getSerializerUnchecked(Datatype.class);
        final Serializer integerSerializer = Bindings.getSerializerUnchecked((Binding)Bindings.INTEGER);
        final Serializer identitySerializer = Bindings.getSerializerUnchecked(Identity.class);
        Serializer extensionSerializer = Bindings.getSerializerUnchecked(Extensions.class);
        try {
            integerSerializer.serialize(out, (Object)source.getResourceCount());
            extensionSerializer.serialize(out, (Object)new Extensions(source.getExtensions()));
            integerSerializer.serialize(out, (Object)source.getIdentityCount());
            processor.sync((ReadInterface)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    try {
                        source.forIdentities(graph, new TransferableGraphSource.TransferableGraphSourceProcedure<Identity>(){

                            @Override
                            public void execute(Identity value) throws Exception {
                                identitySerializer.serialize(out, (Object)value);
                            }
                        });
                        integerSerializer.serialize(out, (Object)source.getStatementCount());
                        source.forStatements(graph, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

                            @Override
                            public void execute(int[] r) throws Exception {
                                int i = 0;
                                while (i < 4) {
                                    integerSerializer.serialize(out, (Object)r[i]);
                                    ++i;
                                }
                            }
                        });
                        integerSerializer.serialize(out, (Object)source.getValueCount());
                        final DataOutputStream dos = new DataOutputStream(out);
                        final TObjectIntHashMap identities = new TObjectIntHashMap();
                        source.forValues2(graph, new TransferableGraphSource.TransferableGraphSourceValueProcedure(){

                            @Override
                            public void execute(int resource, Datatype type, final InputStream stream) throws Exception {
                                integerSerializer.serialize((DataOutput)dos, identities, (Object)resource);
                                identities.clear();
                                datatypeSerializer.serialize((DataOutput)dos, identities, (Object)type);
                                Binding binding = Bindings.getBinding((Datatype)type);
                                Serializer serializer = Bindings.getSerializer((Binding)binding);
                                serializer.skip(new InputStream(){

                                    @Override
                                    public int read() throws IOException {
                                        int value = stream.read();
                                        dos.write(value);
                                        return value;
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            });
        }
        finally {
            out.close();
        }
        long end = System.nanoTime();
        System.err.println("Wrote transferable graph in " + 1.0E-9 * (double)(end - start) + " seconds.");
    }

    public static TransferableGraph1 create(ReadGraph graph, TransferableGraphSource source) throws DatabaseException {
        final TIntArrayList statements = new TIntArrayList();
        final ArrayList values = new ArrayList();
        final ArrayList identities = new ArrayList();
        try {
            source.forStatements(graph, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

                @Override
                public void execute(int[] r) {
                    statements.addAll(r);
                }
            });
            source.forValues(graph, new TransferableGraphSource.TransferableGraphSourceProcedure<Value>(){

                @Override
                public void execute(Value v) {
                    values.add(v);
                }
            });
            source.forIdentities(graph, new TransferableGraphSource.TransferableGraphSourceProcedure<Identity>(){

                @Override
                public void execute(Identity i) {
                    identities.add(i);
                }
            });
            return new TransferableGraph1(source.getResourceCount(), identities.toArray(new Identity[identities.size()]), statements.toArray(), values.toArray(new Value[values.size()]), source.getExtensions());
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

