/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.io.InputStream;
import java.util.TreeMap;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Value;

public interface TransferableGraphSource {
    public DataContainer getHeader() throws Exception;

    public TreeMap<String, Variant> getExtensions() throws Exception;

    public int getResourceCount() throws Exception;

    public int getIdentityCount() throws Exception;

    public void forIdentities(ReadGraph var1, TransferableGraphSourceProcedure<Identity> var2) throws Exception;

    public int getStatementCount() throws Exception;

    public void forStatements(ReadGraph var1, TransferableGraphSourceProcedure<int[]> var2) throws Exception;

    public int getValueCount() throws Exception;

    public void forValues(ReadGraph var1, TransferableGraphSourceProcedure<Value> var2) throws Exception;

    public void forValues2(ReadGraph var1, TransferableGraphSourceValueProcedure var2) throws Exception;

    public void reset() throws Exception;

    public static interface TransferableGraphSourceProcedure<T> {
        public void execute(T var1) throws Exception;
    }

    public static interface TransferableGraphSourceValueProcedure {
        public void execute(int var1, Datatype var2, InputStream var3) throws Exception;
    }
}

