/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.ByteFileReader;
import org.simantics.graph.representation.Extensions;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.Value;

public final class StreamingTransferableGraphFileReader
extends ByteFileReader {
    private static boolean init = true;
    private static final int SIZE = 262144;

    public StreamingTransferableGraphFileReader(File file) throws Exception {
        super(file, 262144);
        if (init) {
            init = false;
            StreamingTransferableGraphFileReader r = new StreamingTransferableGraphFileReader(file, 0);
            int i = 0;
            while (i < 40000) {
                r.readTG();
                ++i;
            }
        }
    }

    public StreamingTransferableGraphFileReader(InputStream stream) throws Exception {
        super(null, (ReadableByteChannel)new InputChannel(stream), 262144);
        if (init) {
            init = false;
            StreamingTransferableGraphFileReader r = new StreamingTransferableGraphFileReader(stream, 0);
            int i = 0;
            while (i < 40000) {
                r.readTG();
                ++i;
            }
        }
    }

    public StreamingTransferableGraphFileReader(ReadableByteChannel channel) throws Exception {
        super(null, channel, 262144);
        if (init) {
            init = false;
            StreamingTransferableGraphFileReader r = new StreamingTransferableGraphFileReader(channel, 0);
            int i = 0;
            while (i < 40000) {
                r.readTG();
                ++i;
            }
        }
    }

    public StreamingTransferableGraphFileReader(ReadableByteChannel channel, int size) throws IOException {
        super(null, channel, 262144);
    }

    public StreamingTransferableGraphFileReader(InputStream stream, int size) throws IOException {
        super(null, (ReadableByteChannel)new InputChannel(stream), size);
    }

    public StreamingTransferableGraphFileReader(File file, int size) throws IOException {
        super(file, size);
    }

    public TransferableGraphSource readTG() throws Exception {
        if (this.getSize() == 0) {
            return null;
        }
        return new FileTransferableGraphSource();
    }

    public static void main(String[] args) {
        try {
            File file = new File("c:/users/antti villberg/desktop/test.apros");
            StreamingTransferableGraphFileReader reader = new StreamingTransferableGraphFileReader(file, 262144);
            reader = new StreamingTransferableGraphFileReader(file);
            long s = System.nanoTime();
            reader.readTG();
            long d = System.nanoTime() - s;
            System.err.println("Duration=" + 1.0E-9 * (double)d + "s.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    class FileTransferableGraphSource
    implements TransferableGraphSource {
        InputStream in = new InputStream(){

            @Override
            public int read() throws IOException {
                return StreamingTransferableGraphFileReader.this.getByte();
            }

            @Override
            public int read(byte[] b) throws IOException {
                System.arraycopy(StreamingTransferableGraphFileReader.this.safeBytes(b.length), 0, b, 0, b.length);
                return b.length;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int i = 0;
                while (i < len) {
                    b[off++] = (byte)StreamingTransferableGraphFileReader.this.getByte();
                    ++i;
                }
                return len;
            }
        };
        DataContainer header;
        Extensions extensions;
        int resourceCount;
        private int identities;
        private int stmLength;
        private int valueLength;

        public FileTransferableGraphSource() throws Exception {
            this.init();
        }

        private void init() throws Exception {
            DataInputStream dis = new DataInputStream(this.in);
            this.header = DataContainers.readHeader((DataInput)dis);
            Bindings.getSerializerUnchecked(Datatype.class).deserialize((DataInput)dis);
            this.resourceCount = StreamingTransferableGraphFileReader.this.safeInt();
            ArrayList idcontext = new ArrayList();
            dis = new DataInputStream(this.in);
            this.extensions = (Extensions)Bindings.getSerializerUnchecked(Extensions.class).deserialize((DataInput)dis, idcontext);
        }

        @Override
        public void reset() throws Exception {
            StreamingTransferableGraphFileReader.this.reset();
            throw new UnsupportedOperationException();
        }

        @Override
        public DataContainer getHeader() throws Exception {
            return this.header;
        }

        @Override
        public int getResourceCount() throws Exception {
            return this.resourceCount;
        }

        @Override
        public int getIdentityCount() throws Exception {
            this.identities = StreamingTransferableGraphFileReader.this.safeInt();
            return this.identities;
        }

        @Override
        public int getStatementCount() throws Exception {
            this.stmLength = StreamingTransferableGraphFileReader.this.safeInt();
            return this.stmLength;
        }

        @Override
        public int getValueCount() throws Exception {
            this.valueLength = StreamingTransferableGraphFileReader.this.safeInt();
            return this.valueLength;
        }

        @Override
        public void forStatements(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
            int[] value = new int[4];
            int stmIndex = 0;
            while (stmIndex < this.stmLength) {
                value[stmIndex & 3] = StreamingTransferableGraphFileReader.this.safeInt();
                if ((++stmIndex & 3) == 0) {
                    procedure.execute(value);
                }
                int avail = 262144 - StreamingTransferableGraphFileReader.this.byteIndex >> 2;
                int allowed = Math.min(this.stmLength - stmIndex, avail);
                int index = StreamingTransferableGraphFileReader.this.byteIndex;
                int i = 0;
                while (i < allowed) {
                    value[stmIndex & 3] = (StreamingTransferableGraphFileReader.this.bytes[index++] & 0xFF) << 24 | (StreamingTransferableGraphFileReader.this.bytes[index++] & 0xFF) << 16 | (StreamingTransferableGraphFileReader.this.bytes[index++] & 0xFF) << 8 | StreamingTransferableGraphFileReader.this.bytes[index++] & 0xFF;
                    if ((++stmIndex & 3) == 0) {
                        procedure.execute(value);
                    }
                    ++i;
                }
                StreamingTransferableGraphFileReader streamingTransferableGraphFileReader = StreamingTransferableGraphFileReader.this;
                streamingTransferableGraphFileReader.byteIndex = streamingTransferableGraphFileReader.byteIndex + (allowed << 2);
            }
        }

        @Override
        public void forIdentities(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Identity> procedure) throws Exception {
            int i = 0;
            while (i < this.identities) {
                int parent;
                int rid = StreamingTransferableGraphFileReader.this.safeInt();
                byte[] byArray = StreamingTransferableGraphFileReader.this.bytes;
                StreamingTransferableGraphFileReader streamingTransferableGraphFileReader = StreamingTransferableGraphFileReader.this;
                int n = streamingTransferableGraphFileReader.byteIndex;
                streamingTransferableGraphFileReader.byteIndex = n + 1;
                byte type = byArray[n];
                if (type == 1) {
                    parent = StreamingTransferableGraphFileReader.this.safeInt();
                    byte[] byArray2 = StreamingTransferableGraphFileReader.this.bytes;
                    StreamingTransferableGraphFileReader streamingTransferableGraphFileReader2 = StreamingTransferableGraphFileReader.this;
                    int n2 = streamingTransferableGraphFileReader2.byteIndex;
                    streamingTransferableGraphFileReader2.byteIndex = n2 + 1;
                    int nameLen = byArray2[n2] & 0xFF;
                    if (StreamingTransferableGraphFileReader.this.byteIndex + nameLen < 262144) {
                        procedure.execute(new Identity(rid, (IdentityDefinition)new External(parent, StreamingTransferableGraphFileReader.this.utf(StreamingTransferableGraphFileReader.this.bytes, StreamingTransferableGraphFileReader.this.byteIndex, StreamingTransferableGraphFileReader.this.byteIndex + nameLen))));
                        StreamingTransferableGraphFileReader streamingTransferableGraphFileReader3 = StreamingTransferableGraphFileReader.this;
                        streamingTransferableGraphFileReader3.byteIndex = streamingTransferableGraphFileReader3.byteIndex + nameLen;
                    } else {
                        procedure.execute(new Identity(rid, (IdentityDefinition)new External(parent, StreamingTransferableGraphFileReader.this.utf(StreamingTransferableGraphFileReader.this.safeBytes(nameLen), 0, nameLen))));
                    }
                } else if (type == 3) {
                    parent = StreamingTransferableGraphFileReader.this.safeInt();
                    byte[] byArray3 = StreamingTransferableGraphFileReader.this.bytes;
                    StreamingTransferableGraphFileReader streamingTransferableGraphFileReader4 = StreamingTransferableGraphFileReader.this;
                    int n3 = streamingTransferableGraphFileReader4.byteIndex;
                    streamingTransferableGraphFileReader4.byteIndex = n3 + 1;
                    int nameLen = byArray3[n3] & 0xFF;
                    if (StreamingTransferableGraphFileReader.this.byteIndex + nameLen < 262144) {
                        procedure.execute(new Identity(rid, (IdentityDefinition)new Internal(parent, StreamingTransferableGraphFileReader.this.utf(StreamingTransferableGraphFileReader.this.bytes, StreamingTransferableGraphFileReader.this.byteIndex, StreamingTransferableGraphFileReader.this.byteIndex + nameLen))));
                        StreamingTransferableGraphFileReader streamingTransferableGraphFileReader5 = StreamingTransferableGraphFileReader.this;
                        streamingTransferableGraphFileReader5.byteIndex = streamingTransferableGraphFileReader5.byteIndex + nameLen;
                    } else {
                        procedure.execute(new Identity(rid, (IdentityDefinition)new Internal(parent, StreamingTransferableGraphFileReader.this.utf(StreamingTransferableGraphFileReader.this.safeBytes(nameLen), 0, nameLen))));
                    }
                } else if (type == 0) {
                    byte[] byArray4 = StreamingTransferableGraphFileReader.this.bytes;
                    StreamingTransferableGraphFileReader streamingTransferableGraphFileReader6 = StreamingTransferableGraphFileReader.this;
                    int n4 = streamingTransferableGraphFileReader6.byteIndex;
                    streamingTransferableGraphFileReader6.byteIndex = n4 + 1;
                    int nameLen = byArray4[n4] & 0xFF;
                    String name = StreamingTransferableGraphFileReader.this.utf(StreamingTransferableGraphFileReader.this.safeBytes(nameLen), 0, nameLen);
                    byte[] byArray5 = StreamingTransferableGraphFileReader.this.bytes;
                    StreamingTransferableGraphFileReader streamingTransferableGraphFileReader7 = StreamingTransferableGraphFileReader.this;
                    int n5 = streamingTransferableGraphFileReader7.byteIndex;
                    streamingTransferableGraphFileReader7.byteIndex = n5 + 1;
                    int nameLen2 = byArray5[n5] & 0xFF;
                    String rType = StreamingTransferableGraphFileReader.this.utf(StreamingTransferableGraphFileReader.this.safeBytes(nameLen2), 0, nameLen2);
                    procedure.execute(new Identity(rid, (IdentityDefinition)new Root(name, rType)));
                } else if (type == 2) {
                    throw new UnsupportedOperationException();
                }
                ++i;
            }
        }

        @Override
        public void forValues(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Value> procedure) throws Exception {
            Serializer variantSerializer = Bindings.getSerializerUnchecked((Binding)Bindings.VARIANT);
            ArrayList idcontext = new ArrayList();
            DataInputStream dis = new DataInputStream(this.in);
            int i = 0;
            while (i < this.valueLength) {
                int resource = StreamingTransferableGraphFileReader.this.safeInt();
                Variant value = (Variant)variantSerializer.deserialize((DataInput)dis, idcontext);
                procedure.execute(new Value(resource, value));
                ++i;
            }
        }

        @Override
        public void forValues2(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceValueProcedure procedure) throws Exception {
            Binding datatypeBinding = Bindings.getBinding(Datatype.class);
            Serializer datatypeSerializer = Bindings.getSerializerUnchecked((Binding)datatypeBinding);
            ArrayList idContext = new ArrayList();
            DataInputStream dis = new DataInputStream(this.in);
            int i = 0;
            while (i < this.valueLength) {
                int resource = StreamingTransferableGraphFileReader.this.safeInt();
                idContext.clear();
                Datatype type = (Datatype)datatypeSerializer.deserialize((DataInput)dis, idContext);
                procedure.execute(resource, type, this.in);
                ++i;
            }
        }

        @Override
        public TreeMap<String, Variant> getExtensions() throws Exception {
            return this.extensions.map;
        }
    }

    static final class InputChannel
    implements ReadableByteChannel {
        private final InputStream stream;

        public InputChannel(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int pos = dst.position();
            int limit = dst.limit();
            int i = this.stream.read(dst.array(), pos, limit - pos);
            return i;
        }
    }
}

