/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.util.HashSet;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.InitSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.ImportAdvisor;
import org.simantics.graph.db.TransferableGraphImportProcess;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.scl.reflection.OntologyVersions;

public class CoreInitialization {
    public static final String LAYER0 = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Layer0-0.0/");
    static final HashSet<InitSupport.Builtin> BUILTINS = new HashSet();
    private static int builtinId = 0;

    static {
        CoreInitialization.addLayer0Builtin("InstanceOf");
        CoreInitialization.addLayer0Builtin("Inherits");
        CoreInitialization.addLayer0Builtin("SubrelationOf");
        CoreInitialization.addLayer0Builtin("InverseOf");
        CoreInitialization.addLayer0Builtin("HasName");
        CoreInitialization.addLayer0Builtin("NameOf");
        CoreInitialization.addLayer0Builtin("ConsistsOf");
        CoreInitialization.addLayer0Builtin("PartOf");
        CoreInitialization.addLayer0Builtin("String");
        CoreInitialization.addLayer0Builtin("Library");
        CoreInitialization.addLayer0Builtin("FunctionalRelation");
        CoreInitialization.addLayer0Builtin("SuperrelationOf");
        CoreInitialization.addLayer0Builtin("Asserts");
        CoreInitialization.addLayer0Builtin("HasInstance");
        CoreInitialization.addLayer0Builtin("HasPredicate");
        CoreInitialization.addLayer0Builtin("HasPredicateInverse");
        CoreInitialization.addLayer0Builtin("HasObject");
        CoreInitialization.addBuiltin("http://Projects");
        CoreInitialization.addBuiltin("http:/");
    }

    public static HashSet<InitSupport.Builtin> getBuiltins() {
        return BUILTINS;
    }

    private static void addBuiltin(String uri) {
        BUILTINS.add(new InitSupport.Builtin(uri, ++builtinId));
    }

    private static void addLayer0Builtin(String name) {
        CoreInitialization.addBuiltin(String.valueOf(LAYER0) + name);
    }

    public static void initializeBuiltins(ServiceLocator serviceLocator) throws DatabaseException {
        InitSupport is = (InitSupport)serviceLocator.getService(InitSupport.class);
        try {
            is.addBuiltins(BUILTINS);
        }
        finally {
            is.close();
        }
    }

    public static long[] initializeGraph(Session session, TransferableGraph1 tg) throws DatabaseException {
        final TransferableGraphImportProcess process = new TransferableGraphImportProcess(tg, new ImportAdvisor());
        session.syncRequest((WriteOnly)new WriteOnlyRequest(){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                process.initialPrepare(graph);
                process.write(graph);
                graph.clearUndoList((WriteTraits)this);
            }
        });
        return process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
    }
}

