/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.annotation.ui.wizard.ExportPlan;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;

public class AnnotationTypeExportPage
extends WizardPage {
    ExportPlan exportModel;
    CCombo model;
    CCombo exportLocation;
    List<NamedResource> models = Collections.emptyList();
    private Button overwrite;

    protected AnnotationTypeExportPage(ExportPlan model) {
        super("Export Annotation Type", "Define Export Location", null);
        this.exportModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText("Exported &annotation type:");
        this.model = new CCombo(container, 2048);
        this.model.setEditable(false);
        this.model.setText("");
        this.model.setToolTipText("Selects the annotation type to export.");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.model);
        this.model.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AnnotationTypeExportPage.this.validatePage();
            }
        });
        new Label(container, 0).setText("&Target file:");
        this.exportLocation = new CCombo(container, 2048);
        this.exportLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
        this.exportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AnnotationTypeExportPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Browse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AnnotationTypeExportPage.this.getShell(), 8192);
                dialog.setText("Choose Export Target File");
                String loc = AnnotationTypeExportPage.this.exportLocation.getText();
                dialog.setFilterPath(loc);
                dialog.setFilterExtensions(new String[]{"*.annotationType"});
                dialog.setFilterNames(new String[]{"Annotation Type (*.annotationType)"});
                dialog.setOverwrite(false);
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                AnnotationTypeExportPage.this.exportLocation.setText(file);
                AnnotationTypeExportPage.this.validatePage();
            }
        });
        Label horizRule = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("&Overwrite existing files without warning");
        this.overwrite.setSelection(this.exportModel.overwrite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.overwrite);
        this.overwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotationTypeExportPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        final List resources = ISelectionUtils.getPossibleKeys((Object)this.exportModel.selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        this.models = (List)this.exportModel.sessionContext.getSession().syncRequest((Read)new UniqueRead<List<NamedResource>>(){
            AnnotationResource ANNO;
            Layer0 L0;
            NameLabelMode mode;

            public List<NamedResource> perform(ReadGraph graph) throws DatabaseException {
                this.ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                this.L0 = Layer0.getInstance((RequestProcessor)AnnotationTypeExportPage.this.exportModel.sessionContext.getSession());
                this.mode = NameLabelMode.NAME;
                TreeMap<String, NamedResource> result = new TreeMap<String, NamedResource>((Comparator<String>)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
                for (Resource r : resources) {
                    this.process(graph, r, result);
                }
                if (result.isEmpty()) {
                    HashSet<Resource> visited = new HashSet<Resource>();
                    Instances types = (Instances)graph.adapt(this.ANNO.AnnotationType, Instances.class);
                    for (Resource r : resources) {
                        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
                        if (indexRoot == null || !visited.add(indexRoot)) continue;
                        for (Resource at : types.find(graph, indexRoot)) {
                            Resource atRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(at));
                            if (!indexRoot.equals(atRoot)) continue;
                            this.process(graph, at, result);
                        }
                    }
                }
                return new ArrayList<NamedResource>(result.values());
            }

            private NamedResource process(ReadGraph graph, Resource r, Map<String, NamedResource> result) throws DatabaseException {
                NamedResource nr = this.process(graph, r);
                if (nr != null) {
                    result.put(nr.getName(), nr);
                }
                return nr;
            }

            private NamedResource process(ReadGraph graph, Resource r) throws DatabaseException {
                if (!graph.isInstanceOf(r, this.ANNO.AnnotationType)) {
                    return null;
                }
                Resource property = graph.getPossibleObject(r, this.L0.HasRange_Inverse);
                String name = this.pathName(graph, r, property != null ? property : r);
                return new NamedResource(name, r);
            }

            private String pathName(ReadGraph graph, Resource r, Resource namedEntity) throws DatabaseException {
                String name = (String)graph.getRelatedValue(namedEntity, this.L0.HasName, (Binding)Bindings.STRING);
                Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
                if (indexRoot == null) {
                    return name;
                }
                Variable rootV = Variables.getPossibleVariable((ReadGraph)graph, (Resource)indexRoot);
                Variable v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)r);
                if (v == null || rootV == null) {
                    return name;
                }
                List path = Variables.getPath((ReadGraph)graph, (Variable)rootV, (Variable)v);
                path.add(0, rootV);
                StringBuilder sb = new StringBuilder();
                for (Variable p : path) {
                    String segmentName = NameLabelUtil.modalName((ReadGraph)graph, (Variable)p, (NameLabelMode)this.mode);
                    sb.append(segmentName).append(" / ");
                }
                sb.append(name);
                return sb.toString();
            }
        });
        if (!this.models.isEmpty()) {
            this.exportModel.model = this.models.get(0);
        }
        int i = 0;
        for (NamedResource m : this.models) {
            this.model.add(m.getName());
            this.model.setData(String.valueOf(i), (Object)m);
            if (m.equals((Object)this.exportModel.model)) {
                this.model.select(i);
            }
            ++i;
        }
        for (String path : this.exportModel.recentLocations) {
            this.exportLocation.add(path);
        }
        if (this.exportLocation.getItemCount() > 0) {
            this.exportLocation.select(0);
        }
    }

    void validatePage() {
        if (this.exportModel.model == null) {
            this.setMessage("Select model to export from.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        String exportLoc = this.exportLocation.getText();
        if (exportLoc.isEmpty()) {
            this.setMessage("Select target file.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(exportLoc);
        if (file.isDirectory()) {
            this.setErrorMessage("The target is a directory.");
            this.setPageComplete(false);
            return;
        }
        File parent = file.getParentFile();
        if (parent == null || !parent.isDirectory()) {
            this.setErrorMessage("The target directory does not exist.");
            this.setPageComplete(false);
            return;
        }
        this.exportModel.exportLocation = file;
        this.exportModel.overwrite = this.overwrite.getSelection();
        this.setErrorMessage(null);
        this.setMessage("Export annotation type.");
        this.setPageComplete(true);
    }
}

