/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class AnnotationDropActionFactory
implements DropActionFactory {
    public Runnable create(ReadGraph graph, Object target, Object source) throws DatabaseException {
        Resource targetFolder = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (targetFolder == null) {
            return null;
        }
        Resource targetModel = (Resource)graph.syncRequest((Read)new PossibleModel(targetFolder));
        List resources = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        HashSet<Resource> movedItems = new HashSet<Resource>();
        for (Resource resource : resources) {
            Resource model;
            if (!graph.isInstanceOf(resource, ANNO.AnnotationType) && !graph.isInstanceOf(resource, ANNO.Annotation) || !ObjectUtils.objectEquals((Object)targetModel, (Object)(model = (Resource)graph.syncRequest((Read)new PossibleModel(resource))))) continue;
            movedItems.add(resource);
        }
        if (!movedItems.isEmpty()) {
            return this.addAnnotations(targetFolder, movedItems);
        }
        return null;
    }

    private Runnable addAnnotations(final Resource targetFolder, final Set<Resource> movedAnnotationItems) {
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        for (Resource annotation : movedAnnotationItems) {
                            graph.deny(annotation, L0.PartOf);
                            graph.claim(targetFolder, L0.ConsistsOf, annotation);
                        }
                        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)targetFolder);
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Moved " + movedAnnotationItems.size() + " annotations to folder " + name + ", resource " + targetFolder));
                    }
                }, (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException e) {
                        if (e != null) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                });
            }
        };
    }
}

