/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.annotation.ui.AnnotationUtils;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.views.swt.client.base.ISWTViewNode;
import org.simantics.views.swt.client.impl.SWTExplorer;

public class SCL {
    public static final String EMPTY = "";
    public static final String MAPPED = "Mapped";
    public static final String SELECTED = "Selected";
    public static final String NO_ANNOTATIONS = "No annotations";
    private static final Comparator<? super Tuple3> AVAILABLE_ANNOTATION_SORTER = new Comparator<Tuple3>(){

        @Override
        public int compare(Tuple3 o1, Tuple3 o2) {
            String s1 = (String)o1.c2;
            String s2 = (String)o2.c2;
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)s1, (Object)s2);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap domainChildren = new VariableMapImpl(){

        private Map<String, Resource> children(ReadGraph graph, Resource resource) throws DatabaseException {
            AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Collection objects = graph.getObjects(resource, ANNO.Annotation_HasEntry);
            THashMap result = new THashMap(objects.size());
            for (Resource r : objects) {
                String name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
                if (name == null || result.put((Object)name, (Object)r) == null) continue;
                System.err.println((Object)((Object)this) + ": The database contains siblings with the same name " + name + " (resource=$" + resource.getResourceId() + ").");
            }
            return result;
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            Map<String, Resource> children = this.children(graph, context.getRepresents(graph));
            Resource child = children.get(name);
            if (child == null) {
                return null;
            }
            VariableBuilder variableBuilder = (VariableBuilder)graph.adapt(child, VariableBuilder.class);
            return variableBuilder.buildChild(graph, context, null, child);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            Map<String, Resource> childMap = this.children(graph, context.getRepresents(graph));
            if (childMap.isEmpty()) {
                return map;
            }
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            for (Map.Entry<String, Resource> entry : childMap.entrySet()) {
                String name = entry.getKey();
                Resource child = entry.getValue();
                VariableBuilder variableBuilder = (VariableBuilder)graph.adapt(child, VariableBuilder.class);
                Variable var = variableBuilder.buildChild(graph, context, null, child);
                if (var != null) {
                    map.put(name, var);
                    continue;
                }
                System.err.println("No adapter for " + child + " in " + context.getURI(graph));
            }
            return map;
        }
    };

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [(String, Resource)]")
    public static List<Tuple> availableSources(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        for (Tuple3 anno : SCL.availableSourcesImpl(graph, selection)) {
            result.add((Tuple)new Tuple2(anno.get(0), (Object)EMPTY));
        }
        return result;
    }

    private static List<Tuple3> availableSourcesImpl(ReadGraph graph, Variable selection) throws DatabaseException {
        ArrayList<Tuple3> result = new ArrayList<Tuple3>();
        Collection maps = ModelingUtils.getMappedVariables((ReadGraph)graph, (Variable)selection);
        if (maps.size() == 1) {
            Variable mapped = (Variable)maps.iterator().next();
            result.add(new Tuple3((Object)SCL.sourceLabel(graph, mapped), (Object)MAPPED, (Object)mapped));
        }
        result.add(new Tuple3((Object)SCL.sourceLabel(graph, selection), (Object)SELECTED, (Object)selection));
        return result;
    }

    private static String sourceLabel(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource represents = variable.getPossibleRepresents(graph);
        if (represents != null) {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            if (graph.isInstanceOf(represents, DIA.Diagram)) {
                return "Diagram";
            }
            if (graph.isInstanceOf(represents, DIA.Flag)) {
                return "Flag Element";
            }
            if (graph.isInstanceOf(represents, DIA.RouteGraphConnection)) {
                return "Connection Element";
            }
            if (graph.isInstanceOf(represents, DIA.Monitor)) {
                return "Monitor Element";
            }
            if (graph.isInstanceOf(represents, DIA.Element)) {
                return "Diagram Element";
            }
            return variable.getName(graph);
        }
        return variable.getURI(graph);
    }

    private static <T> T selectedSource(ReadGraph graph, Variable selection) throws DatabaseException {
        String name = SCL.selectedSourceName(graph, selection);
        for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
            if (!tuple.get(1).equals(name)) continue;
            return (T)tuple.get(2);
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String selectedSource(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        String name = SCL.selectedSourceName(graph, selection);
        for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
            if (!tuple.get(1).equals(name)) continue;
            return (String)tuple.get(0);
        }
        return EMPTY;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object selectedSourceModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Object>(){

            public Object apply(final Object _key) {
                Session s = Simantics.getSession();
                VirtualGraph vg = ((VirtualGraphSupport)s.getService(VirtualGraphSupport.class)).getWorkspacePersistent("preferences");
                s.async((WriteInterface)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
                        Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
                        for (Tuple3 anno : SCL.availableSourcesImpl((ReadGraph)graph, selection)) {
                            if (!anno.get(0).equals(_key)) continue;
                            graph.claimLiteral(model, ANNO.DefaultAnnotationSource, (Object)((String)anno.get(1)), (Binding)Bindings.STRING);
                        }
                    }
                });
                return null;
            }
        };
    }

    private static Collection<Tuple3> availableAnnotationsImpl(ReadGraph graph, Variable selection) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        selection = (Variable)SCL.selectedSource(graph, selection);
        ArrayList<Tuple3> result = new ArrayList<Tuple3>();
        for (Variable child : selection.getChildren(graph)) {
            String name;
            Resource represents = child.getPossibleRepresents(graph);
            if (represents == null || !graph.isInstanceOf(represents, ANNO.Annotation) || (name = (String)graph.getPossibleRelatedValue(represents, L0.HasName)) == null) continue;
            result.add(new Tuple3((Object)child, (Object)represents, (Object)name));
        }
        for (Variable property : selection.getProperties(graph)) {
            Resource propertyResource = property.getPossibleRepresents(graph);
            if (propertyResource == null || !graph.isInstanceOf(propertyResource, ANNO.Annotation)) continue;
            String propertyName = property.getName(graph);
            result.add(new Tuple3((Object)property, (Object)propertyResource, (Object)propertyName));
        }
        Collections.sort(result, AVAILABLE_ANNOTATION_SORTER);
        return result;
    }

    private static Pair<Resource, String> defaultAnnotationTypeAndName(ReadGraph graph, Variable selection) throws DatabaseException {
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
        Resource type = graph.getPossibleObject(model, ANNO.HasDefaultAnnotationType);
        String name = (String)graph.getPossibleRelatedValue(model, ANNO.HasDefaultAnnotationName, (Binding)Bindings.STRING);
        return Pair.make((Object)type, (Object)name);
    }

    private static String selectedAnnotationName(ReadGraph graph, Variable selection) throws DatabaseException {
        Pair<Resource, String> typeAndName = SCL.defaultAnnotationTypeAndName(graph, selection);
        Collection<Tuple3> available = SCL.availableAnnotationsImpl(graph, selection);
        if (!available.isEmpty()) {
            if (available.size() == 1 || typeAndName.first == null) {
                return (String)available.iterator().next().c2;
            }
            String firstTypeMatch = null;
            for (Tuple3 anno : available) {
                if (!graph.isInstanceOf((Resource)anno.c1, (Resource)typeAndName.first)) continue;
                if (firstTypeMatch == null) {
                    firstTypeMatch = (String)anno.c2;
                }
                if (typeAndName.second == null || !((String)typeAndName.second).equals(anno.c2)) continue;
                return (String)anno.c2;
            }
            if (firstTypeMatch != null) {
                return firstTypeMatch;
            }
            return (String)available.iterator().next().c2;
        }
        return NO_ANNOTATIONS;
    }

    private static String selectedSourceName(ReadGraph graph, Variable selection) throws DatabaseException {
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
        String name = (String)graph.getPossibleRelatedValue(model, ANNO.DefaultAnnotationSource, (Binding)Bindings.STRING);
        if (name != null) {
            for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
                if (!tuple.get(1).equals(name)) continue;
                return name;
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
            hashSet.add((String)tuple.get(1));
        }
        if (hashSet.isEmpty()) {
            return EMPTY;
        }
        if (hashSet.contains(MAPPED)) {
            return MAPPED;
        }
        return (String)hashSet.iterator().next();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object explorerInput(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        String selected = SCL.selectedAnnotationName(graph, selection);
        for (Tuple3 anno : SCL.availableAnnotationsImpl(graph, selection)) {
            if (!selected.equals(anno.c2)) continue;
            return anno.c0;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String descriptionText(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        String result = EMPTY;
        Variable sel = SCL.getSelectedAnnotationVariable(graph, context);
        if (sel != null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource literal = sel.getPossibleRepresents(graph);
            if (literal != null) {
                Resource container = graph.getPossibleObject(literal, L0.PartOf);
                if (container != null) {
                    Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)sel);
                    String modelURI = graph.getURI(model);
                    String path = graph.getURI(literal);
                    if (path.startsWith(modelURI)) {
                        path = path.substring(modelURI.length() + 1);
                    }
                    result = String.valueOf(result) + URIStringUtils.unescape((String)path);
                } else {
                    result = String.valueOf(result) + "The annotation is not attached to a library";
                }
            }
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object explorerInput2(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [(String, Resource)]")
    public static List<Tuple> availableAnnotations(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (Tuple3 anno : SCL.availableAnnotationsImpl(graph, selection)) {
            result.add((Tuple)new Tuple2(anno.c2, anno.c1));
        }
        if (result.isEmpty()) {
            result.add((Tuple)new Tuple2((Object)NO_ANNOTATIONS, (Object)EMPTY));
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String selectedAnnotation(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        return SCL.selectedAnnotationName(graph, selection);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object selectedAnnotationModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Object>(){

            public Object apply(final Object _key) {
                Session s = Simantics.getSession();
                VirtualGraph vg = ((VirtualGraphSupport)s.getService(VirtualGraphSupport.class)).getWorkspacePersistent("preferences");
                s.async((WriteInterface)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                        String key = (String)_key;
                        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
                        for (Tuple3 anno : SCL.availableAnnotationsImpl((ReadGraph)graph, selection)) {
                            if (!key.equals(anno.c2)) continue;
                            Resource type = graph.getPossibleType((Resource)anno.c1, ANNO.Annotation);
                            Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
                            graph.deny(model, ANNO.HasDefaultAnnotationType);
                            graph.claim(model, ANNO.HasDefaultAnnotationType, type);
                            graph.denyValue(model, ANNO.HasDefaultAnnotationName);
                            graph.claimLiteral(model, ANNO.HasDefaultAnnotationName, (Object)key, (Binding)Bindings.STRING);
                            break;
                        }
                    }
                });
                return null;
            }
        };
    }

    private static Resource getSelectionResource(Variable context) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((Read)new UnaryRead<Variable, Resource>(context){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)((Variable)this.parameter));
                Variable source = (Variable)SCL.selectedSource(graph, selection);
                return source.getPossibleRepresents(graph);
            }
        });
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object newAnnotationModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new AddModifier(context);
    }

    private static Variable getSelectedAnnotationVariable(Variable context) {
        try {
            return (Variable)Simantics.sync((ReadInterface)new VariableRead<Variable>(context){

                public Variable perform(ReadGraph graph) throws DatabaseException {
                    return SCL.getSelectedAnnotationVariable(graph, this.variable);
                }
            });
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    private static Variable getSelectedAnnotationVariable(ReadGraph graph, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        String selected = SCL.selectedAnnotationName(graph, selection);
        for (Tuple3 anno : SCL.availableAnnotationsImpl(graph, selection)) {
            if (!anno.c2.equals(selected)) continue;
            return (Variable)anno.c0;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object removeAnnotationModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new RemoveModifier();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object saveAnnotationModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new SaveModifier();
    }

    static class AddModifier
    extends FunctionImpl1<Object, Object> {
        private final Variable context;

        public AddModifier(Variable context) {
            this.context = context;
        }

        private void doAdd(Variable variable) throws DatabaseException {
            if (variable != null) {
                AnnotationUtils.newAnnotation(variable);
            } else {
                Resource parent = SCL.getSelectionResource(this.context);
                if (parent != null) {
                    AnnotationUtils.newAnnotation(parent);
                }
            }
        }

        public Object apply(Object p0) {
            ISWTViewNode node = (ISWTViewNode)p0;
            SWTExplorer properties = (SWTExplorer)NodeUtil.browsePossible((INode)node, (String)"./Properties");
            if (properties == null) {
                return null;
            }
            try {
                this.doAdd((Variable)properties.input);
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            return null;
        }
    }

    static class RemoveModifier
    extends FunctionImpl1<Object, Object> {
        RemoveModifier() {
        }

        private void doRemove(final Variable variable) {
            if (!AnnotationUtils.isAnnotation(variable)) {
                return;
            }
            Simantics.getSession().async((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    Resource represents = variable.getPossibleRepresents((ReadGraph)graph);
                    if (represents != null) {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                        if (graph.isInstanceOf(represents, ANNO.Annotation)) {
                            Resource subject = variable.getParent((ReadGraph)graph).getRepresents((ReadGraph)graph);
                            Resource predicate = variable.getPossiblePredicateResource((ReadGraph)graph);
                            if (predicate != null) {
                                graph.deny(subject, predicate);
                                Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Unlinked a property annotation " + graph.getRelatedValue2(predicate, L0.HasName, (Binding)Bindings.STRING) + " " + predicate.toString() + " from " + graph.getRelatedValue2(subject, L0.HasName, (Binding)Bindings.STRING) + " " + subject.toString()));
                            } else {
                                graph.deny(subject, ANNO.Annotation_HasEntry, represents);
                                Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Removed an entry annotation " + graph.getRelatedValue2(subject, L0.HasName, (Binding)Bindings.STRING) + " " + subject.toString() + " from its container " + graph.getRelatedValue2(represents, L0.HasName, (Binding)Bindings.STRING)));
                            }
                            if (!graph.hasStatement(represents, L0.PartOf)) {
                                RemoverUtil.remove((WriteGraph)graph, (Resource)represents);
                            }
                        }
                    }
                }
            });
        }

        public Object apply(Object p0) {
            ISWTViewNode node = (ISWTViewNode)p0;
            SWTExplorer properties = (SWTExplorer)NodeUtil.browsePossible((INode)node, (String)"./Properties");
            if (properties == null) {
                return null;
            }
            ISelection selection = properties.lastSelection;
            if (selection == null || selection.isEmpty()) {
                this.doRemove((Variable)properties.input);
                return null;
            }
            Set vars = ISelectionUtils.filterSetSelection((Object)selection, Variable.class);
            if (vars.size() != 1) {
                return null;
            }
            this.doRemove((Variable)vars.iterator().next());
            return null;
        }
    }

    public static class SaveModifier
    extends FunctionImpl1<Object, Object> {
        private void doSave(final Variable variable) {
            if (!AnnotationUtils.isAnnotation(variable)) {
                return;
            }
            Map<Resource, Pair<String, ImageDescriptor>> map = AnnotationUtils.findLibraries(variable);
            if (map == null) {
                return;
            }
            AnnotationUtils.queryLibrary(map, new Callback<Pair<Resource, String>>(){

                public void run(final Pair<Resource, String> selected) {
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            Resource represents = variable.getPossibleRepresents((ReadGraph)graph);
                            if (represents != null && !((String)selected.second).isEmpty()) {
                                SaveModifier.saveAnnotation(graph, represents, (Resource)selected.first, (String)selected.second);
                            }
                        }
                    });
                }
            });
        }

        public static Resource saveAnnotation(WriteGraph graph, Resource annotation, Resource library, String name) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (graph.hasStatement(annotation, L0.PartOf)) {
                graph.deny(annotation, L0.PartOf);
            }
            graph.claim(library, L0.ConsistsOf, L0.PartOf, annotation);
            graph.claimLiteral(annotation, L0.HasName, (Object)name, (Binding)Bindings.STRING);
            return annotation;
        }

        public Object apply(Object p0) {
            ISWTViewNode node = (ISWTViewNode)p0;
            SWTExplorer properties = (SWTExplorer)NodeUtil.browsePossible((INode)node, (String)"./Properties");
            if (properties == null) {
                return null;
            }
            ISelection selection = properties.lastSelection;
            if (selection == null || selection.isEmpty()) {
                this.doSave((Variable)properties.input);
                return null;
            }
            Set vars = ISelectionUtils.filterSetSelection((Object)selection, Variable.class);
            if (vars.size() != 1) {
                return null;
            }
            this.doSave((Variable)vars.iterator().next());
            return null;
        }
    }
}

