/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.annotation.ui.Activator;
import org.simantics.annotation.ui.internal.SaveAnnotationDialog;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;

public class AnnotationUtils {
    public static Pair<Resource, Resource> newAnnotationType(WriteGraph graph, Resource parent) throws DatabaseException {
        Resource supertype;
        graph.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(parent));
        Resource propertySubrelation = graph.getPossibleObject(indexRoot, ANNO.HasAnnotationPropertySubrelation);
        if (propertySubrelation == null) {
            propertySubrelation = L0.HasProperty;
        }
        if ((supertype = graph.getPossibleObject(indexRoot, ANNO.HasAnnotationTypeSupertype)) == null) {
            supertype = ANNO.Annotation;
        }
        Resource property = graph.newResource();
        String name = NameUtils.findFreshName((ReadGraph)graph, (String)"newAnnotationProperty", (Resource)parent, (Resource)L0.ConsistsOf);
        graph.addLiteral(property, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.claim(property, L0.SubrelationOf, propertySubrelation);
        Resource type = graph.newResource();
        graph.claim(type, L0.Inherits, null, supertype);
        graph.addLiteral(type, L0.HasName, L0.NameOf, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claim(type, STR.ComponentType_HasDefaultPropertyRelationType, SEL.GenericParameterType);
        graph.claim(property, L0.HasRange, type);
        graph.claim(type, L0.ConsistsOf, property);
        graph.claim(parent, L0.ConsistsOf, type);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Added new annotationType " + type + " with property relation " + property + " "));
        return Pair.make((Object)property, (Object)type);
    }

    public static void newAnnotation(ReadGraph graph, final Resource parent, Resource model) throws DatabaseException {
        HashMap<Resource, Pair<String, ImageDescriptor>> map = new HashMap<Resource, Pair<String, ImageDescriptor>>();
        AnnotationUtils.findAnnotationTypes(graph, model, map);
        AnnotationUtils.findAnnotations(graph, model, map);
        AnnotationUtils.queryUserSelectedAnnotationType(map, new Callback<Resource>(){

            public void run(final Resource selected) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        AnnotationUtils.newAnnotation(g, parent, selected);
                    }
                });
            }
        });
    }

    private static boolean isEntryAnnotation(ReadGraph graph, Resource selected) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(selected, ANNO.Annotation)) {
            Resource type = graph.getSingleType(selected, ANNO.Annotation);
            return !graph.hasStatement(type, L0.HasRange_Inverse);
        }
        if (graph.isInstanceOf(selected, ANNO.AnnotationType)) {
            return !graph.hasStatement(selected, L0.HasRange_Inverse);
        }
        throw new DatabaseException("Incompatible resource " + selected);
    }

    public static void newAnnotation(ReadGraph graph, final Variable position, Resource model) throws DatabaseException {
        HashMap<Resource, Pair<String, ImageDescriptor>> map = new HashMap<Resource, Pair<String, ImageDescriptor>>();
        AnnotationUtils.findAnnotationTypes(graph, model, map);
        AnnotationUtils.findAnnotations(graph, model, map);
        AnnotationUtils.queryUserSelectedAnnotationType(map, new Callback<Resource>(){

            public void run(final Resource selected) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        if (AnnotationUtils.isEntryAnnotation((ReadGraph)g, selected)) {
                            AnnotationUtils.newAnnotation(g, position.getRepresents((ReadGraph)g), selected);
                            Layer0Utils.addCommentMetadata((WriteGraph)g, (String)("Attached new annotation to " + g.getRelatedValue2(position.getRepresents((ReadGraph)g), Layer0.getInstance((ReadGraph)g).HasName, (Binding)Bindings.STRING)));
                        } else {
                            AnnotationUtils.newAnnotation(g, position.getParent((ReadGraph)g).getRepresents((ReadGraph)g), selected);
                            Layer0Utils.addCommentMetadata((WriteGraph)g, (String)("Attached new annotation to " + g.getRelatedValue2(position.getParent((ReadGraph)g).getRepresents((ReadGraph)g), Layer0.getInstance((ReadGraph)g).HasName, (Binding)Bindings.STRING)));
                        }
                    }
                });
            }
        });
    }

    public static void newAnnotation(final Resource parent, final Resource model) throws DatabaseException {
        if (model == null) {
            return;
        }
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                AnnotationUtils.newAnnotation(graph, parent, model);
            }
        });
    }

    public static void newAnnotation(final Resource parent) throws DatabaseException {
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(parent));
                if (model == null) {
                    return;
                }
                AnnotationUtils.newAnnotation(graph, parent, model);
            }
        });
    }

    public static void newAnnotation(final Variable position) throws DatabaseException {
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource model = Variables.getModel((ReadGraph)graph, (Variable)position);
                if (model == null) {
                    return;
                }
                AnnotationUtils.newAnnotation(graph, position, model);
            }
        });
    }

    public static void newAnnotationInstance(final Resource parent, final Resource model) throws DatabaseException {
        if (model == null) {
            return;
        }
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                HashMap<Resource, Pair<String, ImageDescriptor>> map = new HashMap<Resource, Pair<String, ImageDescriptor>>();
                AnnotationUtils.findAnnotationTypes(graph, model, map);
                AnnotationUtils.queryUserSelectedAnnotationType(map, new Callback<Resource>(){

                    public void run(final Resource selected) {
                        Simantics.getSession().async((WriteInterface)new WriteRequest(){

                            public void perform(WriteGraph g) throws DatabaseException {
                                g.markUndoPoint();
                                AnnotationUtils.newAnnotationInstance(g, parent, selected);
                            }
                        });
                    }
                });
            }
        });
    }

    protected static void findAnnotationTypes(ReadGraph graph, Resource model, Map<Resource, Pair<String, ImageDescriptor>> map) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(ANNO.AnnotationType, Instances.class);
        String modelURI = graph.getURI(model);
        ImageDescriptor descriptor = (ImageDescriptor)graph.adapt(ANNO.Images_AnnotationType, ImageDescriptor.class);
        for (Resource _res : query.find(graph, model)) {
            String parentURI;
            Resource parent;
            String label;
            String name;
            if (graph.hasStatement(_res, L0.Abstract)) continue;
            Resource res = graph.getPossibleObject(_res, L0.HasRange_Inverse);
            if (res == null) {
                name = (String)graph.getPossibleRelatedValue(_res, L0.HasName, (Binding)Bindings.STRING);
                if (name == null) continue;
                label = (String)graph.getPossibleRelatedValue2(_res, L0.HasLabel, (Binding)Bindings.STRING);
                if (label != null && !name.equals(label)) {
                    name = String.valueOf(label) + " (" + name + ")";
                }
                if ((parent = graph.getPossibleObject(_res, L0.PartOf)) == null) continue;
                parentURI = graph.getURI(parent);
                if (parentURI.startsWith(modelURI) && (parentURI = parentURI.substring(modelURI.length())).startsWith("/")) {
                    parentURI = parentURI.substring(1);
                }
                name = String.valueOf(name) + " - " + URIStringUtils.unescape((String)parentURI);
                map.put(_res, (Pair<String, ImageDescriptor>)new Pair((Object)name, (Object)descriptor));
                continue;
            }
            name = (String)graph.getPossibleRelatedValue(res, L0.HasName, (Binding)Bindings.STRING);
            if (name == null) continue;
            label = (String)graph.getPossibleRelatedValue2(res, L0.HasLabel, (Binding)Bindings.STRING);
            if (label != null && !name.equals(label)) {
                name = String.valueOf(label) + " (" + name + ")";
            }
            if ((parent = graph.getPossibleObject(_res, L0.PartOf)) == null) continue;
            parentURI = graph.getURI(parent);
            if (parentURI.startsWith(modelURI) && (parentURI = parentURI.substring(modelURI.length())).startsWith("/")) {
                parentURI = parentURI.substring(1);
            }
            name = String.valueOf(name) + " - " + URIStringUtils.unescape((String)parentURI);
            map.put(_res, (Pair<String, ImageDescriptor>)new Pair((Object)name, (Object)descriptor));
        }
    }

    protected static void findAnnotations(ReadGraph graph, Resource model, Map<Resource, Pair<String, ImageDescriptor>> map) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(ANNO.Annotation, Instances.class);
        String modelURI = graph.getURI(model);
        ImageDescriptor descriptor = (ImageDescriptor)graph.adapt(ANNO.Images_Annotation, ImageDescriptor.class);
        for (Resource _res : query.find(graph, model)) {
            String rName;
            Resource relation;
            Resource type;
            String parentURI;
            Resource parent;
            String name = (String)graph.getPossibleRelatedValue(_res, L0.HasName, (Binding)Bindings.STRING);
            if (name == null) continue;
            String label = (String)graph.getPossibleRelatedValue2(_res, L0.HasLabel, (Binding)Bindings.STRING);
            if (label != null && !name.equals(label)) {
                name = String.valueOf(label) + " (" + name + ")";
            }
            if ((parent = graph.getPossibleObject(_res, L0.PartOf)) == null || (parentURI = graph.getPossibleURI(parent)) == null) continue;
            if (parentURI.startsWith(modelURI) && (parentURI = parentURI.substring(modelURI.length())).startsWith("/")) {
                parentURI = parentURI.substring(1);
            }
            if ((type = graph.getPossibleType(_res, ANNO.Annotation)) != null && (relation = graph.getPossibleObject(type, L0.HasRange_Inverse)) != null && (rName = (String)graph.getPossibleRelatedValue(relation, L0.HasName, (Binding)Bindings.STRING)) != null) {
                name = String.valueOf(name) + " - " + rName;
            }
            name = String.valueOf(name) + " - " + URIStringUtils.unescape((String)parentURI);
            map.put(_res, (Pair<String, ImageDescriptor>)new Pair((Object)name, (Object)descriptor));
        }
    }

    protected static boolean isAnnotation(Variable variable) {
        if (variable == null) {
            return false;
        }
        try {
            return (Boolean)Simantics.sync((ReadInterface)new VariableRead<Boolean>(variable){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                    Resource represents = this.variable.getPossibleRepresents(graph);
                    if (represents == null) {
                        return false;
                    }
                    return graph.isInstanceOf(represents, ANNO.Annotation);
                }
            });
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    protected static Map<Resource, Pair<String, ImageDescriptor>> findLibraries(Variable variable) {
        try {
            return (Map)Simantics.sync((ReadInterface)new VariableRead<Map<Resource, Pair<String, ImageDescriptor>>>(variable){

                public Map<Resource, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                    HashMap<Resource, Pair<String, ImageDescriptor>> result = new HashMap<Resource, Pair<String, ImageDescriptor>>();
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                    Resource model = Variables.getModel((ReadGraph)graph, (Variable)this.variable);
                    Instances query = (Instances)graph.adapt(L0.Library, Instances.class);
                    String modelURI = graph.getURI(model);
                    int modelPos = modelURI.length();
                    ImageDescriptor descriptor = (ImageDescriptor)graph.adapt(ANNO.Images_Annotation, ImageDescriptor.class);
                    for (Resource lib : query.find(graph, model)) {
                        String path = graph.getURI(lib);
                        if (!path.startsWith(modelURI)) continue;
                        String suffix = URIStringUtils.unescape((String)path.substring(modelPos));
                        if (suffix.startsWith("/")) {
                            suffix = suffix.substring(1);
                        }
                        result.put(lib, (Pair<String, ImageDescriptor>)new Pair((Object)suffix, (Object)descriptor));
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static Resource newAnnotation(WriteGraph graph, Resource container, Resource valueOrProperty) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(valueOrProperty, ANNO.Annotation)) {
            Resource type = graph.getPossibleType(valueOrProperty, ANNO.Annotation);
            if (type == null) {
                return null;
            }
            Resource property = graph.getPossibleObject(type, L0.HasRange_Inverse);
            if (property == null) {
                graph.claim(container, ANNO.Annotation_HasEntry, valueOrProperty);
            } else {
                graph.deny(container, property);
                graph.claim(container, property, valueOrProperty);
            }
            Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Created new annotation value/property " + valueOrProperty + " to " + graph.getRelatedValue2(container, L0.HasName, (Binding)Bindings.STRING)));
            return valueOrProperty;
        }
        if (graph.isInstanceOf(valueOrProperty, ANNO.AnnotationType)) {
            Resource predicate = graph.getPossibleObject(valueOrProperty, L0.HasRange_Inverse);
            if (predicate != null) {
                Resource value = graph.newResource();
                graph.claim(value, L0.InstanceOf, valueOrProperty);
                graph.deny(container, predicate);
                graph.claim(container, predicate, value);
                Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Created new annotation type " + value + " to " + graph.getRelatedValue2(container, L0.HasName, (Binding)Bindings.STRING)));
                return value;
            }
            Resource value = graph.newResource();
            graph.claim(value, L0.InstanceOf, valueOrProperty);
            String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"Value", (Resource)container, (Resource)ANNO.Annotation_HasEntry);
            graph.addLiteral(value, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
            graph.claim(container, ANNO.Annotation_HasEntry, value);
            Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Created new annotation entry " + value + " to " + graph.getRelatedValue2(container, L0.HasName, (Binding)Bindings.STRING)));
            return value;
        }
        Resource valueType = graph.getSingleObject(valueOrProperty, L0.HasRange);
        Resource value = graph.newResource();
        graph.claim(value, L0.InstanceOf, valueType);
        graph.deny(container, valueOrProperty);
        graph.claim(container, valueOrProperty, value);
        return value;
    }

    public static Resource newAnnotationInstance(WriteGraph graph, Resource container, Resource annotationProperty) throws DatabaseException {
        return AnnotationUtils.newAnnotationInstance(graph, container, null, annotationProperty);
    }

    public static Resource newAnnotationInstance(WriteGraph graph, Resource container, String name, Resource annotationProperty) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(annotationProperty, ANNO.AnnotationType)) {
            Resource predicate = graph.getPossibleObject(annotationProperty, L0.HasRange_Inverse);
            String proposition = predicate != null ? (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING) : (String)graph.getRelatedValue(annotationProperty, L0.HasName, (Binding)Bindings.STRING);
            Resource value = graph.newResource();
            graph.claim(value, L0.InstanceOf, annotationProperty);
            if (name == null) {
                name = NameUtils.findFreshName((ReadGraph)graph, (String)(String.valueOf(proposition) + " value"), (Resource)container);
            }
            graph.addLiteral(value, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
            graph.claim(container, L0.ConsistsOf, value);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Added new annotationValue named " + name + ", resource " + value));
            return value;
        }
        String propertyName = (String)graph.getRelatedValue(annotationProperty, L0.HasName, (Binding)Bindings.STRING);
        Resource valueType = graph.getSingleObject(annotationProperty, L0.HasRange);
        Resource value = graph.newResource();
        graph.claim(value, L0.InstanceOf, valueType);
        if (name == null) {
            name = NameUtils.findFreshName((ReadGraph)graph, (String)(String.valueOf(propertyName) + " value"), (Resource)container);
        }
        graph.addLiteral(value, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.claim(container, L0.ConsistsOf, value);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Added new annotationValue named " + name + ", resource " + value));
        return value;
    }

    public static void queryUserSelectedAnnotationType(final Map<Resource, Pair<String, ImageDescriptor>> map, final Callback<Resource> selectionCallback) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] result;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ResourceSelectionDialog3<Resource> dialog = new ResourceSelectionDialog3<Resource>(shell, map, "Select annotation type from list"){

                    protected IDialogSettings getBaseDialogSettings() {
                        return Activator.getDefault().getDialogSettings();
                    }
                };
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                    Resource res = (Resource)result[0];
                    selectionCallback.run((Object)res);
                }
            }
        });
    }

    public static void queryLibrary(final Map<Resource, Pair<String, ImageDescriptor>> map, final Callback<Pair<Resource, String>> selectionCallback) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] result;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SaveAnnotationDialog page = new SaveAnnotationDialog(shell, map, "Select library");
                if (page.open() == 0 && (result = page.getResult()) != null && result.length == 1) {
                    Resource res = (Resource)result[0];
                    selectionCallback.run((Object)Pair.make((Object)res, (Object)page.getName()));
                }
            }
        });
    }
}

