/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.XSupport;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;
import org.simantics.utils.FileUtils;

public class SessionUtil {
    private String clientId;
    private File workspace;
    private ServerManager serverManager = ServerManagerFactory.getServerManager();
    private ServerEx server;
    private Session session;

    public static String getApplicationClientId() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "noProduct";
        }
        String application = product.getApplication();
        return application != null ? application : UUID.randomUUID().toString();
    }

    public SessionUtil() {
        this(UUID.randomUUID().toString());
    }

    public SessionUtil(String clientId) {
        this.clientId = clientId;
    }

    public void close() throws DatabaseException {
        if (this.session != null) {
            ((LifecycleSupport)this.session.getService(LifecycleSupport.class)).close();
        }
        this.serverManager.close();
    }

    public Session open(File workspace) throws IOException, DatabaseException {
        File dbDir = new File(workspace, "db");
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            throw new FileNotFoundException("database directory " + dbDir + " not found");
        }
        File dbPropFile = new File(dbDir, "procore.config.procore");
        if (!(dbPropFile.exists() && dbPropFile.isFile() && dbPropFile.canRead())) {
            throw new FileNotFoundException("database configuration file " + dbPropFile + " can't be read");
        }
        Properties props = new Properties();
        FileReader reader = new FileReader(dbPropFile);
        try {
            props.load(reader);
        }
        catch (IOException e) {
            FileUtils.uncheckedClose((Closeable)reader);
        }
        String commonPort = props.getProperty("common_port", null);
        int port = 0;
        try {
            port = Integer.parseInt(commonPort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (port > 0) {
            try {
                this.server = this.serverManager.getServer(new ServerAddress("127.0.0.1", port));
                this.server.start();
                this.session = this.openSession(this.server, dbDir);
                this.workspace = workspace;
                return this.session;
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        this.server = this.serverManager.getServer(dbDir);
        this.server.start();
        this.session = this.openSession(this.server, dbDir);
        this.workspace = workspace;
        return this.session;
    }

    private Session openSession(ServerEx server, File dbDir) throws DatabaseException {
        Properties info = new Properties(ServerManager.DEFAULT);
        info.setProperty("clientDir", dbDir.getAbsolutePath());
        info.setProperty("clientId", this.clientId);
        info.setProperty("noL0", this.clientId);
        this.session = server.createSession(info);
        ((XSupport)this.session.getService(XSupport.class)).setServiceMode(true, true);
        return this.session;
    }
}

