/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.internal;

import java.io.IOException;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;

public class SCLFunctions {
    public static final String GRAPH = "graph";

    public static <T> T safeExec(Function f) {
        try {
            return (T)f.apply((Object)Tuple0.INSTANCE);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static <T> T syncRead(final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.getCurrent();
        return (T)Simantics.getSession().syncRequest(new Read<T>(){

            public T perform(ReadGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    Object object = f.apply((Object)Tuple0.INSTANCE);
                    return object;
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        });
    }

    public static <T> T syncWrite(final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.getCurrent();
        return (T)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<T>(){

            public T perform(WriteGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    Object object = f.apply((Object)Tuple0.INSTANCE);
                    return object;
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        });
    }

    public static <T> T virtualSyncWriteMem(WriteGraph graph, String virtualGraphId, final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.getCurrent();
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        VirtualGraph vg = vgs.getMemoryPersistent(virtualGraphId);
        return (T)graph.syncRequest((WriteResult)new WriteResultRequest<T>(vg){

            public T perform(WriteGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    Object object = f.apply((Object)Tuple0.INSTANCE);
                    return object;
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        });
    }

    public static <T> T readValue(final String uri) throws DatabaseException {
        return (T)Simantics.getSession().syncRequest(new Read<T>(){

            public T perform(ReadGraph graph) throws DatabaseException {
                return Variables.getVariable((ReadGraph)graph, (String)uri).getValue(graph);
            }
        });
    }

    public static <T> void writeValue(final String uri, final T value) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Variables.getVariable((ReadGraph)graph, (String)uri).setValue(graph, value);
            }
        });
    }

    public static void activateOnce(Resource r) {
        ((IActivationManager)Simantics.getSession().getService(IActivationManager.class)).activateOnce(r);
    }

    public static void syncActivateOnce(WriteGraph graph, Resource r) throws DatabaseException {
        ((IActivationManager)graph.getService(IActivationManager.class)).activateOnce(graph, r);
    }

    public static Resource resourceFromId(ReadGraph graph, long id) throws DatabaseException, IOException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getResource(id);
    }

    public static void disableDependencies(WriteGraph graph) {
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
    }

    public static void enableDependencies(WriteGraph graph) {
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)false);
    }
}

