/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.DatabaseJob;

public class SleepingDatabaseJob
extends DatabaseJob {
    private final Semaphore start = new Semaphore(0);
    private final Semaphore end = new Semaphore(0);

    public SleepingDatabaseJob(String name) {
        super(name);
    }

    protected final IStatus run(IProgressMonitor monitor) {
        this.start.release();
        try {
            IStatus iStatus = this.work(monitor);
            return iStatus;
        }
        finally {
            try {
                this.end.acquire();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected IStatus work(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public void scheduleAndWaitForRunning() throws InterruptedException {
        this.schedule();
        this.start.acquire();
        this.start.release();
    }

    public void scheduleAndWaitForRunningUninterruptibly() {
        this.schedule();
        this.start.acquireUninterruptibly();
        this.start.release();
    }

    public void disposeAndJoin() throws InterruptedException {
        this.end.release();
        this.join();
    }

    public static void sleepWhile(String name, Runnable runnable) throws InterruptedException {
        SleepingDatabaseJob dbjob = new SleepingDatabaseJob(name);
        try {
            dbjob.scheduleAndWaitForRunning();
            runnable.run();
        }
        finally {
            dbjob.disposeAndJoin();
        }
    }

    public static void sleepUninterruptiblyWhile(String name, Runnable runnable) {
        SleepingDatabaseJob dbjob = new SleepingDatabaseJob(name);
        try {
            dbjob.scheduleAndWaitForRunningUninterruptibly();
            runnable.run();
        }
        finally {
            try {
                dbjob.disposeAndJoin();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

