/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Bundle;
import org.simantics.Logger;
import org.simantics.OntologyImportAdvisor;
import org.simantics.PlatformException;
import org.simantics.PlatformUserAgent;
import org.simantics.Simantics;
import org.simantics.SimanticsBindings;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.SessionModel;
import org.simantics.db.UndoContext;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Transaction;
import org.simantics.db.exception.ClusterSetExistException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.genericrelation.DependenciesRelation;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TGTransferableGraphSource;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.SessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.db.service.XSupport;
import org.simantics.graph.db.GraphDependencyAnalyzer;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.internal.Activator;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.project.IProject;
import org.simantics.project.ProjectFeatures;
import org.simantics.project.ProjectKeys;
import org.simantics.project.Projects;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.registry.GroupReference;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.GraphBundleEx;
import org.simantics.project.management.GraphBundleRef;
import org.simantics.project.management.PlatformUtil;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;
import org.simantics.project.management.WorkspaceUtil;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Pair;

public class SimanticsPlatform
implements LifecycleSupport.LifecycleListener {
    public static final boolean TIME_STARTUP = true;
    public static final SimanticsPlatform INSTANCE = new SimanticsPlatform();
    public boolean running;
    public Session session;
    public SessionContext sessionContext;
    public ServerEx server;
    public String projectURI;
    public String projectName;
    public Resource projectResource;
    public SimanticsBindings simanticsBindings;
    public SimanticsBindings simanticsBindings2;
    public Thread mainThread;
    private IProject project;
    protected ILog log = Platform.getLog((Bundle)Activator.getBundleContext().getBundle());
    protected int localPort;
    protected ServerAddress remoteServer;
    private static long beginTime;

    public SimanticsPlatform() {
        this.mainThread = Thread.currentThread();
    }

    public String getApplicationClientId() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "noProduct";
        }
        String application = product.getApplication();
        return application != null ? application : UUID.randomUUID().toString();
    }

    public void setupDatabase(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, int localPort, ServerAddress remoteServer, PlatformUserAgent userAgent) throws PlatformException {
        ServerManager serverManager;
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        this.localPort = localPort;
        this.remoteServer = remoteServer;
        try {
            serverManager = ServerManagerFactory.createOSGI();
        }
        catch (IOException e1) {
            throw new PlatformException("Failed to initialize Server Manager", e1);
        }
        File dbLocation = Platform.getLocation().append("db").toFile();
        progressMonitor.beginTask("Setting up Simantics Platform", 100);
        progressMonitor.setTaskName("Asserting Database is installed.");
        try {
            if (!dbLocation.exists() || !dbLocation.isDirectory()) {
                if (workspacePolicy == RecoveryPolicy.ThrowError) {
                    throw new PlatformException("Database was not found at " + dbLocation);
                }
                this.log.log((IStatus)new Status(1, "org.simantics", "Creating database at " + dbLocation));
                progressMonitor.setTaskName("Creating database at " + dbLocation);
                GraphBundle l0 = PlatformUtil.getGraph((String)"org.simantics.layer0");
                GraphBundleEx l0ex = GraphBundleEx.extend((GraphBundle)l0);
                l0ex.build();
                dbLocation.mkdirs();
                if (remoteServer == null) {
                    serverManager.createDatabase(dbLocation, localPort, new GraphBundle[]{l0ex});
                } else {
                    serverManager.createDatabase(dbLocation, remoteServer, new GraphBundle[]{l0ex});
                }
            }
            progressMonitor.worked(20);
        }
        catch (IOException e) {
            throw new PlatformException("Failed to create database", e);
        }
        catch (DatabaseException e) {
            throw new PlatformException("Failed to create database", e);
        }
    }

    public void startUpServer(IProgressMonitor progressMonitor, ServerAddress remoteServer, boolean initL0) throws PlatformException {
        ServerManager serverManager;
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        try {
            serverManager = ServerManagerFactory.createOSGI();
        }
        catch (IOException e1) {
            throw new PlatformException("Failed to initialize Server Manager", e1);
        }
        File dbLocation = Platform.getLocation().append("db").toFile();
        progressMonitor.setTaskName("Starting Database process");
        try {
            this.server = remoteServer != null ? serverManager.getServer(remoteServer) : serverManager.getServer(dbLocation);
            this.server.start();
            Properties info = new Properties(ServerManager.DEFAULT);
            info.setProperty("clientDir", dbLocation.getAbsolutePath());
            info.setProperty("clientId", this.getApplicationClientId());
            if (!initL0) {
                info.setProperty("noL0", this.getApplicationClientId());
            }
            this.session = this.server.createSession(info);
            ((XSupport)this.session.getService(XSupport.class)).setServiceMode(true, true);
            progressMonitor.worked(20);
        }
        catch (DatabaseException e) {
            throw new PlatformException("Failed to open database session", e);
        }
        LifecycleSupport ls = (LifecycleSupport)this.session.getService(LifecycleSupport.class);
        ls.addListener((LifecycleSupport.LifecycleListener)this);
    }

    /*
     * WARNING - void declaration
     */
    public void synchronizeOntologies(IProgressMonitor progressMonitor, OntologyRecoveryPolicy ontologyPolicy, boolean requireSynchronize) throws PlatformException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        DatabaseManagement mgmt = new DatabaseManagement();
        PlatformUtil.compileAllDynamicOntologies();
        progressMonitor.setTaskName("Asserting all ontologies are installed");
        HashMap<GraphBundleRef, GraphBundleEx> platformTGs = new HashMap<GraphBundleRef, GraphBundleEx>();
        try {
            progressMonitor.subTask("find installed bundles from database");
            HashMap<GraphBundleRef, GraphBundleEx> installedTGs = new HashMap<GraphBundleRef, GraphBundleEx>();
            for (GraphBundle b : (Set)this.session.syncRequest(mgmt.GraphBundleQuery)) {
                installedTGs.put(GraphBundleRef.of((GraphBundle)b), GraphBundleEx.extend((GraphBundle)b));
            }
            if (!requireSynchronize && installedTGs.size() > 1 && !Platform.inDevelopmentMode()) {
                return;
            }
            ArrayList tgs = new ArrayList();
            progressMonitor.subTask("load all transferable graphs from platform");
            PlatformUtil.getAllGraphs(tgs);
            progressMonitor.subTask("extend bundles to compile versions");
            for (GraphBundle b : tgs) {
                GraphBundleEx gbe = GraphBundleEx.extend((GraphBundle)b);
                gbe.build();
                platformTGs.put(GraphBundleRef.of((GraphBundle)b), gbe);
            }
            progressMonitor.subTask("check bundle reinstallation demand");
            ArrayList<Object> installTGs = new ArrayList<Object>();
            TreeMap<Object, GraphBundleEx> reinstallTGs = new TreeMap<Object, GraphBundleEx>();
            for (Map.Entry e : platformTGs.entrySet()) {
                boolean platformBundleIsNewer;
                GraphBundleRef graphBundleRef = (GraphBundleRef)e.getKey();
                GraphBundleEx platformBundle = (GraphBundleEx)e.getValue();
                GraphBundleEx existingBundle = (GraphBundleEx)installedTGs.get(graphBundleRef);
                if (existingBundle == null) {
                    installTGs.add(platformBundle);
                    continue;
                }
                boolean bl = platformBundleIsNewer = existingBundle.getVersion().compareTo((Object)platformBundle.getVersion()) < 0;
                if (!platformBundleIsNewer || platformBundle.getHashcode() == existingBundle.getHashcode()) continue;
                reinstallTGs.put(platformBundle, existingBundle);
            }
            if (!installTGs.isEmpty() || !reinstallTGs.isEmpty()) {
                if (ontologyPolicy == OntologyRecoveryPolicy.ThrowError) {
                    StringBuilder sb = new StringBuilder("The following graphs are not installed in the database: ");
                    if (!installTGs.isEmpty()) {
                        boolean bl = false;
                        for (GraphBundleEx graphBundleEx : installTGs) {
                            void var11_15;
                            if (var11_15 > 0) {
                                sb.append(", ");
                            }
                            ++var11_15;
                            sb.append(graphBundleEx.toString());
                        }
                        sb.append(" is missing from the database.\n");
                    }
                    if (!reinstallTGs.isEmpty()) {
                        boolean bl = false;
                        for (Map.Entry entry : reinstallTGs.entrySet()) {
                            void var11_17;
                            if (var11_17 > 0) {
                                sb.append(", ");
                            }
                            ++var11_17;
                            sb.append(((GraphBundleEx)entry.getKey()).toString());
                        }
                        sb.append(" Database/Platform Bundle version mismatch.\n");
                    }
                    sb.append("Hint: Use -fixErrors to install the graphs.");
                    throw new PlatformException(sb.toString());
                }
                if (ontologyPolicy == OntologyRecoveryPolicy.ReinstallDatabase) {
                    this.log.log((IStatus)new Status(1, "org.simantics", "Reinstalling the database."));
                    throw new PlatformException("Reinstalling Database, NOT IMPLEMENTED");
                }
                if (ontologyPolicy == OntologyRecoveryPolicy.Merge) {
                    progressMonitor.subTask("Merging ontology changes");
                    GraphDependencyAnalyzer analyzer = new GraphDependencyAnalyzer();
                    for (GraphBundle graphBundle : installTGs) {
                        analyzer.addGraph((Comparable)graphBundle, graphBundle.getGraph());
                    }
                    for (GraphBundle graphBundle : reinstallTGs.keySet()) {
                        analyzer.addGraph((Comparable)graphBundle, graphBundle.getGraph());
                    }
                    if (!analyzer.analyzeDependency()) {
                        Collection collection = analyzer.getConflicts();
                        StringBuilder stringBuilder = new StringBuilder();
                        for (Pair problem : collection) {
                            stringBuilder.append("Conflict with " + problem.first + " and " + problem.second + ".\n");
                        }
                        throw new PlatformException(stringBuilder.toString());
                    }
                    if (!((Boolean)this.session.syncRequest(analyzer.queryExternalDependenciesSatisfied)).booleanValue()) {
                        ArrayList arrayList = analyzer.getUnsatisfiedDependencies();
                        StringBuilder stringBuilder = new StringBuilder();
                        for (GraphDependencyAnalyzer.IdentityNode dep : arrayList) {
                            stringBuilder.append("Unsatisfied Dependency " + dep + ". Required by\n");
                            for (GraphDependencyAnalyzer.IU iu : GraphDependencyAnalyzer.toCollection((GraphDependencyAnalyzer.IUList)dep.getRequires())) {
                                stringBuilder.append("    " + ((GraphBundle)iu.getId()).getId() + "\n");
                            }
                        }
                        throw new PlatformException(stringBuilder.toString());
                    }
                    long l = System.nanoTime();
                    this.session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            try {
                                graph.newClusterSet(graph.getRootLibrary());
                            }
                            catch (ClusterSetExistException clusterSetExistException) {
                                // empty catch block
                            }
                            graph.setClusterSet4NewResource(graph.getRootLibrary());
                            graph.flushCluster();
                        }
                    });
                    for (GraphBundle tg : analyzer.getSortedGraphs()) {
                        OntologyImportAdvisor advisor = new OntologyImportAdvisor(tg, mgmt);
                        GraphBundle oldTG = (GraphBundle)reinstallTGs.get(tg);
                        if (oldTG == null) {
                            this.log.log((IStatus)new Status(1, "org.simantics", "Installing " + tg.toString() + " - " + tg.getName()));
                            TransferableGraphs.importGraph1((Session)this.session, (TransferableGraphSource)new TGTransferableGraphSource(tg.getGraph()), (IImportAdvisor)advisor, null);
                            continue;
                        }
                        this.log.log((IStatus)new Status(1, "org.simantics", "Merging new version of " + tg.toString()));
                        Transaction.startTransaction((RequestProcessor)this.session, (boolean)true);
                        TransferableGraphDelta1 delta = new Diff(oldTG.getGraph(), tg.getGraph()).diff();
                        try {
                            try {
                                long[] oldResources = oldTG.getResourceArray();
                                long[] resourceArray = TransferableGraphs.applyDelta((WriteGraph)Transaction.writeGraph(), (long[])oldResources, (TransferableGraphDelta1)delta);
                                tg.setResourceArray(resourceArray);
                                mgmt.setGraphBundleEntry(tg);
                                Transaction.commit();
                            }
                            catch (Throwable t) {
                                throw new PlatformException(t);
                            }
                        }
                        finally {
                            Transaction.endTransaction();
                        }
                    }
                    this.session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.setClusterSet4NewResource(graph.getRootLibrary());
                            graph.flushCluster();
                        }
                    });
                    long duration = System.nanoTime() - l;
                    System.out.println("Ontologies installed in " + 1.0E-9 * (double)duration + "s. ");
                }
            }
            this.session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0.getInstance((ReadGraph)graph);
                    try {
                        graph.newClusterSet(graph.getRootLibrary());
                    }
                    catch (ClusterSetExistException clusterSetExistException) {
                        // empty catch block
                    }
                }
            });
            progressMonitor.worked(20);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
        catch (DatabaseException e) {
            throw new PlatformException(e);
        }
    }

    public boolean assertConfiguration(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy) throws PlatformException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        File workspaceLocation = Platform.getLocation().toFile();
        boolean installProject = false;
        progressMonitor.setTaskName("Asserting simantics.cfg is installed");
        try {
            Properties properties;
            File propertyFile = new File(workspaceLocation, "simantics.cfg");
            try {
                properties = WorkspaceUtil.readProperties((File)propertyFile);
            }
            catch (IOException e) {
                if (workspacePolicy == RecoveryPolicy.ThrowError) {
                    throw new PlatformException("Could not load " + propertyFile);
                }
                properties = new Properties();
                properties.setProperty("project_uri", "http://Projects/Development%20Project");
                properties.setProperty("project_name", "Development Project");
                WorkspaceUtil.writeProperties((File)propertyFile, (Properties)properties);
                installProject |= true;
            }
            this.projectURI = properties.getProperty("project_uri");
            this.projectName = properties.getProperty("project_name");
            progressMonitor.worked(10);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
        return installProject;
    }

    public boolean assertProject(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, boolean installProject) throws PlatformException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        DatabaseManagement mgmt = new DatabaseManagement();
        progressMonitor.setTaskName("Asserting project resource exists in the database");
        try {
            this.projectResource = (Resource)this.session.syncRequest(Queries.resource((String)this.projectURI));
        }
        catch (ResourceNotFoundException nfe) {
            if (workspacePolicy == RecoveryPolicy.ThrowError) {
                throw new PlatformException("Project Resource " + this.projectURI + " is not found in the database.");
            }
            try {
                Transaction.startTransaction((RequestProcessor)this.session, (boolean)true);
                try {
                    ArrayList empty = new ArrayList();
                    this.projectResource = mgmt.createProject(this.projectName, empty);
                    installProject |= true;
                    Transaction.commit();
                }
                finally {
                    Transaction.endTransaction();
                }
            }
            catch (DatabaseException e) {
                throw new PlatformException("Failed to create " + this.projectURI, e);
            }
        }
        catch (DatabaseException e) {
            throw new PlatformException("Failed to create " + this.projectURI, e);
        }
        progressMonitor.worked(10);
        return installProject;
    }

    public void updateInstalledGroups(IProgressMonitor progressMonitor, boolean installProject) throws PlatformException {
        if (installProject) {
            progressMonitor.setTaskName("Install all features");
            Set publishedFeatureGroups = ProjectFeatures.getInstallGroupsOfPublishedFeatures();
            Collection groupsWithoutVersion = GroupReference.stripVersions((Collection)publishedFeatureGroups);
            try {
                Transaction.startTransaction((RequestProcessor)this.session, (boolean)true);
                try {
                    Projects.setProjectInstalledGroups((WriteGraph)Transaction.writeGraph(), (Resource)this.projectResource, (Collection)groupsWithoutVersion);
                    Transaction.commit();
                }
                finally {
                    Transaction.endTransaction();
                }
            }
            catch (DatabaseException ae) {
                throw new PlatformException("Failed to install features", ae);
            }
            progressMonitor.worked(10);
        }
    }

    public void assertSessionModel(IProgressMonitor progressMonitor) throws PlatformException {
        Properties properties = (Properties)this.session.getService(Properties.class);
        final String clientId = properties.getProperty("clientId");
        try {
            VirtualGraphSupport support = (VirtualGraphSupport)this.session.getService(VirtualGraphSupport.class);
            VirtualGraph activations = support.getWorkspacePersistent("activations");
            Resource sessionModel = (Resource)this.session.syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    for (Resource sessionModel : (Collection)graph.syncRequest((Read)new ObjectsWithType(graph.getRootLibrary(), L0X.HasSession, L0X.Session))) {
                        String id = (String)graph.getPossibleRelatedValue(sessionModel, L0X.Session_HasClientId);
                        if (id == null || !id.equals(clientId)) continue;
                        return sessionModel;
                    }
                    return null;
                }
            });
            if (sessionModel == null) {
                sessionModel = (Resource)this.session.syncRequest((WriteResult)new WriteResultRequest<Resource>(activations){

                    public Resource perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                        Resource session = graph.newResource();
                        graph.claim(session, L0.InstanceOf, null, L0X.Session);
                        graph.claim(session, L0X.Session_HasUser, null, graph.getResource("http://Users/AdminUser"));
                        graph.addLiteral(session, L0X.Session_HasClientId, L0X.Session_HasClientId_Inverse, (Object)clientId, (Binding)Bindings.STRING);
                        graph.claim(graph.getRootLibrary(), L0X.HasSession, session);
                        return session;
                    }
                });
            }
            final Resource finalSessionModel = sessionModel;
            this.session.registerService(SessionModel.class, (Object)new SessionModel(){

                public Resource getResource() {
                    return finalSessionModel;
                }
            });
        }
        catch (DatabaseException e) {
            throw new PlatformException(e);
        }
    }

    public void resetDatabase(IProgressMonitor monitor) throws PlatformException {
        File dbLocation = Platform.getLocation().append("db").toFile();
        if (!dbLocation.exists()) {
            return;
        }
        try {
            Driver driver = Manager.getDriver((String)"procore");
            driver.removeDatabaseFiles(dbLocation);
        }
        catch (DatabaseException e) {
            throw new PlatformException("Failed to remove database files at " + dbLocation.getAbsolutePath(), e);
        }
    }

    public void resetWorkspace(IProgressMonitor monitor, ArrayList<String> fileFilter) throws PlatformException, IllegalStateException, IOException {
        this.resetDatabase(monitor);
        FileUtils.deleteAllWithFilter((File)Platform.getLocation().toFile(), fileFilter);
    }

    public SessionContext startUp(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, OntologyRecoveryPolicy ontologyPolicy, ServerAddress remoteServer, PlatformUserAgent userAgent) throws PlatformException {
        return this.startUp(progressMonitor, workspacePolicy, ontologyPolicy, 0, remoteServer, userAgent);
    }

    public SessionContext startUp(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, OntologyRecoveryPolicy ontologyPolicy, int localPort, ServerAddress remoteServer, PlatformUserAgent userAgent) throws PlatformException {
        return this.startUp(progressMonitor, workspacePolicy, ontologyPolicy, true, localPort, remoteServer, userAgent);
    }

    public SessionContext startUp(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, OntologyRecoveryPolicy ontologyPolicy, boolean requireSynchronize, int localPort, ServerAddress remoteServer, PlatformUserAgent userAgent) throws PlatformException {
        assert (!this.running);
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        if ("true".equals(System.getProperty("org.simantics.dumpBundleState"))) {
            this.dumpPlatformBundleState();
        }
        SimanticsPlatform.startTask("clearTemporaryDirectory");
        Simantics.clearTemporaryDirectory();
        SimanticsPlatform.endTask();
        SimanticsPlatform.startTask("setupDatabase");
        this.setupDatabase(progressMonitor, workspacePolicy, localPort, remoteServer, userAgent);
        SimanticsPlatform.endTask();
        SimanticsPlatform.startTask("startUpServer");
        this.startUpServer(progressMonitor, remoteServer, true);
        SimanticsPlatform.endTask();
        SimanticsPlatform.startTask("synchronizeOntologies");
        this.synchronizeOntologies(progressMonitor, ontologyPolicy, requireSynchronize);
        SimanticsPlatform.endTask();
        SessionContext ctx = this.startUpExisting(progressMonitor, workspacePolicy, true);
        return ctx;
    }

    public SessionContext startUpExisting(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, boolean loadProject) throws PlatformException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        ((XSupport)this.session.getService(XSupport.class)).setServiceMode(true, false);
        SimanticsPlatform.startTask("assertConfiguration and assertProject");
        boolean installProject = this.assertConfiguration(progressMonitor, workspacePolicy);
        installProject = this.assertProject(progressMonitor, workspacePolicy, installProject);
        SimanticsPlatform.endTask();
        SimanticsPlatform.startTask("updateInstalledGroups");
        this.updateInstalledGroups(progressMonitor, installProject);
        SimanticsPlatform.endTask();
        SimanticsPlatform.startTask("assertSessionModel, preparations");
        this.assertSessionModel(progressMonitor);
        ((XSupport)this.session.getService(XSupport.class)).setServiceMode(false, false);
        SimanticsPlatform.startTask("flush queries");
        try {
            this.session.sync((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                    qc.flush((ReadGraph)graph);
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError(e);
        }
        SimanticsPlatform.endTask();
        try {
            this.sessionContext = INSTANCE.createSessionContext(true);
            this.sessionContext.setHint(SimanticsKeys.KEY_PROJECT, (Object)SimanticsPlatform.INSTANCE.projectResource);
            Simantics.setSessionContext((ISessionContext)this.sessionContext);
            this.simanticsBindings = new SimanticsBindings(null);
            Bindings.classBindingFactory.addFactory((BindingProvider)this.simanticsBindings);
            Session session = this.sessionContext.getSession();
            Databoard sessionDataboard = new Databoard();
            session.registerService(Databoard.class, (Object)sessionDataboard);
            this.simanticsBindings2 = new SimanticsBindings(session);
            sessionDataboard.classBindingFactory.addFactory((BindingProvider)this.simanticsBindings2);
            SimanticsPlatform.endTask();
            Bindings.defaultBindingFactory.getRepository().put(RGB.Integer.BINDING.type(), RGB.Integer.BINDING);
            Bindings.defaultBindingFactory.getRepository().put(Font.BINDING.type(), Font.BINDING);
            if (loadProject) {
                SimanticsPlatform.startTask("loadProject");
                this.project = Projects.loadProject((RequestProcessor)this.sessionContext.getSession(), (Resource)SimanticsPlatform.INSTANCE.projectResource);
                this.sessionContext.setHint(ProjectKeys.KEY_PROJECT, (Object)this.project);
                SimanticsPlatform.endTask();
                SimanticsPlatform.startTask("activate project");
                this.project.activate();
                SimanticsPlatform.endTask();
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            throw new PlatformException(e);
        }
        catch (ProjectException e) {
            throw new PlatformException(e);
        }
        this.running = true;
        return this.sessionContext;
    }

    public SessionContext createSessionContext(boolean init) throws PlatformException {
        try {
            SessionContext sessionContext = SessionContext.create((Session)this.session, (boolean)init);
            if (init) {
                sessionContext.registerServices();
            }
            return sessionContext;
        }
        catch (DatabaseException e) {
            throw new PlatformException(e);
        }
    }

    public void shutdown(IProgressMonitor progressMonitor) throws PlatformException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        PlatformException platformException = null;
        try {
            progress.subTask("Close Project");
            if (this.project != null) {
                this.project.safeDispose();
            }
            progress.worked(10);
            this.running = false;
            progress.subTask("Close Database Session");
            Databoard databoard = null;
            if (this.sessionContext != null) {
                Session s = this.sessionContext.peekSession();
                if (s != null) {
                    databoard = (Databoard)s.peekService(Databoard.class);
                    progress.subTask("Flushing Index Caches");
                    try {
                        Simantics.flushIndexCaches((IProgressMonitor)progress.newChild(20), s);
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError(t);
                    }
                }
                progress.subTask("Close Database Session");
                this.sessionContext.safeDispose();
                this.sessionContext = null;
                Simantics.setSessionContext(null);
            }
            if (this.simanticsBindings != null) {
                Bindings.classBindingFactory.removeFactory((BindingProvider)this.simanticsBindings);
                this.simanticsBindings = null;
            }
            if (databoard != null) {
                if (this.simanticsBindings2 != null) {
                    databoard.classBindingFactory.removeFactory((BindingProvider)this.simanticsBindings2);
                    this.simanticsBindings2 = null;
                }
                databoard.clear();
            }
            Simantics.setClipboard((SimanticsClipboard)new SimanticsClipboardImpl());
            progress.worked(30);
            progress.subTask("Shutdown Database Server");
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                finally {
                    this.server = null;
                }
            }
            progress.worked(30);
            this.session = null;
            this.projectResource = null;
            DependenciesRelation.assertFinishedTracking();
        }
        catch (DatabaseException e) {
            platformException = new PlatformException("Failed to shutdown Simantics Platform", e);
        }
        progress.subTask("Clearing Workspace Temporary Directory");
        try {
            Simantics.clearTemporaryDirectory();
        }
        catch (Throwable t) {
            Logger.defaultLogError(t);
        }
        progress.worked(10);
        if (platformException != null) {
            throw platformException;
        }
    }

    public void stateChanged(LifecycleSupport.LifecycleState newState) {
        if (newState == LifecycleSupport.LifecycleState.CLOSED && this.running && Platform.isRunning()) {
            SimanticsPlatform.INSTANCE.mainThread.interrupt();
        }
    }

    public boolean discardSessionUndoHistory() {
        UndoContext uc;
        UndoRedoSupport urs;
        Session s = this.session;
        if (s != null && (urs = (UndoRedoSupport)s.peekService(UndoRedoSupport.class)) != null && (uc = urs.getUndoContext(s)) != null) {
            uc.clear();
            return true;
        }
        return false;
    }

    public void reconnect() throws Exception {
        INSTANCE.startUpServer(null, this.remoteServer, true);
        INSTANCE.startUpExisting(null, RecoveryPolicy.ThrowError, true);
    }

    private static void startTask(String name) {
        System.out.print(name);
        int len = name.length();
        int i = 0;
        while (i < 40 - len) {
            System.out.print('.');
            ++i;
        }
        System.out.flush();
        beginTime = System.nanoTime();
    }

    private static void endTask() {
        long endTime = System.nanoTime();
        double duration = (double)(endTime - beginTime) * 1.0E-9;
        System.out.println(" " + duration + " seconds");
    }

    private void dumpPlatformBundleState() {
        BundleDescription[] bs = Platform.getPlatformAdmin().getState().getBundles();
        System.out.println("Total bundles: " + bs.length);
        BundleDescription[] bundleDescriptionArray = bs;
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription b = bundleDescriptionArray[n2];
            System.out.format("%-80s @ %s\n", b.toString(), b.getLocation());
            ++n2;
        }
    }

    public static enum OntologyRecoveryPolicy {
        ThrowError,
        Merge,
        ReinstallDatabase;

    }

    public static enum RecoveryPolicy {
        ThrowError,
        FixError;

    }
}

